/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm.ext.fault;

import java.util.Map;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.BLimitEnable;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BOutOfRangeFaultAlgorithm
extends BFaultAlgorithm {
    public static final Property highLimit = BOutOfRangeFaultAlgorithm.newProperty((int)0, (int)0, null);
    public static final Property lowLimit = BOutOfRangeFaultAlgorithm.newProperty((int)0, (int)0, null);
    public static final Property deadband = BOutOfRangeFaultAlgorithm.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BFloat.make((float)0.0f)));
    public static final Property highLimitText = BOutOfRangeFaultAlgorithm.newProperty((int)0, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property lowLimitText = BOutOfRangeFaultAlgorithm.newProperty((int)0, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property limitEnable = BOutOfRangeFaultAlgorithm.newProperty((int)0, (BValue)new BLimitEnable(), null);
    public static final Property inHighState = BOutOfRangeFaultAlgorithm.newProperty((int)4, (boolean)false, null);
    public static final Property inLowState = BOutOfRangeFaultAlgorithm.newProperty((int)4, (boolean)false, null);
    public static final Type TYPE;
    OutOfRangeState current;
    static /* synthetic */ Class class$javax$baja$alarm$ext$fault$BOutOfRangeFaultAlgorithm;

    public double getHighLimit() {
        return this.getDouble(highLimit);
    }

    public void setHighLimit(double d) {
        this.setDouble(highLimit, d, null);
    }

    public double getLowLimit() {
        return this.getDouble(lowLimit);
    }

    public void setLowLimit(double d) {
        this.setDouble(lowLimit, d, null);
    }

    public double getDeadband() {
        return this.getDouble(deadband);
    }

    public void setDeadband(double d) {
        this.setDouble(deadband, d, null);
    }

    public BFormat getHighLimitText() {
        return (BFormat)this.get(highLimitText);
    }

    public void setHighLimitText(BFormat bFormat) {
        this.set(highLimitText, (BValue)bFormat, null);
    }

    public BFormat getLowLimitText() {
        return (BFormat)this.get(lowLimitText);
    }

    public void setLowLimitText(BFormat bFormat) {
        this.set(lowLimitText, (BValue)bFormat, null);
    }

    public BLimitEnable getLimitEnable() {
        return (BLimitEnable)this.get(limitEnable);
    }

    public void setLimitEnable(BLimitEnable bLimitEnable) {
        this.set(limitEnable, (BValue)bLimitEnable, null);
    }

    public boolean getInHighState() {
        return this.getBoolean(inHighState);
    }

    public void setInHighState(boolean bl) {
        this.setBoolean(inHighState, bl, null);
    }

    public boolean getInLowState() {
        return this.getBoolean(inLowState);
    }

    public void setInLowState(boolean bl) {
        this.setBoolean(inLowState, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    private final boolean isHighLimitEnabled() {
        return this.getLimitEnable().isHighLimitEnabled();
    }

    private final boolean isLowLimitEnabled() {
        return this.getLimitEnable().isLowLimitEnabled();
    }

    public void started() {
        BAlarmState bAlarmState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        if (bAlarmState == BAlarmState.fault) {
            if (this.getInHighState()) {
                this.current = new HighAlarmState();
            } else if (this.getInLowState()) {
                this.current = new LowAlarmState();
            }
        }
    }

    public boolean isGrandparentLegal(BComponent bComponent) {
        return bComponent instanceof BNumericPoint;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == highLimit || slot == lowLimit) {
            return this.getPointFacets();
        }
        if (slot == deadband) {
            BFacets bFacets = this.getPointFacets();
            BUnit bUnit = (BUnit)bFacets.getFacet("units");
            if (bUnit != null) {
                bFacets = BFacets.make((BFacets)bFacets, (String)"units", (BIDataValue)bUnit.getDifferentialUnit());
            }
            return BFacets.make((BFacets)bFacets, (BFacets)super.getSlotFacets((Slot)deadband));
        }
        return super.getSlotFacets(slot);
    }

    public BAlarmState checkFault(BStatusValue bStatusValue) {
        BStatusNumeric bStatusNumeric = (BStatusNumeric)bStatusValue;
        return this.evaluate(bStatusNumeric.getValue());
    }

    private final BAlarmState evaluate(double d) {
        BAlarmState bAlarmState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        if (bAlarmState == BAlarmState.fault) {
            if (this.getInHighState()) {
                this.current = new HighAlarmState();
            } else if (this.getInLowState()) {
                this.current = new LowAlarmState();
            }
        } else {
            this.current = new NormalState();
        }
        return this.current.evaluate(d);
    }

    public void writeAlarmData(BStatusValue bStatusValue, Map map) {
        BFacets bFacets = this.getPointFacets();
        map.put("status", BString.make((String)bStatusValue.getStatus().toString(null)));
        map.put("deadband", BString.make((String)BDouble.toString((double)this.getDeadband(), (Context)bFacets)));
        if (this.current instanceof HighAlarmState) {
            if (!this.getHighLimitText().equals((Object)BFormat.DEFAULT)) {
                map.put("msgText", BString.make((String)this.getHighLimitText().getFormat()));
            }
            map.put("highLimit", BString.make((String)BDouble.toString((double)this.getHighLimit(), (Context)bFacets)));
            if (this.isLowLimitEnabled()) {
                map.put("lowLimit", BString.make((String)BDouble.toString((double)this.getLowLimit(), (Context)bFacets)));
            }
        } else if (this.current instanceof LowAlarmState) {
            if (!this.getLowLimitText().equals((Object)BFormat.DEFAULT)) {
                map.put("msgText", BString.make((String)this.getLowLimitText().getFormat()));
            }
            if (this.isHighLimitEnabled()) {
                map.put("highLimit", BString.make((String)BDouble.toString((double)this.getHighLimit(), (Context)bFacets)));
            }
            map.put("lowLimit", BString.make((String)BDouble.toString((double)this.getLowLimit(), (Context)bFacets)));
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        this.executePoint();
    }

    void transition(OutOfRangeState outOfRangeState) {
        this.current = outOfRangeState;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.current = new NormalState();
    }

    public BOutOfRangeFaultAlgorithm() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$alarm$ext$fault$BOutOfRangeFaultAlgorithm;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$ext$fault$BOutOfRangeFaultAlgorithm = BOutOfRangeFaultAlgorithm.class("[Ljavax.baja.alarm.ext.fault.BOutOfRangeFaultAlgorithm;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class HighAlarmState
    extends OutOfRangeState {
        public String tag() {
            return "HighAlarmState";
        }

        public BAlarmState evaluate(double d) {
            if (!(d >= BOutOfRangeFaultAlgorithm.this.getHighLimit() - BOutOfRangeFaultAlgorithm.this.getDeadband())) {
                if (d < BOutOfRangeFaultAlgorithm.this.getLowLimit() && BOutOfRangeFaultAlgorithm.this.isLowLimitEnabled()) {
                    BOutOfRangeFaultAlgorithm.this.transition(new LowAlarmState());
                    return BAlarmState.fault;
                }
                if (d < BOutOfRangeFaultAlgorithm.this.getHighLimit() - BOutOfRangeFaultAlgorithm.this.getDeadband()) {
                    BOutOfRangeFaultAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
            }
            return null;
        }

        public HighAlarmState() {
            BOutOfRangeFaultAlgorithm.this.setInHighState(true);
            BOutOfRangeFaultAlgorithm.this.setInLowState(false);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LowAlarmState
    extends OutOfRangeState {
        public String tag() {
            return "LowAlarmState";
        }

        public BAlarmState evaluate(double d) {
            if (!(d <= BOutOfRangeFaultAlgorithm.this.getLowLimit() + BOutOfRangeFaultAlgorithm.this.getDeadband())) {
                if (d > BOutOfRangeFaultAlgorithm.this.getHighLimit() && BOutOfRangeFaultAlgorithm.this.isHighLimitEnabled()) {
                    BOutOfRangeFaultAlgorithm.this.transition(new HighAlarmState());
                    return BAlarmState.fault;
                }
                if (d > BOutOfRangeFaultAlgorithm.this.getLowLimit() + BOutOfRangeFaultAlgorithm.this.getDeadband()) {
                    BOutOfRangeFaultAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
            }
            return null;
        }

        public LowAlarmState() {
            BOutOfRangeFaultAlgorithm.this.setInHighState(false);
            BOutOfRangeFaultAlgorithm.this.setInLowState(true);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NormalState
    extends OutOfRangeState {
        public String tag() {
            return "Normal";
        }

        public BAlarmState evaluate(double d) {
            if (d < BOutOfRangeFaultAlgorithm.this.getLowLimit() && BOutOfRangeFaultAlgorithm.this.isLowLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new LowAlarmState());
                return BAlarmState.fault;
            }
            if ((!(d >= BOutOfRangeFaultAlgorithm.this.getLowLimit()) || !(d <= BOutOfRangeFaultAlgorithm.this.getHighLimit())) && d > BOutOfRangeFaultAlgorithm.this.getHighLimit() && BOutOfRangeFaultAlgorithm.this.isHighLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new HighAlarmState());
                return BAlarmState.fault;
            }
            return null;
        }

        public NormalState() {
            BOutOfRangeFaultAlgorithm.this.setInHighState(false);
            BOutOfRangeFaultAlgorithm.this.setInLowState(false);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private abstract class OutOfRangeState {
        public abstract String tag();

        public abstract BAlarmState evaluate(double var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ValidateReturnFromLowState
    extends OutOfRangeState {
        public String tag() {
            return "ValidateReturnFromLowState";
        }

        public BAlarmState evaluate(double d) {
            if (d <= BOutOfRangeFaultAlgorithm.this.getLowLimit() + BOutOfRangeFaultAlgorithm.this.getDeadband() && BOutOfRangeFaultAlgorithm.this.isLowLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new LowAlarmState());
            } else {
                if (d > BOutOfRangeFaultAlgorithm.this.getHighLimit() && BOutOfRangeFaultAlgorithm.this.isHighLimitEnabled()) {
                    BOutOfRangeFaultAlgorithm.this.transition(new HighAlarmState());
                    return BAlarmState.fault;
                }
                if (d > BOutOfRangeFaultAlgorithm.this.getLowLimit() + BOutOfRangeFaultAlgorithm.this.getDeadband()) {
                    BOutOfRangeFaultAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
            }
            return null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ValidateLowAlarmState
    extends OutOfRangeState {
        public String tag() {
            return "ValidateLowAlarmState";
        }

        public BAlarmState evaluate(double d) {
            if (d < BOutOfRangeFaultAlgorithm.this.getLowLimit() && BOutOfRangeFaultAlgorithm.this.isLowLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new LowAlarmState());
                return BAlarmState.fault;
            }
            if (d > BOutOfRangeFaultAlgorithm.this.getHighLimit() && BOutOfRangeFaultAlgorithm.this.isHighLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new HighAlarmState());
                return BAlarmState.fault;
            }
            if (d >= BOutOfRangeFaultAlgorithm.this.getLowLimit()) {
                BOutOfRangeFaultAlgorithm.this.transition(new NormalState());
                return BAlarmState.normal;
            }
            return null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ValidateReturnFromHighState
    extends OutOfRangeState {
        public String tag() {
            return "ValidateReturnFromHighState";
        }

        public BAlarmState evaluate(double d) {
            if (d > BOutOfRangeFaultAlgorithm.this.getHighLimit() - BOutOfRangeFaultAlgorithm.this.getDeadband() && BOutOfRangeFaultAlgorithm.this.isHighLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new HighAlarmState());
                return BAlarmState.fault;
            }
            if (d < BOutOfRangeFaultAlgorithm.this.getLowLimit() && BOutOfRangeFaultAlgorithm.this.isLowLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new LowAlarmState());
                return BAlarmState.fault;
            }
            if (d < BOutOfRangeFaultAlgorithm.this.getHighLimit() - BOutOfRangeFaultAlgorithm.this.getDeadband()) {
                BOutOfRangeFaultAlgorithm.this.transition(new NormalState());
                return BAlarmState.normal;
            }
            return null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ValidateHighAlarmState
    extends OutOfRangeState {
        public String tag() {
            return "ValidateHighAlarmState";
        }

        public BAlarmState evaluate(double d) {
            if (d < BOutOfRangeFaultAlgorithm.this.getLowLimit() && BOutOfRangeFaultAlgorithm.this.isLowLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new LowAlarmState());
                return BAlarmState.fault;
            }
            if (d > BOutOfRangeFaultAlgorithm.this.getHighLimit() && BOutOfRangeFaultAlgorithm.this.isHighLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new HighAlarmState());
                return BAlarmState.fault;
            }
            if (d <= BOutOfRangeFaultAlgorithm.this.getHighLimit()) {
                BOutOfRangeFaultAlgorithm.this.transition(new NormalState());
                return BAlarmState.normal;
            }
            return null;
        }
    }
}

