/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm.ext;

import java.util.HashMap;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BAlarmTimestamps;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.control.BControlPoint;
import javax.baja.control.BDiscretePoint;
import javax.baja.control.BPointExtension;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BModule;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAlarmSourceExt
extends BPointExtension
implements BIAlarmSource {
    public static final Property alarmInhibit = BAlarmSourceExt.newProperty((int)0, (BValue)new BStatusBoolean(false), null);
    public static final Property inhibitTime = BAlarmSourceExt.newProperty((int)0, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)));
    public static final Property alarmState = BAlarmSourceExt.newProperty((int)1, (BValue)BAlarmState.normal, null);
    public static final Property timeDelay = BAlarmSourceExt.newProperty((int)0, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)));
    public static final Property timeDelayToNormal = BAlarmSourceExt.newProperty((int)0, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)));
    public static final Property alarmEnable = BAlarmSourceExt.newProperty((int)0, (BValue)BAlarmTransitionBits.DEFAULT, (BFacets)BFacets.make((String[])new String[]{"showNormal", "showAlert"}, (BIDataValue[])new BBoolean[]{BBoolean.FALSE, BBoolean.FALSE}));
    public static final Property ackedTransitions = BAlarmSourceExt.newProperty((int)7, (BValue)BAlarmTransitionBits.ALL, null);
    public static final Property toOffnormalTimes = BAlarmSourceExt.newProperty((int)1, (BValue)new BAlarmTimestamps(), null);
    public static final Property toFaultTimes = BAlarmSourceExt.newProperty((int)1, (BValue)new BAlarmTimestamps(), null);
    public static final Property timeInCurrentState = BAlarmSourceExt.newProperty((int)3, (BValue)BRelTime.DEFAULT, null);
    public static final Property sourceName = BAlarmSourceExt.newProperty((int)0, (BValue)BFormat.make((String)"%parent.displayName%"), null);
    public static final Property toFaultText = BAlarmSourceExt.newProperty((int)0, (BValue)BFormat.make((String)""), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property toOffnormalText = BAlarmSourceExt.newProperty((int)0, (BValue)BFormat.make((String)""), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property toNormalText = BAlarmSourceExt.newProperty((int)0, (BValue)BFormat.make((String)""), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property hyperlinkOrd = BAlarmSourceExt.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"ordRelativize", (BIDataValue)BBoolean.FALSE, (String)"chooseView", (BIDataValue)BBoolean.TRUE));
    public static final Property soundFile = BAlarmSourceExt.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"file:AudioFile")));
    public static final Property alarmIcon = BAlarmSourceExt.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"file:ImageFile")));
    public static final Property alarmInstructions = BAlarmSourceExt.newProperty((int)0, (BValue)BAlarmInstructions.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:InstructionsFE")));
    public static final Property faultAlgorithm = BAlarmSourceExt.newProperty((int)0, (BValue)new BFaultAlgorithm(), null);
    public static final Property offnormalAlgorithm = BAlarmSourceExt.newProperty((int)0, (BValue)new BOffnormalAlgorithm(), null);
    public static final Property alarmClass = BAlarmSourceExt.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Property metaData = BAlarmSourceExt.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Property status = BAlarmSourceExt.newProperty((int)7, (BValue)BStatus.DEFAULT, null);
    public static final Action timerExpired = BAlarmSourceExt.newAction((int)4, null);
    public static final Action inhibitTimerExpired = BAlarmSourceExt.newAction((int)4, null);
    public static final Action ackAlarm = BAlarmSourceExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Topic toOffnormal = BAlarmSourceExt.newTopic((int)0, null);
    public static final Topic toFault = BAlarmSourceExt.newTopic((int)0, null);
    public static final Topic toNormal = BAlarmSourceExt.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static final int NON_ALARM_BITS = -139;
    private static Log log;
    private Clock.Ticket ticket;
    private Clock.Ticket inhibitTicket;
    private long timeOfLastStateChange;
    private AlarmSupport support;
    private boolean unackedAlarm;
    private BAbsTime lastOffnormalTime;
    private BAbsTime lastFaultTime;
    private BAbsTime lastToNormalTime;
    private BAbsTime lastAckTime;
    private boolean atSteadyState;
    static /* synthetic */ Class class$javax$baja$alarm$ext$BAlarmSourceExt;

    public BStatusBoolean getAlarmInhibit() {
        return (BStatusBoolean)this.get(alarmInhibit);
    }

    public void setAlarmInhibit(BStatusBoolean bStatusBoolean) {
        this.set(alarmInhibit, (BValue)bStatusBoolean, null);
    }

    public BRelTime getInhibitTime() {
        return (BRelTime)this.get(inhibitTime);
    }

    public void setInhibitTime(BRelTime bRelTime) {
        this.set(inhibitTime, (BValue)bRelTime, null);
    }

    public BAlarmState getAlarmState() {
        return (BAlarmState)this.get(alarmState);
    }

    public void setAlarmState(BAlarmState bAlarmState) {
        this.set(alarmState, (BValue)bAlarmState, null);
    }

    public BRelTime getTimeDelay() {
        return (BRelTime)this.get(timeDelay);
    }

    public void setTimeDelay(BRelTime bRelTime) {
        this.set(timeDelay, (BValue)bRelTime, null);
    }

    public BRelTime getTimeDelayToNormal() {
        return (BRelTime)this.get(timeDelayToNormal);
    }

    public void setTimeDelayToNormal(BRelTime bRelTime) {
        this.set(timeDelayToNormal, (BValue)bRelTime, null);
    }

    public BAlarmTransitionBits getAlarmEnable() {
        return (BAlarmTransitionBits)this.get(alarmEnable);
    }

    public void setAlarmEnable(BAlarmTransitionBits bAlarmTransitionBits) {
        this.set(alarmEnable, (BValue)bAlarmTransitionBits, null);
    }

    public BAlarmTransitionBits getAckedTransitions() {
        return (BAlarmTransitionBits)this.get(ackedTransitions);
    }

    public void setAckedTransitions(BAlarmTransitionBits bAlarmTransitionBits) {
        this.set(ackedTransitions, (BValue)bAlarmTransitionBits, null);
    }

    public BAlarmTimestamps getToOffnormalTimes() {
        return (BAlarmTimestamps)this.get(toOffnormalTimes);
    }

    public void setToOffnormalTimes(BAlarmTimestamps bAlarmTimestamps) {
        this.set(toOffnormalTimes, (BValue)bAlarmTimestamps, null);
    }

    public BAlarmTimestamps getToFaultTimes() {
        return (BAlarmTimestamps)this.get(toFaultTimes);
    }

    public void setToFaultTimes(BAlarmTimestamps bAlarmTimestamps) {
        this.set(toFaultTimes, (BValue)bAlarmTimestamps, null);
    }

    public BRelTime getTimeInCurrentState() {
        return (BRelTime)this.get(timeInCurrentState);
    }

    public void setTimeInCurrentState(BRelTime bRelTime) {
        this.set(timeInCurrentState, (BValue)bRelTime, null);
    }

    public BFormat getSourceName() {
        return (BFormat)this.get(sourceName);
    }

    public void setSourceName(BFormat bFormat) {
        this.set(sourceName, (BValue)bFormat, null);
    }

    public BFormat getToFaultText() {
        return (BFormat)this.get(toFaultText);
    }

    public void setToFaultText(BFormat bFormat) {
        this.set(toFaultText, (BValue)bFormat, null);
    }

    public BFormat getToOffnormalText() {
        return (BFormat)this.get(toOffnormalText);
    }

    public void setToOffnormalText(BFormat bFormat) {
        this.set(toOffnormalText, (BValue)bFormat, null);
    }

    public BFormat getToNormalText() {
        return (BFormat)this.get(toNormalText);
    }

    public void setToNormalText(BFormat bFormat) {
        this.set(toNormalText, (BValue)bFormat, null);
    }

    public BOrd getHyperlinkOrd() {
        return (BOrd)this.get(hyperlinkOrd);
    }

    public void setHyperlinkOrd(BOrd bOrd) {
        this.set(hyperlinkOrd, (BValue)bOrd, null);
    }

    public BOrd getSoundFile() {
        return (BOrd)this.get(soundFile);
    }

    public void setSoundFile(BOrd bOrd) {
        this.set(soundFile, (BValue)bOrd, null);
    }

    public BOrd getAlarmIcon() {
        return (BOrd)this.get(alarmIcon);
    }

    public void setAlarmIcon(BOrd bOrd) {
        this.set(alarmIcon, (BValue)bOrd, null);
    }

    public BAlarmInstructions getAlarmInstructions() {
        return (BAlarmInstructions)this.get(alarmInstructions);
    }

    public void setAlarmInstructions(BAlarmInstructions bAlarmInstructions) {
        this.set(alarmInstructions, (BValue)bAlarmInstructions, null);
    }

    public BFaultAlgorithm getFaultAlgorithm() {
        return (BFaultAlgorithm)this.get(faultAlgorithm);
    }

    public void setFaultAlgorithm(BFaultAlgorithm bFaultAlgorithm) {
        this.set(faultAlgorithm, (BValue)bFaultAlgorithm, null);
    }

    public BOffnormalAlgorithm getOffnormalAlgorithm() {
        return (BOffnormalAlgorithm)this.get(offnormalAlgorithm);
    }

    public void setOffnormalAlgorithm(BOffnormalAlgorithm bOffnormalAlgorithm) {
        this.set(offnormalAlgorithm, (BValue)bOffnormalAlgorithm, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String string) {
        this.setString(alarmClass, string, null);
    }

    public BFacets getMetaData() {
        return (BFacets)this.get(metaData);
    }

    public void setMetaData(BFacets bFacets) {
        this.set(metaData, (BValue)bFacets, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    public void inhibitTimerExpired() {
        this.invoke(inhibitTimerExpired, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public void fireToOffnormal(BAlarmRecord bAlarmRecord) {
        this.fire(toOffnormal, (BValue)bAlarmRecord, null);
    }

    public void fireToFault(BAlarmRecord bAlarmRecord) {
        this.fire(toFault, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.support = new AlarmSupport((BIAlarmSource)this, this.getAlarmClass());
        this.timeOfLastStateChange = Clock.ticks();
        this.initScheduler();
        if (Sys.atSteadyState()) {
            this.atSteadyState = true;
        }
    }

    public void atSteadyState() throws Exception {
        this.atSteadyState = true;
        this.executePoint();
    }

    public boolean requiresPointSubscription() {
        return this.getAlarmEnable().isToOffnormal() || this.getAlarmEnable().isToFault();
    }

    public void checkPointSubscription() {
        BControlPoint bControlPoint = this.getParentPoint();
        if (bControlPoint != null) {
            bControlPoint.checkExtensionsRequireSubscription();
        }
    }

    public boolean isParentLegal(BComponent bComponent) {
        if (bComponent instanceof BControlPoint) {
            if (!this.getOffnormalAlgorithm().isGrandparentLegal(bComponent)) {
                return false;
            }
            return this.getFaultAlgorithm().isGrandparentLegal(bComponent);
        }
        return false;
    }

    protected boolean isSiblingLegal(BComponent bComponent) {
        return true;
    }

    private final void initScheduler() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)10000L), (Action)timerExpired, null);
    }

    public BOrdList getSourceOrd() {
        return this.support.getSourceOrd();
    }

    public void doTimerExpired() {
        this.setTimeInCurrentState(BRelTime.make((long)(Clock.ticks() - this.timeOfLastStateChange)));
    }

    public void doInhibitTimerExpired() {
        this.inhibitTicket = null;
        this.checkPointSubscription();
        this.executePoint();
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        if (!this.isRunning()) {
            return BBoolean.make((boolean)false);
        }
        try {
            boolean bl = this.support.ackAlarm(bAlarmRecord);
            this.lastAckTime = bAlarmRecord.getAckTime();
            BSourceState bSourceState = bAlarmRecord.getAlarmTransition();
            if (bl) {
                BAlarmTransitionBits bAlarmTransitionBits = this.getAckedTransitions();
                this.setAckedTransitions(BAlarmTransitionBits.make(bAlarmTransitionBits, bSourceState.getAlarmTransitionBits(), true));
                bAlarmTransitionBits = this.getAckedTransitions();
                bSourceState = bAlarmRecord.getSourceState();
                if (bSourceState == BSourceState.normal) {
                    this.setAckedTransitions(BAlarmTransitionBits.make(bAlarmTransitionBits, bSourceState.getAlarmTransitionBits(), true));
                }
                BAlarmTimestamps bAlarmTimestamps = null;
                BSourceState bSourceState2 = bAlarmRecord.getAlarmTransition();
                if (bSourceState2 == BSourceState.offnormal) {
                    bAlarmTimestamps = this.getToOffnormalTimes();
                } else if (bSourceState2 == BSourceState.fault) {
                    bAlarmTimestamps = this.getToFaultTimes();
                }
                if (bAlarmTimestamps != null && !bAlarmTimestamps.getAlarmTime().isNull()) {
                    bAlarmTimestamps.setAckTime(bAlarmRecord.getAckTime());
                }
            }
            if (bl && this.getStatus().isUnackedAlarm()) {
                this.setStatus(BStatus.makeUnackedAlarm((BStatus)this.getStatus(), (boolean)false));
            }
            this.executePoint();
            return BBoolean.make((boolean)bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return BBoolean.make((boolean)false);
        }
    }

    public void onExecute(BStatusValue bStatusValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (!this.atSteadyState) {
            return;
        }
        boolean bl = bStatusValue.getStatus().isAlarm();
        boolean bl2 = bStatusValue.getStatus().isFault();
        this.checkAlarms(bStatusValue);
        String string = Lexicon.make((BModule)TYPE.getModule(), (Context)context).getText("alarm.alarmInhibit.facet");
        BStatus bStatus = bStatusValue.getStatus();
        if (this.inhibitTicket == null || this.inhibitTicket.isExpired()) {
            if (this.getAlarmInhibit().getBoolean() || this.isTimerActive()) {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (String)string, (boolean)true));
            } else {
                this.setStatus(BStatus.make((int)this.getStatus().getBits(), (BFacets)BFacets.makeRemove((BFacets)this.getStatus().getFacets(), (String)string)));
            }
        } else if (this.getAlarmInhibit().getBoolean() || this.isTimerActive()) {
            this.setStatus(BStatus.make((int)this.getStatus().getBits(), (BFacets)BFacets.makeRemove((BFacets)this.getStatus().getFacets(), (String)string)));
        } else {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (String)string, (boolean)true));
        }
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$javax$baja$alarm$ext$BAlarmSourceExt;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$ext$BAlarmSourceExt = BAlarmSourceExt.class("[Ljavax.baja.alarm.ext.BAlarmSourceExt;", false);
        }
        BAlarmSourceExt[] bAlarmSourceExtArray = (BAlarmSourceExt[])bControlPoint.getChildren(clazz);
        int n = bStatusValue.getStatus().getBits() & 0xFFFFFF75;
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < bAlarmSourceExtArray.length) {
            n |= bAlarmSourceExtArray[n2].getStatus().getBits();
            if (bAlarmSourceExtArray[n2].getStatus().getb(string, false)) {
                bl3 = true;
            }
            if (bAlarmSourceExtArray[n2] == this) break;
            ++n2;
        }
        if (bl3) {
            bStatusValue.setStatus(BStatus.make((int)n, (BFacets)BFacets.make((BFacets)bStatusValue.getStatus().getFacets(), (String)string, (BIDataValue)BBoolean.TRUE)));
        } else {
            bStatusValue.setStatus(BStatus.make((int)n, (BFacets)BFacets.makeRemove((BFacets)bStatusValue.getStatus().getFacets(), (String)string)));
        }
        if (bl) {
            bStatusValue.setStatusInAlarm(true);
        }
        if (bl2) {
            bStatusValue.setStatusFault(true);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)alarmClass) && this.support != null) {
            this.support.setAlarmClass(this.getAlarmClass());
        } else if (property.equals((Object)timeDelay)) {
            this.executePoint();
        } else if (property.equals((Object)alarmInhibit)) {
            this.checkPointSubscription();
            if (this.getInhibitTime().getMillis() > 0L) {
                if (this.inhibitTicket != null) {
                    this.inhibitTicket.cancel();
                }
                if (!this.getAlarmInhibit().getBoolean()) {
                    this.inhibitTicket = Clock.schedule((BComponent)this, (BRelTime)this.getInhibitTime(), (Action)inhibitTimerExpired, null);
                } else if (this.getParent() instanceof BDiscretePoint) {
                    this.inhibitTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)(this.getInhibitTime().getMillis() * (long)3)), (Action)inhibitTimerExpired, null);
                }
            } else {
                this.executePoint();
            }
        } else if (property.equals((Object)alarmEnable)) {
            this.checkPointSubscription();
            this.executePoint();
        }
    }

    protected boolean isTimerActive() {
        try {
            return this.getOffnormalAlgorithm().isTimerExpired() ^ true;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    protected boolean isInhibitTimerActive() {
        try {
            boolean bl = false;
            if (this.inhibitTicket != null && !this.inhibitTicket.isExpired()) {
                bl = true;
            }
            return bl;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    protected void checkAlarms(BStatusValue bStatusValue) {
        boolean bl;
        BAlarmState bAlarmState = null;
        BAlarmState bAlarmState2 = this.getAlarmState();
        if ((BAlarmService)Sys.getService((Type)BAlarmService.TYPE) == null) {
            return;
        }
        if (bStatusValue.getStatus().isDisabled() || bStatusValue.getStatus().isStale()) {
            return;
        }
        boolean bl2 = false;
        if (this.getInhibitTime().getMillis() == 0L && this.getAlarmInhibit().getBoolean() || (this.inhibitTicket == null || this.inhibitTicket.isExpired()) && this.getAlarmInhibit().getBoolean() || this.inhibitTicket != null && !this.inhibitTicket.isExpired() && !this.getAlarmInhibit().getBoolean()) {
            bl2 = true;
        }
        if (bl = bl2) {
            if (bAlarmState2 != BAlarmState.normal) {
                bAlarmState = BAlarmState.normal;
            }
        } else {
            if (this.getAlarmEnable().isToFault()) {
                bAlarmState = this.getFaultAlgorithm().checkFault(bStatusValue);
            }
            if (bAlarmState2 == BAlarmState.fault && !this.getAlarmEnable().isToFault()) {
                bAlarmState = BAlarmState.normal;
            }
            if (bAlarmState != BAlarmState.fault && this.getAlarmEnable().isToOffnormal()) {
                if (bAlarmState == null) {
                    if (bAlarmState2 != BAlarmState.fault) {
                        bAlarmState = this.getOffnormalAlgorithm().checkAlarmState(bStatusValue, this.getTimeDelay().getMillis(), this.getTimeDelayToNormal().getMillis());
                    }
                } else if (bAlarmState == BAlarmState.normal && (bAlarmState = this.getOffnormalAlgorithm().checkAlarmState(bStatusValue, this.getTimeDelay().getMillis(), this.getTimeDelayToNormal().getMillis())) == null) {
                    bAlarmState = BAlarmState.normal;
                }
            }
            if (bAlarmState2.isOffnormal() && !this.getAlarmEnable().isToOffnormal()) {
                bAlarmState = BAlarmState.normal;
            }
        }
        boolean bl3 = true;
        if (bAlarmState != null) {
            if (this.getAlarmEnable().isToOffnormal() && bAlarmState.isInAlarm()) {
                this.setStatus(BStatus.makeAlarm((BStatus)this.getStatus(), (boolean)true));
            } else if (!bAlarmState.isInAlarm()) {
                this.setStatus(BStatus.makeAlarm((BStatus)this.getStatus(), (boolean)false));
            }
            if (this.getAlarmEnable().isToFault() && bAlarmState == BAlarmState.fault) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            } else if (bAlarmState != BAlarmState.fault) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            }
            if (bAlarmState == BAlarmState.normal) {
                bl3 = this.alarmStateTransition(BSourceState.normal, BAlarmState.normal, bStatusValue);
                if (bAlarmState2.isOffnormal()) {
                    boolean bl4 = false;
                    if (bl3 || this.support.isAckRequired(BSourceState.offnormal)) {
                        bl4 = true;
                    }
                    bl3 = bl4;
                } else if (bAlarmState2.isInAlarm()) {
                    boolean bl5 = false;
                    if (bl3 || this.support.isAckRequired(BSourceState.fault)) {
                        bl5 = true;
                    }
                    bl3 = bl5;
                }
            } else {
                bl3 = bAlarmState == BAlarmState.fault ? this.alarmStateTransition(BSourceState.fault, BAlarmState.fault, bStatusValue) : this.alarmStateTransition(BSourceState.offnormal, bAlarmState, bStatusValue);
            }
            this.setAlarmState(bAlarmState);
            this.timeOfLastStateChange = Clock.ticks();
            this.setTimeInCurrentState(BRelTime.DEFAULT);
            this.unackedAlarm = bl3;
        } else {
            if (this.getAlarmEnable().isToOffnormal()) {
                this.setStatus(BStatus.makeAlarm((BStatus)this.getStatus(), (boolean)bAlarmState2.isInAlarm()));
            }
            if (this.getAlarmEnable().isToFault()) {
                BStatus bStatus = this.getStatus();
                boolean bl6 = false;
                if (bAlarmState2 == BAlarmState.fault) {
                    bl6 = true;
                }
                this.setStatus(BStatus.makeFault((BStatus)bStatus, (boolean)bl6));
            }
            this.setTimeInCurrentState(BRelTime.make((long)(Clock.ticks() - this.timeOfLastStateChange)));
        }
        BAlarmTransitionBits bAlarmTransitionBits = this.getAckedTransitions();
        if (this.getAlarmEnable().isToOffnormal() || this.getAlarmEnable().isToFault()) {
            if (!(bAlarmTransitionBits.isToOffnormal() && bAlarmTransitionBits.isToFault() && bAlarmTransitionBits.isToNormal() || !bl3)) {
                this.setStatus(BStatus.makeUnackedAlarm((BStatus)this.getStatus(), (boolean)true));
            } else {
                this.setStatus(BStatus.makeUnackedAlarm((BStatus)this.getStatus(), (boolean)false));
            }
        }
        if ((bAlarmState2 == BAlarmState.lowLimit || bAlarmState2 == BAlarmState.highLimit) && bAlarmState == BAlarmState.normal) {
            this.checkAlarms(bStatusValue);
        }
    }

    private final boolean alarmStateTransition(BSourceState bSourceState, BAlarmState bAlarmState, BStatusValue bStatusValue) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object var5_5 = null;
        BOrd bOrd = BOrd.NULL;
        Property property = null;
        boolean bl = false;
        bOrd = this.getHyperlinkOrd();
        if (bSourceState == BSourceState.offnormal) {
            hashMap.put("offnormalValue", BString.make((String)bStatusValue.valueToString((Context)this.getPointFacets())));
            hashMap.put("alarmValue", bStatusValue.getValueValue());
        } else if (bSourceState == BSourceState.fault) {
            hashMap.put("faultValue", BString.make((String)bStatusValue.valueToString((Context)this.getPointFacets())));
            hashMap.put("alarmValue", bStatusValue.getValueValue());
        }
        hashMap.put("presentValue", BString.make((String)bStatusValue.valueToString((Context)this.getPointFacets())));
        hashMap.put("fromState", BString.make((String)this.getAlarmState().getTag()));
        hashMap.put("toState", BString.make((String)bAlarmState.getTag()));
        hashMap.put("sourceName", BString.make((String)this.getSourceName().format((Object)this)));
        if (!bOrd.isNull()) {
            hashMap.put("hyperlinkOrd", BString.make((String)bOrd.toString()));
        }
        if (!this.getSoundFile().isNull()) {
            hashMap.put("soundFile", BString.make((String)this.getSoundFile().toString()));
        }
        if (!this.getAlarmIcon().isNull()) {
            hashMap.put("icon", BString.make((String)this.getAlarmIcon().toString()));
        }
        try {
            if (!this.getAlarmInstructions().equals((Object)BAlarmInstructions.NULL)) {
                hashMap.put("instructions", BString.make((String)this.getAlarmInstructions().encodeToString()));
            }
        }
        catch (Exception exception) {
            log.error("Could not encode Alarm Instructions", (Throwable)exception);
        }
        BFacets bFacets = this.getMetaData();
        String[] stringArray = bFacets.list();
        boolean bl2 = false;
        while (bl2 < stringArray.length) {
            hashMap.put(stringArray[bl2], bFacets.get(stringArray[bl2]));
            bl2 += 1;
        }
        if (bSourceState == BSourceState.normal) {
            hashMap.put("msgText", BString.make((String)this.getToNormalText().getFormat()));
            if (this.getAlarmState().isInAlarm()) {
                this.getOffnormalAlgorithm().writeAlarmData(bStatusValue, hashMap);
            } else {
                this.getFaultAlgorithm().writeAlarmData(bStatusValue, hashMap);
            }
        } else if (bSourceState == BSourceState.offnormal) {
            hashMap.put("msgText", BString.make((String)this.getToOffnormalText().getFormat()));
            hashMap.put(BAlarmTimestamps.count.getDefaultDisplayName(null), BInteger.make((int)(this.getToOffnormalTimes().getCount() + 1)));
            this.getOffnormalAlgorithm().writeAlarmData(bStatusValue, hashMap);
            property = toOffnormalTimes;
        } else if (bSourceState == BSourceState.fault) {
            hashMap.put("msgText", BString.make((String)this.getToFaultText().getFormat()));
            hashMap.put(BAlarmTimestamps.count.getDefaultDisplayName(null), BInteger.make((int)(this.getToFaultTimes().getCount() + 1)));
            this.getFaultAlgorithm().writeAlarmData(bStatusValue, hashMap);
            property = toFaultTimes;
        } else {
            throw new IllegalStateException();
        }
        bl2 = false;
        try {
            Object object;
            bl2 = this.support.isAckRequired(bSourceState);
            BAlarmRecord bAlarmRecord = null;
            if (bSourceState == BSourceState.normal) {
                this.support.toNormal(BFacets.make(hashMap), null);
            } else if (bSourceState == BSourceState.offnormal) {
                bAlarmRecord = this.support.newOffnormalAlarm(BFacets.make(hashMap));
                this.lastOffnormalTime = bAlarmRecord.getTimestamp();
                this.fireToOffnormal(bAlarmRecord);
            } else if (bSourceState == BSourceState.fault) {
                bAlarmRecord = this.support.newFaultAlarm(BFacets.make(hashMap));
                this.lastFaultTime = bAlarmRecord.getTimestamp();
                this.fireToFault(bAlarmRecord);
            }
            if (bAlarmRecord != null) {
                if (bSourceState == BSourceState.normal) {
                    object = this.getToOffnormalTimes();
                    if (!((BAlarmTimestamps)((Object)object)).getAlarmTime().isNull()) {
                        ((BAlarmTimestamps)((Object)object)).setNormalTime(bAlarmRecord.getNormalTime());
                    }
                    if (!((BAlarmTimestamps)((Object)(object = this.getToFaultTimes()))).getAlarmTime().isNull()) {
                        ((BAlarmTimestamps)((Object)object)).setNormalTime(bAlarmRecord.getNormalTime());
                    }
                }
                if (property != null) {
                    object = (BAlarmTimestamps)this.get(property);
                    ((BAlarmTimestamps)((Object)object)).setAlarmTime(bAlarmRecord.getTimestamp());
                    ((BAlarmTimestamps)((Object)object)).setAckTime(BAbsTime.NULL);
                    ((BAlarmTimestamps)((Object)object)).setNormalTime(BAbsTime.NULL);
                    ((BAlarmTimestamps)((Object)object)).setCount(((BAlarmTimestamps)((Object)object)).getCount() + 1);
                }
            }
            if (bl2) {
                object = this.getAckedTransitions();
                this.setAckedTransitions(BAlarmTransitionBits.make(object, bSourceState.getAlarmTransitionBits(), false));
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("AlarmState Transition Failed - AlarmService not found.");
        }
        catch (Exception exception) {
            log.error("AlarmState Transition Failed: " + exception, (Throwable)exception);
        }
        return bl2;
    }

    public void fireToNormal(BAlarmRecord bAlarmRecord) {
        this.lastToNormalTime = bAlarmRecord.getNormalTime();
        if (bAlarmRecord.getSourceState().getOrdinal() == 0) {
            BAlarmTimestamps bAlarmTimestamps = this.getToOffnormalTimes();
            if (!bAlarmTimestamps.getAlarmTime().isNull()) {
                bAlarmTimestamps.setNormalTime(bAlarmRecord.getNormalTime());
            }
            if (!(bAlarmTimestamps = this.getToFaultTimes()).getAlarmTime().isNull()) {
                bAlarmTimestamps.setNormalTime(bAlarmRecord.getNormalTime());
            }
        }
        this.fire(toNormal, (BValue)bAlarmRecord, null);
    }

    public BAbsTime getLastOffnormalTime() {
        return this.lastOffnormalTime;
    }

    public BAbsTime getLastFaultTime() {
        return this.lastFaultTime;
    }

    public BAbsTime getLastToNormalTime() {
        return this.lastToNormalTime;
    }

    public BAbsTime getLastAckTime() {
        return this.lastAckTime;
    }

    public BIcon getIcon() {
        return icon;
    }

    private static final void dump(String string) {
        System.out.println(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.timeOfLastStateChange = 0L;
        this.unackedAlarm = false;
        this.lastOffnormalTime = BAbsTime.NULL;
        this.lastFaultTime = BAbsTime.NULL;
        this.lastToNormalTime = BAbsTime.NULL;
        this.lastAckTime = BAbsTime.NULL;
        this.atSteadyState = false;
    }

    public BAlarmSourceExt() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$alarm$ext$BAlarmSourceExt;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$ext$BAlarmSourceExt = BAlarmSourceExt.class("[Ljavax.baja.alarm.ext.BAlarmSourceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"control/controlExtension.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
        log = Log.getLog((String)"alarm");
    }
}

