/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BRecoverableRecipient
extends BAlarmRecipient
implements BIStatus {
    public static final Property status = BRecoverableRecipient.newProperty((int)1, (BValue)BStatus.DEFAULT, null);
    public static final Property lastSendTime = BRecoverableRecipient.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property lastAckSendTime = BRecoverableRecipient.newProperty((int)4, (BValue)BAbsTime.NULL, null);
    public static final Property lastFailureTime = BRecoverableRecipient.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property lastFailureCause = BRecoverableRecipient.newProperty((int)1, (String)"", null);
    public static final Property retryInterval = BRecoverableRecipient.newProperty((int)0, (BValue)BRelTime.make((long)15000L), null);
    public static final Property queuedAlarmCount = BRecoverableRecipient.newProperty((int)3, (int)0, null);
    public static final Property persistent = BRecoverableRecipient.newProperty((int)0, (boolean)true, null);
    public static final Action clearAlarmQueue = BRecoverableRecipient.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static final Log logger;
    private RetryThread retryThread;
    Queue q;
    BOrd persistenceDirectory;
    static /* synthetic */ Class class$javax$baja$alarm$BRecoverableRecipient;
    static /* synthetic */ Class class$javax$baja$sys$BLink;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public BAbsTime getLastSendTime() {
        return (BAbsTime)this.get(lastSendTime);
    }

    public void setLastSendTime(BAbsTime bAbsTime) {
        this.set(lastSendTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastAckSendTime() {
        return (BAbsTime)this.get(lastAckSendTime);
    }

    public void setLastAckSendTime(BAbsTime bAbsTime) {
        this.set(lastAckSendTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastFailureTime() {
        return (BAbsTime)this.get(lastFailureTime);
    }

    public void setLastFailureTime(BAbsTime bAbsTime) {
        this.set(lastFailureTime, (BValue)bAbsTime, null);
    }

    public String getLastFailureCause() {
        return this.getString(lastFailureCause);
    }

    public void setLastFailureCause(String string) {
        this.setString(lastFailureCause, string, null);
    }

    public BRelTime getRetryInterval() {
        return (BRelTime)this.get(retryInterval);
    }

    public void setRetryInterval(BRelTime bRelTime) {
        this.set(retryInterval, (BValue)bRelTime, null);
    }

    public int getQueuedAlarmCount() {
        return this.getInt(queuedAlarmCount);
    }

    public void setQueuedAlarmCount(int n) {
        this.setInt(queuedAlarmCount, n, null);
    }

    public boolean getPersistent() {
        return this.getBoolean(persistent);
    }

    public void setPersistent(boolean bl) {
        this.setBoolean(persistent, bl, null);
    }

    public void clearAlarmQueue() {
        this.invoke(clearAlarmQueue, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.persistenceDirectory = BOrd.make((String)("file:^alarm/" + this.getName() + "AlarmQueue"));
        this.retryThread = new RetryThread();
        this.retryThread.start();
    }

    public void stopped() throws Exception {
        if (this.retryThread != null) {
            this.retryThread.kill();
            this.retryThread = null;
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("RecoverableRecipient");
        spyWriter.prop((Object)"persistenceDirectory", (Object)("" + this.persistenceDirectory));
        spyWriter.endProps();
        super.spy(spyWriter);
    }

    private final void poll() {
        try {
            if (this.getPersistent() && this.getQueuedAlarmCount() > 0) {
                this.dequeueDisk();
            } else {
                this.dequeueMemory();
            }
        }
        catch (Exception exception) {}
        if (this.getQueuedAlarmCount() == 0) {
            this.retryThread.kill();
            this.retryThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleAlarm(BAlarmRecord bAlarmRecord) {
        logger.trace("BRecoverableRecipient.handleAlarm " + bAlarmRecord.getTimestamp());
        try {
            logger.trace("  sending ... " + bAlarmRecord.getTimestamp());
            boolean bl = this.sendAlarm(bAlarmRecord);
            if (!bl) {
                return;
            }
            this.setLastSendTime(BAbsTime.make());
            logger.trace("  sent @ " + this.getLastSendTime());
            this.setStatus(BStatus.ok);
            return;
        }
        catch (Exception exception) {
            this.setStatus(BStatus.fault);
            this.setLastFailureTime(BAbsTime.make());
            if (exception instanceof BajaRuntimeException) {
                this.setLastFailureCause(((BajaRuntimeException)exception).getCause().toString());
            } else {
                this.setLastFailureCause(exception.toString());
            }
            logger.trace("  failed @ " + this.getLastFailureTime() + " -> " + this.getLastFailureCause());
            if (this.getPersistent()) {
                try {
                    File file = null;
                    BRecoverableRecipient bRecoverableRecipient = this;
                    synchronized (bRecoverableRecipient) {
                        file = new File(this.dirFile(), bAlarmRecord.getUuid().toString() + ".xml");
                    }
                    ValueDocEncoder valueDocEncoder = new ValueDocEncoder(file);
                    valueDocEncoder.encodeDocument((BValue)bAlarmRecord);
                    valueDocEncoder.close();
                    this.setQueuedAlarmCount(this.dirFile().listFiles().length);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                this.q.enqueue((Object)bAlarmRecord);
                this.setQueuedAlarmCount(this.q.size());
            }
            if (this.retryThread != null) return;
            this.retryThread = new RetryThread();
            this.retryThread.start();
        }
    }

    public void doClearAlarmQueue() {
        if (this.getPersistent() && this.getQueuedAlarmCount() > 0) {
            try {
                File file = this.dirFile();
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    fileArray[n].delete();
                    this.setQueuedAlarmCount(this.getQueuedAlarmCount() - 1);
                    ++n;
                }
            }
            catch (Exception exception) {
                return;
            }
            this.setQueuedAlarmCount(0);
        } else {
            this.q.clear();
            this.setQueuedAlarmCount(0);
        }
    }

    private final File dirFile() throws IOException {
        BFileSystem bFileSystem = BFileSystem.INSTANCE;
        FilePath filePath = (FilePath)this.persistenceDirectory.parse()[0];
        BDirectory bDirectory = bFileSystem.makeDir(filePath);
        return ((BLocalFileStore)bDirectory.getStore()).getLocalFile();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void dequeueMemory() throws Exception {
        int n = this.q.size();
        int n2 = 0;
        while (n2 < n) {
            Object var4_3;
            try {
                this.handleAlarm((BAlarmRecord)((Object)this.q.dequeue()));
            }
            catch (Throwable throwable) {
                var4_3 = null;
                this.setQueuedAlarmCount(this.q.size());
                throw throwable;
            }
            {
                var4_3 = null;
                this.setQueuedAlarmCount(this.q.size());
                ++n2;
                continue;
            }
            break;
        }
        return;
    }

    private final void dequeueDisk() throws Exception {
        File file = this.dirFile();
        File[] fileArray = file.listFiles();
        Arrays.sort(fileArray, new Comparator(){

            public final int compare(Object object, Object object2) {
                File file = (File)object;
                File file2 = (File)object2;
                return (int)(file.lastModified() - file2.lastModified());
            }
        });
        try {
            int n = 0;
            while (n < fileArray.length) {
                BAlarmRecord bAlarmRecord = (BAlarmRecord)new ValueDocDecoder(fileArray[n]).decodeDocument();
                this.handleAlarm(bAlarmRecord);
                fileArray[n].delete();
                ++n;
            }
            this.setQueuedAlarmCount(0);
        }
        catch (Exception exception) {}
    }

    protected abstract boolean sendAlarm(BAlarmRecord var1) throws Exception;

    public BIcon getIcon() {
        return icon;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getSubscribedAlarmClasses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            SlotCursor slotCursor = this.getProperties();
            while (true) {
                Class clazz;
                if ((clazz = class$javax$baja$sys$BLink) == null) {
                    clazz = BRecoverableRecipient.class("[Ljavax.baja.sys.BLink;", false);
                }
                if (!slotCursor.next(clazz)) {
                    return arrayList.toArray(new String[arrayList.size()]);
                }
                BLink bLink = (BLink)slotCursor.get();
                if (!(bLink.getSourceComponent() instanceof BAlarmClass)) continue;
                arrayList.add(bLink.getSourceComponent().getName());
            }
        }
        catch (NullPointerException nullPointerException) {}
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.q = new Queue();
    }

    public BRecoverableRecipient() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$alarm$BRecoverableRecipient;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BRecoverableRecipient = BRecoverableRecipient.class("[Ljavax.baja.alarm.BRecoverableRecipient;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"alarm.png");
        logger = Log.getLog((String)"alarm");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RetryThread
    extends Thread {
        private boolean alive;

        void kill() {
            this.alive = false;
            this.interrupt();
        }

        public void run() {
            this.alive = true;
            while (this.alive) {
                try {
                    RetryThread.sleep(Math.max(BRecoverableRecipient.this.getRetryInterval().getMillis(), 1000L));
                }
                catch (InterruptedException interruptedException) {
                    this.alive = false;
                    break;
                }
                try {
                    BRecoverableRecipient.this.poll();
                }
                catch (Exception exception) {}
            }
        }

        public boolean isRunning() {
            return this.alive;
        }

        private final /* synthetic */ void this() {
            this.alive = false;
        }

        public RetryThread() {
            super("alarm:RecipRetryThread");
            this.this();
        }
    }
}

