/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import com.tridium.alarm.AlarmsToSourcesCursor;
import com.tridium.alarm.db.BAckPendingAlarmTable;
import com.tridium.alarm.db.BAlarmDbQueryResult;
import com.tridium.alarm.db.BOpenAlarmTable;
import com.tridium.bql.BBqlExtent;
import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import com.tridium.bql.SelectQuery;
import com.tridium.util.EmptyCursor;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.bql.BIRelational;
import javax.baja.bql.BqlQuery;
import javax.baja.bql.Queryable;
import javax.baja.collection.BICollection;
import javax.baja.collection.BIList;
import javax.baja.collection.BITable;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.IFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BAlarmDatabase
extends BObject
implements Queryable,
BIRelational {
    public static final Type TYPE;
    public static final Log log;
    private boolean open;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmDatabase;

    public final synchronized void open() throws IOException {
        this.doOpen();
        this.open = true;
    }

    protected void doOpen() throws IOException {
    }

    public boolean isOpen() {
        return this.open;
    }

    public final synchronized void save() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        this.flush();
        this.doSave();
    }

    protected void doSave() throws IOException {
    }

    public final synchronized void flush() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        this.doFlush();
    }

    protected void doFlush() throws IOException {
    }

    protected synchronized void assertOpen() {
        if (!this.isOpen()) {
            throw new AlarmException("Operation not allowed while database is closed.");
        }
    }

    public final synchronized void close() {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.doClose();
        }
        catch (Exception exception) {
            log.error("Cannot close alarm database.", (Throwable)exception);
        }
        this.open = false;
    }

    protected void doClose() {
    }

    public abstract void append(BAlarmRecord var1) throws IOException, AlarmException;

    public abstract void update(BAlarmRecord var1) throws IOException, AlarmException;

    public abstract int getRecordCount();

    public abstract BAlarmRecord getRecord(BUuid var1) throws IOException;

    public Cursor getOpenAlarmSources() throws IOException {
        Cursor cursor = this.getOpenAlarms();
        return new AlarmsToSourcesCursor(cursor);
    }

    public abstract Cursor getOpenAlarms() throws IOException;

    public abstract Cursor getAckPendingAlarms() throws IOException;

    public abstract Cursor getAlarmsForSource(BOrdList var1) throws IOException;

    public abstract Cursor scan() throws IOException, AlarmException;

    public abstract Cursor timeQuery(BAbsTime var1, BAbsTime var2) throws IOException, AlarmException;

    public synchronized Cursor doBqlQuery(BqlQuery bqlQuery) throws IOException, AlarmException {
        SelectQuery selectQuery = (SelectQuery)bqlQuery;
        RangeSet rangeSet = null;
        if (((BBqlExtent)selectQuery.getSelect().getExtent()).getUnparsed().equals("openAlarms")) {
            return this.getOpenAlarms();
        }
        if (((BBqlExtent)selectQuery.getSelect().getExtent()).getUnparsed().equals("ackPendingAlarms")) {
            return this.getAckPendingAlarms();
        }
        if (!selectQuery.hasPredicate()) {
            return this.scan();
        }
        try {
            rangeSet = selectQuery.getRange("uuid", BUuid.TYPE, true);
            if (!rangeSet.isAll()) {
                ArrayList<BValue> arrayList = new ArrayList<BValue>(1);
                int n = rangeSet.getCount();
                int n2 = 0;
                while (n2 < n) {
                    Range range = rangeSet.getRange(n2);
                    BAlarmRecord bAlarmRecord = this.getRecord((BUuid)range.getSingleton());
                    if (bAlarmRecord != null) {
                        arrayList.add(bAlarmRecord.newCopy(true));
                    }
                    ++n2;
                }
                BAlarmRecord[] bAlarmRecordArray = arrayList.toArray(new BAlarmRecord[arrayList.size()]);
                return new ArrayCursor(bAlarmRecordArray);
            }
            rangeSet = selectQuery.getRange("source", BOrdList.TYPE, true);
            if (!rangeSet.isAll() && rangeSet.getCount() == 1) {
                return this.getAlarmsForSource((BOrdList)rangeSet.getRange(0).getSingleton());
            }
            rangeSet = selectQuery.getRange("timestamp", BAbsTime.TYPE, false);
            if (rangeSet.isAll()) {
                return this.scan();
            }
            rangeSet.sort();
            Range range = rangeSet.getRange(0);
            Range range2 = rangeSet.getRange(rangeSet.getCount() - 1);
            return this.timeQuery((BAbsTime)range.min, (BAbsTime)range2.max);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return this.scan();
        }
    }

    public void toNormal(BAlarmRecord bAlarmRecord) {
        BObject bObject;
        Object object;
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        Object object2 = null;
        StringBuffer stringBuffer = new StringBuffer("alarm:|bql:select * where ");
        stringBuffer.append("source = OrdList '");
        stringBuffer.append(SlotPath.escape((String)bAlarmRecord.getSource().encodeToString()));
        stringBuffer.append("' and sourceState != alarm:SourceState.normal and sourceState != alarm:SourceState.alert");
        BOrd bOrd = BOrd.make((String)stringBuffer.toString());
        Cursor cursor = ((BICollection)bOrd.resolve((BObject)bAlarmService).get()).cursor();
        if (cursor.next()) {
            do {
                if (((BAlarmRecord)((Object)(object = (BAlarmRecord)((BValue)cursor.get()).newCopy(true)))).getSourceState() == BSourceState.alert) continue;
                ((BAlarmRecord)((Object)object)).setSource(bAlarmRecord.getSource());
                ((BAlarmRecord)((Object)object)).setAlarmClass(bAlarmRecord.getAlarmClass());
                ((BAlarmRecord)((Object)object)).setNormalTime(Clock.time());
                ((BAlarmRecord)((Object)object)).setSourceState(BSourceState.normal);
                boolean bl = false;
                if (((BAlarmRecord)((Object)object)).getAckRequired() || bAlarmRecord.getAckRequired()) {
                    bl = true;
                }
                ((BAlarmRecord)((Object)object)).setAckRequired(bl);
                ((BAlarmRecord)((Object)object)).setAlarmData(BFacets.make((BFacets)((BAlarmRecord)((Object)object)).getAlarmData(), (BFacets)bAlarmRecord.getAlarmData()));
                if (bAlarmRecord.getAckRequired()) {
                    ((BAlarmRecord)((Object)object)).setAckState(BAckState.unacked);
                }
                bAlarmService.routeAlarm((BAlarmRecord)((Object)object));
                object2 = object;
            } while (cursor.next());
        }
        if (object2 == null) {
            object = new BAlarmRecord();
            if (bAlarmRecord.getAckRequired()) {
                ((BAlarmRecord)((Object)object)).setAckState(BAckState.unacked);
            }
            ((BAlarmRecord)((Object)object)).setSource(bAlarmRecord.getSource());
            ((BAlarmRecord)((Object)object)).setAlarmClass(bAlarmRecord.getAlarmClass());
            ((BAlarmRecord)((Object)object)).setNormalTime(Clock.time());
            ((BAlarmRecord)((Object)object)).setSourceState(BSourceState.normal);
            ((BAlarmRecord)((Object)object)).setAckRequired(bAlarmRecord.getAckRequired());
            ((BAlarmRecord)((Object)object)).setAlarmData(bAlarmRecord.getAlarmData());
            bAlarmService.routeAlarm((BAlarmRecord)((Object)object));
            object2 = object;
        }
        if ((bObject = (object = bAlarmRecord.getSource()).get(0).resolve().get()) instanceof BAlarmSourceExt) {
            BAlarmSourceExt bAlarmSourceExt = (BAlarmSourceExt)bObject;
            bAlarmSourceExt.fireToNormal((BAlarmRecord)((Object)object2));
        }
    }

    public BObject bqlQuery(OrdTarget ordTarget, BqlQuery bqlQuery) {
        return new BAlarmDbQueryResult(this, bqlQuery);
    }

    public BITable getRelation(String string) {
        if (string.equals("openAlarms")) {
            return new BOpenAlarmTable(this);
        }
        if (string.equals("ackPendingAlarms")) {
            return new BAckPendingAlarmTable(this);
        }
        return null;
    }

    public Cursor cursor() {
        return new EmptyCursor(null);
    }

    public BIList toList() {
        return null;
    }

    public BITable toTable() {
        return null;
    }

    public BICollection filter(IFilter iFilter) {
        return null;
    }

    public abstract void clearAllRecords(Context var1) throws IOException;

    public abstract void clearOldRecords(BAbsTime var1, Context var2) throws IOException;

    public abstract void clearRecord(BUuid var1, Context var2) throws IOException;

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.open = false;
    }

    public BAlarmDatabase() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$alarm$BAlarmDatabase;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmDatabase = BAlarmDatabase.class("[Ljavax.baja.alarm.BAlarmDatabase;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"alarm.database");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class ArrayCursor
    implements Cursor {
        BAlarmRecord[] recs;
        int index;
        static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

        public Context getContext() {
            return null;
        }

        public BObject get() {
            if (this.index == -1) {
                throw new IllegalStateException("get() before next()");
            }
            return this.recs[this.index];
        }

        public boolean next() {
            if (this.index == this.recs.length) {
                return false;
            }
            ++this.index;
            boolean bl = false;
            if (this.index != this.recs.length) {
                bl = true;
            }
            return bl;
        }

        public boolean next(Class clazz) {
            Class clazz2 = class$javax$baja$alarm$BAlarmRecord;
            if (clazz2 == null) {
                clazz2 = class$javax$baja$alarm$BAlarmRecord = ArrayCursor.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return this.next();
            }
            this.index = this.recs.length;
            return false;
        }

        public boolean nextComponent() {
            this.index = this.recs.length;
            return false;
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public ArrayCursor(BAlarmRecord[] bAlarmRecordArray) {
            this.recs = bAlarmRecordArray;
            this.index = -1;
        }
    }
}

