/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import com.tridium.alarm.AlarmClassRouteAlarmInvocation;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmPriorities;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmClassFolder;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAlarmClass
extends BComponent {
    public static final Property ackRequired = BAlarmClass.newProperty((int)0, (BValue)BAlarmTransitionBits.make(7), null);
    public static final Property priority = BAlarmClass.newProperty((int)0, (BValue)BAlarmPriorities.DEFAULT, null);
    public static final Property totalAlarmCount = BAlarmClass.newProperty((int)67, (int)0, null);
    public static final Property openAlarmCount = BAlarmClass.newProperty((int)67, (int)0, null);
    public static final Property inAlarmCount = BAlarmClass.newProperty((int)67, (int)0, null);
    public static final Property unackedAlarmCount = BAlarmClass.newProperty((int)67, (int)0, null);
    public static final Property timeOfLastAlarm = BAlarmClass.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    public static final Property escalationLevel1Enabled = BAlarmClass.newProperty((int)0, (boolean)false, null);
    public static final Property escalationLevel1Delay = BAlarmClass.newProperty((int)0, (BValue)BRelTime.make((long)300000L), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.make((long)60000L)));
    public static final Property escalationLevel2Enabled = BAlarmClass.newProperty((int)0, (boolean)false, null);
    public static final Property escalationLevel2Delay = BAlarmClass.newProperty((int)0, (BValue)BRelTime.make((long)900000L), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.make((long)120000L)));
    public static final Property escalationLevel3Enabled = BAlarmClass.newProperty((int)0, (boolean)false, null);
    public static final Property escalationLevel3Delay = BAlarmClass.newProperty((int)0, (BValue)BRelTime.make((long)1800000L), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.make((long)180000L)));
    public static final Action routeAlarm = BAlarmClass.newAction((int)20, (BValue)new BAlarmRecord(), null);
    public static final Topic alarm = BAlarmClass.newTopic((int)8, null);
    public static final Topic escalatedAlarm1 = BAlarmClass.newTopic((int)0, null);
    public static final Topic escalatedAlarm2 = BAlarmClass.newTopic((int)0, null);
    public static final Topic escalatedAlarm3 = BAlarmClass.newTopic((int)0, null);
    public static final Type TYPE;
    public static final Log log;
    private static final BIcon icon;
    public static String ESCALATED;
    public static String LEVEL_1;
    public static String LEVEL_2;
    public static String LEVEL_3;
    BAlarmService alarmService;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmClass;

    public BAlarmTransitionBits getAckRequired() {
        return (BAlarmTransitionBits)this.get(ackRequired);
    }

    public void setAckRequired(BAlarmTransitionBits bAlarmTransitionBits) {
        this.set(ackRequired, (BValue)bAlarmTransitionBits, null);
    }

    public BAlarmPriorities getPriority() {
        return (BAlarmPriorities)this.get(priority);
    }

    public void setPriority(BAlarmPriorities bAlarmPriorities) {
        this.set(priority, (BValue)bAlarmPriorities, null);
    }

    public int getTotalAlarmCount() {
        return this.getInt(totalAlarmCount);
    }

    public void setTotalAlarmCount(int n) {
        this.setInt(totalAlarmCount, n, null);
    }

    public int getOpenAlarmCount() {
        return this.getInt(openAlarmCount);
    }

    public void setOpenAlarmCount(int n) {
        this.setInt(openAlarmCount, n, null);
    }

    public int getInAlarmCount() {
        return this.getInt(inAlarmCount);
    }

    public void setInAlarmCount(int n) {
        this.setInt(inAlarmCount, n, null);
    }

    public int getUnackedAlarmCount() {
        return this.getInt(unackedAlarmCount);
    }

    public void setUnackedAlarmCount(int n) {
        this.setInt(unackedAlarmCount, n, null);
    }

    public BAbsTime getTimeOfLastAlarm() {
        return (BAbsTime)this.get(timeOfLastAlarm);
    }

    public void setTimeOfLastAlarm(BAbsTime bAbsTime) {
        this.set(timeOfLastAlarm, (BValue)bAbsTime, null);
    }

    public boolean getEscalationLevel1Enabled() {
        return this.getBoolean(escalationLevel1Enabled);
    }

    public void setEscalationLevel1Enabled(boolean bl) {
        this.setBoolean(escalationLevel1Enabled, bl, null);
    }

    public BRelTime getEscalationLevel1Delay() {
        return (BRelTime)this.get(escalationLevel1Delay);
    }

    public void setEscalationLevel1Delay(BRelTime bRelTime) {
        this.set(escalationLevel1Delay, (BValue)bRelTime, null);
    }

    public boolean getEscalationLevel2Enabled() {
        return this.getBoolean(escalationLevel2Enabled);
    }

    public void setEscalationLevel2Enabled(boolean bl) {
        this.setBoolean(escalationLevel2Enabled, bl, null);
    }

    public BRelTime getEscalationLevel2Delay() {
        return (BRelTime)this.get(escalationLevel2Delay);
    }

    public void setEscalationLevel2Delay(BRelTime bRelTime) {
        this.set(escalationLevel2Delay, (BValue)bRelTime, null);
    }

    public boolean getEscalationLevel3Enabled() {
        return this.getBoolean(escalationLevel3Enabled);
    }

    public void setEscalationLevel3Enabled(boolean bl) {
        this.setBoolean(escalationLevel3Enabled, bl, null);
    }

    public BRelTime getEscalationLevel3Delay() {
        return (BRelTime)this.get(escalationLevel3Delay);
    }

    public void setEscalationLevel3Delay(BRelTime bRelTime) {
        this.set(escalationLevel3Delay, (BValue)bRelTime, null);
    }

    public void routeAlarm(BAlarmRecord bAlarmRecord) {
        this.invoke(routeAlarm, (BValue)bAlarmRecord, null);
    }

    public void fireAlarm(BAlarmRecord bAlarmRecord) {
        this.fire(alarm, (BValue)bAlarmRecord, null);
    }

    public void fireEscalatedAlarm1(BAlarmRecord bAlarmRecord) {
        this.fire(escalatedAlarm1, (BValue)bAlarmRecord, null);
    }

    public void fireEscalatedAlarm2(BAlarmRecord bAlarmRecord) {
        this.fire(escalatedAlarm2, (BValue)bAlarmRecord, null);
    }

    public void fireEscalatedAlarm3(BAlarmRecord bAlarmRecord) {
        this.fire(escalatedAlarm3, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == totalAlarmCount || property == openAlarmCount || property == unackedAlarmCount || property == inAlarmCount) {
            if (this.getInt(property) < 0) {
                this.setInt(property, 0, null);
            }
        } else if (property == escalationLevel1Enabled) {
            if (this.getEscalationLevel1Enabled()) {
                int n = this.getFlags((Slot)escalatedAlarm1);
                this.setFlags((Slot)escalatedAlarm1, n |= 8);
            } else {
                int n = this.getFlags((Slot)escalatedAlarm1);
                this.setFlags((Slot)escalatedAlarm1, n &= 0xFFFFFFF7);
            }
        } else if (property == escalationLevel2Enabled) {
            if (this.getEscalationLevel2Enabled()) {
                int n = this.getFlags((Slot)escalatedAlarm1);
                this.setFlags((Slot)escalatedAlarm2, n |= 8);
            } else {
                int n = this.getFlags((Slot)escalatedAlarm2);
                this.setFlags((Slot)escalatedAlarm2, n &= 0xFFFFFFF7);
            }
        } else if (property == escalationLevel3Enabled) {
            if (this.getEscalationLevel3Enabled()) {
                int n = this.getFlags((Slot)escalatedAlarm3);
                this.setFlags((Slot)escalatedAlarm3, n |= 8);
            } else {
                int n = this.getFlags((Slot)escalatedAlarm3);
                this.setFlags((Slot)escalatedAlarm3, n &= 0xFFFFFFF7);
            }
        }
    }

    public void started() {
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == routeAlarm) {
            Queue queue = (Queue)((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).fw(601);
            AlarmClassRouteAlarmInvocation alarmClassRouteAlarmInvocation = new AlarmClassRouteAlarmInvocation(this, action, (BAlarmRecord)bValue, context);
            queue.enqueue((Object)alarmClassRouteAlarmInvocation);
            if (action == routeAlarm) {
                return alarmClassRouteAlarmInvocation;
            }
            return null;
        }
        return super.post(action, bValue, context);
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BIAlarmClassFolder;
    }

    public void doRouteAlarm(BAlarmRecord bAlarmRecord) {
        try {
            if (!this.isRunning()) {
                return;
            }
            BSourceState bSourceState = bAlarmRecord.getSourceState();
            bAlarmRecord.setPriority(this.getPriority().getPriority(bSourceState));
            bAlarmRecord.setAlarmClass(this.getName());
            bAlarmRecord.setAlarmData(BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (String)"TimeZone", (BIDataValue)BTimeZone.getLocal()));
            boolean bl = this.getAckRequired().includes(bSourceState);
            if (bAlarmRecord.getSourceState() == BSourceState.alert && bAlarmRecord.getAckState() == BAckState.acked) {
                bAlarmRecord.setSourceState(BSourceState.normal);
                bAlarmRecord.setAlarmTransition(BSourceState.alert);
            }
            if (bAlarmRecord.getAlarmData().get(ESCALATED) == null) {
                bAlarmRecord.addAlarmFacet(ESCALATED, (BIDataValue)BString.make((String)""));
            }
            bAlarmRecord.setLastUpdate(BAbsTime.now());
            BAlarmService bAlarmService = this.getAlarmService();
            try {
                if (bAlarmService.getAlarmDb().getRecord(bAlarmRecord.getUuid()) == null) {
                    bAlarmService.getAlarmDb().append(bAlarmRecord);
                } else {
                    bAlarmService.getAlarmDb().update(bAlarmRecord);
                }
            }
            catch (Exception exception) {
                log.error("Cannot write alarm.", (Throwable)exception);
                throw new AlarmException("Cannot write alarm", exception);
            }
            log.trace("BAlarmClass: " + this.getName() + " stored alarm.timestamp: " + bAlarmRecord.getTimestamp());
            if (bAlarmRecord.isAlarm()) {
                this.setTimeOfLastAlarm(bAlarmRecord.getTimestamp());
            }
            this.fireAlarm(bAlarmRecord);
            BString bString = (BString)bAlarmRecord.getAlarmData().get(ESCALATED);
            if (bString != null) {
                if (this.getEscalationLevel1Enabled() && (bString.equals((Object)BString.make((String)LEVEL_1)) || bString.equals((Object)BString.make((String)LEVEL_2)) || bString.equals((Object)BString.make((String)LEVEL_3)))) {
                    this.fireEscalatedAlarm1(bAlarmRecord);
                }
                if (this.getEscalationLevel2Enabled() && (bString.equals((Object)BString.make((String)LEVEL_2)) || bString.equals((Object)BString.make((String)LEVEL_3)))) {
                    this.fireEscalatedAlarm2(bAlarmRecord);
                }
                if (this.getEscalationLevel3Enabled() && bString.equals((Object)BString.make((String)LEVEL_3))) {
                    this.fireEscalatedAlarm3(bAlarmRecord);
                }
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("Alarm service not found", (Throwable)serviceNotFoundException);
        }
    }

    public String toString(Context context) {
        return this.getDisplayName(context);
    }

    protected BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        return this.alarmService;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$alarm$BAlarmClass;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmClass = BAlarmClass.class("[Ljavax.baja.alarm.BAlarmClass;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"alarm");
        icon = BIcon.make((BIcon)BIcon.std((String)"shapes/squareBlue.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
        ESCALATED = new String("escalated");
        LEVEL_1 = new String("level1");
        LEVEL_2 = new String("level2");
        LEVEL_3 = new String("level3");
    }
}

