/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui.portal;

import com.tridium.alarm.BAlarmConsoleChannel;
import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.BAlarmConsoleUIChannel;
import com.tridium.alarm.ui.BAlarmDialog;
import com.tridium.alarm.ui.BTrayIcon;
import com.tridium.alarm.ui.TrayIconListener;
import com.tridium.alarm.ui.portal.BAlarmPortalOptions;
import com.tridium.alarm.ui.portal.BConsoleRecord;
import com.tridium.alarm.ui.portal.BConsoleRecordList;
import com.tridium.alarm.ui.portal.BPortalConsoleRecipient;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.broker.BFoxStationSpace;
import com.tridium.workbench.auth.AuthUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BICollection;
import javax.baja.gx.BImage;
import javax.baja.gx.BPoint;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.tool.BWbService;

public class BAlarmPortalTool
extends BWbService
implements TrayIconListener,
NavListener,
BFoxClientConnection.Interest {
    public static final Property alarmPortalConsoleRecipient = BAlarmPortalTool.newProperty((int)4, (BValue)new BConsoleRecipient(), null);
    public static final Action connect = BAlarmPortalTool.newAction((int)4, (BValue)new BWidget(), null);
    public static final Action routeAlarm = BAlarmPortalTool.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action updateConnectionStatus = BAlarmPortalTool.newAction((int)4, null);
    public static final Action scanForReconnect = BAlarmPortalTool.newAction((int)4, null);
    public static final Topic newUnackedAlarm = BAlarmPortalTool.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$portal$BAlarmPortalTool == null ? (class$com$tridium$alarm$ui$portal$BAlarmPortalTool = BAlarmPortalTool.class$("com.tridium.alarm.ui.portal.BAlarmPortalTool")) : class$com$tridium$alarm$ui$portal$BAlarmPortalTool));
    Hashtable recipients = new Hashtable();
    Hashtable recipToRecord = new Hashtable();
    Array stations = new Array(class$javax$baja$naming$BOrd == null ? (class$javax$baja$naming$BOrd = BAlarmPortalTool.class$("javax.baja.naming.BOrd")) : class$javax$baja$naming$BOrd);
    BWidget view;
    Clock.Ticket reconnectTicket;
    BTrayIcon trayIcon = new BTrayIcon();
    protected int acked = 0;
    protected int unacked = 0;
    int activeViewCount = 0;
    int unackedTrayIconImg = BTrayIcon.loadImage(System.mapLibraryName("trayIcon"), BTrayIcon.YELLOW_ICON);
    int inactiveTrayIconImg = BTrayIcon.loadImage(System.mapLibraryName("trayIcon"), BTrayIcon.GRAY_ICON);
    int activeTrayIconImg = BTrayIcon.loadImage(System.mapLibraryName("trayIcon"), BTrayIcon.RED_ICON);
    int normalTrayIconImg = BTrayIcon.loadImage(System.mapLibraryName("trayIcon"), BTrayIcon.GREEN_ICON);
    int clearedTrayIconImg = BTrayIcon.loadImage(System.mapLibraryName("trayIcon"), BTrayIcon.WHITE_ICON);
    protected BAlarmPortalOptions options;
    static BAlarmDialog alarmDialog;
    Hashtable alarms = new Hashtable();
    Hashtable sourceStates = new Hashtable();
    boolean sourcesInAlarm = false;
    Clock.Ticket updateTicket;
    private boolean running = false;
    static BImage alarmImg;
    public static final UiLexicon lexicon;
    private static final BIcon icon;
    public static final Log logger;
    static /* synthetic */ Class class$com$tridium$alarm$ui$portal$BAlarmPortalTool;
    static /* synthetic */ Class class$com$tridium$alarm$BConsoleRecipient;
    static /* synthetic */ Class class$javax$baja$naming$BOrd;

    public BConsoleRecipient getAlarmPortalConsoleRecipient() {
        return (BConsoleRecipient)this.get(alarmPortalConsoleRecipient);
    }

    public void setAlarmPortalConsoleRecipient(BConsoleRecipient bConsoleRecipient) {
        this.set(alarmPortalConsoleRecipient, (BValue)bConsoleRecipient, null);
    }

    public void connect(BWidget bWidget) {
        this.invoke(connect, (BValue)bWidget, null);
    }

    public void routeAlarm(BAlarmRecord bAlarmRecord) {
        this.invoke(routeAlarm, (BValue)bAlarmRecord, null);
    }

    public void updateConnectionStatus() {
        this.invoke(updateConnectionStatus, null, null);
    }

    public void scanForReconnect() {
        this.invoke(scanForReconnect, null, null);
    }

    public void fireNewUnackedAlarm(BAlarmRecord bAlarmRecord) {
        this.fire(newUnackedAlarm, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAlarmPortalTool() {
        this.options = BAlarmPortalOptions.getDefault();
        this.setAlarmPortalConsoleRecipient(new BPortalConsoleRecipient(this));
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
        this.start();
    }

    private void doConnect() {
        this.doConnect(null);
    }

    public void doConnect(BWidget bWidget) {
        this.view = bWidget;
        this.acked = 0;
        this.unacked = 0;
        this.sourcesInAlarm = false;
        BLink[] bLinkArray = this.getLinks();
        for (int i = 0; i < bLinkArray.length; ++i) {
            this.remove(bLinkArray[i].getName());
        }
        this.recipients = new Hashtable();
        BConsoleRecordList bConsoleRecordList = this.options.getConsoleList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < bConsoleRecordList.size(); ++i) {
            Object object;
            BConsoleRecord bConsoleRecord = bConsoleRecordList.get(i);
            try {
                BConsoleRecipient bConsoleRecipient = this.connectToServer(bWidget, bConsoleRecord);
                object = this.getInitialAlarmCounts(bConsoleRecipient);
                this.acked += object[0];
                this.unacked += object[1];
                continue;
            }
            catch (Exception exception) {
                object = bConsoleRecord.getUseFoxs() ? "|foxs:" : "|fox:";
                Object[] objectArray = new Object[]{bConsoleRecord.getHostOrd() + (String)object + bConsoleRecord.getPort() + "|station:|" + bConsoleRecord.getConsoleOrd()};
                arrayList.add(lexicon.getText("messages.connectionError", objectArray));
            }
        }
        if (arrayList.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuffer.append(arrayList.get(i) + "\n");
            }
        }
        this.updateTrayIcon(this.acked, this.unacked, this.sourcesInAlarm);
        this.showAlarmDialog(this.acked, this.unacked, this.sourcesInAlarm, null);
        Clock.Ticket ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.options.getReconnectInterval(), (Action)scanForReconnect, null);
    }

    public void doRouteAlarm(BAlarmRecord bAlarmRecord) {
        this.getAlarmPortalConsoleRecipient().doRouteAlarm(bAlarmRecord);
    }

    public void doUpdateConnectionStatus() {
        this.updateTicket.cancel();
        this.updateTrayIcon(this.acked, this.unacked, this.sourcesInAlarm);
        boolean bl = this.fullyConnected();
        if (alarmDialog != null) {
            alarmDialog.setFullyConnected(bl);
        }
        if (!bl) {
            if ((this.running || this.activeViewCount > 0) && this.options.getAlarmPopupEnabled() && alarmDialog == null) {
                this.showAlarmDialog(this.acked, this.unacked, this.sourcesInAlarm, null);
            }
        } else {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
            }
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)30000L), (Action)updateConnectionStatus, null);
        }
    }

    public BConsoleRecipient connectToServer(BWidget bWidget, BConsoleRecord bConsoleRecord) throws Exception {
        String string = bConsoleRecord.getHostOrd().toString();
        BOrd bOrd = bConsoleRecord.getHostOrd();
        BFoxSession bFoxSession = BFoxSession.make((BHost)((BHost)bOrd.get()), (int)bConsoleRecord.getPort(), (boolean)bConsoleRecord.getUseFoxs());
        BOrd bOrd2 = bConsoleRecord.getConsoleOrd();
        BICredentials bICredentials = AuthUtil.getCredentials((AuthenticationRealm)bFoxSession);
        if (((BUsernameAndPassword)bICredentials).getUsername().isEmpty()) {
            AuthUtil.challenge(null, (AuthenticationRealm)bFoxSession);
        } else {
            bFoxSession.setCredentials(bICredentials);
        }
        try {
            bFoxSession.connect();
            BOrd bOrd3 = BOrd.make((String)"station:");
            BObject bObject = bOrd3.get((BObject)bFoxSession);
            BFoxStationSpace bFoxStationSpace = (BFoxStationSpace)bObject;
            BOrd bOrd4 = BOrd.make((String)("station:|" + bOrd2.toString()));
            BConsoleRecipient bConsoleRecipient = (BConsoleRecipient)bOrd4.get((BObject)bFoxStationSpace.getRootComponent());
            if (!this.recipients.contains((Object)bConsoleRecipient)) {
                if (!this.stations.contains((Object)bConsoleRecord.getHostOrd())) {
                    this.stations.add((Object)bConsoleRecord.getHostOrd());
                }
                String string2 = bConsoleRecord.getUseFoxs() ? "|foxs:" : "|fox:";
                this.recipients.put(bConsoleRecord.getHostOrd() + string2 + bConsoleRecord.getPort() + "|station:|" + bOrd2, bConsoleRecipient);
                this.recipToRecord.put(bConsoleRecipient, bConsoleRecord);
            }
            boolean bl = this.fullyConnected();
            this.updateTrayIcon(this.acked, this.unacked, this.sourcesInAlarm);
            this.showAlarmDialog(this.acked, this.unacked, this.sourcesInAlarm, null);
            return bConsoleRecipient;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BAlarmConsoleUIChannel channel(BConsoleRecipient bConsoleRecipient) {
        if (bConsoleRecipient == null) {
            return null;
        }
        try {
            BFoxSession bFoxSession = (BFoxSession)bConsoleRecipient.getSession();
            if (bFoxSession != null) {
                BFoxClientConnection bFoxClientConnection = bFoxSession.getConnection();
                Object object = BAlarmConsoleChannel.channelMutex;
                synchronized (object) {
                    BAlarmConsoleChannel bAlarmConsoleChannel = (BAlarmConsoleChannel)bFoxClientConnection.getChannels().get("alarmui");
                    if (bAlarmConsoleChannel == null || !(bAlarmConsoleChannel instanceof BAlarmConsoleUIChannel)) {
                        bAlarmConsoleChannel = new BAlarmConsoleUIChannel();
                        ((BFoxSession)bConsoleRecipient.getSession()).getConnection().getChannels().remove("alarmui");
                        ((BFoxSession)bConsoleRecipient.getSession()).getConnection().getChannels().add("alarmui", (BValue)bAlarmConsoleChannel);
                    }
                    return (BAlarmConsoleUIChannel)bAlarmConsoleChannel;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected int[] getInitialAlarmCounts(BConsoleRecipient bConsoleRecipient) {
        if (bConsoleRecipient == null) {
            return new int[]{0, 0};
        }
        try {
            String string = this.channel(bConsoleRecipient).getInitialAlarmQuery(this, bConsoleRecipient).toString();
            BOrd bOrd = BOrd.make((String)string);
            BICollection bICollection = (BICollection)bOrd.get((BObject)bConsoleRecipient);
            Cursor cursor = bICollection.cursor();
            int n = 0;
            int n2 = 0;
            while (cursor.next()) {
                BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
                if (!this.accept(bAlarmRecord)) continue;
                if (this.alarms == null) {
                    this.alarms = new Hashtable();
                }
                this.alarms.put(bAlarmRecord.getUuid(), bAlarmRecord.getAckState());
                if (this.sourceStates == null) {
                    this.sourceStates = new Hashtable();
                }
                this.sourceStates.put(bAlarmRecord.getSource(), bAlarmRecord.getSourceState());
                if (bAlarmRecord.isAcknowledged()) {
                    ++n;
                } else {
                    ++n2;
                }
                if (bAlarmRecord.isNormal()) continue;
                this.sourcesInAlarm = true;
            }
            return new int[]{n, n2};
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new int[]{0, 0};
        }
    }

    protected BConsoleRecord getConsoleRecordForStation(BOrd bOrd) {
        BConsoleRecordList bConsoleRecordList = this.options.getConsoleList();
        for (int i = 0; i < bConsoleRecordList.size(); ++i) {
            BConsoleRecord bConsoleRecord = bConsoleRecordList.get(i);
            String string = bConsoleRecord.getUseFoxs() ? "|foxs:" : "|fox:";
            String string2 = bConsoleRecord.getHostOrd() + string + bConsoleRecord.getPort();
            if (!string2.equals(bOrd.toString())) continue;
            return bConsoleRecordList.get(i);
        }
        return null;
    }

    public BConsoleRecipient getRecipientForRecord(BConsoleRecord bConsoleRecord) {
        if (bConsoleRecord == null) {
            return null;
        }
        String string = bConsoleRecord.getUseFoxs() ? "|foxs:" : "|fox:";
        return (BConsoleRecipient)((Object)this.recipients.get(bConsoleRecord.getHostOrd() + string + bConsoleRecord.getPort() + "|station:|" + bConsoleRecord.getConsoleOrd()));
    }

    protected BConsoleRecord getRecordForRecipient(BConsoleRecipient bConsoleRecipient) {
        return (BConsoleRecord)((Object)this.recipToRecord.get((Object)bConsoleRecipient));
    }

    protected BConsoleRecord getConsoleRecordFor(BOrd bOrd) {
        String string;
        Object object;
        String string2;
        String string3 = string2 = bOrd.toString();
        if (string2.indexOf("|fox:") < 0 && string2.indexOf("|foxs:") < 0) {
            int n = string2.indexOf("|station");
            StringBuffer stringBuffer = new StringBuffer();
            object = new StringBuffer();
            string = string2.substring(0, n);
            stringBuffer.append(string);
            ((StringBuffer)object).append(string);
            stringBuffer.append("|fox:1911");
            ((StringBuffer)object).append("|foxs:4911");
            String string4 = string2.substring(n);
            stringBuffer.append(string4);
            ((StringBuffer)object).append(string4);
            string2 = stringBuffer.toString();
            string3 = ((StringBuffer)object).toString();
        }
        BConsoleRecordList bConsoleRecordList = this.options.getConsoleList();
        for (int i = 0; i < bConsoleRecordList.size(); ++i) {
            object = bConsoleRecordList.get(i);
            string = object.getHostOrd() + "|fox:" + object.getPort() + "|station:|" + object.getConsoleOrd();
            if (string.toString().equals(string2)) {
                return object;
            }
            string = object.getHostOrd() + "|foxs:" + object.getPort() + "|station:|" + object.getConsoleOrd();
            if (!string.toString().equals(string3)) continue;
            return object;
        }
        return null;
    }

    protected BConsoleRecipient[] getRecipientsFor(BOrd bOrd) {
        Array array = new Array(class$com$tridium$alarm$BConsoleRecipient == null ? (class$com$tridium$alarm$BConsoleRecipient = BAlarmPortalTool.class$("com.tridium.alarm.BConsoleRecipient")) : class$com$tridium$alarm$BConsoleRecipient);
        Enumeration enumeration = this.recipients.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.equals(bOrd.toString())) continue;
            array.add(this.recipients.get(string));
        }
        return (BConsoleRecipient[])array.array();
    }

    public final void handleAlarm(BAlarmRecord bAlarmRecord) {
        this.getAlarmPortalConsoleRecipient().fireNewUnackedAlarm(bAlarmRecord);
    }

    public void processAlarm(BAlarmRecord bAlarmRecord) {
        if (this.running && this.accept(bAlarmRecord)) {
            BAckState bAckState = (BAckState)((Object)this.alarms.get(bAlarmRecord.getUuid()));
            BSourceState bSourceState = (BSourceState)((Object)this.sourceStates.get(bAlarmRecord.getSource()));
            if (bAckState == null) {
                ++this.unacked;
            } else if (bAckState != BAckState.acked && bAlarmRecord.isAcknowledged()) {
                ++this.acked;
                --this.unacked;
            }
            if (bSourceState == null) {
                this.sourcesInAlarm = true;
            } else if (bSourceState != BSourceState.normal && bAlarmRecord.isNormal()) {
                this.sourcesInAlarm = false;
            } else if (bSourceState == BSourceState.normal && !bAlarmRecord.isNormal()) {
                this.sourcesInAlarm = false;
                Iterator iterator = this.sourceStates.values().iterator();
                while (iterator.hasNext()) {
                    if ((BSourceState)((Object)iterator.next()) == BSourceState.normal) continue;
                    this.sourcesInAlarm = true;
                    break;
                }
            }
            this.alarms.put(bAlarmRecord.getUuid(), bAlarmRecord.getAckState());
            this.sourceStates.put(bAlarmRecord.getSource(), bAlarmRecord.getSourceState());
            this.showAlarmDialog(this.acked, this.unacked, this.sourcesInAlarm, bAlarmRecord);
            this.updateTrayIcon(this.acked, this.unacked, this.sourcesInAlarm);
        }
    }

    public boolean accept(BAlarmRecord bAlarmRecord) {
        Iterator iterator = this.recipients.values().iterator();
        while (iterator.hasNext()) {
            BConsoleRecipient bConsoleRecipient = (BConsoleRecipient)((Object)iterator.next());
            if (!bConsoleRecipient.accept(bAlarmRecord)) continue;
            return true;
        }
        return false;
    }

    public void navEvent(NavEvent navEvent) {
    }

    public boolean fullyConnected() {
        if (this.options.getConsoleList().size() <= 0) {
            return false;
        }
        for (int i = 0; i < this.options.getConsoleList().size(); ++i) {
            BConsoleRecipient bConsoleRecipient = this.getRecipientForRecord(this.options.getConsoleList().get(i));
            if (bConsoleRecipient != null && bConsoleRecipient.isMounted() && bConsoleRecipient.getSession() != null && ((BFoxSession)bConsoleRecipient.getSession()).isConnected()) continue;
            return false;
        }
        return true;
    }

    public boolean partiallyConnected() {
        if (this.options.getConsoleList().size() <= 0) {
            return false;
        }
        if (this.fullyConnected()) {
            return false;
        }
        Enumeration enumeration = this.recipients.keys();
        while (enumeration.hasMoreElements()) {
            BConsoleRecipient bConsoleRecipient = (BConsoleRecipient)((Object)this.recipients.get(enumeration.nextElement()));
            if (!bConsoleRecipient.isMounted()) continue;
            return true;
        }
        return false;
    }

    public boolean serviceRunning() {
        return BAlarmPortalTool.getManager().isRunning(this.getType().getTypeInfo());
    }

    protected BWbShell getToolWbShell() {
        int n;
        BWidgetShell[] bWidgetShellArray = BWidget.getApplication().getShells();
        if (bWidgetShellArray.length <= 0) {
            return null;
        }
        for (n = 0; n < bWidgetShellArray.length && !(bWidgetShellArray[n] instanceof BWbShell); ++n) {
        }
        try {
            return (BWbShell)bWidgetShellArray[n];
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void updateTrayIcon(int n, int n2, boolean bl) {
        if (this.running || this.activeViewCount > 0) {
            if (this.options.getTrayIconEnabled()) {
                if (this.trayIcon == null) {
                    this.trayIcon = new BTrayIcon();
                }
                int n3 = this.activeTrayIconImg;
                if (!this.fullyConnected()) {
                    n3 = this.inactiveTrayIconImg;
                } else if (n == 0 && n2 == 0) {
                    n3 = this.clearedTrayIconImg;
                } else if (n > 0 && n2 == 0) {
                    n3 = this.unackedTrayIconImg;
                } else if (!bl) {
                    n3 = this.normalTrayIconImg;
                }
                this.trayIcon.updateTrayIcon(n3, lexicon.getText("AlarmPortalTool.displayName") + ": " + n + " " + lexicon.getText("trayIcon.acked") + " / " + n2 + " " + lexicon.getText("trayIcon.unackedAlarms"));
                if (!this.trayIcon.isShowing()) {
                    this.trayIcon.show();
                }
                if (n3 != this.inactiveTrayIconImg) {
                    if (this.updateTicket != null) {
                        this.updateTicket.cancel();
                    }
                    this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)30000L), (Action)updateConnectionStatus, null);
                }
            } else if (this.trayIcon != null && this.trayIcon.isShowing()) {
                this.trayIcon.hide();
            }
        }
    }

    protected void showAlarmDialog(int n, int n2, boolean bl, BAlarmRecord bAlarmRecord) {
        if ((this.running || this.activeViewCount > 0) && this.options.getAlarmPopupEnabled()) {
            if (alarmDialog == null) {
                alarmDialog = new BAlarmDialog(this, lexicon.getText("AlarmPortalTool.displayName"), alarmImg, bAlarmRecord, n, n2, this.options.getAlarmPopupAlwaysOnTop(), this.options.getAlarmPopupUncloseable());
                alarmDialog.open();
            } else {
                alarmDialog.setVisible(true);
            }
            alarmDialog.setFullyConnected(this.fullyConnected());
            alarmDialog.updateAlarmCounts(n, n2, bl);
            alarmDialog.updateLastAlarm(bAlarmRecord);
            alarmDialog.setFullyConnected(this.fullyConnected());
            if (this.fullyConnected()) {
                if (this.updateTicket != null) {
                    this.updateTicket.cancel();
                }
                this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)30000L), (Action)updateConnectionStatus, null);
            }
        }
    }

    protected void updateLastAlarm(BAlarmRecord bAlarmRecord) {
        if (alarmDialog != null) {
            alarmDialog.updateLastAlarm(bAlarmRecord);
            if (!alarmDialog.isVisible()) {
                alarmDialog.setVisible(true);
                alarmDialog.open();
            }
        }
    }

    public void closeAlarmDialog() {
        if (alarmDialog != null) {
            alarmDialog = null;
        }
    }

    protected void viewActivated() {
        ++this.activeViewCount;
    }

    protected void viewDeactivated() {
        if (alarmDialog != null) {
            this.options.setPopupPosition(BPoint.make((double)alarmDialog.getScreenBounds().x(), (double)alarmDialog.getScreenBounds().y()));
            this.options.save();
        }
        --this.activeViewCount;
        if (this.activeViewCount == 0) {
            if (alarmDialog != null) {
                alarmDialog.close();
            }
            if (this.trayIcon != null) {
                this.trayIcon.removeTrayIconListener(this);
                if (this.trayIcon.isShowing()) {
                    this.trayIcon.hide();
                }
            }
            if (!this.serviceRunning()) {
                try {
                    this.serviceStopped();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void serviceStarted() throws Exception {
        this.running = true;
        this.alarms = new Hashtable();
        try {
            this.doConnect();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateTrayIcon(this.acked, this.unacked, this.sourcesInAlarm);
        this.showAlarmDialog(this.acked, this.unacked, this.sourcesInAlarm, null);
        if (this.trayIcon != null) {
            this.trayIcon.addTrayIconListener(this);
        }
    }

    public void serviceStopped() throws Exception {
        this.running = false;
        this.alarms = null;
        this.sourceStates = null;
        BConsoleRecordList bConsoleRecordList = this.options.getConsoleList();
        for (int i = 0; i < bConsoleRecordList.size(); ++i) {
            try {
                BConsoleRecord bConsoleRecord = bConsoleRecordList.get(i);
                this.channel(this.getRecipientForRecord(bConsoleRecord)).unregister((BAlarmConsole)null);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.activeViewCount == 0) {
            if (this.trayIcon != null) {
                this.trayIcon.removeTrayIconListener(this);
            }
            if (this.trayIcon.isShowing()) {
                this.trayIcon.hide();
            }
            this.options.save();
            alarmDialog.close();
            alarmDialog = null;
            this.trayIcon = null;
        }
        if (this.reconnectTicket != null) {
            this.reconnectTicket.cancel();
        }
    }

    public void onTrayIconClicked(BTrayIcon bTrayIcon) {
    }

    public void onTrayIconDoubleClicked(BTrayIcon bTrayIcon) {
        try {
            this.getToolWbShell().hyperlink(this.getNavOrd());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onAlarmDialogHyperlink(BAlarmDialog bAlarmDialog, BOrd bOrd) {
        try {
            this.getToolWbShell().hyperlink(new HyperlinkInfo(bOrd, BHyperlinkMode.newTab));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onAlarmDialogClosed(BAlarmDialog bAlarmDialog) {
        this.options.setPopupPosition(BPoint.make((double)bAlarmDialog.getScreenBounds().x(), (double)bAlarmDialog.getScreenBounds().y()));
        alarmDialog = null;
    }

    public void doScanForReconnect() throws Exception {
        if (this.options.getConsoleList().size() <= 0) {
            return;
        }
        if (this.recipients.size() == 0) {
            return;
        }
        Enumeration enumeration = this.recipients.keys();
        while (enumeration.hasMoreElements()) {
            try {
                BConsoleRecipient bConsoleRecipient = (BConsoleRecipient)((Object)this.recipients.get(enumeration.nextElement()));
                if (bConsoleRecipient.isMounted()) continue;
                this.connectToServer(this.view, this.getRecordForRecipient(bConsoleRecipient));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.remove("alarm:AlarmConsole");
        agentList.remove("alarm:PortalAlarmConsole");
        return agentList;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        alarmImg = BImage.make((String)"module://icons/x16/alarm.png");
        lexicon = new UiLexicon(class$com$tridium$alarm$ui$portal$BAlarmPortalTool == null ? (class$com$tridium$alarm$ui$portal$BAlarmPortalTool = BAlarmPortalTool.class$("com.tridium.alarm.ui.portal.BAlarmPortalTool")) : class$com$tridium$alarm$ui$portal$BAlarmPortalTool);
        icon = BIcon.std((String)"alarm.png");
        logger = Log.getLog((String)"alarm");
    }
}

