/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui.portal;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.portal.AddConsoleWizard;
import com.tridium.alarm.ui.portal.BAlarmPortalTool;
import com.tridium.alarm.ui.portal.BConsoleRecord;
import com.tridium.alarm.ui.portal.BConsoleRecordList;
import com.tridium.alarm.ui.portal.BPortalAlarmConsole;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.collection.BICollection;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.workbench.view.BWbView;

public class BAlarmPortal
extends BWbView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$portal$BAlarmPortal == null ? (class$com$tridium$alarm$ui$portal$BAlarmPortal = BAlarmPortal.class$("com.tridium.alarm.ui.portal.BAlarmPortal")) : class$com$tridium$alarm$ui$portal$BAlarmPortal));
    private ConsoleRecipientSubscriber subscriber;
    BGridPane controlPane;
    ToggleCommand trayIconEnabled;
    ToggleCommand alarmPopupEnabled;
    ToggleCommand alarmPopupAlwaysOnTop;
    ToggleCommand alarmPopupUncloseable;
    Command addCommand;
    BButton startButton;
    BButton stopButton;
    BCheckBox autoStart;
    public static final UiLexicon lexicon = new UiLexicon(class$com$tridium$alarm$ui$portal$BAlarmPortal == null ? (class$com$tridium$alarm$ui$portal$BAlarmPortal = BAlarmPortal.class$("com.tridium.alarm.ui.portal.BAlarmPortal")) : class$com$tridium$alarm$ui$portal$BAlarmPortal);
    public static final Log log = Log.getLog((String)"alarm");
    BAlarmPortalTool tool;
    BPortalAlarmConsole console;
    BTable acMonitor = new BTable();
    static /* synthetic */ Class class$com$tridium$alarm$ui$portal$BAlarmPortal;

    public Type getType() {
        return TYPE;
    }

    public BAlarmPortal() throws Exception {
        this.acMonitor.setController((TableController)new MonitorController());
        this.acMonitor.setModel((TableModel)new MonitorModel());
        this.acMonitor.setCellRenderer((TableCellRenderer)new MonitorCellRenderer());
        this.acMonitor.setSelection(new TableSelection(){

            public void select(int n, boolean bl) {
                super.select(n, true);
            }

            public void select(int n, int n2, boolean bl) {
                super.select(n2, true);
            }

            public void select(int[] nArray) {
                super.select(nArray[0], true);
            }
        });
        BSplitPane bSplitPane = new BSplitPane(BOrientation.vertical, 20.0);
        bSplitPane.setWidget1((BWidget)BTitlePane.makePane((String)lexicon.getText("portal.alarmConsoleMonitor"), (BTable)this.acMonitor, (String)"Consoles"));
        this.console = new BPortalAlarmConsole();
        bSplitPane.setWidget2((BWidget)this.console);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)bSplitPane);
        this.setContent((BWidget)bEdgePane);
    }

    public void doLoadValue(BObject bObject, Context context) throws Exception {
        this.tool = (BAlarmPortalTool)bObject;
        this.trayIconEnabled = new ToggleCommand((BWidget)this.getWbShell(), BAlarmPortal.lexicon.module, "commands.trayIconEnabled"){

            public CommandArtifact doInvoke() {
                BAlarmPortal.this.tool.options.setTrayIconEnabled(this.isSelected());
                BAlarmPortal.this.tool.updateTrayIcon(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm());
                return null;
            }
        };
        this.trayIconEnabled.setSelected(this.tool.options.getTrayIconEnabled());
        this.alarmPopupEnabled = new ToggleCommand((BWidget)this.getWbShell(), BAlarmPortal.lexicon.module, "commands.alarmPopupEnabled"){

            public CommandArtifact doInvoke() {
                BAlarmPortal.this.tool.options.setAlarmPopupEnabled(this.isSelected());
                BAlarmPortal.this.alarmPopupAlwaysOnTop.setEnabled(this.isSelected());
                BAlarmPortal.this.alarmPopupUncloseable.setEnabled(this.isSelected());
                if (this.isSelected()) {
                    BAlarmPortal.this.tool.showAlarmDialog(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm(), BAlarmPortal.this.console.getMostRecentRecord());
                } else {
                    BAlarmPortal.this.tool.closeAlarmDialog();
                }
                return null;
            }
        };
        this.alarmPopupEnabled.setSelected(this.tool.options.getAlarmPopupEnabled());
        this.alarmPopupAlwaysOnTop = new ToggleCommand((BWidget)this.getWbShell(), BAlarmPortal.lexicon.module, "commands.alarmPopupAlwaysOnTop"){

            public CommandArtifact doInvoke() {
                BAlarmPortal.this.tool.options.setAlarmPopupAlwaysOnTop(this.isSelected());
                if (BAlarmPortalTool.alarmDialog != null) {
                    BAlarmPortalTool.alarmDialog.setAlwaysOnTop(this.isSelected());
                }
                BAlarmPortal.this.tool.showAlarmDialog(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm(), null);
                return null;
            }
        };
        this.alarmPopupAlwaysOnTop.setEnabled(this.alarmPopupEnabled.isSelected());
        this.alarmPopupAlwaysOnTop.setSelected(this.tool.options.getAlarmPopupAlwaysOnTop());
        this.alarmPopupUncloseable = new ToggleCommand((BWidget)this.getWbShell(), BAlarmPortal.lexicon.module, "commands.alarmPopupUncloseable"){

            public CommandArtifact doInvoke() {
                BAlarmPortal.this.tool.options.setAlarmPopupUncloseable(this.isSelected());
                if (BAlarmPortalTool.alarmDialog != null) {
                    BAlarmPortalTool.alarmDialog.setUncloseable(this.isSelected());
                }
                BAlarmPortal.this.tool.showAlarmDialog(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm(), null);
                return null;
            }
        };
        this.alarmPopupUncloseable.setEnabled(this.alarmPopupEnabled.isSelected());
        this.alarmPopupUncloseable.setSelected(this.tool.options.getAlarmPopupUncloseable());
        this.addCommand = new Command((BWidget)this.getWbShell(), BAlarmPortal.lexicon.module, "commands.add"){

            public CommandArtifact doInvoke() {
                BAlarmPortal.this.addConsoleRecipient();
                return null;
            }
        };
        BConsoleRecordList bConsoleRecordList = this.tool.options.getConsoleList();
        for (int i = 0; i < bConsoleRecordList.size(); ++i) {
            BConsoleRecord bConsoleRecord = bConsoleRecordList.get(i);
            ((MonitorModel)this.acMonitor.getModel()).addConsoleRecord(bConsoleRecord);
        }
        this.tool.viewActivated();
        new LoadThread().start();
    }

    public void deactivated() {
        this.tool.viewDeactivated();
        super.deactivated();
        if (this.subscriber != null) {
            this.subscriber.unsubscribeAll();
        }
    }

    public BMenu[] getViewMenus() {
        BMenu[] bMenuArray = this.console.getViewMenus();
        bMenuArray[0].add("portalSep", (BValue)new BSeparator());
        bMenuArray[0].add("addConsole", this.addCommand);
        bMenuArray[0].add("portalSep2", (BValue)new BSeparator());
        bMenuArray[0].add("trayIconEnabled", (Command)this.trayIconEnabled);
        bMenuArray[0].add("alarmPopupEnabled", (Command)this.alarmPopupEnabled);
        bMenuArray[0].add("alarmPopupAlwaysOnTop", (Command)this.alarmPopupAlwaysOnTop);
        bMenuArray[0].add("alarmPopupUncloseable", (Command)this.alarmPopupUncloseable);
        return bMenuArray;
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("addConsole", this.addCommand);
        return bToolBar;
    }

    private void addConsoleRecipient() {
        BConsoleRecordList bConsoleRecordList = this.tool.options.getConsoleList();
        int n = bConsoleRecordList.size();
        AddConsoleWizard addConsoleWizard = new AddConsoleWizard(bConsoleRecordList);
        BWizard.open((BWidget)this.getWbShell(), (WizardModel)addConsoleWizard);
        bConsoleRecordList = addConsoleWizard.getConsoleRecordList();
        int n2 = bConsoleRecordList.size() - n;
        if (n2 > 0) {
            this.tool.options.setConsoleList(bConsoleRecordList);
            this.tool.options.save();
            for (int i = n2; i > 0; --i) {
                BConsoleRecord bConsoleRecord = bConsoleRecordList.get(bConsoleRecordList.size() - i);
                ((MonitorModel)this.acMonitor.getModel()).addConsoleRecord(bConsoleRecord);
                this.connect(bConsoleRecord, bConsoleRecordList.size() - i);
            }
            this.acMonitor.sizeColumnsToFit();
            this.acMonitor.getModel().updateTable();
        }
    }

    void connect(BConsoleRecord bConsoleRecord, int n) {
        BAbsTime bAbsTime = (BAbsTime)this.acMonitor.getModel().getValueAt(n, 5);
        ConnectThread connectThread = new ConnectThread(bConsoleRecord, n, bAbsTime);
        connectThread.start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MonitorCellRenderer
    extends TableCellRenderer {
        int i = -1;

        MonitorCellRenderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            boolean bl;
            BOrd bOrd = (BOrd)this.getTable().getModel().getValueAt(cell.row, 0);
            Integer n = (Integer)this.getTable().getModel().getValueAt(cell.row, 1);
            BBoolean bBoolean = (BBoolean)this.getTable().getModel().getValueAt(cell.row, 2);
            BOrd bOrd2 = (BOrd)this.getTable().getModel().getValueAt(cell.row, 3);
            BConsoleRecipient bConsoleRecipient = bBoolean.getBoolean() ? (BConsoleRecipient)((Object)BAlarmPortal.this.tool.recipients.get(bOrd + "|foxs:" + n + "|station:|" + bOrd2)) : (BConsoleRecipient)((Object)BAlarmPortal.this.tool.recipients.get(bOrd + "|fox:" + n + "|station:|" + bOrd2));
            boolean bl2 = bl = bConsoleRecipient != null && bConsoleRecipient.isMounted();
            if (!bl) {
                if (BAlarmPortal.this.console != null && BAlarmPortal.this.tool != null) {
                    BAlarmPortal.this.tool.updateTrayIcon(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm());
                    BAlarmPortal.this.tool.showAlarmDialog(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm(), null);
                }
                return BBrush.makeSolid((BColor)((BColor)BStatus.downBg));
            }
            return null;
        }
    }

    class MonitorController
    extends TableController {
        MonitorController() {
        }

        public void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            Command command = new Command((BWidget)BAlarmPortal.this.getWbShell(), BAlarmPortal.lexicon.module, "commands.connect"){

                public CommandArtifact doInvoke() {
                    int n = MonitorController.this.getTable().getSelection().getRow();
                    BAbsTime bAbsTime = (BAbsTime)MonitorController.this.getTable().getModel().getValueAt(n, 5);
                    BConsoleRecord bConsoleRecord = ((MonitorModel)MonitorController.this.getTable().getModel()).getConsoleEntry(n);
                    try {
                        ((MonitorController)MonitorController.this).BAlarmPortal.this.tool.connectToServer((BWidget)BAlarmPortal.this, bConsoleRecord);
                        BConsoleRecipient bConsoleRecipient = ((MonitorController)MonitorController.this).BAlarmPortal.this.tool.getRecipientForRecord(bConsoleRecord);
                        BOrd bOrd = bConsoleRecord.getUseFoxs() ? BOrd.make((BOrd)bConsoleRecord.getHostOrd(), (String)("foxs:" + bConsoleRecord.getPort() + "|station:|" + bConsoleRecord.getConsoleOrd().toString())) : BOrd.make((BOrd)bConsoleRecord.getHostOrd(), (String)("fox:" + bConsoleRecord.getPort() + "|station:|" + bConsoleRecord.getConsoleOrd().toString()));
                        String string = ((MonitorController)MonitorController.this).BAlarmPortal.this.console.channel(bConsoleRecipient).getInitialAlarmQuery(((MonitorController)MonitorController.this).BAlarmPortal.this.console, bConsoleRecipient, bOrd).toString();
                        BOrd bOrd2 = BOrd.make((String)(string + " and timestamp >= AbsTime '" + bAbsTime.encodeToString() + "'"));
                        BICollection bICollection = (BICollection)bOrd2.get((BObject)bConsoleRecipient);
                        ((MonitorModel)MonitorController.this.getTable().getModel()).set(n, 5, BAbsTime.now());
                        Cursor cursor = bICollection.cursor();
                        BPortalAlarmConsole.SourceModCursor sourceModCursor = new BPortalAlarmConsole.SourceModCursor(bOrd, cursor);
                        while (sourceModCursor.next()) {
                            BAlarmRecord bAlarmRecord = (BAlarmRecord)sourceModCursor.get();
                            ((MonitorController)MonitorController.this).BAlarmPortal.this.console.processAlarm(bAlarmRecord);
                        }
                    }
                    catch (Exception exception) {
                        BDialog.error((BWidget)BAlarmPortal.this, (String)lexicon.getText("alarm.connectFailed"), (Object)lexicon.getText("messages.connectionError", new Object[]{bConsoleRecord.getHostOrd()}), (Throwable)exception);
                    }
                    return null;
                }
            };
            Command command2 = new Command((BWidget)BAlarmPortal.this.getWbShell(), BAlarmPortal.lexicon.module, "commands.disconnect"){

                public CommandArtifact doInvoke() {
                    try {
                        int n = MonitorController.this.getTable().getSelection().getRow();
                        BConsoleRecord bConsoleRecord = ((MonitorModel)MonitorController.this.getTable().getModel()).getConsoleEntry(n);
                        BConsoleRecipient bConsoleRecipient = bConsoleRecord.getUseFoxs() ? (BConsoleRecipient)((Object)((MonitorController)MonitorController.this).BAlarmPortal.this.tool.recipients.get(bConsoleRecord.getHostOrd() + "|foxs:" + bConsoleRecord.getPort() + "|station:|" + bConsoleRecord.getConsoleOrd())) : (BConsoleRecipient)((Object)((MonitorController)MonitorController.this).BAlarmPortal.this.tool.recipients.get(bConsoleRecord.getHostOrd() + "|fox:" + bConsoleRecord.getPort() + "|station:|" + bConsoleRecord.getConsoleOrd()));
                        if (bConsoleRecipient != null && bConsoleRecipient.getSession() != null) {
                            ((BFoxSession)bConsoleRecipient.getSession()).disconnect();
                        }
                        ((MonitorModel)MonitorController.this.getTable().getModel()).set(n, 5, BAbsTime.now());
                    }
                    catch (Exception exception) {
                        log.error("Cannot disconnect: " + exception);
                    }
                    return null;
                }
            };
            Command command3 = new Command((BWidget)BAlarmPortal.this.getWbShell(), BAlarmPortal.lexicon.module, "commands.edit"){

                public CommandArtifact doInvoke() {
                    MonitorController.this.editConsoleRecipient();
                    return null;
                }
            };
            Command command4 = new Command((BWidget)BAlarmPortal.this.getWbShell(), BAlarmPortal.lexicon.module, "commands.remove"){

                public CommandArtifact doInvoke() {
                    MonitorController.this.deleteConsoleRecipient();
                    return null;
                }
            };
            Command command5 = null;
            command5 = this.getTable().getModel().getValueAt(n, 4).toString().equals(lexicon.getText("portal.connected")) ? command2 : command;
            BMenu bMenu = new BMenu();
            bMenu.add("connect", command5);
            bMenu.add("sep", (BValue)new BSeparator());
            bMenu.add("edit", command3);
            bMenu.add("remove", command4);
            bMenu.open((BWidget)this.getTable(), bMouseEvent.getX(), bMouseEvent.getY());
        }

        protected void backgroundPopup(BMouseEvent bMouseEvent) {
            BMenu bMenu = new BMenu();
            bMenu.add("add", BAlarmPortal.this.addCommand);
            bMenu.open((BWidget)this.getTable(), bMouseEvent.getX(), bMouseEvent.getY());
        }

        private void editConsoleRecipient() {
            int n = this.getTable().getSelection().getRow();
            BOrd bOrd = (BOrd)this.getTable().getModel().getValueAt(n, 0);
            int n2 = (Integer)this.getTable().getModel().getValueAt(n, 1);
            boolean bl = ((BBoolean)this.getTable().getModel().getValueAt(n, 2)).getBoolean();
            BOrd bOrd2 = (BOrd)this.getTable().getModel().getValueAt(n, 3);
            int n3 = BAlarmPortal.this.acMonitor.getModel().getRowCount();
            BConsoleRecordList bConsoleRecordList = BAlarmPortal.this.tool.options.getConsoleList();
            int n4 = bConsoleRecordList.size();
            AddConsoleWizard addConsoleWizard = new AddConsoleWizard(bConsoleRecordList, bOrd, n2, bl, bOrd2);
            BWizard.open((BWidget)BAlarmPortal.this.getWbShell(), (WizardModel)addConsoleWizard);
            bConsoleRecordList = addConsoleWizard.getConsoleRecordList();
            int n5 = bConsoleRecordList.size() - n4;
            if (n5 > 0) {
                BAlarmPortal.this.tool.options.setConsoleList(bConsoleRecordList);
                BAlarmPortal.this.tool.options.save();
                for (int i = n5; i > 0; --i) {
                    BConsoleRecord bConsoleRecord = bConsoleRecordList.get(bConsoleRecordList.size() - i);
                    ((MonitorModel)BAlarmPortal.this.acMonitor.getModel()).addConsoleRecord(bConsoleRecord);
                }
                BAlarmPortal.this.acMonitor.sizeColumnsToFit();
                BAlarmPortal.this.acMonitor.getModel().updateTable();
            }
            if (BAlarmPortal.this.acMonitor.getModel().getRowCount() > n3) {
                this.deleteConsoleRecipient();
            }
        }

        private void deleteConsoleRecipient() {
            int[] nArray = this.getTable().getSelection().getRows();
            nArray = this.sort(nArray);
            BConsoleRecord[] bConsoleRecordArray = new BConsoleRecord[nArray.length];
            for (int i = nArray.length - 1; i >= 0; --i) {
                bConsoleRecordArray[i] = ((MonitorModel)this.getTable().getModel()).getConsoleEntry(nArray[i]);
                BConsoleRecipient bConsoleRecipient = bConsoleRecordArray[i].getUseFoxs() ? (BConsoleRecipient)((Object)BAlarmPortal.this.tool.recipients.get(bConsoleRecordArray[i].getHostOrd() + "|foxs:" + bConsoleRecordArray[i].getPort() + "|station:|" + bConsoleRecordArray[i].getConsoleOrd())) : (BConsoleRecipient)((Object)BAlarmPortal.this.tool.recipients.get(bConsoleRecordArray[i].getHostOrd() + "|fox:" + bConsoleRecordArray[i].getPort() + "|station:|" + bConsoleRecordArray[i].getConsoleOrd()));
                if (bConsoleRecipient != null && bConsoleRecipient.getSession() != null) {
                    ((BFoxSession)bConsoleRecipient.getSession()).disconnect();
                }
                BAlarmPortal.this.console.removeAlarmsFrom(bConsoleRecordArray[i]);
            }
            BConsoleRecordList bConsoleRecordList = BAlarmPortal.this.tool.options.getConsoleList();
            for (int i = nArray.length - 1; i >= 0; --i) {
                bConsoleRecordList = BConsoleRecordList.remove(bConsoleRecordList, nArray[i]);
                ((MonitorModel)this.getTable().getModel()).removeConsoleRecordAt(nArray[i]);
            }
            BAlarmPortal.this.tool.options.setConsoleList(bConsoleRecordList);
            BAlarmPortal.this.tool.options.save();
            ((MonitorModel)this.getTable().getModel()).updateTable();
            this.getTable().sizeColumnsToFit();
            BAlarmPortal.this.tool.showAlarmDialog(BAlarmPortal.this.console.getAckedAlarmCount(), BAlarmPortal.this.console.getUnackedAlarmCount(), BAlarmPortal.this.console.sourcesInAlarm(), null);
        }

        private int[] sort(int[] nArray) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                for (int j = 1; j <= i; ++j) {
                    if (nArray[j - 1] <= nArray[j]) continue;
                    int n = nArray[j - 1];
                    nArray[j - 1] = nArray[j];
                    nArray[j] = n;
                }
            }
            return nArray;
        }
    }

    class MonitorModel
    extends DefaultTableModel {
        ArrayList entries;
        Hashtable wasConnectedList = new Hashtable();

        public MonitorModel() {
            super(new String[]{lexicon.getText("portal.station"), lexicon.getText("portal.port"), lexicon.getText("auth.foxs"), lexicon.getText("portal.consoleOrd"), lexicon.getText("portal.status"), lexicon.getText("portal.lastConnectTime"), lexicon.getText("portal.lastDisconnectTime")});
            this.entries = new ArrayList();
        }

        public void addConsoleRecord(BConsoleRecord bConsoleRecord) {
            this.entries.add(bConsoleRecord);
            Object[] objectArray = new Object[]{bConsoleRecord.getHostOrd(), new Integer(bConsoleRecord.getPort()), BBoolean.make((boolean)bConsoleRecord.getUseFoxs()), bConsoleRecord.getConsoleOrd(), lexicon.getText("portal.notConnected"), BAbsTime.NULL, BAbsTime.NULL};
            this.addRow(null, objectArray);
        }

        public void removeConsoleRecordAt(int n) {
            this.removeRow(n);
            BConsoleRecord bConsoleRecord = (BConsoleRecord)((Object)this.entries.remove(n));
            if (bConsoleRecord != null) {
                String string = bConsoleRecord.getUseFoxs() ? "|foxs:" : "|fox:";
                BConsoleRecipient bConsoleRecipient = (BConsoleRecipient)((Object)BAlarmPortal.this.tool.recipients.get(bConsoleRecord.getHostOrd() + string + bConsoleRecord.getPort() + "|station:|" + bConsoleRecord.getConsoleOrd()));
                if (bConsoleRecipient != null && BAlarmPortal.this.subscriber != null) {
                    BAlarmPortal.this.subscriber.unsubscribe(bConsoleRecipient);
                }
            }
        }

        public BConsoleRecord getConsoleEntry(int n) {
            return (BConsoleRecord)((Object)this.entries.get(n));
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 4) {
                boolean bl;
                BOrd bOrd = (BOrd)this.getTable().getModel().getValueAt(n, 0);
                Integer n3 = (Integer)this.getTable().getModel().getValueAt(n, 1);
                BBoolean bBoolean = (BBoolean)this.getTable().getModel().getValueAt(n, 2);
                BOrd bOrd2 = (BOrd)this.getTable().getModel().getValueAt(n, 3);
                String string = bBoolean.getBoolean() ? "|foxs:" : "|fox:";
                BConsoleRecipient bConsoleRecipient = (BConsoleRecipient)((Object)BAlarmPortal.this.tool.recipients.get(bOrd + string + n3 + "|station:|" + bOrd2));
                Boolean bl2 = new Boolean(false);
                if (bConsoleRecipient == null) {
                    return lexicon.getText("portal.notConnected");
                }
                bl2 = (Boolean)this.wasConnectedList.get((Object)bConsoleRecipient);
                boolean bl3 = bl2 != null ? bl2 : false;
                boolean bl4 = bl = bConsoleRecipient != null && bConsoleRecipient.isMounted();
                if (bl3 && !bl) {
                    this.set(n, 6, BAbsTime.now());
                } else if (!bl3 && bl) {
                    BConsoleRecord bConsoleRecord = ((MonitorModel)this.getTable().getModel()).getConsoleEntry(n);
                    BAlarmPortal.this.connect(bConsoleRecord, n);
                    this.set(n, 5, BAbsTime.now());
                }
                this.wasConnectedList.put(bConsoleRecipient, new Boolean(bl));
                return bl ? lexicon.getText("portal.connected") : lexicon.getText("portal.notConnected");
            }
            return super.getValueAt(n, n2);
        }
    }

    private class ConsoleRecipientSubscriber
    extends Subscriber {
        private ConsoleRecipientSubscriber() {
        }

        public void event(BComponentEvent bComponentEvent) {
        }
    }

    class ConnectThread
    extends Thread {
        BConsoleRecord rec;
        int currentRow;
        BAbsTime sinceTime;

        ConnectThread(BConsoleRecord bConsoleRecord, int n, BAbsTime bAbsTime) {
            super("alarm: Portal Reconnect");
            this.rec = bConsoleRecord;
            this.currentRow = n;
            this.sinceTime = bAbsTime;
        }

        public void run() {
            try {
                BAlarmPortal.this.tool.connectToServer((BWidget)BAlarmPortal.this, this.rec);
                BConsoleRecipient bConsoleRecipient = BAlarmPortal.this.tool.getRecipientForRecord(this.rec);
                if (BAlarmPortal.this.subscriber == null) {
                    BAlarmPortal.this.subscriber = new ConsoleRecipientSubscriber();
                }
                BAlarmPortal.this.subscriber.subscribe(bConsoleRecipient);
                String string = this.rec.getUseFoxs() ? "|foxs:" : "|fox:";
                BOrd bOrd = BOrd.make((String)(this.rec.getHostOrd() + string + this.rec.getPort() + "|station:|" + this.rec.getConsoleOrd()));
                String string2 = BAlarmPortal.this.console.channel(bConsoleRecipient).getInitialAlarmQuery(BAlarmPortal.this.console, bConsoleRecipient, bOrd).toString();
                boolean bl = this.sinceTime.isNull();
                BOrd bOrd2 = bl ? BOrd.make((String)string2) : BOrd.make((String)(string2 + " and timestamp >= AbsTime '" + this.sinceTime.encodeToString() + "'"));
                BICollection bICollection = (BICollection)bOrd2.get((BObject)bConsoleRecipient);
                ((MonitorModel)BAlarmPortal.this.acMonitor.getModel()).set(this.currentRow, 5, BAbsTime.now());
                Cursor cursor = bICollection.cursor();
                BPortalAlarmConsole.SourceModCursor sourceModCursor = new BPortalAlarmConsole.SourceModCursor(bOrd, cursor);
                int n = 0;
                while (sourceModCursor.next()) {
                    BAlarmRecord bAlarmRecord = (BAlarmRecord)sourceModCursor.get();
                    BAlarmPortal.this.console.doProcessAlarm(bAlarmRecord);
                    ++n;
                }
                this.rec.setInitialLoadComplete(true);
                BAlarmPortal.this.console.init();
            }
            catch (Exception exception) {
                String string = this.rec.getUseFoxs() ? "|foxs:" : "|fox:";
                log.error("Cannot connect to: " + this.rec.getHostOrd() + string + this.rec.getPort() + "|station:|" + this.rec.getConsoleOrd() + " : ", (Throwable)exception);
            }
        }
    }

    class LoadThread
    extends Thread {
        LoadThread() {
        }

        public void run() {
            BAlarmPortal.this.console.loadValue((BObject)BAlarmPortal.this.tool);
            BAlarmPortal.this.tool.connect((BWidget)BAlarmPortal.this);
            try {
                BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)BAlarmPortal.this.getWbShell();
                bNiagaraWbShell.pane.update(bNiagaraWbShell.tab());
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = BAlarmPortal.this.console.getAckedAlarmCount();
            int n2 = BAlarmPortal.this.console.getUnackedAlarmCount();
            BAlarmPortal.this.tool.showAlarmDialog(n, n2, BAlarmPortal.this.console.sourcesInAlarm(), null);
        }
    }
}

