/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.util.Queue;

public class SoundPlayer {
    protected boolean stopRequest = false;
    protected Queue media = new Queue();
    protected HashMap soundToSourcesMap = new HashMap();
    protected HashMap sourceToSoundMap = new HashMap();
    protected boolean isPlaying = false;
    protected BRelTime delay = BRelTime.make((long)1000L);
    public static final Log logger = Log.getLog((String)"bajaui");
    private ArrayList listeners = new ArrayList();
    static /* synthetic */ Class class$javax$baja$sys$BValue;

    public SoundPlayer() {
    }

    public SoundPlayer(BRelTime bRelTime) {
        this.delay = bRelTime;
    }

    public boolean addMediaObject(BValue bValue, Object object) {
        Array array = (Array)this.soundToSourcesMap.get(object);
        if (array == null) {
            array = new Array(class$javax$baja$sys$BValue == null ? (class$javax$baja$sys$BValue = SoundPlayer.class$("javax.baja.sys.BValue")) : class$javax$baja$sys$BValue);
            array.add((Object)bValue);
            this.soundToSourcesMap.put(object, array);
            this.sourceToSoundMap.put(bValue, object);
            this.media.enqueue(object);
            return true;
        }
        if (!array.contains((Object)bValue)) {
            array.add((Object)bValue);
            this.soundToSourcesMap.put(object, array);
            this.sourceToSoundMap.put(bValue, object);
            this.media.enqueue(object);
            return true;
        }
        return false;
    }

    public void removeMediaObject(BValue bValue) {
        Object v = this.sourceToSoundMap.remove(bValue);
        Array array = (Array)this.soundToSourcesMap.get(v);
        if (array != null) {
            array.remove((Object)bValue);
            if (array.size() == 0) {
                this.soundToSourcesMap.remove(v);
            }
        }
    }

    public boolean hasMediaObjects() {
        return this.media.size() > 0 && this.soundToSourcesMap.size() > 0;
    }

    public void setDelay(BRelTime bRelTime) {
        this.delay = bRelTime.getMillis() < 1000L ? BRelTime.make((long)1000L) : bRelTime;
    }

    public BRelTime getDelay() {
        return this.delay;
    }

    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    protected void processMediaObject(Object object) throws Exception {
        this.beep();
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void play() throws Exception {
        this.play(true);
    }

    public void play(boolean bl) throws Exception {
        this.play(bl, this.delay);
    }

    public void play(boolean bl, BRelTime bRelTime) throws Exception {
        this.delay = bRelTime;
        if (this.media.isEmpty()) {
            throw new Exception("Cannot play: Media File(s) not specified.");
        }
        if (this.isPlaying) {
            return;
        }
        this.stopRequest = false;
        PlayThread playThread = new PlayThread(bl);
        playThread.start();
    }

    public void stop() {
        this.stopRequest = true;
        this.soundToSourcesMap.clear();
        this.sourceToSoundMap.clear();
        this.media.clear();
    }

    public void fireMediaPlayerStopped() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((MediaPlayerListener)this.listeners.get(i)).mediaPlayerStopped();
        }
    }

    public void addListener(MediaPlayerListener mediaPlayerListener) {
        this.listeners.add(mediaPlayerListener);
    }

    public void removeListener(MediaPlayerListener mediaPlayerListener) {
        this.listeners.remove(mediaPlayerListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface MediaPlayerListener {
        public void mediaPlayerStopped();
    }

    private class PlayThread
    extends Thread {
        private boolean continuous;

        PlayThread(boolean bl) {
            super("Alarm: MediaPlayer");
            this.continuous = bl;
        }

        public void run() {
            block4: while (true) {
                try {
                    while (!SoundPlayer.this.media.isEmpty()) {
                        SoundPlayer.this.isPlaying = true;
                        Object object = SoundPlayer.this.media.dequeue();
                        if (SoundPlayer.this.stopRequest) break block4;
                        if (SoundPlayer.this.soundToSourcesMap.get(object) != null) {
                            SoundPlayer.this.processMediaObject(object);
                            if (this.continuous) {
                                SoundPlayer.this.media.enqueue(object);
                            }
                        }
                        try {
                            Thread.sleep(SoundPlayer.this.delay.getMillis());
                            continue block4;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    break;
                }
                catch (Exception exception) {
                    logger.error("BAlarmConsole.soundAlarm: failed to play alarm sound: " + exception);
                    break;
                }
            }
            if (SoundPlayer.this.stopRequest || !this.continuous && SoundPlayer.this.media.isEmpty()) {
                SoundPlayer.this.fireMediaPlayerStopped();
            }
            SoundPlayer.this.stopRequest = false;
            SoundPlayer.this.isPlaying = false;
            SoundPlayer.this.media.clear();
        }
    }
}

