/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.BIAlarmServiceView;
import com.tridium.alarm.ui.ConsoleTableModel;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;

public class ConsoleColumns {
    protected ArrayList columns;
    protected ArrayList models = new ArrayList();
    protected BIAlarmServiceView alarmServiceView;
    protected HashMap alarmClassDisplayNames = new HashMap();
    private boolean inited = false;
    Context cx;
    public static final UiLexicon lexicon = new UiLexicon(class$com$tridium$alarm$ui$BAlarmConsole == null ? (class$com$tridium$alarm$ui$BAlarmConsole = ConsoleColumns.class$("com.tridium.alarm.ui.BAlarmConsole")) : class$com$tridium$alarm$ui$BAlarmConsole);
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmConsole;

    public ConsoleColumns() {
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        Property[] propertyArray = bAlarmRecord.getPropertiesArray();
        this.columns = new ArrayList(propertyArray.length);
        for (int i = 0; i < propertyArray.length; ++i) {
            if (propertyArray[i].getType() == BAbsTime.TYPE) {
                this.columns.add(new TimeColumn(propertyArray[i]));
                continue;
            }
            this.columns.add(new PropertyColumn(propertyArray[i]));
        }
    }

    public void init(BIAlarmServiceView bIAlarmServiceView, Context context) {
        this.alarmServiceView = bIAlarmServiceView;
        this.cx = context;
        this.inited = true;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Column getColumn(int n) {
        return (Column)this.columns.get(n);
    }

    public void addDataColumn(String string, String string2) {
        this.columns.add(new DataColumn(string, SlotPath.escape((String)string2)));
    }

    public int removeDataColumn(String string) {
        int n = this.dataColumnIndex(string);
        if (n != -1) {
            this.columns.remove(n);
        }
        return n;
    }

    public int dataColumnIndex(String string) {
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            Column column = (Column)this.columns.get(i);
            if (!(column instanceof DataColumn) || !((DataColumn)column).key.equals(SlotPath.escape((String)string))) continue;
            return i;
        }
        return -1;
    }

    public void addModel(ConsoleTableModel consoleTableModel) {
        this.models.add(consoleTableModel);
    }

    public void removeModel(ConsoleTableModel consoleTableModel) {
        this.models.remove((Object)consoleTableModel);
    }

    public void fireModified() {
        int n = this.models.size();
        for (int i = 0; i < n; ++i) {
            ((ConsoleTableModel)((Object)this.models.get(i))).columnsModified();
        }
    }

    private BAlarmService getAlarmService(BConsoleRecipient bConsoleRecipient) {
        try {
            return (BAlarmService)BOrd.make((String)"serivce:alarm:AlarmService").resolve((BObject)bConsoleRecipient).get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getAlarmClassDisplayName(BAlarmRecord bAlarmRecord) {
        String string = bAlarmRecord.getAlarmClass();
        if (this.inited) {
            AlarmClassKey alarmClassKey;
            String string2;
            BOrdList bOrdList = bAlarmRecord.getSource();
            BOrd bOrd = bOrdList.get(bOrdList.size() - 1);
            String string3 = bOrd.toString();
            if (string3.indexOf("|station:|") >= 0) {
                string3 = string3.substring(0, string3.indexOf("|station:|"));
            }
            if ((string2 = (String)this.alarmClassDisplayNames.get(alarmClassKey = new AlarmClassKey(string3, string))) == null) {
                BAlarmService bAlarmService = this.alarmServiceView.getAlarmService(bAlarmRecord);
                if (bAlarmService == null) {
                    string2 = string;
                } else {
                    string2 = bAlarmService.getAlarmClassDisplayName(BString.make((String)string), this.cx).toString();
                    this.alarmClassDisplayNames.put(alarmClassKey, string2);
                }
            }
            return string2;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AlarmClassKey {
        String station;
        String alarmClass;

        public AlarmClassKey(String string, String string2) {
            this.station = string;
            this.alarmClass = string2;
        }

        public boolean equals(Object object) {
            if (object instanceof AlarmClassKey) {
                AlarmClassKey alarmClassKey = (AlarmClassKey)object;
                return alarmClassKey.station.equals(this.station) && alarmClassKey.alarmClass.equals(this.alarmClass);
            }
            return false;
        }

        public int hashCode() {
            return new String(this.station + "|" + this.alarmClass).hashCode();
        }
    }

    public class DataColumn
    extends Column {
        private String name;
        private String key;

        public DataColumn(String string, String string2) {
            this.name = string;
            this.key = string2;
        }

        public String getName() {
            if (this.name == null) {
                this.name = lexicon.get("alarmData." + this.key, null);
            }
            if (this.name == null) {
                this.name = TextUtil.toFriendly((String)this.key);
            }
            return SlotPath.unescape((String)this.name);
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue(BAlarmRecord bAlarmRecord) {
            if (this.key.equals("sourceOrd")) {
                return bAlarmRecord.getSource();
            }
            BFacets bFacets = bAlarmRecord.getAlarmData();
            Object object = bFacets.get(this.key);
            if (object == null) {
                return "";
            }
            object = BFormat.make((String)object.toString()).format((Object)bAlarmRecord);
            return object;
        }

        public String getQueryName() {
            return "alarmData." + this.key;
        }
    }

    public class TimeColumn
    extends PropertyColumn {
        public TimeColumn(Property property) {
            super(property);
        }

        public Object getValue(BAlarmRecord bAlarmRecord) {
            BAbsTime bAbsTime = (BAbsTime)super.getValue(bAlarmRecord);
            return bAbsTime;
        }
    }

    public class PropertyColumn
    extends Column {
        private Property prop;

        public PropertyColumn(Property property) {
            this.prop = property;
        }

        public String getName() {
            return this.prop.getDefaultDisplayName(null);
        }

        public Object getValue(BAlarmRecord bAlarmRecord) {
            return this.getValue(bAlarmRecord, null);
        }

        public Object getValue(BAlarmRecord bAlarmRecord, Context context) {
            if (this.prop.equals(BAlarmRecord.source)) {
                BString bString = (BString)bAlarmRecord.getAlarmData().get("sourceName");
                if (bString != null && bString != BString.DEFAULT) {
                    return BFormat.make((String)bString.toString(context)).format((Object)bAlarmRecord);
                }
                return bAlarmRecord.get(this.prop);
            }
            if (this.prop.equals(BAlarmRecord.alarmClass)) {
                return ConsoleColumns.this.getAlarmClassDisplayName(bAlarmRecord);
            }
            return bAlarmRecord.get(this.prop);
        }

        public String getQueryName() {
            return this.prop.getName();
        }
    }

    public static abstract class Column {
        public abstract String getName();

        public abstract String getQueryName();

        public abstract Object getValue(BAlarmRecord var1);

        public Object getValue(BAlarmRecord bAlarmRecord, Context context) {
            return this.getValue(bAlarmRecord);
        }
    }
}

