/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.TrayIconListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTrayIcon
extends BComponent {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$BTrayIcon == null ? (class$com$tridium$alarm$ui$BTrayIcon = BTrayIcon.class$("com.tridium.alarm.ui.BTrayIcon")) : class$com$tridium$alarm$ui$BTrayIcon));
    private boolean isShowing = false;
    private int nativePeer;
    private int nativeImage;
    private String toolTip;
    private Vector listeners = new Vector();
    private Thread thread;
    public static int YELLOW_ICON;
    public static int GRAY_ICON;
    public static int GREEN_ICON;
    public static int RED_ICON;
    public static int WHITE_ICON;
    static /* synthetic */ Class class$com$tridium$alarm$ui$BTrayIcon;

    public Type getType() {
        return TYPE;
    }

    public BTrayIcon make() {
        return new BTrayIcon();
    }

    public BTrayIcon() {
        this.nativeImage = BTrayIcon.loadImage(System.mapLibraryName("trayIcon"));
        this.toolTip = "Niagara Alarms";
    }

    public BTrayIcon(int n, String string) {
        this.nativeImage = n;
        this.toolTip = string;
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public int getImage() {
        return this.nativeImage;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setImage(int n) {
        this.nativeImage = n;
    }

    public void setToolTip(String string) {
        this.toolTip = string;
    }

    public void show() {
        this.isShowing = true;
        this.doShow();
    }

    public void updateTrayIcon() {
        this.updateTrayIcon(this.nativeImage, this.toolTip);
    }

    public void updateTrayIcon(String string) {
        this.updateTrayIcon(this.nativeImage, string);
    }

    public void updateTrayIcon(int n) {
        this.updateTrayIcon(n, this.toolTip);
    }

    public void updateTrayIcon(int n, String string) {
        this.nativeImage = n;
        this.toolTip = string;
        if (this.isShowing) {
            this.nativePeer = this.nativeUpdate(this.nativeImage, string, this.nativePeer);
        }
    }

    public void hide() {
        if (this.isShowing) {
            this.isShowing = false;
            this.nativeHide(this.nativePeer);
            this.thread = null;
        }
        this.nativePeer = 0;
    }

    private void doShow() {
        if (this.thread != null) {
            this.hide();
        }
        this.thread = new Thread(){

            public void run() {
                BTrayIcon.this.nativePeer = BTrayIcon.this.nativeShow(BTrayIcon.this.nativeImage, BTrayIcon.this.toolTip, BTrayIcon.this.nativePeer);
            }
        };
        this.thread.start();
    }

    public void fireClicked() {
        Vector vector = (Vector)this.listeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TrayIconListener trayIconListener = (TrayIconListener)enumeration.nextElement();
            trayIconListener.onTrayIconClicked(this);
        }
    }

    public void fireDoubleClicked() {
        Vector vector = (Vector)this.listeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TrayIconListener trayIconListener = (TrayIconListener)enumeration.nextElement();
            trayIconListener.onTrayIconDoubleClicked(this);
        }
    }

    public void addTrayIconListener(TrayIconListener trayIconListener) {
        this.listeners.addElement(trayIconListener);
    }

    public void removeTrayIconListener(TrayIconListener trayIconListener) {
        this.listeners.removeElement(trayIconListener);
    }

    private native int nativeShow(int var1, String var2, int var3);

    private synchronized native int nativeUpdate(int var1, String var2, int var3);

    private native void nativeHide(int var1);

    private static synchronized native int nativeLoadImage(String var0, int var1) throws UnsatisfiedLinkError;

    private static synchronized native int nativeFreeImage(int var0) throws UnsatisfiedLinkError;

    public static int loadImage(String string) {
        return BTrayIcon.loadImage(string, 0);
    }

    public static int loadImage(String string, int n) {
        try {
            return BTrayIcon.nativeLoadImage(string, n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return -1;
        }
    }

    protected static void freeImage(int n) {
        try {
            BTrayIcon.nativeFreeImage(n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        BTrayIcon bTrayIcon = new BTrayIcon();
        long l = System.currentTimeMillis();
        bTrayIcon.show();
        long l2 = System.currentTimeMillis();
        bTrayIcon.updateTrayIcon("77 UnAcked Alarms");
        long l3 = System.currentTimeMillis();
        System.out.println("show: " + (l2 - l) + "ms");
        System.out.println("end: " + (l3 - l2) + "ms");
        System.out.println("total: " + (l3 - l) + "ms");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            System.loadLibrary("trayIcon");
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: Cannot load trayIcon native library");
            System.out.println("  " + throwable);
        }
        YELLOW_ICON = 0;
        GRAY_ICON = 1;
        GREEN_ICON = 2;
        RED_ICON = 3;
        WHITE_ICON = 4;
    }
}

