/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.workbench.fieldeditors.BDialogFE;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.workbench.BWbShell;

public class BInstructionsFE
extends BDialogFE {
    public static final Action setEnabledStates = BInstructionsFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$BInstructionsFE == null ? (class$com$tridium$alarm$ui$BInstructionsFE = BInstructionsFE.class$("com.tridium.alarm.ui.BInstructionsFE")) : class$com$tridium$alarm$ui$BInstructionsFE));
    BLabel label = new BLabel();
    BList list;
    BTable table;
    BAlarmInstructions instructions;
    Context ctx;
    BEdgePane mainPane = null;
    MoveDownCommand moveDownCommand = null;
    MoveUpCommand moveUpCommand = null;
    RemoveCommand removeCommand = null;
    EditCommand editCommand = null;
    AddCommand addCommand = null;
    public static final UiLexicon lexicon = new UiLexicon(class$com$tridium$alarm$ui$BInstructionsFE == null ? (class$com$tridium$alarm$ui$BInstructionsFE = BInstructionsFE.class$("com.tridium.alarm.ui.BInstructionsFE")) : class$com$tridium$alarm$ui$BInstructionsFE);
    static /* synthetic */ Class class$com$tridium$alarm$ui$BInstructionsFE;

    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BInstructionsFE() {
        BFlowPane bFlowPane = new BFlowPane();
        bFlowPane.add(null, (BValue)this.label);
        bFlowPane.add(null, (BValue)this.getEditButton());
        this.setContent((BWidget)bFlowPane);
        this.addCommand = new AddCommand();
        this.editCommand = new EditCommand();
        this.removeCommand = new RemoveCommand();
        this.moveUpCommand = new MoveUpCommand();
        this.moveDownCommand = new MoveDownCommand();
        this.table = new BTable((TableModel)new NumberedTableModel());
        this.table.setHeaderVisible(false);
        this.table.setVgridVisible(false);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)this.table);
        bConstrainedPane.setMinSize(400.0, 200.0);
        this.mainPane = new BEdgePane();
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add(null, (BValue)new BButton((Command)this.addCommand));
        bGridPane.add(null, (BValue)new BButton((Command)this.editCommand));
        bGridPane.add(null, (BValue)new BButton((Command)this.removeCommand));
        bGridPane.add(null, (BValue)new BLabel(""));
        bGridPane.add(null, (BValue)new BButton((Command)this.moveUpCommand));
        bGridPane.add(null, (BValue)new BButton((Command)this.moveDownCommand));
        this.linkTo(null, (BComponent)this.table, (Slot)BTable.tableModified, (Slot)setEnabledStates);
        this.linkTo(null, (BComponent)this.table, (Slot)BTable.actionPerformed, (Slot)setEnabledStates);
        this.linkTo(null, (BComponent)this.table, (Slot)BTable.selectionModified, (Slot)setEnabledStates);
        this.doSetEnabledStates();
        this.mainPane.setCenter((BWidget)new BBorderPane((BWidget)bConstrainedPane));
        this.mainPane.setRight((BWidget)new BBorderPane((BWidget)bGridPane));
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.instructions = (BAlarmInstructions)bObject;
        this.ctx = context;
        ((NumberedTableModel)this.table.getModel()).removeAllRows();
        for (int i = 0; i < this.instructions.size(); ++i) {
            ((NumberedTableModel)this.table.getModel()).addRow(this.instructions.get(i));
        }
        this.label.setText(this.instructions.size() + " " + lexicon.getText("alarm.instructions"));
    }

    public BObject doSaveValue(BObject bObject, Context context) {
        return this.instructions;
    }

    public void doSetReadonly(boolean bl) {
        if (bl) {
            this.moveDownCommand.setEnabled(!bl);
            this.moveUpCommand.setEnabled(!bl);
            this.removeCommand.setEnabled(!bl);
            this.editCommand.setEnabled(!bl);
            this.addCommand.setEnabled(!bl);
        } else {
            this.addCommand.setEnabled(true);
        }
        this.table.setEnabled(!bl);
        this.mainPane.setEnabled(!bl);
    }

    public void setEnabled(boolean bl) {
        this.setReadonly(!bl);
    }

    public void doEditPressed() {
        int n = BDialog.open((BWidget)this, (String)"Edit", (Object)this.mainPane, (int)3);
        if (n == 2) {
            return;
        }
        BAlarmInstructions bAlarmInstructions = this.instructions;
        BFormat[] bFormatArray = new BFormat[this.table.getModel().getRowCount()];
        for (int i = 0; i < this.table.getModel().getRowCount(); ++i) {
            bFormatArray[i] = ((NumberedTableModel)this.table.getModel()).getFormat(i);
        }
        this.instructions = BAlarmInstructions.make(bFormatArray);
        if (!this.instructions.equivalent((Object)bAlarmInstructions)) {
            this.label.setText(this.instructions.size() + " " + lexicon.getText("alarm.instructions"));
            this.setModified();
        }
    }

    public void doSetEnabledStates() {
        boolean bl = this.isReadonly();
        if (bl) {
            this.moveDownCommand.setEnabled(false);
            this.moveUpCommand.setEnabled(false);
            this.removeCommand.setEnabled(false);
            this.editCommand.setEnabled(false);
            this.addCommand.setEnabled(false);
        } else {
            this.addCommand.setEnabled(true);
            boolean bl2 = !this.table.getSelection().isEmpty();
            this.removeCommand.setEnabled(bl2);
            boolean bl3 = this.table.getSelection().getRows().length == 1;
            this.moveDownCommand.setEnabled(bl3);
            this.moveUpCommand.setEnabled(bl3);
            this.editCommand.setEnabled(bl3);
        }
    }

    public final BComponent loadService(Type type) {
        BWbShell bWbShell = this.getWbShell();
        BOrd bOrd = BOrd.make((BOrd)bWbShell.getActiveOrd(), (String)("service:" + type.toString()));
        return (BComponent)bOrd.get();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class NumberedTableModel
    extends DefaultTableModel {
        public NumberedTableModel() {
            super(new String[]{"", ""});
        }

        public void addRow(BFormat bFormat) {
            super.addRow(new Object[]{null, bFormat});
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return "";
        }

        public BFormat getFormat(int n) {
            return BFormat.make((String)super.getValueAt(n, 1).toString());
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return new String(n + 1 + ".");
            }
            return this.getFormat(n);
        }
    }

    private class MoveDownCommand
    extends Command {
        public MoveDownCommand() {
            super((BWidget)BInstructionsFE.this, TYPE.getModule(), "commands.moveDown");
        }

        public CommandArtifact doInvoke() {
            int n = BInstructionsFE.this.table.getSelection().getRow();
            if (n < BInstructionsFE.this.table.getModel().getRowCount() - 1) {
                Object object = BInstructionsFE.this.table.getModel().getValueAt(n, 1);
                Object object2 = BInstructionsFE.this.table.getModel().getValueAt(n + 1, 1);
                ((NumberedTableModel)BInstructionsFE.this.table.getModel()).set(n, 1, object2);
                ((NumberedTableModel)BInstructionsFE.this.table.getModel()).set(n + 1, 1, object);
                BInstructionsFE.this.table.getSelection().deselectAll();
                BInstructionsFE.this.table.getSelection().select(n + 1);
            }
            return null;
        }
    }

    private class MoveUpCommand
    extends Command {
        public MoveUpCommand() {
            super((BWidget)BInstructionsFE.this, TYPE.getModule(), "commands.moveUp");
        }

        public CommandArtifact doInvoke() {
            int n = BInstructionsFE.this.table.getSelection().getRow();
            if (n > 0) {
                Object object = BInstructionsFE.this.table.getModel().getValueAt(n, 1);
                Object object2 = BInstructionsFE.this.table.getModel().getValueAt(n - 1, 1);
                ((NumberedTableModel)BInstructionsFE.this.table.getModel()).set(n, 1, object2);
                ((NumberedTableModel)BInstructionsFE.this.table.getModel()).set(n - 1, 1, object);
                BInstructionsFE.this.table.getSelection().deselectAll();
                BInstructionsFE.this.table.getSelection().select(n - 1);
            }
            return null;
        }
    }

    private class RemoveCommand
    extends Command {
        public RemoveCommand() {
            super((BWidget)BInstructionsFE.this, TYPE.getModule(), "commands.removeMsg");
        }

        public CommandArtifact doInvoke() {
            int[] nArray = BInstructionsFE.this.table.getSelection().getRows();
            for (int i = nArray.length - 1; i >= 0; --i) {
                ((NumberedTableModel)BInstructionsFE.this.table.getModel()).removeRow(nArray[i]);
            }
            return null;
        }
    }

    private class EditCommand
    extends Command {
        public EditCommand() {
            super((BWidget)BInstructionsFE.this, TYPE.getModule(), "commands.editMsg");
        }

        public CommandArtifact doInvoke() {
            int n = BInstructionsFE.this.table.getSelection().getRow();
            String string = BDialog.prompt((BWidget)BInstructionsFE.this, (String)"Edit", (String)BInstructionsFE.this.table.getModel().getValueAt(n, 1).toString(), (int)40);
            if (string != null) {
                if ((string = string.trim()).equals("")) {
                    ((NumberedTableModel)BInstructionsFE.this.table.getModel()).removeRow(n);
                } else {
                    ((NumberedTableModel)BInstructionsFE.this.table.getModel()).set(n, 1, string);
                    BInstructionsFE.this.table.sizeColumnsToFit();
                }
            }
            return null;
        }
    }

    private class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BInstructionsFE.this, TYPE.getModule(), "commands.addMsg");
        }

        public CommandArtifact doInvoke() {
            int n;
            BTextDropDown bTextDropDown = new BTextDropDown();
            BAlarmService bAlarmService = (BAlarmService)BInstructionsFE.this.loadService(BAlarmService.TYPE);
            bAlarmService.lease();
            BAlarmInstructions bAlarmInstructions = bAlarmService.getMasterAlarmInstructions();
            if (!BInstructionsFE.this.instructions.equals((Object)bAlarmInstructions)) {
                for (n = 0; n < bAlarmInstructions.size(); ++n) {
                    bTextDropDown.getList().addItem((Object)bAlarmInstructions.get(n));
                }
            }
            if ((n = BDialog.open((BWidget)BInstructionsFE.this, (String)"Add", (Object)new BBorderPane((BWidget)bTextDropDown), (int)3)) == 1) {
                String string = bTextDropDown.getText().trim();
                if (string == null || string.equals("")) {
                    return null;
                }
                ((NumberedTableModel)BInstructionsFE.this.table.getModel()).addRow(BFormat.make((String)string));
                BInstructionsFE.this.table.sizeColumnsToFit();
            }
            return null;
        }
    }
}

