/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.BAlarmClassDef;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.BAlarmTitlePane;
import com.tridium.alarm.ui.ConsoleTableModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.security.BPermissions;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class BAlarmReportDialog
extends BDialog {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$BAlarmReportDialog == null ? (class$com$tridium$alarm$ui$BAlarmReportDialog = BAlarmReportDialog.class$("com.tridium.alarm.ui.BAlarmReportDialog")) : class$com$tridium$alarm$ui$BAlarmReportDialog));
    BAlarmConsole console;
    BTable table;
    String title;
    private Command ackCmd;
    private Command closeCmd;
    private Command hyperlinkCmd;
    private Command notesCmd;
    private Command detailsCmd;
    private Command showVideoCmd;
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmReportDialog;
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmConsole;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

    public Type getType() {
        return TYPE;
    }

    public BAlarmReportDialog() {
        throw new IllegalStateException();
    }

    public BAlarmReportDialog(BAlarmConsole bAlarmConsole, String string, BTable bTable) {
        super((BWidget)bAlarmConsole, string, true);
        Object object;
        BAlarmRecord bAlarmRecord;
        this.console = bAlarmConsole;
        this.table = bTable;
        this.hyperlinkCmd = new HyperlinkCommand((BWidget)this);
        BButton bButton = new BButton(this.hyperlinkCmd, true, true);
        this.ackCmd = new AckCommand((BWidget)this);
        BButton bButton2 = new BButton(this.ackCmd, true, true);
        this.notesCmd = new NotesCommand((BWidget)this);
        BButton bButton3 = new BButton(this.notesCmd, true, true);
        this.showVideoCmd = new ShowVideoCommand((BWidget)this);
        BButton bButton4 = new BButton(this.showVideoCmd, true, true);
        this.closeCmd = new CloseCommand((BWidget)this);
        BButton bButton5 = new BButton(this.closeCmd, true, true);
        this.detailsCmd = new DetailsCommand((BWidget)this);
        BGridPane bGridPane = new BGridPane(BAlarmConsole.isVideoDriverAvailable() ? 5 : 4);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        ConsoleTableModel consoleTableModel = (ConsoleTableModel)((DynamicTableModel)bTable.getModel()).getRootModel();
        if (consoleTableModel.getRowCount() > 0) {
            bAlarmRecord = consoleTableModel.getRecord(0);
            object = bAlarmConsole.getAlarmService();
            BAlarmClass bAlarmClass = ((BAlarmService)object).lookupAlarmClass(bAlarmRecord.getAlarmClass());
            BPermissions bPermissions = bAlarmClass.getPermissions(bAlarmConsole.ctx);
            if (bPermissions.hasOperatorWrite()) {
                bGridPane.add("ack", (BValue)bButton2);
            }
        } else {
            bGridPane.add("ack", (BValue)bButton2);
        }
        bGridPane.add("url", (BValue)bButton);
        bGridPane.add("notes", (BValue)bButton3);
        if (BAlarmConsole.isVideoDriverAvailable()) {
            bGridPane.add("showVideo", (BValue)bButton4);
        }
        bGridPane.add("close", (BValue)bButton5);
        bAlarmRecord = new BEdgePane();
        bAlarmRecord.setBottom((BWidget)new BBorderPane((BWidget)bGridPane));
        object = new Controller();
        bTable.setController((TableController)object);
        bAlarmRecord.setCenter((BWidget)BAlarmTitlePane.makePane(bAlarmConsole.getTitle(), bTable));
        bTable.getSelection().select(0);
        ((Controller)((Object)object)).enableCommands();
        this.setContent((BWidget)bAlarmRecord);
    }

    public void close() {
        ((BEdgePane)this.getContent()).setCenter((BWidget)new BNullWidget());
        super.close();
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void keyReleased(BKeyEvent bKeyEvent) {
            super.keyReleased(bKeyEvent);
            this.enableCommands();
        }

        public void mouseReleased(BMouseEvent bMouseEvent) {
            super.mouseReleased(bMouseEvent);
            this.enableCommands();
        }

        void enableCommands() {
            TableSelection tableSelection = this.getTable().getSelection();
            if (tableSelection.getRows().length == 1) {
                BAlarmClassDef bAlarmClassDef;
                Object object;
                ConsoleTableModel consoleTableModel = (ConsoleTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel();
                BAlarmRecord bAlarmRecord = consoleTableModel.getRecord(tableSelection.getRow());
                BString bString = (BString)bAlarmRecord.getAlarmData().get("hyperlinkOrd");
                BOrd bOrd = BOrd.NULL;
                if (bString != null) {
                    bOrd = BOrd.make((String)bString.toString());
                }
                if (bOrd == null || bOrd.isNull()) {
                    object = BAlarmReportDialog.this.console.options.getAlarmClassMapping();
                    bAlarmClassDef = object.getAlarmClassDefFor(bAlarmRecord.getAlarmClass());
                    bOrd = bAlarmClassDef.getAlarmUrl();
                }
                if (bOrd != null && !bOrd.isNull()) {
                    BAlarmReportDialog.this.hyperlinkCmd.setEnabled(true);
                } else {
                    BAlarmReportDialog.this.hyperlinkCmd.setEnabled(false);
                }
                object = bAlarmRecord.getAlarmData().gets("cameraOrd", null);
                if (object != null) {
                    bAlarmClassDef = BOrd.make((String)object);
                    if (!bAlarmClassDef.equals(BOrd.NULL)) {
                        BAlarmReportDialog.this.showVideoCmd.setEnabled(true);
                    } else {
                        BAlarmReportDialog.this.showVideoCmd.setEnabled(false);
                    }
                } else {
                    BAlarmReportDialog.this.showVideoCmd.setEnabled(false);
                }
                BAlarmReportDialog.this.notesCmd.setEnabled(true);
            } else {
                BAlarmReportDialog.this.hyperlinkCmd.setEnabled(false);
                BAlarmReportDialog.this.notesCmd.setEnabled(false);
                BAlarmReportDialog.this.detailsCmd.setEnabled(false);
                BAlarmReportDialog.this.showVideoCmd.setEnabled(false);
            }
        }

        protected void cellReleased(BMouseEvent bMouseEvent, int n, int n2) {
            super.cellReleased(bMouseEvent, n, n2);
            if (bMouseEvent.getClickCount() == 2) {
                BAlarmReportDialog.this.console.showDetailsDialog(BAlarmReportDialog.this.table, n);
            }
        }

        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            BMenu bMenu = new BMenu();
            bMenu.add("ack", BAlarmReportDialog.this.ackCmd);
            bMenu.add("url", BAlarmReportDialog.this.hyperlinkCmd);
            bMenu.add("notes", BAlarmReportDialog.this.notesCmd);
            bMenu.add("details", BAlarmReportDialog.this.detailsCmd);
            if (BAlarmConsole.isVideoDriverAvailable()) {
                bMenu.add("showVideo", BAlarmReportDialog.this.showVideoCmd);
            }
            bMenu.open((BWidget)BAlarmReportDialog.this.table, bMouseEvent.getX(), bMouseEvent.getY());
        }

        public BMenu makeOptionsMenu() {
            BMenu bMenu = super.makeOptionsMenu();
            bMenu.add("acSep", (BValue)new BSeparator());
            bMenu.add("addColumn", BAlarmReportDialog.this.console.addColumnCommand);
            bMenu.add("removeColumn", BAlarmReportDialog.this.console.removeColumnCommand);
            return bMenu;
        }
    }

    private class ShowVideoCommand
    extends Command {
        public ShowVideoCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)BAlarmConsole.lexicon, "commands.showVideo");
        }

        public CommandArtifact doInvoke() {
            block9: {
                try {
                    Class clazz = Sys.loadClass((String)"videoDriver", (String)"com.tridium.videoDriver.alarm.AlarmConsoleExt");
                    if (clazz != null) {
                        Method method = clazz.getMethod("doShowVideo", class$com$tridium$alarm$ui$BAlarmConsole == null ? (class$com$tridium$alarm$ui$BAlarmConsole = BAlarmReportDialog.class$("com.tridium.alarm.ui.BAlarmConsole")) : class$com$tridium$alarm$ui$BAlarmConsole, class$javax$baja$alarm$BAlarmRecord == null ? (class$javax$baja$alarm$BAlarmRecord = BAlarmReportDialog.class$("javax.baja.alarm.BAlarmRecord")) : class$javax$baja$alarm$BAlarmRecord);
                        if (method != null) {
                            BAlarmRecord[] bAlarmRecordArray = BAlarmReportDialog.this.console.getSelectedAlarms(BAlarmReportDialog.this.table);
                            if (bAlarmRecordArray != null && bAlarmRecordArray.length > 0) {
                                method.invoke((Object)clazz, new Object[]{BAlarmReportDialog.this.console, bAlarmRecordArray[0]});
                            }
                        } else {
                            System.out.println("The 'doShowVideo' method was not found on class AlarmConsoleExt in videoDriver.jar. Please have my program fixed");
                        }
                        break block9;
                    }
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)noSuchMethodException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)invocationTargetException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)illegalAccessException);
                }
            }
            return null;
        }
    }

    private class DetailsCommand
    extends Command {
        public DetailsCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)BAlarmConsole.lexicon, "commands.details");
        }

        public CommandArtifact doInvoke() {
            int[] nArray = BAlarmReportDialog.this.table.getSelection().getRows();
            if (nArray.length != 1) {
                return null;
            }
            BAlarmReportDialog.this.console.showDetailsDialog(BAlarmReportDialog.this.table, nArray[0]);
            return null;
        }
    }

    private class CloseCommand
    extends Command {
        public CloseCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)UiLexicon.bajaui, "commands.close");
        }

        public CommandArtifact doInvoke() {
            BAlarmReportDialog.this.close();
            return null;
        }
    }

    private class NotesCommand
    extends Command {
        public NotesCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)BAlarmConsole.lexicon, "commands.notes");
        }

        public CommandArtifact doInvoke() {
            BAlarmRecord[] bAlarmRecordArray = BAlarmReportDialog.this.console.getSelectedAlarms(BAlarmReportDialog.this.table);
            if (bAlarmRecordArray.length == 0) {
                return null;
            }
            BAlarmReportDialog.this.console.showNotes((BWidget)BAlarmReportDialog.this.table, bAlarmRecordArray);
            return null;
        }
    }

    private class HyperlinkCommand
    extends Command {
        public HyperlinkCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)BAlarmConsole.lexicon, "commands.hyperlink");
        }

        public CommandArtifact doInvoke() {
            BAlarmRecord[] bAlarmRecordArray = BAlarmReportDialog.this.console.getSelectedAlarms(BAlarmReportDialog.this.table);
            if (bAlarmRecordArray.length == 0) {
                return null;
            }
            BAlarmReportDialog.this.console.hyperlink(bAlarmRecordArray[0]);
            return null;
        }
    }

    private class AckCommand
    extends Command {
        public AckCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)BAlarmConsole.lexicon, "commands.acknowledge");
        }

        public CommandArtifact doInvoke() {
            BAlarmRecord[] bAlarmRecordArray = BAlarmReportDialog.this.console.getSelectedAlarms(BAlarmReportDialog.this.table);
            if (bAlarmRecordArray.length == 0) {
                return null;
            }
            BAlarmReportDialog.this.console.acknowledgeAlarms(bAlarmRecordArray);
            return null;
        }
    }
}

