/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.BAlarmConsoleOptions;
import com.tridium.alarm.ui.portal.BAlarmPortalOptions;
import com.tridium.alarm.ui.portal.BAlarmPortalTool;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BPoint;
import javax.baja.gx.Point;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BFrame;
import javax.baja.ui.BHyperlinkLabel;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;

public class BAlarmDialog
extends BFrame {
    public static final Action update = BAlarmDialog.newAction((int)4, null);
    public static final Action handleHyperlink = BAlarmDialog.newAction((int)4, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$BAlarmDialog == null ? (class$com$tridium$alarm$ui$BAlarmDialog = BAlarmDialog.class$("com.tridium.alarm.ui.BAlarmDialog")) : class$com$tridium$alarm$ui$BAlarmDialog));
    private BLabel lastAlarm;
    private BLabel lastAlarmSrc;
    private BLabel lastAlarmMsg;
    private BHyperlinkLabel lastAlarmHyperlink;
    private BLabel status;
    private BAlarmRecord lastAlarmRecord;
    private boolean lastAlarmRecordChanged;
    private BHyperlinkLabel imgLabel;
    private String title;
    private boolean fullyConnected = false;
    private int acked;
    private int unacked;
    private boolean sourcesInAlarm;
    private boolean alwaysOnTop;
    private boolean uncloseable;
    private boolean closed = true;
    private BAlarmPortalTool tool;
    static BImage alarmImg = BImage.make((String)"module://icons/x16/alarm.png");
    static BImage alarmRed = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmRed.png");
    static BImage alarmGreen = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmGreen.png");
    private static BImage ALARM_YELLOW = BImage.make((String)"module://alarm/com/tridium/alarm/ui/images/alarm.gif");
    private static BImage ALARM_GREEN = BImage.make((String)"module://alarm/com/tridium/alarm/ui/images/alarmGreen.gif");
    private static BImage ALARM_RED = BImage.make((String)"module://alarm/com/tridium/alarm/ui/images/alarmRed.gif");
    private static BImage ALARM_WHITE = BImage.make((String)"module://alarm/com/tridium/alarm/ui/images/alarmWhite.gif");
    private static BImage ALARM_GRAY = BImage.make((String)"module://alarm/com/tridium/alarm/ui/images/alarmGray.gif");
    public static final UiLexicon lexicon = new UiLexicon(class$com$tridium$alarm$ui$BAlarmDialog == null ? (class$com$tridium$alarm$ui$BAlarmDialog = BAlarmDialog.class$("com.tridium.alarm.ui.BAlarmDialog")) : class$com$tridium$alarm$ui$BAlarmDialog);
    public BAlarmConsoleOptions options = BAlarmConsoleOptions.getDefault();
    public static final BFacets TIME_FACETS = BFacets.make((String)"showTimeZone", (BIDataValue)BBoolean.FALSE, (String)"showSeconds", (BIDataValue)BBoolean.TRUE);
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmDialog;

    public void update() {
        this.invoke(update, null, null);
    }

    public void handleHyperlink(BMouseEvent bMouseEvent) {
        this.invoke(handleHyperlink, (BValue)bMouseEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAlarmDialog() {
        throw new IllegalStateException();
    }

    public BAlarmDialog(BAlarmPortalTool bAlarmPortalTool, String string, BImage bImage, BAlarmRecord bAlarmRecord, int n, int n2, boolean bl, boolean bl2) {
        super(string);
        this.acked = n;
        this.unacked = n2;
        this.title = string;
        this.alwaysOnTop = bl;
        this.uncloseable = bl2;
        this.tool = bAlarmPortalTool;
        BAlarmPortalOptions bAlarmPortalOptions = BAlarmPortalOptions.getDefault();
        BPoint bPoint = bAlarmPortalOptions.getPopupPosition();
        this.setVisible(true);
        this.setIconImage(bImage);
        String string2 = lexicon.getText("portal.popup.lastAlarm") + ": ";
        String string3 = lexicon.getText("portal.popup.source") + ": ";
        String string4 = lexicon.getText("portal.popup.message") + ": ";
        String string5 = lexicon.getText("portal.popup.hyperlink") + ": ";
        BEdgePane bEdgePane = new BEdgePane();
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setValign(BValign.top);
        bGridPane.setHalign(BHalign.center);
        bGridPane.setColumnAlign(BHalign.center);
        this.imgLabel = new BHyperlinkLabel();
        this.imgLabel.setImage(ALARM_GRAY);
        this.imgLabel.setBackground(BColor.white.toBrush());
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.imgLabel);
        bBorderPane.setBorder(BBorder.make((double)1.0, (int)1, (BBrush)BColor.black.toBrush()));
        bBorderPane.setMargin(BInsets.make((double)15.0, (double)20.0, (double)10.0, (double)20.0));
        bBorderPane.setPadding(BInsets.NULL);
        bGridPane.add(null, (BValue)bBorderPane);
        this.linkTo((BComponent)this.imgLabel, (Slot)BWidget.mouseEvent, (Slot)handleHyperlink);
        this.status = new BLabel();
        this.status.setHalign(BHalign.center);
        this.status.setPadding(BInsets.make((double)0.0, (double)10.0, (double)0.0, (double)10.0));
        bGridPane.add(null, (BValue)this.status);
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.setRowAlign(BValign.top);
        bGridPane2.setColumnAlign(BHalign.left);
        BLabel bLabel = new BLabel(string2);
        bLabel.setPadding(BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)0.0));
        bLabel.setHalign(BHalign.left);
        bGridPane2.add(null, (BValue)bLabel);
        this.lastAlarm = new BLabel();
        this.lastAlarm.setPadding(BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)0.0));
        this.lastAlarm.setHalign(BHalign.left);
        bGridPane2.add(null, (BValue)this.lastAlarm);
        BLabel bLabel2 = new BLabel(string3);
        bLabel2.setHalign(BHalign.left);
        bGridPane2.add(null, (BValue)bLabel2);
        this.lastAlarmSrc = new BLabel();
        this.lastAlarmSrc.setHalign(BHalign.left);
        bGridPane2.add(null, (BValue)this.lastAlarmSrc);
        BLabel bLabel3 = new BLabel(string4);
        bLabel3.setHalign(BHalign.left);
        bGridPane2.add(null, (BValue)bLabel3);
        this.lastAlarmMsg = new BLabel();
        this.lastAlarmMsg.setHalign(BHalign.left);
        bGridPane2.add(null, (BValue)this.lastAlarmMsg);
        BLabel bLabel4 = new BLabel(string5);
        bLabel4.setHalign(BHalign.left);
        bLabel4.setPadding(BInsets.make((double)0.0, (double)0.0, (double)10.0, (double)0.0));
        bGridPane2.add(null, (BValue)bLabel4);
        this.lastAlarmHyperlink = new BHyperlinkLabel();
        this.lastAlarmHyperlink.setHalign(BHalign.left);
        this.lastAlarmHyperlink.setPadding(BInsets.make((double)0.0, (double)0.0, (double)10.0, (double)0.0));
        bGridPane2.add(null, (BValue)this.lastAlarmHyperlink);
        this.linkTo((BComponent)this.lastAlarmHyperlink, (Slot)BWidget.mouseEvent, (Slot)handleHyperlink);
        bEdgePane.setLeft((BWidget)bGridPane);
        bEdgePane.setCenter((BWidget)bGridPane2);
        bEdgePane.computePreferredSize();
        this.setScreenBounds(bPoint.x(), bPoint.y(), bEdgePane.getPreferredWidth() + 50.0, bEdgePane.getPreferredHeight() + 50.0);
        this.setContent((BWidget)bEdgePane);
        if (bAlarmRecord != null) {
            this.updateLastAlarm(bAlarmRecord);
        }
        try {
            this.doLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setAlwaysOnTop(string, bl);
        Thread thread = new Thread(){

            public void run() {
                while (!BAlarmDialog.this.closed) {
                    BAlarmDialog.this.update();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        thread.start();
    }

    protected void doLoad() throws Exception {
        System.loadLibrary("alarmDialog");
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        if (!this.uncloseable) {
            this.close();
        }
    }

    public void open() {
        if (this.closed) {
            this.closed = false;
            super.open();
        }
    }

    public void close() {
        this.tool.onAlarmDialogClosed(this);
        this.closed = true;
        this.releaseNativeResources(this.title);
        this.setVisible(false);
        super.close();
    }

    public void windowDeactivated(BWindowEvent bWindowEvent) {
        if (!this.closed) {
            this.setAlwaysOnTop(this.title, this.alwaysOnTop);
        }
    }

    public void windowActivated(BWindowEvent bWindowEvent) {
        if (!this.closed) {
            this.setAlwaysOnTop(this.title, this.alwaysOnTop);
        }
    }

    public void windowDeiconified(BWindowEvent bWindowEvent) {
        if (!this.closed) {
            this.setAlwaysOnTop(this.title, this.alwaysOnTop);
        }
    }

    public void windowIconified(BWindowEvent bWindowEvent) {
        if (!this.closed) {
            this.setAlwaysOnTop(this.title, this.alwaysOnTop);
            if (this.alwaysOnTop) {
                this.toTop(this.title);
            }
        }
    }

    public int getPixel(BWidget bWidget, int n, int n2) {
        bWidget = (BWidget)bWidget.getParent();
        while (bWidget.getParent() != null) {
            Point point = new Point(bWidget.getX(), bWidget.getY());
            n = (int)((double)n + point.x);
            n2 = (int)((double)n2 + point.y);
            bWidget = (BWidget)bWidget.getParent();
        }
        return this.getPixel(n -= 3, n2 -= 22);
    }

    public void doUpdate() {
        BObject bObject;
        Object object;
        if (this.lastAlarmRecord != null && this.lastAlarmRecordChanged) {
            this.lastAlarmRecordChanged = false;
            object = this.lastAlarmRecord.getSource().toString();
            bObject = this.lastAlarmRecord.getAlarmData().get("sourceName");
            if (bObject != null && !bObject.toString().equals("")) {
                object = BFormat.make((String)this.lastAlarmRecord.getAlarmData().get("sourceName").toString()).format((Object)this.lastAlarmRecord);
            }
            this.lastAlarmSrc.setText((String)object);
            this.lastAlarm.setText(this.lastAlarmRecord.getTimestamp().toString());
            this.lastAlarm.setImage(alarmImg);
            String string = "";
            if (this.lastAlarmRecord.getAlarmData().get("msgText") != null) {
                string = this.lastAlarmRecord.getAlarmData().get("msgText").toString();
            }
            this.lastAlarmMsg.setText(lexicon.getText(BFormat.make((String)string).format((Object)this.lastAlarmRecord)));
            String string2 = "";
            if (this.lastAlarmRecord.getAlarmData().get("hyperlinkOrd") != null) {
                string2 = this.lastAlarmRecord.getAlarmData().get("hyperlinkOrd").toString();
                this.lastAlarmHyperlink.setText(BFormat.make((String)string2).format((Object)this.lastAlarmRecord));
                this.lastAlarmHyperlink.setOrd(BOrd.make((String)string2));
                this.lastAlarmHyperlink.setVisible(true);
                this.imgLabel.setOrd(BOrd.make((String)string2));
            } else {
                this.lastAlarmHyperlink.setVisible(false);
                this.lastAlarmHyperlink.setOrd(BOrd.NULL);
                this.imgLabel.setOrd(BOrd.NULL);
            }
        }
        object = new Object[]{new Integer(this.acked), new Integer(this.unacked)};
        this.status.setText(lexicon.getText("portal.popup.unackedAlarms", object));
        this.updateImage(this.sourcesInAlarm);
        bObject = this.getContent();
        bObject.computePreferredSize();
        this.setScreenBounds(this.getScreenBounds().x(), this.getScreenBounds().y(), bObject.getPreferredWidth() + 50.0, bObject.getPreferredHeight() + 50.0);
        this.repaint();
        this.toTop(this.title);
    }

    public void updateLastAlarm(BAlarmRecord bAlarmRecord) {
        this.lastAlarmRecord = bAlarmRecord;
        this.lastAlarmRecordChanged = true;
    }

    public void updateAlarmCounts(int n, int n2, boolean bl) {
        boolean bl2 = n != this.acked;
        bl2 |= n2 != this.unacked;
        bl2 |= bl != this.sourcesInAlarm;
        this.unacked = n2;
        this.acked = n;
        this.sourcesInAlarm = bl;
    }

    private void updateImage(BImage bImage) {
        if (!this.imgLabel.getImage().equals((Object)bImage)) {
            this.imgLabel.setImage(bImage);
        }
    }

    private void updateImage(boolean bl) {
        if (!this.fullyConnected) {
            this.updateImage(ALARM_GRAY);
        } else if (this.unacked > 0) {
            if (bl) {
                this.updateImage(ALARM_RED);
            } else {
                this.updateImage(ALARM_GREEN);
            }
        } else if (this.unacked == 0 && this.acked > 0) {
            this.updateImage(ALARM_YELLOW);
        } else if (this.acked == 0 && this.unacked == 0) {
            this.updateImage(ALARM_WHITE);
        }
    }

    public void doHandleHyperlink(BMouseEvent bMouseEvent) {
        switch (bMouseEvent.getId()) {
            case 501: {
                this.fireHyperlink(this.lastAlarmHyperlink.getOrd());
            }
        }
    }

    public void fireHyperlink(BOrd bOrd) {
        if (bOrd.isNull()) {
            return;
        }
        this.tool.onAlarmDialogHyperlink(this, bOrd);
    }

    public void setUncloseable(boolean bl) {
        this.uncloseable = bl;
    }

    public void setAlwaysOnTop(boolean bl) {
        this.alwaysOnTop = bl;
        this.setAlwaysOnTop(this.title, bl);
        if (bl) {
            this.toTop(this.title);
        }
    }

    public void setFullyConnected(boolean bl) {
        this.fullyConnected = bl;
    }

    public native void setAlwaysOnTop(String var1, boolean var2);

    public native void toTop(String var1);

    public native int getPixel(int var1, int var2);

    public native void releaseNativeResources(String var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

