/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.fox.BAlarmDbChannel;
import com.tridium.alarm.ui.AlarmDbTableModel;
import com.tridium.alarm.ui.BAlarmConsoleOptions;
import com.tridium.alarm.ui.BAlarmDetailsDialog;
import com.tridium.alarm.ui.BIAlarmServiceView;
import com.tridium.alarm.ui.BNotesDialog;
import com.tridium.alarm.ui.BTimeZoneDisplay;
import com.tridium.alarm.ui.ConsoleColumns;
import com.tridium.alarm.ui.ConsoleTableModel;
import com.tridium.bql.filter.BAbsTimeFilter;
import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.workbench.bql.filter.BFilterSetEditor;
import com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.bql.BIBqlFilter;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.BICollection;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

public class BAlarmDbView
extends BWbComponentView
implements BIAlarmServiceView {
    public static final Property defaultTimeRange = BAlarmDbView.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    public static final Property timeZoneDisplay = BAlarmDbView.newProperty((int)0, (BValue)BTimeZoneDisplay.console, null);
    public static final Action query = BAlarmDbView.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$BAlarmDbView == null ? (class$com$tridium$alarm$ui$BAlarmDbView = BAlarmDbView.class$("com.tridium.alarm.ui.BAlarmDbView")) : class$com$tridium$alarm$ui$BAlarmDbView));
    private static UiLexicon lex = new UiLexicon(class$com$tridium$alarm$ui$BAlarmDbView == null ? (class$com$tridium$alarm$ui$BAlarmDbView = BAlarmDbView.class$("com.tridium.alarm.ui.BAlarmDbView")) : class$com$tridium$alarm$ui$BAlarmDbView);
    public static final BFacets TIME_FACETS = BFacets.make((String)"showSeconds", (boolean)true);
    BTable table;
    AlarmDbTableModel model;
    BAlarmService alarmService;
    Context context;
    private BFilterSet filterSet;
    private BDynamicTimeRangeFE timeRangeEd;
    private Command filterCmd;
    private Command notesCmd;
    private Command tzCmd;
    private Command addColumnCommand;
    private Command removeColumnCommand;
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmDbView;
    static /* synthetic */ Class class$javax$baja$sys$BString;
    static /* synthetic */ Class class$java$lang$Integer;

    public BDynamicTimeRange getDefaultTimeRange() {
        return (BDynamicTimeRange)this.get(defaultTimeRange);
    }

    public void setDefaultTimeRange(BDynamicTimeRange bDynamicTimeRange) {
        this.set(defaultTimeRange, (BValue)bDynamicTimeRange, null);
    }

    public BTimeZoneDisplay getTimeZoneDisplay() {
        return (BTimeZoneDisplay)this.get(timeZoneDisplay);
    }

    public void setTimeZoneDisplay(BTimeZoneDisplay bTimeZoneDisplay) {
        this.set(timeZoneDisplay, (BValue)bTimeZoneDisplay, null);
    }

    public void query() {
        this.invoke(query, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public ConsoleColumns getConsoleColumns() {
        if (this.model != null) {
            return this.model.getColumns();
        }
        ConsoleColumns consoleColumns = new ConsoleColumns();
        BString[] bStringArray = (BString[])BAlarmConsoleOptions.getDefault().getAlarmDataCols().getChildren(class$javax$baja$sys$BString == null ? (class$javax$baja$sys$BString = BAlarmDbView.class$("javax.baja.sys.BString")) : class$javax$baja$sys$BString);
        for (int i = 0; i < bStringArray.length; ++i) {
            consoleColumns.addDataColumn(null, bStringArray[i].toString());
        }
        return consoleColumns;
    }

    public int[] getDefaultColumns() {
        Object object;
        String string = BAlarmConsoleOptions.getDefault().getDisplayColumns();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Array array = new Array(class$java$lang$Integer == null ? (class$java$lang$Integer = BAlarmDbView.class$("java.lang.Integer")) : class$java$lang$Integer);
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            array.add((Object)new Integer((String)object));
        }
        object = new int[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            object[i] = (Integer)array.get(i);
        }
        return object;
    }

    public int getSortColumn() {
        return BAlarmConsoleOptions.getDefault().getSortColumn();
    }

    public boolean getSortDirection() {
        return BAlarmConsoleOptions.getDefault().getSortAscending();
    }

    public BTable getTable() {
        return this.table;
    }

    public BAlarmService getAlarmService(BAlarmRecord bAlarmRecord) {
        return this.alarmService;
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.filterSet = this.buildFilterSet();
        this.alarmService = (BAlarmService)bObject;
        this.context = context;
        this.model = new AlarmDbTableModel(this.getConsoleColumns());
        this.model.init(this, context);
        this.table = new BTable((TableModel)new DynamicTableModel((TableModel)this.model, this.getDefaultColumns()), (TableController)new Controller());
        this.table.setMultipleSelection(false);
        this.model.options.setTimeZoneDisplay(this.getTimeZoneDisplay());
        this.filterCmd = new Command((BWidget)this, BAlarmDbView.lex.module, "commands.filter"){

            public CommandArtifact doInvoke() {
                BAlarmDbView.this.configFilters();
                BAlarmDbView.this.query();
                return null;
            }
        };
        this.notesCmd = new Command((BWidget)this, BAlarmDbView.lex.module, "commands.notes"){

            public CommandArtifact doInvoke() {
                int n = BAlarmDbView.this.table.getSelection().getRow();
                if (n != -1) {
                    BAlarmRecord bAlarmRecord = BAlarmDbView.this.model.getRecord(n);
                    BAlarmDbView.this.showNotes(bAlarmRecord);
                }
                return null;
            }
        };
        this.tzCmd = new Command((BWidget)this, BAlarmDbView.lex.module, "commands.timeZoneDisplay"){

            public CommandArtifact doInvoke() {
                BFrozenEnumFE bFrozenEnumFE = new BFrozenEnumFE();
                bFrozenEnumFE.loadValue((BObject)BAlarmDbView.this.getTimeZoneDisplay());
                int n = BDialog.open((BWidget)BAlarmDbView.this, (String)lex.getText("commands.timeZoneDisplay.label"), (Object)bFrozenEnumFE, (int)3);
                if (n == 2) {
                    return null;
                }
                try {
                    BTimeZoneDisplay bTimeZoneDisplay = (BTimeZoneDisplay)bFrozenEnumFE.saveValue();
                    BAlarmDbView.this.setTimeZoneDisplay(bTimeZoneDisplay);
                    BAlarmDbView.this.model.options.setTimeZoneDisplay(bTimeZoneDisplay);
                    BAlarmDbView.this.model.options.save();
                    BAlarmDbView.this.repaint();
                }
                catch (Exception exception) {
                    BDialog.error((BWidget)BAlarmDbView.this, (String)"Cannot Save", (Object)exception.getMessage(), (Throwable)exception);
                }
                return null;
            }
        };
        this.addColumnCommand = new Command((BWidget)this, BAlarmDbView.lex.module, "commands.addColumn"){

            public CommandArtifact doInvoke() {
                BGridPane bGridPane = new BGridPane(2);
                bGridPane.add("lbl", (BValue)new BLabel("AlarmData."));
                BTextField bTextField = new BTextField("");
                bGridPane.add("tf", (BValue)bTextField);
                int n = BDialog.open((BWidget)BAlarmDbView.this, (String)lex.getText("commands.addColumn.label"), (Object)bGridPane, (int)3, (BImage)null);
                if (n == 1) {
                    try {
                        BAlarmDbView.this.getConsoleColumns().addDataColumn(null, bTextField.getText());
                        for (int i = 0; i < 2; ++i) {
                            DynamicTableModel dynamicTableModel = (DynamicTableModel)BAlarmDbView.this.table.getModel();
                            dynamicTableModel.setColumnShowable(BAlarmDbView.this.getConsoleColumns().getColumnCount() - 1, true);
                            dynamicTableModel.setShowColumn(BAlarmDbView.this.getConsoleColumns().getColumnCount() - 1, true);
                            dynamicTableModel.updateTable();
                        }
                        BAlarmDbView.this.model.options.getAlarmDataCols().add(SlotPath.escape((String)bTextField.getText()), (BValue)BString.make((String)bTextField.getText()));
                        BAlarmDbView.this.model.options.save();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return null;
            }
        };
        this.removeColumnCommand = new Command((BWidget)this, BAlarmDbView.lex.module, "commands.removeColumn"){

            public CommandArtifact doInvoke() {
                BGridPane bGridPane = new BGridPane(2);
                bGridPane.add("lbl", (BValue)new BLabel("AlarmData."));
                ArrayList<String> arrayList = new ArrayList<String>();
                BString[] bStringArray = (BString[])BAlarmDbView.this.model.options.getAlarmDataCols().getChildren(class$javax$baja$sys$BString == null ? (class$javax$baja$sys$BString = BAlarmDbView.class$("javax.baja.sys.BString")) : class$javax$baja$sys$BString);
                for (int i = 0; i < bStringArray.length; ++i) {
                    arrayList.add(bStringArray[i].toString());
                }
                BTextDropDown bTextDropDown = new BTextDropDown(arrayList, 20, false);
                bGridPane.add("tf", (BValue)bTextDropDown);
                int n = BDialog.open((BWidget)BAlarmDbView.this, (String)lex.getText("commands.removeColumn.label"), (Object)bGridPane, (int)3, (BImage)null);
                if (n == 1) {
                    String string = bTextDropDown.getText();
                    int n2 = BAlarmDbView.this.getConsoleColumns().dataColumnIndex(string);
                    if (n2 == -1) {
                        return null;
                    }
                    for (int i = 0; i < 2; ++i) {
                        int n3;
                        DynamicTableModel dynamicTableModel = (DynamicTableModel)BAlarmDbView.this.table.getModel();
                        boolean[] blArray = new boolean[BAlarmDbView.this.getConsoleColumns().getColumnCount()];
                        for (n3 = 0; n3 < blArray.length; ++n3) {
                            blArray[n3] = dynamicTableModel.showColumn(n3);
                        }
                        for (n3 = n2; n3 < blArray.length - 1; ++n3) {
                            blArray[n3] = blArray[n3 + 1];
                        }
                        blArray[blArray.length - 1] = false;
                        for (n3 = 0; n3 < blArray.length; ++n3) {
                            dynamicTableModel.setShowColumn(n3, blArray[n3]);
                        }
                    }
                    BAlarmDbView.this.getConsoleColumns().removeDataColumn(string);
                    BAlarmDbView.this.model.options.getAlarmDataCols().remove(SlotPath.escape((String)bTextDropDown.getText()));
                    BAlarmDbView.this.model.options.save();
                    BAlarmDbView.this.model.updateTable();
                }
                return null;
            }
        };
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.setHalign(BHalign.left);
        this.timeRangeEd = new BDynamicTimeRangeFE();
        this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY);
        bGridPane.add("timeRangeQuery", (BValue)this.timeRangeEd);
        BDynamicTimeRange bDynamicTimeRange = this.getDefaultTimeRange();
        if (!bDynamicTimeRange.equals((Object)BDynamicTimeRange.DEFAULT)) {
            this.timeRangeEd.loadValue((BObject)bDynamicTimeRange, context);
        }
        this.linkTo("rangeLink", (BComponent)this.timeRangeEd, (Slot)BWbFieldEditor.setModified, (Slot)query);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BBorderPane((BWidget)bGridPane));
        bEdgePane.setCenter((BWidget)BTitlePane.makePane((String)lex.getText("alarm.alarmHistory"), (BTable)this.table, (String)lex.getText("alarm.alarms")));
        this.setContent((BWidget)bEdgePane);
        this.query();
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("filter", this.filterCmd);
        bToolBar.add("notes", this.notesCmd);
        bToolBar.add("timezone", this.tzCmd);
        return bToolBar;
    }

    public void stopped() throws Exception {
        super.stopped();
        DynamicTableModel dynamicTableModel = (DynamicTableModel)this.table.getModel();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dynamicTableModel.getRootColumnCount(); ++i) {
            if (!dynamicTableModel.showColumn(i)) continue;
            stringBuffer.append(i + ",");
        }
        if (dynamicTableModel.getRootColumnCount() > 0) {
            this.model.options.setDisplayColumns(stringBuffer.toString());
        }
        this.model.options.setSortColumn(this.model.getLastSortColumn());
        this.model.options.setSortAscending(this.model.getLastSortAscending());
        if (this.model != null) {
            this.model.options.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doQuery() {
        this.enterBusy();
        try {
            String string;
            BAbsTimeFilter bAbsTimeFilter;
            Object object;
            String string2;
            Object object2;
            StringBuffer stringBuffer = new StringBuffer("select * ");
            if (this.filterSet != null) {
                object2 = new StringBuffer(64);
                string2 = this.filterSet.getPredicate();
                if (string2 != null && string2.length() > 0) {
                    if (((StringBuffer)object2).length() != 0) {
                        ((StringBuffer)object2).append(" and ");
                    }
                    ((StringBuffer)object2).append(string2);
                }
                if (!(object = (BDynamicTimeRange)this.timeRangeEd.saveValue()).equals((Object)BDynamicTimeRange.DEFAULT)) {
                    bAbsTimeFilter = new BAbsTimeFilter();
                    bAbsTimeFilter.initFromDynamicTimeRange(object);
                    string = bAbsTimeFilter.getPredicate(BAlarmRecord.timestamp.getName());
                    if (((StringBuffer)object2).length() != 0) {
                        ((StringBuffer)object2).append(" and ");
                    }
                    ((StringBuffer)object2).append(string.toString());
                }
                if (((StringBuffer)object2).length() != 0) {
                    stringBuffer.append(" where ").append(((StringBuffer)object2).toString());
                }
            }
            object2 = (BAlarmDatabase)BOrd.make((BOrd)this.alarmService.getAbsoluteOrd(), (BOrd)BOrd.make((String)"alarm:")).get();
            try {
                string2 = ((BAlarmDatabase)((Object)object2)).doBqlQuery(BqlQuery.make((String)stringBuffer.toString()));
            }
            catch (Exception exception) {
                bAbsTimeFilter = BOrd.make((BOrd)((BWbShell)this.getShell()).getActiveOrd(), (BOrd)BOrd.make((String)("alarm:|bql:" + stringBuffer.toString())));
                string = (BICollection)bAbsTimeFilter.resolve(this.getCurrentValue()).get();
                string2 = string.cursor();
            }
            this.model.clear();
            while (string2.next()) {
                object = (BAlarmRecord)string2.get();
                if (!this.filterSet.accept((BComplex)object)) continue;
                this.model.add((BAlarmRecord)((Object)object));
            }
            this.model.sortByColumn(this.getSortColumn(), this.getSortDirection());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.exitBusy();
            this.table.sizeColumnsToFit();
        }
        this.table.fireTableModified(null);
    }

    public BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            BOrd bOrd = ((BWbShell)this.getShell()).getActiveOrd();
            try {
                BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)"service:alarm:AlarmService");
                this.alarmService = (BAlarmService)bOrd2.resolve().get();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.alarmService;
    }

    public void configFilters() {
        BFilterSetEditor bFilterSetEditor = new BFilterSetEditor();
        bFilterSetEditor.loadValue((BObject)this.filterSet);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bFilterSetEditor);
        if (BDialog.open((BWidget)this, (String)"Filters", (Object)bBorderPane, (int)3) != 2) {
            try {
                if (bFilterSetEditor.isModified()) {
                    this.filterSet = (BFilterSet)bFilterSetEditor.saveValue();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    private BFilterSet buildFilterSet() {
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        BFilterSet bFilterSet = new BFilterSet();
        Property[] propertyArray = bAlarmRecord.getPropertiesArray();
        for (int i = 0; i < propertyArray.length; ++i) {
            BValue bValue;
            AgentList agentList;
            if (propertyArray[i].equals(BAlarmRecord.timestamp) || (agentList = (bValue = bAlarmRecord.get(propertyArray[i])).getAgents().filter(AgentFilter.is((Type)BIBqlFilter.TYPE))).size() == 0) continue;
            BIBqlFilter bIBqlFilter = (BIBqlFilter)agentList.getDefault().getInstance();
            bIBqlFilter.init((BObject)bValue);
            BFilterEntry bFilterEntry = new BFilterEntry(false, propertyArray[i].getDefaultDisplayName(this.getCurrentContext()), bIBqlFilter);
            bFilterSet.add(propertyArray[i].getName(), (BValue)bFilterEntry, 0, bAlarmRecord.getSlotFacets((Slot)propertyArray[i]), null);
        }
        return bFilterSet;
    }

    public void showDetailsDialog(BAlarmRecord bAlarmRecord) {
        BAlarmDetailsDialog bAlarmDetailsDialog = new BAlarmDetailsDialog(this.alarmService, this.getTimeZoneDisplay(), bAlarmRecord, (ConsoleTableModel)((DynamicTableModel)this.table.getModel()).getRootModel(), this.context);
        bAlarmDetailsDialog.setBoundsCenteredOnOwner();
        bAlarmDetailsDialog.open();
    }

    public void showNotes(BAlarmRecord bAlarmRecord) {
        String string = "";
        try {
            string = ((BString)bAlarmRecord.getAlarmData().getFacet("notes")).getString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BNotesDialog bNotesDialog = new BNotesDialog((BWidget)this, string, this.getUsername(bAlarmRecord), true);
        bNotesDialog.setBoundsCenteredOnOwner();
        bNotesDialog.open();
        String string2 = bNotesDialog.getNewNotes();
        if (string2 != null) {
            string = string2 + string;
            BFacets bFacets = bAlarmRecord.getAlarmData();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            String[] stringArray = bFacets.list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("notes")) continue;
                BObject bObject = bFacets.get(stringArray[i]);
                hashMap.put(stringArray[i], bObject);
            }
            hashMap.put("notes", BString.make((String)string));
            BFacets bFacets2 = BFacets.make(hashMap);
            bAlarmRecord.setAlarmData(bFacets2);
            try {
                this.getAlarmDbChannel().update(bAlarmRecord);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected String getUsername(BAlarmRecord bAlarmRecord) {
        BFoxSession bFoxSession = (BFoxSession)this.getCurrentValueSession();
        BFoxClientConnection bFoxClientConnection = bFoxSession.getConnection();
        return bFoxClientConnection.getUsername();
    }

    protected BAlarmDbChannel getAlarmDbChannel() {
        BFoxSession bFoxSession = (BFoxSession)this.getCurrentValueSession();
        BFoxClientConnection bFoxClientConnection = bFoxSession.getConnection();
        return (BAlarmDbChannel)bFoxClientConnection.getChannels().get("alarmdb", BAlarmDbChannel.TYPE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellReleased(BMouseEvent bMouseEvent, int n, int n2) {
            super.cellReleased(bMouseEvent, n, n2);
            if (bMouseEvent.getClickCount() == 2) {
                BAlarmDbView.this.showDetailsDialog(BAlarmDbView.this.model.getRecord(n));
            }
        }

        public BMenu makeOptionsMenu() {
            BMenu bMenu = super.makeOptionsMenu();
            bMenu.add("acSep", (BValue)new BSeparator());
            bMenu.add("addColumn", BAlarmDbView.this.addColumnCommand);
            bMenu.add("removeColumn", BAlarmDbView.this.removeColumnCommand);
            return bMenu;
        }
    }
}

