/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.ConsoleColumns;
import com.tridium.alarm.ui.ConsoleTableModel;
import com.tridium.alarm.ui.SourceTableModel;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.nre.util.SortUtil;

public class AlarmTableModel
extends ConsoleTableModel {
    private SourceTableModel.AlarmList alarmList;

    public AlarmTableModel(ConsoleColumns consoleColumns, SourceTableModel.AlarmList alarmList) {
        super(consoleColumns);
        this.alarmList = alarmList;
        alarmList.setModel(this);
        this.sortByColumn(this.getLastSortColumn(), this.getLastSortAscending());
    }

    public int getAlarmCount() {
        return this.getRowCount();
    }

    public int getSourceCount() {
        return 1;
    }

    public int getRowCount() {
        return this.alarmList.size();
    }

    public BAlarmRecord getRecord(int n) {
        SourceTableModel.AlarmEntry alarmEntry = this.alarmList.getEntry(n);
        return alarmEntry.rec;
    }

    public void close() {
        super.close();
        this.alarmList.setModel(null);
    }

    public synchronized void sortByColumn(int n, boolean bl) {
        if (n < 0 || n >= super.getColumnCount()) {
            return;
        }
        this.setInitialSort(n, bl);
        ConsoleColumns.Column column = this.getColumns().getColumn(n);
        if (bl) {
            this.alarmList.sort(column, SortUtil.ASCENDING);
        } else {
            this.alarmList.sort(column, SortUtil.DESCENDING);
        }
    }
}

