/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.print;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BFont;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Queue;
import javax.baja.util.Worker;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.standard.PrinterName;

public class BPrinterRecipient
extends BAlarmRecipient
implements BIAlarmSource {
    public static final Property printer = BPrinterRecipient.newProperty((int)0, (String)"<Enter Printer Name>", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:PrinterFE")));
    public static final Property font = BPrinterRecipient.newProperty((int)0, (BValue)BFont.make((String)"12pt Monospaced"), null);
    public static final Property printFormat = BPrinterRecipient.newProperty((int)0, (BValue)BPrinterRecipient.makeDefaultPrintFormat(), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property alertOnFailure = BPrinterRecipient.newProperty((int)0, (boolean)false, null);
    public static final Property alarmSourceInfo = BPrinterRecipient.newProperty((int)0, (BValue)BPrinterRecipient.makeDefaultAlarmSourceInfo(), null);
    public static final Action getPrinters = BPrinterRecipient.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$print$BPrinterRecipient == null ? (class$com$tridium$alarm$print$BPrinterRecipient = BPrinterRecipient.class$("com.tridium.alarm.print.BPrinterRecipient")) : class$com$tridium$alarm$print$BPrinterRecipient));
    private static final Log log = Log.getLog((String)"alarm.printer");
    private AlarmSupport support;
    private Queue printQueue = new Queue();
    private Worker printThread = new Worker((Worker.ITodo)this.printQueue);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"print.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    static /* synthetic */ Class class$com$tridium$alarm$print$BPrinterRecipient;

    public String getPrinter() {
        return this.getString(printer);
    }

    public void setPrinter(String string) {
        this.setString(printer, string, null);
    }

    public BFont getFont() {
        return (BFont)this.get(font);
    }

    public void setFont(BFont bFont) {
        this.set(font, (BValue)bFont, null);
    }

    public BFormat getPrintFormat() {
        return (BFormat)this.get(printFormat);
    }

    public void setPrintFormat(BFormat bFormat) {
        this.set(printFormat, (BValue)bFormat, null);
    }

    public boolean getAlertOnFailure() {
        return this.getBoolean(alertOnFailure);
    }

    public void setAlertOnFailure(boolean bl) {
        this.setBoolean(alertOnFailure, bl, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo bAlarmSourceInfo) {
        this.set(alarmSourceInfo, (BValue)bAlarmSourceInfo, null);
    }

    public BVector getPrinters() {
        return (BVector)this.invoke(getPrinters, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.support = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.printThread.start("alarm:printing");
    }

    public void stopped() throws Exception {
        this.printThread.stop();
    }

    public static BFormat makeDefaultPrintFormat() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Source:      %alarmData.sourceName%\n");
        stringBuffer.append("Timestamp:   %timestamp%\n");
        stringBuffer.append("State:       %sourceState% / %ackState%\n");
        stringBuffer.append("Priority:    %priority%\n");
        stringBuffer.append("Alarm Class: %alarmClass%\n");
        stringBuffer.append("Text:        %alarmData.msgText%\n");
        stringBuffer.append("\n");
        return BFormat.make((String)stringBuffer.toString());
    }

    public static BAlarmSourceInfo makeDefaultAlarmSourceInfo() {
        BAlarmSourceInfo bAlarmSourceInfo = new BAlarmSourceInfo();
        bAlarmSourceInfo.setAlarmIcon(BOrd.make((String)"module://icons/x16/print.png"));
        return bAlarmSourceInfo;
    }

    public BVector doGetPrinters() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, null);
        BVector bVector = new BVector();
        for (int i = 0; i < printServiceArray.length; ++i) {
            bVector.add(null, (BValue)BString.make((String)printServiceArray[i].getName()));
        }
        return bVector;
    }

    public void handleAlarm(BAlarmRecord bAlarmRecord) {
        if (bAlarmRecord.getSource().equals((Object)BOrdList.make((BOrd)this.getNavOrd()))) {
            return;
        }
        this.printQueue.enqueue((Object)new PrintJob(BFormat.make((String)this.getPrintFormat().format((Object)bAlarmRecord)).format((Object)bAlarmRecord)));
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        try {
            return BBoolean.make((boolean)this.support.ackAlarm(bAlarmRecord));
        }
        catch (Exception exception) {
            return BBoolean.FALSE;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PrintJob
    implements Runnable,
    Printable {
        int[] lineNumberAtTopOfPage;
        ArrayList textLines = new ArrayList();

        public PrintJob(String string) {
            int n;
            String[] stringArray = string.split("\n");
            for (n = 0; n < stringArray.length; ++n) {
                this.textLines.add(stringArray[n]);
            }
            this.lineNumberAtTopOfPage = new int[100];
            this.lineNumberAtTopOfPage[0] = 0;
            for (n = 1; n < this.lineNumberAtTopOfPage.length; ++n) {
                this.lineNumberAtTopOfPage[n] = -1;
            }
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            int n2 = this.lineNumberAtTopOfPage[n];
            if (this.lineNumberAtTopOfPage[n] == -1) {
                return 1;
            }
            if (n != 0) {
                while (((String)this.textLines.get(n2)).length() == 0) {
                    ++n2;
                }
            }
            try {
                Object object;
                Font font;
                int n3;
                Object object2;
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                if (!BPrinterRecipient.this.getFont().isNull()) {
                    object2 = BPrinterRecipient.this.getFont();
                    n3 = 0;
                    if (object2.isBold()) {
                        n3 |= 1;
                    }
                    if (object2.isItalic()) {
                        n3 |= 2;
                    }
                    font = new Font(object2.getName(), n3, (int)object2.getSize());
                    if (object2.isUnderline()) {
                        object = new Hashtable();
                        object.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                        font = font.deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)object);
                    }
                    graphics.setFont(font);
                    graphics2D.setFont(font);
                } else {
                    font = graphics2D.getFont();
                }
                object2 = graphics2D.getFontMetrics(font);
                n3 = ((FontMetrics)object2).getAscent();
                while (n2 < this.textLines.size() && (double)n3 < pageFormat.getImageableHeight()) {
                    object = (String)this.textLines.get(n2);
                    if ((double)((FontMetrics)object2).charsWidth(((String)object).toCharArray(), 0, ((String)object).length()) > pageFormat.getImageableWidth()) {
                        int n4;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (int i = 0; i < ((String)object).length(); i += n4) {
                            n4 = ((String)object).length() - i;
                            while ((double)((FontMetrics)object2).charsWidth(((String)object).toCharArray(), i, n4) > pageFormat.getImageableWidth()) {
                                --n4;
                            }
                            int n5 = n4;
                            if (i + n5 < ((String)object).length()) {
                                while (((String)object).charAt(i + n5 - 1) != ' ' && n5 > 1) {
                                    --n5;
                                }
                                if (n5 > 1) {
                                    n4 = n5;
                                }
                            }
                            arrayList.add(((String)object).substring(i, i + n4));
                        }
                        this.textLines.remove(n2);
                        for (n4 = arrayList.size() - 1; n4 >= 0; --n4) {
                            this.textLines.add(n2, arrayList.get(n4));
                        }
                    }
                    graphics2D.drawString((String)object, 0, n3);
                    n3 += ((FontMetrics)object2).getAscent();
                    ++n2;
                }
                if ((double)n3 >= pageFormat.getImageableHeight()) {
                    this.lineNumberAtTopOfPage[n + 1] = n2;
                }
            }
            catch (Exception exception) {
                log.error("Print failure", (Throwable)exception);
                return 1;
            }
            return 0;
        }

        public void run() {
            HashAttributeSet hashAttributeSet = new HashAttributeSet();
            hashAttributeSet.add(new PrinterName(BPrinterRecipient.this.getPrinter(), null));
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, hashAttributeSet);
            if (printServiceArray.length < 1) {
                try {
                    if (BPrinterRecipient.this.getAlertOnFailure()) {
                        BFacets bFacets = BPrinterRecipient.this.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal);
                        bFacets = BFacets.make((BFacets)bFacets, (String)"msgText", (BIDataValue)BString.make((String)("Printer '" + BPrinterRecipient.this.getPrinter() + "' not found.")));
                        BPrinterRecipient.this.support.newAlert(bFacets);
                    }
                }
                catch (Exception exception) {
                    log.warning("Printer not found: " + BPrinterRecipient.this.getPrinter(), (Throwable)exception);
                }
                return;
            }
            try {
                DocPrintJob docPrintJob = printServiceArray[0].createPrintJob();
                docPrintJob.print(new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null), null);
            }
            catch (PrintException printException) {
                if (BPrinterRecipient.this.getAlertOnFailure()) {
                    BFacets bFacets = BPrinterRecipient.this.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal);
                    bFacets = BFacets.make((BFacets)bFacets, (String)"msgText", (BIDataValue)BString.make((String)("Unable to print to '" + BPrinterRecipient.this.getPrinter() + "'")));
                    try {
                        BPrinterRecipient.this.support.newAlert(bFacets);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                log.error("Printer failure", (Throwable)printException);
            }
        }
    }
}

