/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BAlarmConsoleRow
extends BStruct {
    public static final Property alarm = BAlarmConsoleRow.newProperty((int)257, (BValue)new BAlarmRecord(), null);
    public static final Property ackState = BAlarmConsoleRow.newProperty((int)257, (String)"", null);
    public static final Type TYPE;
    private Map openAlarms;
    private Context cx;
    private int ackedCount;
    private int ackPendingCount;
    private int unackedCount;
    static /* synthetic */ Class class$com$tridium$alarm$model$BAlarmConsoleRow;

    public final BAlarmRecord getAlarm() {
        return (BAlarmRecord)this.get(alarm);
    }

    public final void setAlarm(BAlarmRecord bAlarmRecord) {
        this.set(alarm, (BValue)bAlarmRecord, null);
    }

    public final String getAckState() {
        return this.getString(ackState);
    }

    public final void setAckState(String string) {
        this.setString(ackState, string, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getAlarm().getTimestamp().toString());
        stringBuffer.append(" ");
        stringBuffer.append(this.getAckStateStr());
        return stringBuffer.toString();
    }

    final void update(BAlarmRecord bAlarmRecord) {
        BAlarmRecord bAlarmRecord2 = (BAlarmRecord)((Object)this.openAlarms.get(bAlarmRecord.getUuid()));
        bAlarmRecord = (BAlarmRecord)bAlarmRecord.newCopy(true);
        this.openAlarms.put(bAlarmRecord.getUuid(), bAlarmRecord);
        if (bAlarmRecord2 != null) {
            if (!bAlarmRecord2.isAcknowledged() && !bAlarmRecord2.isAckPending() && bAlarmRecord.isAckPending()) {
                ++this.ackPendingCount;
                --this.unackedCount;
            } else if (bAlarmRecord2.isAckPending() && bAlarmRecord.isAcknowledged()) {
                --this.ackPendingCount;
                ++this.ackedCount;
            } else if (bAlarmRecord2.isAckPending() && !bAlarmRecord.isAcknowledged() && !bAlarmRecord.isAckPending()) {
                --this.ackPendingCount;
                ++this.unackedCount;
            } else if (bAlarmRecord2.isAcknowledged() && !bAlarmRecord.isAcknowledged() && !bAlarmRecord.isAckPending()) {
                --this.ackedCount;
                ++this.unackedCount;
            } else if (bAlarmRecord2.isAcknowledged() && bAlarmRecord.isAckPending()) {
                --this.ackedCount;
                ++this.ackPendingCount;
            } else if (bAlarmRecord.isAcknowledged() && !bAlarmRecord2.isAcknowledged() && !bAlarmRecord2.isAckPending()) {
                ++this.ackedCount;
                --this.unackedCount;
            }
        } else if (bAlarmRecord.isAcknowledged()) {
            ++this.ackedCount;
        } else if (bAlarmRecord.isAckPending()) {
            ++this.ackPendingCount;
        } else {
            ++this.unackedCount;
        }
        if (!(bAlarmRecord.getSourceState() != BSourceState.normal && bAlarmRecord.getSourceState() != BSourceState.alert || !bAlarmRecord.isAcknowledged() && bAlarmRecord.getAckRequired())) {
            if (this.openAlarms.get(bAlarmRecord.getUuid()) == null) {
                return;
            }
            this.openAlarms.remove(bAlarmRecord.getUuid());
            if (bAlarmRecord.isAcknowledged()) {
                --this.ackedCount;
            } else if (bAlarmRecord.getAckState() == BAckState.ackPending) {
                --this.ackPendingCount;
            } else {
                --this.unackedCount;
            }
        }
        this.updateAlarmInfo();
    }

    final boolean isEmpty() {
        boolean bl = false;
        if (this.openAlarms.size() == 0) {
            bl = true;
        }
        return bl;
    }

    private final void updateAlarmInfo() {
        BAlarmRecord bAlarmRecord = null;
        BAlarmRecord bAlarmRecord2 = null;
        Iterator iterator = this.openAlarms.keySet().iterator();
        while (iterator.hasNext()) {
            bAlarmRecord2 = (BAlarmRecord)((Object)this.openAlarms.get(iterator.next()));
            if (bAlarmRecord == null) {
                bAlarmRecord = bAlarmRecord2;
                continue;
            }
            if (!bAlarmRecord2.getTimestamp().isAfter(bAlarmRecord.getTimestamp())) continue;
            bAlarmRecord = bAlarmRecord2;
        }
        if (bAlarmRecord != null) {
            this.setAlarm(bAlarmRecord);
        }
        this.setAckState(this.getAckStateStr());
    }

    private final String getAckStateStr() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.ackedCount).append(" ").append(BAckState.acked.getDisplayTag(this.cx)).append(" / ");
        stringBuffer.append(this.unackedCount).append(" ").append(BAckState.unacked.getDisplayTag(this.cx));
        if (this.ackPendingCount > 0) {
            stringBuffer.append(" / ").append(this.ackPendingCount).append(" ").append(BAckState.ackPending.getDisplayTag(this.cx));
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.openAlarms = new HashMap();
        this.ackedCount = 0;
        this.ackPendingCount = 0;
        this.unackedCount = 0;
    }

    public BAlarmConsoleRow() {
        this.this();
    }

    public BAlarmConsoleRow(Context context) {
        this.this();
        this.cx = context;
    }

    static {
        Class clazz = class$com$tridium$alarm$model$BAlarmConsoleRow;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$model$BAlarmConsoleRow = BAlarmConsoleRow.class("[Lcom.tridium.alarm.model.BAlarmConsoleRow;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

