/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.model;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.model.BAlarmConsoleRow;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BICollection;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BAlarmConsoleModel
extends BComponent {
    public static final Action routeAlarm = BAlarmConsoleModel.newAction((int)260, (BValue)new BAlarmRecord(), null);
    public static final Action ackAlarms = BAlarmConsoleModel.newAction((int)260, (BValue)new BComponent(), null);
    public static final Action forceClear = BAlarmConsoleModel.newAction((int)260, (BValue)new BComponent(), null);
    public static final Action refresh = BAlarmConsoleModel.newAction((int)260, null);
    public static final Action addNotes = BAlarmConsoleModel.newAction((int)260, (BValue)new BComponent(), null);
    public static final Action expire = BAlarmConsoleModel.newAction((int)260, null);
    public static final Type TYPE;
    private static final BRelTime expiryTime;
    private static final Log log;
    private volatile Context routeAlarmCx;
    private final Object alarmMon;
    private volatile boolean started;
    private volatile Clock.Ticket expireTicket;
    static /* synthetic */ Class class$com$tridium$alarm$model$BAlarmConsoleModel;
    static /* synthetic */ Class class$com$tridium$alarm$model$BAlarmConsoleRow;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

    public final void routeAlarm(BAlarmRecord bAlarmRecord) {
        this.invoke(routeAlarm, (BValue)bAlarmRecord, null);
    }

    public final void ackAlarms(BComponent bComponent) {
        this.invoke(ackAlarms, (BValue)bComponent, null);
    }

    public final void forceClear(BComponent bComponent) {
        this.invoke(forceClear, (BValue)bComponent, null);
    }

    public final void refresh() {
        this.invoke(refresh, null, null);
    }

    public final void addNotes(BComponent bComponent) {
        this.invoke(addNotes, (BValue)bComponent, null);
    }

    public final void expire() {
        this.invoke(expire, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void started() {
        this.linkTo(this.getConsole(), (Slot)BAlarmRecipient.routeAlarm, (Slot)routeAlarm);
        this.expireTicket = Clock.schedule((BComponent)this, (BRelTime)expiryTime, (Action)expire, null);
    }

    public final void stopped() throws Exception {
        this.expireTicket.cancel();
    }

    public final void subscribed() {
        this.expireTicket.cancel();
    }

    public final void unsubscribed() {
        if (this.isRunning()) {
            this.expireTicket = Clock.schedule((BComponent)this, (BRelTime)expiryTime, (Action)expire, null);
        }
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BConsoleRecipient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doRefresh(Context var1_1) {
        if (this.routeAlarmCx == null) {
            this.routeAlarmCx = new BasicContext(var1_1.getUser(), var1_1.getLanguage());
        }
        this.started = true;
        var2_2 = this.alarmMon;
        synchronized (var2_2) {
            if (BAlarmConsoleModel.log.isTraceOn()) {
                BAlarmConsoleModel.log.trace("Refreshing alarm console");
            }
            if ((v0 = BAlarmConsoleModel.class$com$tridium$alarm$model$BAlarmConsoleRow) == null) {
                v0 = BAlarmConsoleModel.class$com$tridium$alarm$model$BAlarmConsoleRow = BAlarmConsoleModel.class("[Lcom.tridium.alarm.model.BAlarmConsoleRow;", false);
            }
            var4_3 = (BAlarmConsoleRow[])this.getChildren(v0);
            var5_4 = 0;
            while (true) {
                block8: {
                    if (var5_4 < var4_3.length) break block8;
                    var5_5 = this.getConsole().getOpenAlarms(var1_1);
                    if (true) ** GOTO lbl27
                }
                this.remove((BComplex)var4_3[var5_4]);
                ++var5_4;
            }
            do {
                if ((var6_6 = (BAlarmRecord)var5_5.get()).getSourceState() == BSourceState.normal && (var6_6.isAcknowledged() || !var6_6.getAckRequired())) continue;
                this.doRouteAlarm(var6_6, var1_1);
lbl27:
                // 3 sources

            } while (var5_5.next());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doRouteAlarm(BAlarmRecord bAlarmRecord, Context context) {
        if (!this.started) {
            return;
        }
        if (!this.getConsole().accept(bAlarmRecord)) {
            return;
        }
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        if (!this.hasPermissions(bAlarmService, bAlarmRecord, BPermissions.operatorRead, this.routeAlarmCx)) {
            return;
        }
        Object object = this.alarmMon;
        synchronized (object) {
            block11: {
                BAlarmConsoleRow bAlarmConsoleRow;
                String string;
                block10: {
                    string = SlotPath.escape((String)bAlarmRecord.getSource().toString());
                    bAlarmConsoleRow = (BAlarmConsoleRow)this.get(string);
                    if (bAlarmConsoleRow == null) {
                        bAlarmConsoleRow = new BAlarmConsoleRow(this.routeAlarmCx);
                    }
                    bAlarmConsoleRow.update(bAlarmRecord);
                    if (!bAlarmConsoleRow.isEmpty()) break block10;
                    if (bAlarmConsoleRow.getParent() != null) {
                        this.remove((BComplex)bAlarmConsoleRow);
                    }
                    break block11;
                }
                int n = 258;
                if (!this.hasPermissions(bAlarmService, bAlarmRecord, BPermissions.operatorWrite, this.routeAlarmCx)) {
                    n |= 1;
                }
                if (bAlarmConsoleRow.getParent() == null) {
                    this.add(string, (BValue)bAlarmConsoleRow, n);
                }
            }
            return;
        }
    }

    private final BAlarmRecord[] getAlarmRecords(BAlarmService bAlarmService, BComponent bComponent) throws Exception {
        BComponent bComponent2 = (BComponent)bComponent.get("alarmSources");
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BAlarmConsoleModel.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        Array array = new Array(clazz);
        if (bComponent2 != null) {
            Property[] propertyArray = bComponent2.getDynamicPropertiesArray();
            int n = 0;
            while (n < propertyArray.length) {
                BValue bValue = bComponent2.get(propertyArray[n]);
                if (bValue instanceof BOrdList) {
                    BOrdList bOrdList = (BOrdList)bValue;
                    BOrd bOrd = BOrd.make((String)("alarm:|bql:select * from openAlarms where source = OrdList '" + SlotPath.escape((String)bOrdList.encodeToString()) + '\''));
                    BICollection bICollection = (BICollection)bOrd.get();
                    Cursor cursor = bICollection.cursor();
                    while (cursor.next()) {
                        array.add((Object)cursor.get().asValue().newCopy(true));
                    }
                }
                ++n;
            }
        } else {
            BComponent bComponent3 = (BComponent)bComponent.get("alarms");
            Property[] propertyArray = bComponent3.getDynamicPropertiesArray();
            int n = 0;
            while (n < propertyArray.length) {
                BAlarmRecord bAlarmRecord = bAlarmService.getAlarmDb().getRecord((BUuid)bComponent3.get(propertyArray[n]));
                if (bAlarmRecord != null) {
                    array.add((Object)bAlarmRecord.newCopy(true));
                }
                ++n;
            }
        }
        return (BAlarmRecord[])array.trim();
    }

    public final void doAckAlarms(BComponent bComponent, Context context) throws Exception {
        if (log.isTraceOn()) {
            log.trace("Acknowledging alarms");
        }
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmDatabase bAlarmDatabase = bAlarmService.getAlarmDb();
        BAlarmRecord[] bAlarmRecordArray = this.getAlarmRecords(bAlarmService, bComponent);
        int n = 0;
        while (n < bAlarmRecordArray.length) {
            if (this.hasPermissions(bAlarmService, bAlarmRecordArray[n], BPermissions.operatorWrite, context)) {
                boolean bl = false;
                if (bAlarmRecordArray[n].getAckState() != BAckState.ackPending) {
                    bl = true;
                }
                boolean bl2 = bl;
                bAlarmRecordArray[n].setUser(context.getUser().getUsername());
                bAlarmRecordArray[n].setAckTime(BAbsTime.now());
                bAlarmRecordArray[n].setAckState(BAckState.ackPending);
                if (bl2) {
                    bAlarmDatabase.update(bAlarmRecordArray[n]);
                }
                bAlarmService.ackAlarm(bAlarmRecordArray[n]);
            }
            ++n;
        }
    }

    public final void doAddNotes(BComponent bComponent, Context context) throws Exception {
        if (log.isTraceOn()) {
            log.trace("Add Notes to alarms");
        }
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("##");
        stringBuffer.append(BAbsTime.now().toString());
        stringBuffer.append(" - ");
        stringBuffer.append(context.getUser().getName());
        stringBuffer.append(" ##\n");
        stringBuffer.append(((BString)bComponent.get("notes")).toString());
        BAlarmRecord[] bAlarmRecordArray = this.getAlarmRecords(bAlarmService, bComponent);
        int n = 0;
        while (n < bAlarmRecordArray.length) {
            if (this.hasPermissions(bAlarmService, bAlarmRecordArray[n], BPermissions.operatorWrite, context)) {
                String string = bAlarmRecordArray[n].getAlarmData().gets("notes", "");
                bAlarmRecordArray[n].setAlarmData(BFacets.make((BFacets)bAlarmRecordArray[n].getAlarmData(), (String)"notes", (BIDataValue)BString.make((String)(stringBuffer + string))));
                bAlarmRecordArray[n].setLastUpdate(BAbsTime.now());
                bAlarmService.routeAlarm(bAlarmRecordArray[n]);
                bAlarmService.doRouteToSource(bAlarmRecordArray[n]);
            }
            ++n;
        }
    }

    public final void doExpire(Context context) {
        if (log.isTraceOn()) {
            log.trace("Expiring Alarm Console Model: " + this.toPathString());
        }
        this.getConsole().remove((BComplex)this);
    }

    public final void doForceClear(BComponent bComponent, Context context) throws Exception {
        if (log.isTraceOn()) {
            log.trace("Alarm force clear");
        }
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmDatabase bAlarmDatabase = bAlarmService.getAlarmDb();
        BUser bUser = context.getUser();
        BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this.getConsole());
        if (!bPermissions.has(BPermissions.adminWrite) && !bPermissions.has(BPermissions.adminInvoke)) {
            throw new PermissionException(bPermissions + " < " + BPermissions.adminWrite);
        }
        BAlarmRecord[] bAlarmRecordArray = this.getAlarmRecords(bAlarmService, bComponent);
        int n = 0;
        while (n < bAlarmRecordArray.length) {
            BAlarmRecord bAlarmRecord = bAlarmRecordArray[n];
            BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
            if (bAlarmClass == null) {
                bAlarmClass = bAlarmService.getDefaultAlarmClass();
            }
            if (bUser.getPermissionsFor((BIProtected)bAlarmClass).has(BPermissions.adminWrite)) {
                bAlarmRecord.addAlarmFacet("forceCleared", (BIDataValue)BString.make((String)bUser.getUsername()));
                if (bAlarmRecord.getAckTime().equals((Object)BAbsTime.NULL)) {
                    bAlarmRecord.setAckTime(BAbsTime.now());
                }
                if (bAlarmRecord.getNormalTime().equals((Object)BAbsTime.NULL)) {
                    bAlarmRecord.setNormalTime(BAbsTime.now());
                }
                if (!bAlarmRecord.getAckState().equals((Object)BAckState.acked)) {
                    bAlarmRecord.setUser(bUser.getUsername());
                }
                bAlarmRecord.setSourceState(BSourceState.normal);
                bAlarmRecord.setAckState(BAckState.acked);
                bAlarmDatabase.update(bAlarmRecord);
                bAlarmService.invoke(BAlarmService.auditForceClear, (BValue)bAlarmRecord, context);
            }
            ++n;
        }
    }

    private final boolean hasPermissions(BAlarmService bAlarmService, BAlarmRecord bAlarmRecord, BPermissions bPermissions, Context context) {
        BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
        if (bAlarmClass == null) {
            bAlarmClass = bAlarmService.getDefaultAlarmClass();
        }
        return context.getUser().getPermissionsFor((BIProtected)bAlarmClass).has(bPermissions);
    }

    private final BConsoleRecipient getConsole() {
        return (BConsoleRecipient)this.getParent();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.alarmMon = new Object();
        this.started = false;
        this.expireTicket = Clock.expiredTicket;
    }

    public BAlarmConsoleModel() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$alarm$model$BAlarmConsoleModel;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$model$BAlarmConsoleModel = BAlarmConsoleModel.class("[Lcom.tridium.alarm.model.BAlarmConsoleModel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        expiryTime = BRelTime.makeSeconds((int)60);
        log = Log.getLog((String)"alarm.alarmConsoleModel");
    }
}

