/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.memory;

import com.tridium.alarm.FilterCursor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMemoryAlarmDatabase
extends BAlarmDatabase {
    public static final Type TYPE;
    private static final String CAPACITY = "capacity";
    private int capacity;
    private AlarmEntry first;
    private AlarmEntry last;
    private int recordCount;
    private HashMap byUuid;
    private IFilter openFilter;
    private IFilter ackPendingFilter;
    private BAlarmService alarmService;
    static /* synthetic */ Class class$com$tridium$alarm$db$memory$BMemoryAlarmDatabase;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmClass;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

    public Type getType() {
        return TYPE;
    }

    protected void doOpen() {
        this.recordCount = 0;
        this.first = null;
        this.last = null;
        this.byUuid = new HashMap();
    }

    protected void doClose() {
        this.recordCount = 0;
        this.first = null;
        this.last = null;
        this.byUuid = new HashMap();
    }

    public synchronized void append(BAlarmRecord bAlarmRecord) throws IOException {
        Object object;
        AlarmEntry alarmEntry = new AlarmEntry((BAlarmRecord)bAlarmRecord.newCopy(true));
        if (this.first == null) {
            this.first = this.last = alarmEntry;
        } else {
            object = bAlarmRecord.getTimestamp();
            AlarmEntry alarmEntry2 = this.first;
            while (alarmEntry2 != null && alarmEntry2.rec.getTimestamp().isBefore((BAbsTime)object)) {
                alarmEntry2 = alarmEntry2.next;
            }
            if (alarmEntry2 == null) {
                this.last.next = alarmEntry;
                alarmEntry.prev = this.last;
                this.last = alarmEntry;
            } else {
                alarmEntry.prev = alarmEntry2.prev;
                if (alarmEntry2.prev != null) {
                    alarmEntry2.prev.next = alarmEntry;
                }
                alarmEntry.next = alarmEntry2;
                alarmEntry2.prev = alarmEntry;
                if (alarmEntry2 == this.first) {
                    this.first = alarmEntry;
                }
            }
        }
        this.byUuid.put(bAlarmRecord.getUuid(), alarmEntry);
        ++this.recordCount;
        object = this.alarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
        if (object.getName().equals(bAlarmRecord.getAlarmClass())) {
            ((BAlarmClass)((Object)object)).setTotalAlarmCount(((BAlarmClass)((Object)object)).getTotalAlarmCount() + 1);
            if (!bAlarmRecord.isAcknowledged()) {
                ((BAlarmClass)((Object)object)).setUnackedAlarmCount(((BAlarmClass)((Object)object)).getUnackedAlarmCount() + 1);
            }
            if (!bAlarmRecord.isNormal()) {
                ((BAlarmClass)((Object)object)).setInAlarmCount(((BAlarmClass)((Object)object)).getInAlarmCount() + 1);
            }
            if (bAlarmRecord.isOpen()) {
                ((BAlarmClass)((Object)object)).setOpenAlarmCount(((BAlarmClass)((Object)object)).getOpenAlarmCount() + 1);
            }
        }
        if (this.recordCount > this.capacity) {
            this.trim();
        }
    }

    public synchronized void update(BAlarmRecord bAlarmRecord) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bAlarmRecord.write(new DataOutputStream(byteArrayOutputStream));
        BUuid bUuid = bAlarmRecord.getUuid();
        AlarmEntry alarmEntry = (AlarmEntry)this.byUuid.get(bUuid);
        if (alarmEntry != null) {
            BAlarmClass bAlarmClass = this.alarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
            if (bAlarmClass.getName().equals(bAlarmRecord.getAlarmClass())) {
                if (!alarmEntry.rec.isAcknowledged() && bAlarmRecord.isAcknowledged()) {
                    bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() - 1);
                } else if (alarmEntry.rec.isAcknowledged() && !bAlarmRecord.isAcknowledged()) {
                    bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() + 1);
                }
                if (alarmEntry.rec.isOpen() && !bAlarmRecord.isOpen()) {
                    bAlarmClass.setOpenAlarmCount(bAlarmClass.getOpenAlarmCount() - 1);
                }
                if (!alarmEntry.rec.isNormal() && bAlarmRecord.isNormal()) {
                    bAlarmClass.setInAlarmCount(bAlarmClass.getInAlarmCount() - 1);
                }
            }
            alarmEntry.rec = (BAlarmRecord)bAlarmRecord.newCopy(true);
        } else {
            this.append(bAlarmRecord);
        }
    }

    public synchronized void remove(BAlarmRecord bAlarmRecord) {
        BUuid bUuid = bAlarmRecord.getUuid();
        AlarmEntry alarmEntry = (AlarmEntry)this.byUuid.get(bUuid);
        if (alarmEntry != null) {
            if (alarmEntry.prev != null) {
                alarmEntry.prev.next = alarmEntry.next;
            }
            if (alarmEntry.next != null) {
                alarmEntry.next.prev = alarmEntry.prev;
            }
            if (alarmEntry == this.first) {
                this.first = alarmEntry.next;
            }
            if (alarmEntry == this.last) {
                this.last = alarmEntry.prev;
            }
            alarmEntry.prev = null;
            alarmEntry.next = null;
            this.byUuid.remove(bUuid);
        }
    }

    private final synchronized void trim() {
        while (this.recordCount > this.capacity) {
            AlarmEntry alarmEntry = this.first;
            this.first = this.first.next;
            alarmEntry.next = null;
            if (this.first != null) {
                this.first.prev = null;
            }
            this.byUuid.remove(alarmEntry.rec.getUuid());
            --this.recordCount;
            BAlarmClass bAlarmClass = this.alarmService.lookupAlarmClass(alarmEntry.rec.getAlarmClass());
            if (!bAlarmClass.getName().equals(alarmEntry.rec.getAlarmClass())) continue;
            bAlarmClass.setTotalAlarmCount(bAlarmClass.getTotalAlarmCount() - 1);
            if (!alarmEntry.rec.isAcknowledged()) {
                bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() - 1);
            }
            if (alarmEntry.rec.isOpen()) {
                bAlarmClass.setOpenAlarmCount(bAlarmClass.getOpenAlarmCount() - 1);
            }
            if (alarmEntry.rec.isNormal()) continue;
            bAlarmClass.setInAlarmCount(bAlarmClass.getInAlarmCount() - 1);
        }
    }

    public synchronized int getRecordCount() {
        return this.recordCount;
    }

    public BAlarmRecord getRecord(BUuid bUuid) {
        AlarmEntry alarmEntry = (AlarmEntry)this.byUuid.get(bUuid);
        if (alarmEntry == null) {
            return null;
        }
        return alarmEntry.rec;
    }

    public synchronized Cursor scan() throws IOException, AlarmException {
        return new AlarmCursor(this, this.first, BAbsTime.NULL, null);
    }

    public synchronized Cursor timeQuery(BAbsTime bAbsTime, BAbsTime bAbsTime2) throws IOException, AlarmException {
        AlarmEntry alarmEntry = null;
        AlarmEntry alarmEntry2 = this.first;
        while (alarmEntry2 != null) {
            if (!alarmEntry2.rec.getTimestamp().isBefore(bAbsTime)) {
                alarmEntry = alarmEntry2;
                break;
            }
            alarmEntry2 = alarmEntry2.next;
        }
        return new AlarmCursor(this, alarmEntry, bAbsTime2, null);
    }

    public Cursor getAlarmsForSource(BOrdList bOrdList) throws IOException {
        return new FilterCursor(new SourceFilter(bOrdList), this.scan());
    }

    public Cursor getOpenAlarms() throws IOException {
        return new FilterCursor(this.openFilter, this.scan());
    }

    public Cursor getAckPendingAlarms() throws IOException {
        return new FilterCursor(this.ackPendingFilter, this.scan());
    }

    public synchronized void clearAllRecords(Context context) throws IOException {
        this.recordCount = 0;
        this.first = null;
        this.last = null;
        this.byUuid = new HashMap();
        Class clazz = class$javax$baja$alarm$BAlarmClass;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmClass = BMemoryAlarmDatabase.class("[Ljavax.baja.alarm.BAlarmClass;", false);
        }
        BAlarmClass[] bAlarmClassArray = (BAlarmClass[])this.alarmService.getChildren(clazz);
        int n = 0;
        while (n < bAlarmClassArray.length) {
            bAlarmClassArray[n].setTotalAlarmCount(0);
            bAlarmClassArray[n].setUnackedAlarmCount(0);
            bAlarmClassArray[n].setOpenAlarmCount(0);
            bAlarmClassArray[n].setInAlarmCount(0);
            ++n;
        }
    }

    public synchronized void clearOldRecords(BAbsTime bAbsTime, Context context) throws IOException {
        while (this.first != null) {
            if (!bAbsTime.isAfter(this.first.rec.getTimestamp())) {
                return;
            }
            AlarmEntry alarmEntry = this.first;
            this.first = this.first.next;
            alarmEntry.next = null;
            if (this.first != null) {
                this.first.prev = null;
            }
            this.byUuid.remove(alarmEntry.rec.getUuid());
            --this.recordCount;
            BAlarmClass bAlarmClass = this.alarmService.lookupAlarmClass(alarmEntry.rec.getAlarmClass());
            if (!bAlarmClass.getName().equals(alarmEntry.rec.getAlarmClass())) continue;
            bAlarmClass.setTotalAlarmCount(bAlarmClass.getTotalAlarmCount() - 1);
            if (!alarmEntry.rec.isAcknowledged()) {
                bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() - 1);
            }
            if (alarmEntry.rec.isOpen()) {
                bAlarmClass.setOpenAlarmCount(bAlarmClass.getOpenAlarmCount() - 1);
            }
            if (alarmEntry.rec.isNormal()) continue;
            bAlarmClass.setInAlarmCount(bAlarmClass.getInAlarmCount() - 1);
        }
    }

    public void clearRecord(BUuid bUuid, Context context) {
        if (bUuid == null || bUuid.isNull()) {
            return;
        }
        AlarmEntry alarmEntry = (AlarmEntry)this.byUuid.get(bUuid);
        if (alarmEntry != null) {
            if (alarmEntry.prev != null) {
                alarmEntry.prev.next = alarmEntry.next;
            }
            if (alarmEntry.next != null) {
                alarmEntry.next.prev = alarmEntry.prev;
            }
            alarmEntry.next = null;
            alarmEntry.prev = null;
            this.byUuid.remove(bUuid);
            --this.recordCount;
            BAlarmClass bAlarmClass = this.alarmService.lookupAlarmClass(alarmEntry.rec.getAlarmClass());
            if (bAlarmClass.getName().equals(alarmEntry.rec.getAlarmClass())) {
                bAlarmClass.setTotalAlarmCount(bAlarmClass.getTotalAlarmCount() - 1);
                if (!alarmEntry.rec.isAcknowledged()) {
                    bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() - 1);
                }
                if (alarmEntry.rec.isOpen()) {
                    bAlarmClass.setOpenAlarmCount(bAlarmClass.getOpenAlarmCount() - 1);
                }
                if (!alarmEntry.rec.isNormal()) {
                    bAlarmClass.setInAlarmCount(bAlarmClass.getInAlarmCount() - 1);
                }
            }
            if (this.byUuid.size() == 0) {
                this.first = null;
                this.last = null;
            }
            alarmEntry = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCapacity(int n) throws IOException {
        if (n < 5) {
            throw new IllegalArgumentException("Attempted to set capacity < 5.");
        }
        if (this.capacity == n) {
            return;
        }
        this.capacity = n;
        if (!this.isOpen()) {
            return;
        }
        BMemoryAlarmDatabase bMemoryAlarmDatabase = this;
        synchronized (bMemoryAlarmDatabase) {
            AlarmEntry alarmEntry = this.first;
            this.first = null;
            this.last = null;
            this.recordCount = 0;
            while (alarmEntry != null) {
                this.append(alarmEntry.rec);
                alarmEntry = alarmEntry.next;
            }
            return;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.capacity = 1000;
        this.byUuid = new HashMap();
        this.openFilter = new OpenFilter();
        this.ackPendingFilter = new AckPendingFilter();
    }

    public BMemoryAlarmDatabase() {
        this.this();
        this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
    }

    static {
        Class clazz = class$com$tridium$alarm$db$memory$BMemoryAlarmDatabase;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$db$memory$BMemoryAlarmDatabase = BMemoryAlarmDatabase.class("[Lcom.tridium.alarm.db.memory.BMemoryAlarmDatabase;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AlarmEntry {
        BAlarmRecord rec;
        AlarmEntry prev;
        AlarmEntry next;

        public AlarmEntry(BAlarmRecord bAlarmRecord) {
            this.rec = bAlarmRecord;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AlarmCursor
    implements Cursor {
        private BMemoryAlarmDatabase db;
        private AlarmEntry start;
        private AlarmEntry entry;
        private BAbsTime endTime;
        private Context context;

        public Context getContext() {
            return this.context;
        }

        public BObject get() {
            if (this.start == null) {
                return null;
            }
            if (this.entry == null) {
                throw new IllegalStateException("get() before next()");
            }
            return this.entry.rec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean next() {
            if (this.start == null) {
                return false;
            }
            BMemoryAlarmDatabase bMemoryAlarmDatabase = this.db;
            synchronized (bMemoryAlarmDatabase) {
                this.entry = this.entry == null ? this.start : this.entry.next;
                if (this.entry == null) {
                    this.start = null;
                    return false;
                }
                return true;
            }
        }

        public boolean next(Class clazz) {
            Class clazz2 = class$javax$baja$alarm$BAlarmRecord;
            if (clazz2 == null) {
                clazz2 = class$javax$baja$alarm$BAlarmRecord = BMemoryAlarmDatabase.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
            }
            if (clazz2.isAssignableFrom(clazz)) {
                this.start = null;
                return false;
            }
            return this.next();
        }

        public boolean nextComponent() {
            this.start = null;
            return false;
        }

        public AlarmCursor(BMemoryAlarmDatabase bMemoryAlarmDatabase2, AlarmEntry alarmEntry, BAbsTime bAbsTime, Context context) {
            this.db = bMemoryAlarmDatabase2;
            this.start = alarmEntry;
            this.endTime = bAbsTime;
            this.context = context;
            this.entry = null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SourceFilter
    implements IFilter {
        BOrdList source;

        public boolean accept(Object object) {
            if (object == null || object instanceof BAlarmRecord) {
                return ((BAlarmRecord)((Object)object)).getSource().equals((Object)this.source);
            }
            return false;
        }

        public SourceFilter(BOrdList bOrdList) {
            this.source = bOrdList;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class OpenFilter
    implements IFilter {
        public boolean accept(Object object) {
            if (object == null || object instanceof BAlarmRecord) {
                return ((BAlarmRecord)((Object)object)).isOpen();
            }
            return false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AckPendingFilter
    implements IFilter {
        public boolean accept(Object object) {
            if (object == null || object instanceof BAlarmRecord) {
                return ((BAlarmRecord)((Object)object)).isAckPending();
            }
            return false;
        }
    }
}

