/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.IndexEntry;
import com.tridium.alarm.db.file.SkipList;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;

public class TimestampIndex
extends SkipList {
    public IndexEntry find(Object object) {
        BAbsTime bAbsTime = (BAbsTime)object;
        IndexEntry indexEntry = super.find(object);
        if (indexEntry.timestamp == null) {
            return indexEntry;
        }
        if (!indexEntry.timestamp.equals((Object)bAbsTime)) {
            return indexEntry;
        }
        IndexEntry indexEntry2 = this.getPrev(indexEntry);
        while (indexEntry2.timestamp != null && indexEntry2.timestamp.equals((Object)bAbsTime)) {
            indexEntry = indexEntry2;
            indexEntry2 = this.getPrev(indexEntry);
        }
        return indexEntry;
    }

    protected int compareToKey(IndexEntry indexEntry, Object object) {
        return indexEntry.timestamp.compareTo((Object)((BAbsTime)object));
    }

    protected int compare(IndexEntry indexEntry, IndexEntry indexEntry2) {
        int n = indexEntry.timestamp.compareTo((Object)indexEntry2.timestamp);
        if (n == 0) {
            return indexEntry.pageIndex - indexEntry2.pageIndex;
        }
        return n;
    }

    protected int getLevel(IndexEntry indexEntry) {
        return indexEntry.nextTimestamp.length;
    }

    protected void setLevel(IndexEntry indexEntry, int n) {
        indexEntry.nextTimestamp = new IndexEntry[n];
    }

    protected IndexEntry getNext(IndexEntry indexEntry, int n) {
        return indexEntry.nextTimestamp[n];
    }

    protected void setNext(IndexEntry indexEntry, int n, IndexEntry indexEntry2) {
        indexEntry.nextTimestamp[n] = indexEntry2;
    }

    protected IndexEntry getPrev(IndexEntry indexEntry) {
        return indexEntry.prevTimestamp;
    }

    protected void setPrev(IndexEntry indexEntry, IndexEntry indexEntry2) {
        indexEntry.prevTimestamp = indexEntry2;
    }

    public String entryToString(IndexEntry indexEntry) {
        return indexEntry.timestamp.toString((Context)BAlarmRecord.TIMESTAMP_FACETS) + " => " + indexEntry.pageIndex;
    }

    public TimestampIndex(double d, int n) {
        super(d, n);
    }
}

