/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.Block;
import java.io.IOException;

public class Page {
    public static final int HEADER_SIZE = 12;
    private Block block;
    private int pageInBlock;
    private int size;
    private int recPage;
    private int recPages;
    private int nextPage;

    public int getPageOfRecord() {
        return this.recPage;
    }

    public int getPagesOfRecord() {
        return this.recPages;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public synchronized void read() throws IOException {
        Block.Input input = this.block.getInput();
        input.seek(this.size * this.pageInBlock);
        this.recPage = input.readInt();
        this.recPages = input.readInt();
        this.nextPage = input.readInt();
    }

    public synchronized void write(int n, int n2, int n3, byte[] byArray, int n4, int n5) throws IOException {
        this.recPage = n;
        this.recPages = n2;
        this.nextPage = n3;
        Block.Output output = this.block.getOutput();
        output.seek(this.size * this.pageInBlock);
        output.writeInt(n);
        output.writeInt(n2);
        output.writeInt(n3);
        if (n5 != 0) {
            output.write(byArray, n4, n5);
        }
    }

    public void clear() throws IOException {
        this.write(-1, 0, -1, null, 0, 0);
    }

    public synchronized int readData(int n) throws IOException {
        Block.Input input = this.block.getInput();
        input.seek(this.size * this.pageInBlock + 12 + n);
        return input.read();
    }

    public synchronized int readData(int n, byte[] byArray, int n2, int n3) throws IOException {
        Block.Input input = this.block.getInput();
        input.seek(this.size * this.pageInBlock + 12 + n);
        int n4 = this.size - 12 - n;
        if (n4 < n3) {
            return input.read(byArray, n2, n4);
        }
        return input.read(byArray, n2, n3);
    }

    public String toString() {
        return this.recPage + " of " + this.recPages + ", next=" + this.nextPage;
    }

    public Page(Block block, int n, int n2) {
        this.block = block;
        this.pageInBlock = n;
        this.size = n2;
    }
}

