/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

public class FreePageMap {
    private static final int[] BIT_MASKS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private int pageCount = 0;
    private byte[] pageMask = null;

    public int getPageCount() {
        return this.pageCount;
    }

    public int getFreeCount() {
        int n;
        int n2;
        byte by;
        if (this.pageCount == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.pageMask.length - 1) {
            by = this.pageMask[n4];
            n2 = 1;
            n = 0;
            while (n < 8) {
                if ((by & n2) == 0) {
                    ++n3;
                }
                n2 <<= 1;
                ++n;
            }
            ++n4;
        }
        n4 = this.pageCount - (this.pageMask.length - 1) * 8;
        by = this.pageMask[this.pageMask.length - 1];
        n2 = 1;
        n = 0;
        while (n < n4) {
            if ((by & n2) == 0) {
                ++n3;
            }
            n2 <<= 1;
            ++n;
        }
        return n3;
    }

    public int getFreePage() {
        if (this.pageCount != 0) {
            int n = this.pageMask.length;
            int n2 = 0;
            while (n2 < n) {
                if ((this.pageMask[n2] & 0xFF ^ 0xFF) != 0) {
                    int n3 = 1;
                    int n4 = 0;
                    while (n4 < 8) {
                        if ((this.pageMask[n2] & 0xFF & n3) == 0) {
                            return n2 * 8 + n4;
                        }
                        n3 <<= 1;
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return -1;
    }

    public boolean isFree(int n) {
        int n2 = n / 8;
        if (n2 >= this.pageCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        boolean bl = false;
        if ((this.pageMask[n2] & BIT_MASKS[n - n2 * 8]) == 0) {
            bl = true;
        }
        return bl;
    }

    public void setFree(int n, boolean bl) {
        if (n >= this.pageCount) {
            this.addFreePages(n - this.pageCount + 1);
        }
        int n2 = n / 8;
        int n3 = BIT_MASKS[n - n2 * 8];
        this.pageMask[n2] = bl ? (byte)(this.pageMask[n2] & ~n3) : (byte)(this.pageMask[n2] | n3);
    }

    public void addFreePages(int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Invalid add count: " + n);
        }
        if (this.pageMask == null) {
            int n3 = n / 8;
            if (n % 8 != 0) {
                ++n3;
            }
            this.pageMask = new byte[n3];
            this.pageCount = n;
            return;
        }
        int n4 = this.pageMask.length * 8;
        int n5 = n4 - this.pageCount;
        if (n5 != 0) {
            n2 = n5 > n ? n : n5;
            this.pageCount += n2;
            n -= n2;
        }
        if (n == 0) {
            return;
        }
        n2 = n / 8;
        if (n % 8 != 0) {
            ++n2;
        }
        int n6 = this.pageMask.length;
        byte[] byArray = new byte[n6 + n2];
        System.arraycopy(this.pageMask, 0, byArray, 0, n6);
        this.pageMask = byArray;
        this.pageCount += n;
    }

    public int getSizeInBytes() {
        return this.pageMask.length;
    }

    public void dump() {
        int n;
        int n2;
        byte by;
        if (this.pageCount == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.pageMask.length - 1) {
            by = this.pageMask[n4];
            n2 = 1;
            n = 0;
            while (n < 8) {
                if ((by & n2) == 0) {
                    System.out.println(n3++ + ") free");
                } else {
                    System.out.println(n3++ + ") in use");
                }
                n2 <<= 1;
                ++n;
            }
            ++n4;
        }
        n4 = this.pageCount - (this.pageMask.length - 1) * 8;
        by = this.pageMask[this.pageMask.length - 1];
        n2 = 1;
        n = 0;
        while (n < n4) {
            if ((by & n2) == 0) {
                System.out.println(n3++ + ") free");
            } else {
                System.out.println(n3++ + ") in use");
            }
            n2 <<= 1;
            ++n;
        }
    }
}

