/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.alarm.db.file.BFileAlarmDatabase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.dataRecovery.DataRecoveryException;
import javax.baja.io.ByteBuffer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public abstract class DataRecoveryAlarmEvent {
    static final byte EVENT_APPEND = 0;
    static final byte EVENT_UPDATE = 1;
    static final byte EVENT_CLEARALL = 2;
    static final byte EVENT_CLEAROLD = 3;
    static final byte EVENT_CLEARRECORD = 4;
    static final byte EVENT_CAPACITYCHANGE = 5;
    private int eventCode;

    public static final DataRecoveryAlarmEvent make(byte[] byArray) throws Exception {
        ByteBuffer byteBuffer = new ByteBuffer(byArray);
        int n = -1;
        try {
            n = byteBuffer.readByte();
            switch (n) {
                case 0: {
                    return new Append(byteBuffer);
                }
                case 1: {
                    return new Update(byteBuffer);
                }
                case 2: {
                    return new ClearAll(byteBuffer);
                }
                case 3: {
                    return new ClearOld(byteBuffer);
                }
                case 4: {
                    return new ClearRecord(byteBuffer);
                }
                case 5: {
                    return new CapacityChange(byteBuffer);
                }
            }
            throw new IllegalStateException("Unknown alarm event code: '" + n + '\'');
        }
        catch (IOException iOException) {
            throw new DataRecoveryException("Invalid alarm data (event=" + n + ", length=" + byArray.length + ')', (Throwable)iOException);
        }
    }

    public abstract void execute(BFileAlarmDatabase var1) throws Exception;

    public byte[] encode() throws IOException {
        ByteBuffer byteBuffer = new ByteBuffer();
        byteBuffer.writeByte(this.eventCode);
        return byteBuffer.toByteArray();
    }

    protected final AlarmStore getAlarmStore(BFileAlarmDatabase bFileAlarmDatabase) {
        return (AlarmStore)bFileAlarmDatabase.fw(602, null, null, null, null);
    }

    int getEventCode() {
        return this.eventCode;
    }

    private DataRecoveryAlarmEvent(int n) {
        this.eventCode = n;
    }

    public static class Append
    extends DataRecoveryAlarmEvent {
        BAlarmRecord record;

        public void execute(BFileAlarmDatabase bFileAlarmDatabase) throws IOException {
            AlarmStore alarmStore = this.getAlarmStore(bFileAlarmDatabase);
            BAlarmRecord bAlarmRecord = alarmStore.getRecord(this.record.getUuid());
            if (bAlarmRecord == null || bAlarmRecord.getLastUpdate().isBefore(this.record.getLastUpdate())) {
                this.getAlarmStore(bFileAlarmDatabase).append(this.record);
                if (this.record.getAckState().equals((Object)BAckState.ackPending)) {
                    ((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).ackAlarm(this.record);
                }
            }
        }

        public byte[] encode() throws IOException {
            ByteBuffer byteBuffer = new ByteBuffer();
            byteBuffer.write(super.encode());
            this.record.write((DataOutput)byteBuffer);
            return byteBuffer.toByteArray();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[Append ");
            if (this.record.getAckState().equals((Object)BAckState.ackPending)) {
                stringBuffer.append("and Route ");
            }
            stringBuffer.append(this.record.getUuid()).append("]");
            return stringBuffer.toString();
        }

        public Append(BAlarmRecord bAlarmRecord) {
            super(0);
            this.record = bAlarmRecord;
        }

        public Append(ByteBuffer byteBuffer) throws Exception {
            super(0);
            this.record = new BAlarmRecord();
            this.record.read((DataInput)byteBuffer);
        }
    }

    public static class Update
    extends DataRecoveryAlarmEvent {
        BAlarmRecord record;

        public void execute(BFileAlarmDatabase bFileAlarmDatabase) throws IOException {
            AlarmStore alarmStore = this.getAlarmStore(bFileAlarmDatabase);
            BAlarmRecord bAlarmRecord = alarmStore.getRecord(this.record.getUuid());
            if (bAlarmRecord == null || bAlarmRecord.getLastUpdate().isBefore(this.record.getLastUpdate())) {
                this.getAlarmStore(bFileAlarmDatabase).update(this.record);
                if (bAlarmRecord != null && bAlarmRecord.getAckState().equals((Object)BAckState.ackPending)) {
                    ((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).ackAlarm(this.record);
                }
            }
        }

        public byte[] encode() throws IOException {
            ByteBuffer byteBuffer = new ByteBuffer();
            byteBuffer.write(super.encode());
            this.record.write((DataOutput)byteBuffer);
            return byteBuffer.toByteArray();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[Update ");
            if (this.record.getAckState().equals((Object)BAckState.ackPending)) {
                stringBuffer.append("and Route ");
            }
            stringBuffer.append(this.record.getUuid()).append("]");
            return stringBuffer.toString();
        }

        public Update(BAlarmRecord bAlarmRecord) {
            super(1);
            this.record = bAlarmRecord;
        }

        public Update(ByteBuffer byteBuffer) throws Exception {
            super(1);
            this.record = new BAlarmRecord();
            this.record.read((DataInput)byteBuffer);
        }
    }

    public static class ClearAll
    extends DataRecoveryAlarmEvent {
        public void execute(BFileAlarmDatabase bFileAlarmDatabase) throws IOException {
            this.getAlarmStore(bFileAlarmDatabase).clearAllRecords(null);
        }

        public String toString() {
            return "[ClearAll]";
        }

        public ClearAll() {
            super(2);
        }

        public ClearAll(ByteBuffer byteBuffer) {
            this();
        }
    }

    public static class ClearOld
    extends DataRecoveryAlarmEvent {
        BAbsTime before;

        public void execute(BFileAlarmDatabase bFileAlarmDatabase) throws IOException {
            this.getAlarmStore(bFileAlarmDatabase).clearOldRecords(this.before, null);
        }

        public byte[] encode() throws IOException {
            ByteBuffer byteBuffer = new ByteBuffer();
            byteBuffer.write(super.encode());
            this.before.encode((DataOutput)byteBuffer);
            return byteBuffer.toByteArray();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[ClearOld ").append(this.before).append("]");
            return stringBuffer.toString();
        }

        public ClearOld(BAbsTime bAbsTime) {
            super(3);
            this.before = bAbsTime;
        }

        public ClearOld(ByteBuffer byteBuffer) throws Exception {
            this(BAbsTime.make((long)byteBuffer.readLong()));
        }
    }

    public static class ClearRecord
    extends DataRecoveryAlarmEvent {
        BUuid uuid;

        public void execute(BFileAlarmDatabase bFileAlarmDatabase) throws IOException {
            this.getAlarmStore(bFileAlarmDatabase).clearRecord(this.uuid, null);
        }

        public byte[] encode() throws IOException {
            ByteBuffer byteBuffer = new ByteBuffer();
            byteBuffer.write(super.encode());
            this.uuid.encode((DataOutput)byteBuffer);
            return byteBuffer.toByteArray();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[ClearRecord ").append(this.uuid).append("]");
            return stringBuffer.toString();
        }

        public ClearRecord(BUuid bUuid) {
            super(4);
            this.uuid = bUuid;
        }

        public ClearRecord(ByteBuffer byteBuffer) throws IOException {
            this((BUuid)BUuid.DEFAULT.decode((DataInput)byteBuffer));
        }
    }

    public static class CapacityChange
    extends DataRecoveryAlarmEvent {
        int capacity;

        public void execute(BFileAlarmDatabase bFileAlarmDatabase) throws IOException {
            AlarmStore alarmStore = this.getAlarmStore(bFileAlarmDatabase);
            alarmStore.setCapacity(this.capacity);
            alarmStore.trimToCapacity();
        }

        public byte[] encode() throws IOException {
            ByteBuffer byteBuffer = new ByteBuffer();
            byteBuffer.write(super.encode());
            byteBuffer.writeInt(this.capacity);
            return byteBuffer.toByteArray();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[Capacity ").append(this.capacity).append("]");
            return stringBuffer.toString();
        }

        public CapacityChange(int n) {
            super(5);
            this.capacity = n;
        }

        public CapacityChange(ByteBuffer byteBuffer) throws Exception {
            this(byteBuffer.readInt());
        }
    }
}

