/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.alarm.db.file.Block;
import java.io.IOException;
import javax.baja.nre.util.IntHashMap;

public class BlockCache {
    private AlarmStore store;
    private int max;
    private int size;
    private IntHashMap table;
    private Block newest;
    private Block oldest;

    public synchronized Block getBlock(int n) {
        return (Block)this.table.get(n);
    }

    public synchronized void add(Block block) throws IOException {
        int n = block.getIndex();
        Block block2 = (Block)this.table.get(n);
        if (block2 != null) {
            if (block2.prev != null) {
                block2.prev.next = block2.next;
            }
            if (block2.next != null) {
                block2.next.prev = block2.prev;
            }
            if (block2 == this.newest) {
                this.newest = block2.next;
            }
            if (block2 == this.oldest) {
                this.oldest = block2.prev;
            }
            block2.next = null;
            block2.prev = null;
            --this.size;
        }
        this.table.put(n, (Object)block);
        if (this.newest == null) {
            this.newest = this.oldest = block;
            block.next = null;
            block.prev = null;
        } else {
            this.newest.prev = block;
            block.next = this.newest;
            block.prev = null;
            this.newest = block;
        }
        ++this.size;
        if (this.size > this.max) {
            this.evict(this.size - this.max);
        }
    }

    public synchronized void remove(int n) {
        Block block = (Block)this.table.get(n);
        if (block == null) {
            return;
        }
        this.table.remove(n);
        if (block.prev != null) {
            block.prev.next = block.next;
        }
        if (block.next != null) {
            block.next.prev = block.prev;
        }
        if (block == this.newest) {
            this.newest = block.next;
        }
        if (block == this.oldest) {
            this.oldest = block.prev;
        }
        block.next = null;
        block.prev = null;
        --this.size;
    }

    public synchronized void remove(Block block) {
        this.remove(block.getIndex());
    }

    public synchronized void flush() throws IOException {
        Block block = this.newest;
        while (block != null) {
            this.store.writeBlock(block);
            block = block.next;
        }
    }

    public synchronized void evict(int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            if (this.size == 0) {
                return;
            }
            this.store.writeBlock(this.oldest);
            this.table.remove(this.oldest.getIndex());
            if (this.newest == this.oldest) {
                this.oldest = null;
                this.newest = null;
            } else {
                Block block = this.oldest;
                this.oldest = this.oldest.prev;
                this.oldest.next = null;
                block.next = null;
                block.prev = null;
            }
            --this.size;
            ++n2;
        }
    }

    public void dump() {
        System.out.println("BlockCache.dump");
        System.out.println("  forward");
        int n = 0;
        Block block = this.newest;
        while (block != null) {
            System.out.print("    " + n++ + ") block " + block.getIndex());
            if (block == this.oldest) {
                System.out.print(" (oldest)");
            }
            if (block == this.newest) {
                System.out.print(" (newest)");
            }
            System.out.println();
            block = block.next;
        }
        System.out.println("  reverse");
        --n;
        block = this.oldest;
        while (block != null) {
            System.out.print("    " + n-- + ") block " + block.getIndex());
            if (block == this.oldest) {
                System.out.print(" (oldest)");
            }
            if (block == this.newest) {
                System.out.print(" (newest)");
            }
            System.out.println();
            block = block.prev;
        }
    }

    public BlockCache(AlarmStore alarmStore, int n) {
        this.store = alarmStore;
        this.max = n;
        this.table = new IntHashMap(this.max);
        this.size = 0;
        this.newest = null;
        this.oldest = null;
    }
}

