/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.alarm.db.file.Page;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Block {
    private AlarmStore store;
    private int index;
    private byte[] data;
    private Page[] pages;
    private Input in;
    private Output out;
    private boolean dirty;
    Block prev;
    Block next;

    public int getSize() {
        return this.data.length;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clear() throws IOException {
        int n = 0;
        while (n < this.pages.length) {
            this.pages[n] = new Page(this, n, this.store.getHeader().getPageSize());
            this.pages[n].clear();
            ++n;
        }
    }

    public void read(DataInput dataInput) throws IOException {
        dataInput.readFully(this.data);
        this.dirty = false;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.data);
        this.dirty = false;
    }

    public synchronized Page getPage(int n) throws IOException {
        if (this.pages == null) {
            this.pages = new Page[this.store.getHeader().getPagesPerBlock()];
        }
        try {
            if (this.pages[n] == null) {
                this.pages[n] = this.initPage(n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n2 = this.store.getHeader().getPagesPerBlock();
            throw new IllegalArgumentException("Invalid page index: " + n + ". Pages per block = " + n2);
        }
        return this.pages[n];
    }

    private final Page initPage(int n) throws IOException {
        Page page = new Page(this, n, this.store.getHeader().getPageSize());
        page.read();
        return page;
    }

    public void dump() throws IOException {
        int n = this.store.getHeader().getPagesPerBlock();
        int n2 = 0;
        while (n2 < n) {
            Page page = this.getPage(n2);
            System.out.println(n2 + "] " + page.getPageOfRecord() + " of " + page.getPagesOfRecord());
            ++n2;
        }
    }

    public Input getInput() {
        return this.in;
    }

    public int write(int n, int n2) {
        this.data[n] = (byte)n2;
        this.dirty = true;
        return n + 1;
    }

    public int write(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.data, n, n3);
        this.dirty = true;
        return n + n3;
    }

    public int writeInt(int n, int n2) {
        this.write(n++, n2 >>> 24 & 0xFF);
        this.write(n++, n2 >>> 16 & 0xFF);
        this.write(n++, n2 >>> 8 & 0xFF);
        this.write(n++, n2 & 0xFF);
        return n;
    }

    public Output getOutput() {
        return this.out;
    }

    private final /* synthetic */ void this() {
        this.dirty = true;
    }

    public Block(AlarmStore alarmStore, int n) {
        this.this();
        this.store = alarmStore;
        this.index = n;
        int n2 = alarmStore.getHeader().getPageSize();
        int n3 = alarmStore.getHeader().getPagesPerBlock();
        this.data = new byte[n2 * n3];
        this.pages = new Page[n3];
        this.out = new Output(this);
        this.in = new Input(this.data);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Output {
        private Block block;
        private int pos;

        public void seek(int n) {
            this.pos = n;
        }

        public void write(int n) {
            this.block.write(this.pos++, n);
        }

        public void write(byte[] byArray) {
            this.pos = this.block.write(this.pos, byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) {
            this.pos = this.block.write(this.pos, byArray, n, n2);
        }

        public void writeInt(int n) {
            this.pos = this.block.writeInt(this.pos, n);
        }

        public Output(Block block2) {
            this.block = block2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Input {
        private byte[] buffer;
        private int length;
        private int pos;

        public void seek(int n) {
            this.pos = n;
        }

        public int read() throws IOException {
            try {
                return this.buffer[this.pos++] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new EOFException();
            }
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = Math.min(n2, this.length - this.pos);
            if (n3 == 0) {
                return -1;
            }
            System.arraycopy(this.buffer, this.pos, byArray, n, n3);
            this.pos += n3;
            return n3;
        }

        public void readFully(byte[] byArray) throws IOException {
            this.read(byArray, 0, byArray.length);
        }

        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            this.read(byArray, n, n2);
        }

        public int readInt() throws IOException {
            return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
        }

        public Input(byte[] byArray) {
            this.buffer = byArray;
            this.length = byArray.length;
            this.pos = 0;
        }
    }
}

