/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.alarm.db.file.DataRecoveryAlarmEvent;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.archive.FileArchive;
import com.tridium.sys.Nre;
import com.tridium.sys.resource.ResourceReport;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySource;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.io.BIEncodable;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFileAlarmDatabase
extends BAlarmDatabase
implements BIDataRecoverySource {
    public static final Type TYPE;
    private static final BOrd ordInSession;
    private static final String CAPACITY = "capacity";
    private static final String ARCHIVE_ID = "alarm";
    private static final Log dataRecoveryLog;
    private ServiceListener serviceListener;
    private int capacity;
    private File dbDir;
    private File alarmFile;
    private AlarmStore alarmStore;
    private BOrd alarmServiceOrd;
    private BIDataRecoveryService dataRecoveryService;
    static /* synthetic */ Class class$com$tridium$alarm$db$file$BFileAlarmDatabase;

    public void doOpen() throws IOException {
        Object object;
        if (this.dbDir == null) {
            try {
                FilePath filePath;
                BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
                if (bSystemPlatformService.archiveEnabled(ARCHIVE_ID)) {
                    bSystemPlatformService.extractArchive(ARCHIVE_ID);
                }
                String string = bSystemPlatformService.getRuntimeDirectory(ARCHIVE_ID);
                object = (BFileSpace)BOrd.make((String)"file:").get();
                BIFile bIFile = object.findFile(filePath = new FilePath(string));
                if (bIFile == null) {
                    BDirectory bDirectory = object.makeDir(filePath);
                    this.dbDir = ((BLocalFileStore)bDirectory.getStore()).getLocalFile();
                } else {
                    this.dbDir = ((BLocalFileStore)bIFile.getStore()).getLocalFile();
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                if (Sys.getStation() != null) {
                    log.warning("No system platform service available, using station home directory for alarm database root.");
                    this.dbDir = new File(Sys.getBajaHome().getAbsolutePath() + File.separatorChar + "stations" + File.separatorChar + Sys.getStation().getStationName() + File.separatorChar + ARCHIVE_ID);
                }
                log.warning("No system platform service available, using Niagara home directory for alarm database root.");
                this.dbDir = new File(Sys.getBajaHome().getAbsolutePath() + File.separatorChar + ARCHIVE_ID);
            }
        }
        if (!this.dbDir.exists()) {
            this.dbDir.mkdirs();
        }
        this.alarmFile = new File(this.dbDir, "alarm.adb");
        if (!this.alarmFile.exists()) {
            this.alarmFile.createNewFile();
        }
        int n = 0;
        while (true) {
            try {
                this.alarmStore = new AlarmStore(this.alarmFile, this.capacity);
                this.alarmStore.open();
            }
            catch (Exception exception) {
                BAlarmDatabase.log.error("Cannot open alarm database.", (Throwable)exception);
                if (!this.alarmFile.exists() || ++n == 2) break;
                if (Nre.getPlatform().isFlashFileSystem()) {
                    if (this.alarmFile.delete()) {
                        BAlarmDatabase.log.error("Old alarm database deleted.");
                        continue;
                    }
                    throw new IOException("Unable to delete old alarm database.");
                }
                object = this.saveErrorDb();
                if (object == null) continue;
                BAlarmDatabase.log.error("Old alarm database saved as " + ((File)object).getAbsolutePath() + '.');
                continue;
            }
            break;
        }
        this.alarmServiceOrd = Sys.getService((Type)BAlarmService.TYPE).getOrdInSession();
        try {
            this.dataRecoveryService = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
            if (!this.dataRecoveryService.isEnabled()) {
                this.dataRecoveryService = null;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {}
        Nre.serviceManager.addServiceListener(this.serviceListener);
    }

    private final File saveErrorDb() throws IOException {
        String[] stringArray = this.dbDir.list();
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].indexOf("error") != -1) {
                ++n;
            }
            if (n == 3) {
                throw new IOException("Cannot create recovery file.  " + n + " recovery files already exist.");
            }
            ++n2;
        }
        File file = new File(this.dbDir, "alarm_error.adb");
        if (file.exists()) {
            int n3 = 2;
            while (file.exists()) {
                file = new File(this.dbDir, "alarm_error" + n3 + ".adb");
                ++n3;
            }
        }
        if (!this.alarmFile.renameTo(file)) {
            throw new IOException("Unable to create recovery file.");
        }
        return file;
    }

    public void doSave() throws IOException {
        try {
            BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            if (bSystemPlatformService.archiveEnabled(ARCHIVE_ID)) {
                FileArchive fileArchive = bSystemPlatformService.createFileArchive(ARCHIVE_ID);
                String string = this.dbDir.getAbsolutePath();
                String string2 = this.alarmFile.getAbsolutePath().substring(string.length() + 1);
                fileArchive.writeFile(this.alarmFile, string2);
                fileArchive.close();
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("No system platform service available, cannot create alarm archive file.");
            throw new IOException("Could not create alarm archive file.");
        }
    }

    public void doFlush() throws IOException {
        this.alarmStore.flush();
    }

    public void doClose() {
        this.alarmStore.close();
        this.alarmStore = null;
    }

    public synchronized void append(BAlarmRecord bAlarmRecord) throws IOException {
        this.assertOpen();
        if (this.dataRecoveryService != null) {
            this.dataRecoveryService.append((BIDataRecoverySource)this, (BIEncodable)bAlarmRecord.getUuid(), new DataRecoveryAlarmEvent.Append(bAlarmRecord).encode());
        }
        this.alarmStore.append(bAlarmRecord);
    }

    public synchronized void update(BAlarmRecord bAlarmRecord) throws IOException {
        this.assertOpen();
        if (this.dataRecoveryService != null) {
            this.dataRecoveryService.update((BIDataRecoverySource)this, (BIEncodable)bAlarmRecord.getUuid(), new DataRecoveryAlarmEvent.Update(bAlarmRecord).encode());
        }
        this.alarmStore.update(bAlarmRecord);
    }

    public synchronized int getRecordCount() {
        this.assertOpen();
        return this.alarmStore.getRecordCount();
    }

    public synchronized BAlarmRecord getRecord(BUuid bUuid) throws IOException {
        this.assertOpen();
        return this.alarmStore.getRecord(bUuid);
    }

    public synchronized Cursor scan() {
        this.assertOpen();
        return this.alarmStore.scan();
    }

    public synchronized Cursor timeQuery(BAbsTime bAbsTime, BAbsTime bAbsTime2) {
        this.assertOpen();
        return this.alarmStore.timeQuery(bAbsTime, bAbsTime2);
    }

    public synchronized Cursor getAlarmsForSource(BOrdList bOrdList) throws IOException {
        this.assertOpen();
        return this.alarmStore.getAlarmsForSource(bOrdList);
    }

    public synchronized Cursor getOpenAlarms() throws IOException {
        this.assertOpen();
        return this.alarmStore.getOpenAlarms();
    }

    public synchronized Cursor getAckPendingAlarms() throws IOException {
        this.assertOpen();
        return this.alarmStore.getAckPendingAlarms();
    }

    public synchronized void clearAllRecords(Context context) throws IOException {
        this.assertOpen();
        if (this.dataRecoveryService != null) {
            this.dataRecoveryService.append((BIDataRecoverySource)this, (BIEncodable)BString.make((String)"clearAll"), new DataRecoveryAlarmEvent.ClearAll().encode());
        }
        Auditor auditor = Nre.auditor;
        int n = this.getRecordCount();
        this.alarmStore.clearAllRecords(context);
        if (auditor != null) {
            String string = "";
            if (context != null && context.getUser() != null) {
                string = context.getUser().getUsername();
            }
            auditor.audit(new AuditEvent("Invoked", "Alarm Database", "Clear", Integer.toString(n) + " records", Integer.toString(this.getRecordCount()) + " records", string));
        }
    }

    public synchronized void clearOldRecords(BAbsTime bAbsTime, Context context) throws IOException {
        this.assertOpen();
        if (this.dataRecoveryService != null) {
            this.dataRecoveryService.append((BIDataRecoverySource)this, (BIEncodable)BLong.make((long)Clock.ticks()), new DataRecoveryAlarmEvent.ClearOld(bAbsTime).encode());
        }
        Auditor auditor = Nre.auditor;
        int n = this.getRecordCount();
        this.alarmStore.clearOldRecords(bAbsTime, context);
        if (auditor != null) {
            String string = "";
            if (context != null && context.getUser() != null) {
                string = context.getUser().getUsername();
            }
            auditor.audit(new AuditEvent("Invoked", "Alarm Database", "Clear before " + bAbsTime.toString((Context)BAlarmRecord.TIMESTAMP_FACETS), Integer.toString(n) + " records", Integer.toString(this.getRecordCount()) + " records", string));
        }
    }

    public synchronized void clearRecord(BUuid bUuid, Context context) throws IOException {
        if (bUuid == null || bUuid.isNull()) {
            return;
        }
        this.assertOpen();
        if (this.dataRecoveryService != null) {
            this.dataRecoveryService.append((BIDataRecoverySource)this, (BIEncodable)bUuid, new DataRecoveryAlarmEvent.ClearRecord(bUuid).encode());
        }
        Auditor auditor = Nre.auditor;
        int n = this.getRecordCount();
        this.alarmStore.clearRecord(bUuid, context);
        if (auditor != null) {
            String string = "";
            if (context != null && context.getUser() != null) {
                string = context.getUser().getUsername();
            }
            auditor.audit(new AuditEvent("Invoked", "Alarm Database", "Clear record " + bUuid, Integer.toString(n) + " records", Integer.toString(this.getRecordCount()) + " records", string));
        }
    }

    public void setCapacity(int n) throws IOException {
        if (this.capacity == n) {
            return;
        }
        if (this.dataRecoveryService != null) {
            this.dataRecoveryService.append((BIDataRecoverySource)this, (BIEncodable)BString.make((String)CAPACITY), new DataRecoveryAlarmEvent.CapacityChange(n).encode());
        }
        this.capacity = n;
        if (!this.isOpen()) {
            return;
        }
        this.alarmStore.setCapacity(this.capacity);
        this.alarmStore.trimToCapacity();
    }

    public BOrd getOrdInSession() throws Exception {
        return ordInSession;
    }

    public void dataRecoveryRestoreComplete() {
    }

    public boolean dataRecoveryRestore(IDataRecoveryRecord iDataRecoveryRecord) throws Exception {
        DataRecoveryAlarmEvent dataRecoveryAlarmEvent = null;
        try {
            dataRecoveryAlarmEvent = DataRecoveryAlarmEvent.make(iDataRecoveryRecord.getData());
            dataRecoveryAlarmEvent.execute(this);
            if (dataRecoveryLog.isTraceOn()) {
                dataRecoveryLog.trace("Restored alarm event " + dataRecoveryAlarmEvent);
            }
            return true;
        }
        catch (Exception exception) {
            if (dataRecoveryAlarmEvent == null) {
                dataRecoveryLog.error("Could not restore event", (Throwable)exception);
            } else {
                dataRecoveryLog.error("Could not restore event " + dataRecoveryAlarmEvent, (Throwable)exception);
            }
            throw exception;
        }
    }

    public void dataRecoverySpy(SpyWriter spyWriter, Iterator iterator) throws Exception {
        Object object;
        Object object2;
        IDataRecoveryRecord iDataRecoveryRecord;
        DataRecoveryAlarmEvent dataRecoveryAlarmEvent = null;
        HashMap<Object, DataRecoveryAlarmSpyData> hashMap = new HashMap<Object, DataRecoveryAlarmSpyData>();
        int n = 0;
        while (iterator.hasNext()) {
            try {
                ++n;
                iDataRecoveryRecord = (IDataRecoveryRecord)iterator.next();
                dataRecoveryAlarmEvent = DataRecoveryAlarmEvent.make(iDataRecoveryRecord.getData());
                object2 = new Integer(dataRecoveryAlarmEvent.getEventCode());
                object = (DataRecoveryAlarmSpyData)hashMap.get(object2);
                if (object == null) {
                    hashMap.put(object2, new DataRecoveryAlarmSpyData(iDataRecoveryRecord.getData().length));
                    continue;
                }
                hashMap.put(object2, ((DataRecoveryAlarmSpyData)object).addEvent(iDataRecoveryRecord.getData().length));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        iDataRecoveryRecord = hashMap.keySet().iterator();
        object2 = n + " Alarm Events Recently Recorded in Data Recovery";
        spyWriter.startTable(true);
        spyWriter.trTitle(object2, 4);
        spyWriter.w((Object)"<tr><th>Event</th><th>Occurrences</th><th>Total Bytes</th><th>Avg Bytes</th></tr>\n");
        while (iDataRecoveryRecord.hasNext()) {
            try {
                String string;
                object = (Integer)iDataRecoveryRecord.next();
                DataRecoveryAlarmSpyData dataRecoveryAlarmSpyData = (DataRecoveryAlarmSpyData)hashMap.get(object);
                switch ((Integer)object) {
                    case 0: {
                        string = "Append";
                        break;
                    }
                    case 1: {
                        string = "Update";
                        break;
                    }
                    case 2: {
                        string = "ClearAll";
                        break;
                    }
                    case 3: {
                        string = "ClearOld";
                        break;
                    }
                    case 4: {
                        string = "ClearRecord";
                        break;
                    }
                    case 5: {
                        string = "CapacityChange";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown alarm event code: '" + object + '\'');
                    }
                }
                spyWriter.tr((Object)string, (Object)("" + dataRecoveryAlarmSpyData.occurances), (Object)("" + dataRecoveryAlarmSpyData.totalBytes), (Object)("" + (double)dataRecoveryAlarmSpyData.totalBytes / (double)dataRecoveryAlarmSpyData.occurances));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        spyWriter.endTable();
    }

    private final BIDataRecoveryService getDataRecoveryService() {
        if (this.dataRecoveryService == null) {
            try {
                this.dataRecoveryService = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
                if (!this.dataRecoveryService.isEnabled()) {
                    this.dataRecoveryService = null;
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                this.dataRecoveryService = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.dataRecoveryService;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 21: {
                ((ResourceReport)object).add(ARCHIVE_ID, this.countResourceUnits());
                break;
            }
            case 602: {
                return this.alarmStore;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final int countResourceUnits() {
        return this.capacity;
    }

    public Type getType() {
        return TYPE;
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            String string = stringArray[0];
            if (string.equals("o")) {
                BFileAlarmDatabase bFileAlarmDatabase = new BFileAlarmDatabase();
                bFileAlarmDatabase.open();
                System.out.println("Done.");
                bFileAlarmDatabase.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.serviceListener = new ServiceListener(){

            public final void serviceEvent(BServiceEvent bServiceEvent) {
                if (bServiceEvent.getServiceType().is(BIDataRecoveryService.TYPE)) {
                    if (bServiceEvent.getId() == 0) {
                        BFileAlarmDatabase.this.dataRecoveryService = (BIDataRecoveryService)bServiceEvent.getService();
                        if (!BFileAlarmDatabase.this.dataRecoveryService.isEnabled()) {
                            BFileAlarmDatabase.this.dataRecoveryService = null;
                        }
                    } else if (bServiceEvent.getId() == 1) {
                        BFileAlarmDatabase.this.dataRecoveryService = null;
                    }
                }
            }

            public final String toString() {
                return "ServiceListener for AlarmService";
            }
        };
        this.capacity = 10000;
        this.dbDir = null;
        this.alarmFile = null;
        this.alarmStore = null;
        this.alarmServiceOrd = null;
        this.dataRecoveryService = null;
    }

    public BFileAlarmDatabase() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$alarm$db$file$BFileAlarmDatabase;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$db$file$BFileAlarmDatabase = BFileAlarmDatabase.class("[Lcom.tridium.alarm.db.file.BFileAlarmDatabase;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ordInSession = BOrd.make((String)"alarm:");
        dataRecoveryLog = Log.getLog((String)"alarm.dataRecovery");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DataRecoveryAlarmSpyData {
        int occurances;
        int totalBytes;

        public DataRecoveryAlarmSpyData addEvent(int n) {
            ++this.occurances;
            this.totalBytes += n;
            return this;
        }

        private final /* synthetic */ void this() {
            this.occurances = -1;
            this.totalBytes = -1;
        }

        public DataRecoveryAlarmSpyData(int n) {
            this.this();
            this.occurances = 1;
            this.totalBytes = n;
        }
    }
}

