/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.io.ByteBuffer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlarmStoreHeader {
    private static final int MAGIC = 1611526157;
    private static final int LATEST_VERSION = 1;
    private static final int DEFAULT_HEADER_SIZE = 1024;
    private static final int DEFAULT_PAGE_SIZE = 512;
    private static final int DEFAULT_PAGES_PER_BLOCK = 8;
    private long creationTime;
    private int version;
    private int recordVersion;
    private long dataOffset;
    private int pageSize;
    private int pagesPerBlock;
    private boolean newStore;
    private ByteBuffer writeBuffer;

    public void write(DataOutput dataOutput) throws IOException {
        if (this.writeBuffer == null) {
            this.writeBuffer = new ByteBuffer(1024);
        } else {
            this.writeBuffer.reset();
        }
        this.writeBuffer.writeInt(1611526157);
        this.writeBuffer.writeInt(this.version);
        this.writeBuffer.writeInt(this.recordVersion);
        this.writeBuffer.writeLong(this.creationTime);
        this.writeBuffer.writeInt(this.pageSize);
        this.writeBuffer.writeInt(this.pagesPerBlock);
        int n = this.writeBuffer.getLength();
        int n2 = n + 8;
        if (this.newStore) {
            this.writeBuffer.writeTo(dataOutput, 0, n);
            this.dataOffset = Math.max(n2, 1024);
            dataOutput.writeLong(this.dataOffset);
            int n3 = (int)this.dataOffset - n2;
            dataOutput.write(new byte[n3]);
        } else {
            if ((long)n2 > this.dataOffset) {
                throw new IOException("Header overflow: " + n2 + " > " + this.dataOffset);
            }
            this.writeBuffer.writeTo(dataOutput, 0, n);
            dataOutput.writeLong(this.dataOffset);
        }
    }

    public void read(DataInput dataInput) throws IOException {
        this.newStore = false;
        int n = dataInput.readInt();
        if (n != 1611526157) {
            throw new IOException("Invalid or corrupt alarm database.");
        }
        this.version = dataInput.readInt();
        if (this.version != 1) {
            throw new IOException("Unrecognized alarm db version: " + this.version);
        }
        this.recordVersion = dataInput.readInt();
        this.creationTime = dataInput.readLong();
        this.pageSize = dataInput.readInt();
        this.pagesPerBlock = dataInput.readInt();
        this.dataOffset = dataInput.readLong();
    }

    public int getRecordVersion() {
        return this.recordVersion;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPagesPerBlock() {
        return this.pagesPerBlock;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    private final /* synthetic */ void this() {
        this.newStore = true;
    }

    public AlarmStoreHeader() {
        this(0);
    }

    public AlarmStoreHeader(int n) {
        this.this();
        this.version = 1;
        this.creationTime = System.currentTimeMillis();
        this.pageSize = 512;
        this.pagesPerBlock = 8;
        this.recordVersion = n;
    }
}

