/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.IndexEntry;
import com.tridium.alarm.db.file.SkipList;
import java.util.HashMap;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlarmSourceIndex {
    private static final BFacets showSecs = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE);
    private HashMap table;
    private double probability;
    private int maxSizePerSource;

    public synchronized IndexEntry getListForSource(BOrdList bOrdList) {
        SourceList sourceList = (SourceList)this.table.get(bOrdList);
        if (sourceList == null) {
            return null;
        }
        return sourceList.getFirstEntry();
    }

    public synchronized void add(BOrdList bOrdList, IndexEntry indexEntry) {
        SourceList sourceList = (SourceList)this.table.get(bOrdList);
        if (sourceList == null) {
            sourceList = new SourceList(this.probability, this.maxSizePerSource);
            this.table.put(bOrdList, sourceList);
            sourceList.add(indexEntry);
        } else {
            sourceList.add(indexEntry);
        }
    }

    public synchronized void remove(BOrdList bOrdList, IndexEntry indexEntry) {
        SourceList sourceList = (SourceList)this.table.get(bOrdList);
        if (sourceList == null) {
            return;
        }
        sourceList.remove(indexEntry);
    }

    public IndexEntry getNext(IndexEntry indexEntry) {
        return indexEntry.nextSource[0];
    }

    private final /* synthetic */ void this() {
        this.table = new HashMap(1001);
    }

    public AlarmSourceIndex(double d, int n) {
        this.this();
        this.probability = d;
        this.maxSizePerSource = n;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SourceList
    extends SkipList {
        public int compare(IndexEntry indexEntry, IndexEntry indexEntry2) {
            int n = indexEntry.timestamp.compareTo((Object)indexEntry2.timestamp);
            if (n == 0) {
                return indexEntry.pageIndex - indexEntry2.pageIndex;
            }
            return n;
        }

        public int compareToKey(IndexEntry indexEntry, Object object) {
            return indexEntry.timestamp.compareTo((Object)((BAbsTime)object));
        }

        public int getLevel(IndexEntry indexEntry) {
            return indexEntry.nextSource.length;
        }

        public void setLevel(IndexEntry indexEntry, int n) {
            indexEntry.nextSource = new IndexEntry[n];
        }

        public IndexEntry getNext(IndexEntry indexEntry, int n) {
            return indexEntry.nextSource[n];
        }

        public void setNext(IndexEntry indexEntry, int n, IndexEntry indexEntry2) {
            indexEntry.nextSource[n] = indexEntry2;
        }

        public IndexEntry getPrev(IndexEntry indexEntry) {
            return indexEntry.prevSource;
        }

        public void setPrev(IndexEntry indexEntry, IndexEntry indexEntry2) {
            indexEntry.prevSource = indexEntry2;
        }

        public String entryToString(IndexEntry indexEntry) {
            return indexEntry.timestamp.toString((Context)BAlarmRecord.TIMESTAMP_FACETS) + " => " + indexEntry.pageIndex;
        }

        public SourceList(double d, int n) {
            super(d, n);
        }
    }
}

