/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.IndexEntry;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;

public class AckPendingIndex {
    private static final BFacets showSecs = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE);
    private IndexEntry first = null;
    private IndexEntry last = null;
    private int size = 0;

    public int getSize() {
        return this.size;
    }

    public IndexEntry getFirstEntry() {
        return this.first;
    }

    public void add(IndexEntry indexEntry) {
        if (indexEntry.isAckPending()) {
            return;
        }
        indexEntry.setAckPending(true);
        indexEntry.nextAckPending = null;
        indexEntry.prevAckPending = null;
        if (this.size == 0) {
            this.first = this.last = indexEntry;
        } else {
            IndexEntry indexEntry2 = indexEntry.prevTimestamp;
            while (indexEntry2 != null && !indexEntry2.isAckPending()) {
                indexEntry2 = indexEntry2.prevTimestamp;
            }
            if (indexEntry2 == null) {
                if (this.first == null) {
                    this.first = this.last = indexEntry;
                } else {
                    indexEntry.nextAckPending = this.first;
                    this.first.prevAckPending = indexEntry;
                    this.first = indexEntry;
                }
            } else {
                indexEntry.nextAckPending = indexEntry2.nextAckPending;
                indexEntry.prevAckPending = indexEntry2;
                if (indexEntry2.nextAckPending != null) {
                    indexEntry2.nextAckPending.prevAckPending = indexEntry;
                }
                indexEntry2.nextAckPending = indexEntry;
                if (indexEntry.prevAckPending == this.last) {
                    this.last = indexEntry;
                }
            }
        }
        ++this.size;
    }

    public void remove(IndexEntry indexEntry) {
        if (this.size == 0 || indexEntry == null) {
            return;
        }
        if (!indexEntry.isAckPending()) {
            return;
        }
        indexEntry.setAckPending(false);
        if (indexEntry.prevAckPending != null) {
            indexEntry.prevAckPending.nextAckPending = indexEntry.nextAckPending;
        }
        if (indexEntry.nextAckPending != null) {
            indexEntry.nextAckPending.prevAckPending = indexEntry.prevAckPending;
        }
        if (indexEntry == this.first) {
            this.first = indexEntry.nextAckPending;
        }
        if (indexEntry == this.last) {
            this.last = indexEntry.prevAckPending;
        }
        indexEntry.nextAckPending = null;
        indexEntry.prevAckPending = null;
        --this.size;
    }

    public void dump() {
        IndexEntry indexEntry = this.first;
        int n = 0;
        while (indexEntry != null) {
            System.out.println(n++ + ") " + indexEntry.timestamp.toString((Context)showSecs) + " ackPending=" + indexEntry.isAckPending());
            indexEntry = indexEntry.nextAckPending;
        }
    }

    public void verify() {
        IndexEntry indexEntry = null;
        IndexEntry indexEntry2 = this.first;
        int n = 0;
        while (indexEntry2 != null) {
            ++n;
            if (indexEntry != null && indexEntry.timestamp.isAfter(indexEntry2.timestamp)) {
                throw new IllegalStateException("Invalid ascending order.  " + indexEntry2.timestamp.toString((Context)showSecs) + " is before " + indexEntry.timestamp.toString((Context)showSecs));
            }
            if (!indexEntry2.isAckPending()) {
                throw new IllegalStateException("Cleared alarm in ackPending index, ascending. " + indexEntry2.timestamp.toString((Context)showSecs));
            }
            indexEntry = indexEntry2;
            indexEntry2 = indexEntry2.nextAckPending;
        }
        if (this.size != n) {
            throw new IllegalStateException("Invalid ascending count. size=" + this.size + ", count=" + n);
        }
        indexEntry = null;
        indexEntry2 = this.last;
        n = 0;
        while (indexEntry2 != null) {
            ++n;
            if (indexEntry != null && indexEntry.timestamp.isBefore(indexEntry2.timestamp)) {
                throw new IllegalStateException("Invalid descending order.  " + indexEntry2.timestamp.toString((Context)showSecs) + " is after " + indexEntry.timestamp.toString((Context)showSecs));
            }
            if (!indexEntry2.isAckPending()) {
                throw new IllegalStateException("Cleared alarm in ackPending index, descending. " + indexEntry2.timestamp.toString((Context)showSecs));
            }
            indexEntry = indexEntry2;
            indexEntry2 = indexEntry2.prevAckPending;
        }
        if (this.size != n) {
            throw new IllegalStateException("Invalid descending count. size=" + this.size + ", count=" + n);
        }
    }
}

