/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm;

import com.tridium.alarm.AlarmsToSourcesCursor;
import com.tridium.alarm.BAlarmConsoleChannel;
import com.tridium.bql.util.BDynamicTimeRange;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.collection.BICollection;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BConsoleRecipient
extends BAlarmRecipient {
    public static final Property transitions = BConsoleRecipient.newProperty((int)0, (BValue)BAlarmTransitionBits.ALL, (BFacets)BFacets.make((String[])new String[]{"showNormal"}, (BIDataValue[])new BBoolean[]{BBoolean.FALSE}));
    public static final Property routeAcks = BConsoleRecipient.newProperty((int)1, (boolean)true, null);
    public static final Property defaultTimeRange = BConsoleRecipient.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    public static final Type TYPE;
    public static final Log logger;
    private static final BIcon icon;
    Array channels;
    static /* synthetic */ Class class$com$tridium$alarm$BConsoleRecipient;
    static /* synthetic */ Class class$com$tridium$alarm$BAlarmConsoleChannel;
    static /* synthetic */ Class class$javax$baja$user$BUser;

    public BAlarmTransitionBits getTransitions() {
        return (BAlarmTransitionBits)this.get(transitions);
    }

    public void setTransitions(BAlarmTransitionBits bAlarmTransitionBits) {
        this.set(transitions, (BValue)bAlarmTransitionBits, null);
    }

    public boolean getRouteAcks() {
        return this.getBoolean(routeAcks);
    }

    public void setRouteAcks(boolean bl) {
        this.setBoolean(routeAcks, bl, null);
    }

    public BDynamicTimeRange getDefaultTimeRange() {
        return (BDynamicTimeRange)this.get(defaultTimeRange);
    }

    public void setDefaultTimeRange(BDynamicTimeRange bDynamicTimeRange) {
        this.set(defaultTimeRange, (BValue)bDynamicTimeRange, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void handleAlarm(BAlarmRecord bAlarmRecord) {
        logger.trace("BConsoleRecipient.handleAlarm: " + (Object)((Object)bAlarmRecord.getSourceState()));
        int n = 0;
        while (n < this.channels.size()) {
            try {
                BAlarmConsoleChannel bAlarmConsoleChannel = (BAlarmConsoleChannel)((Object)this.channels.get(n));
                bAlarmConsoleChannel.newAlarm(this, bAlarmRecord);
            }
            catch (PermissionException permissionException) {
            }
            catch (Exception exception) {}
            ++n;
        }
    }

    public void registerAlarmChannel(BAlarmConsoleChannel bAlarmConsoleChannel) {
        if (!this.channels.contains((Object)bAlarmConsoleChannel)) {
            this.channels.add((Object)bAlarmConsoleChannel);
            try {
                bAlarmConsoleChannel.startWorker();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void unregisterAlarmChannel(BAlarmConsoleChannel bAlarmConsoleChannel) {
        this.channels.remove((Object)bAlarmConsoleChannel);
        try {
            bAlarmConsoleChannel.stopWorker();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Cursor getOpenAlarmSources(Context context) {
        return new AlarmsToSourcesCursor(this.getOpenAlarms(context));
    }

    public Cursor getOpenAlarms(Context context) {
        String string = this.getInitialAlarmQuery(context);
        return ((BICollection)BOrd.make((String)string).resolve((BObject)this).get()).cursor();
    }

    public String getInitialAlarmQuery(Context context) {
        BUserService bUserService;
        BUser bUser = null;
        if (context != null) {
            bUser = context.getUser();
        }
        if (bUser == null && !(bUser = (bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE)).getAdmin()).getEnabled()) {
            Class clazz = class$javax$baja$user$BUser;
            if (clazz == null) {
                clazz = class$javax$baja$user$BUser = BConsoleRecipient.class("[Ljavax.baja.user.BUser;", false);
            }
            BUser[] bUserArray = (BUser[])bUserService.getChildren(clazz);
            int n = 0;
            while (n < bUserArray.length) {
                if (bUserArray[n].getEnabled() && bUserArray[n].getPermissions().isSuperUser()) {
                    bUser = bUserArray[n];
                    break;
                }
                ++n;
            }
        }
        return this.getInitialAlarmQuery(bUser);
    }

    public String getInitialAlarmQuery(BUser bUser) {
        String string;
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        String[] stringArray = this.getSubscribedAlarmClasses();
        StringBuffer stringBuffer = new StringBuffer("alarm:|bql:select * from openAlarms");
        int n = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                string = stringArray[n2];
                bUser.check((BIProtected)bAlarmService.lookupAlarmClass(string), BPermissions.operatorRead);
                if (n > 0) {
                    stringBuffer2.append(" or ");
                } else {
                    stringBuffer2.append("(");
                }
                ++n;
                stringBuffer2.append("alarmClass = '" + SlotPath.escape((String)string) + '\'');
            }
            catch (PermissionException permissionException) {}
            ++n2;
        }
        if (n > 0) {
            stringBuffer2.append(")");
        }
        stringArray = this.getSubscribedEscalatedAlarmClasses(1);
        n2 = 0;
        while (n2 < stringArray.length) {
            try {
                string = stringArray[n2];
                bUser.check((BIProtected)bAlarmService.lookupAlarmClass(string), BPermissions.operatorRead);
                if (n > 0) {
                    stringBuffer2.append(" or ");
                }
                stringBuffer2.append("(alarmClass = '" + SlotPath.escape((String)string) + "' and (alarmData." + BAlarmClass.ESCALATED + " != null and alarmData." + BAlarmClass.ESCALATED + " = '" + BAlarmClass.LEVEL_3 + "' or alarmData." + BAlarmClass.ESCALATED + " = '" + BAlarmClass.LEVEL_2 + "' or alarmData." + BAlarmClass.ESCALATED + " = '" + BAlarmClass.LEVEL_1 + "'))");
                ++n;
            }
            catch (PermissionException permissionException) {}
            ++n2;
        }
        stringArray = this.getSubscribedEscalatedAlarmClasses(2);
        n2 = 0;
        while (n2 < stringArray.length) {
            try {
                string = stringArray[n2];
                bUser.check((BIProtected)bAlarmService.lookupAlarmClass(string), BPermissions.operatorRead);
                if (n > 0) {
                    stringBuffer2.append(" or ");
                }
                stringBuffer2.append("(alarmClass = '" + SlotPath.escape((String)string) + "' and (alarmData." + BAlarmClass.ESCALATED + " != null and alarmData." + BAlarmClass.ESCALATED + " = '" + BAlarmClass.LEVEL_3 + "' or alarmData." + BAlarmClass.ESCALATED + " = '" + BAlarmClass.LEVEL_2 + "'))");
                ++n;
            }
            catch (PermissionException permissionException) {}
            ++n2;
        }
        stringArray = this.getSubscribedEscalatedAlarmClasses(3);
        n2 = 0;
        while (n2 < stringArray.length) {
            try {
                string = stringArray[n2];
                bUser.check((BIProtected)bAlarmService.lookupAlarmClass(string), BPermissions.operatorRead);
                if (n > 0) {
                    stringBuffer2.append(" or ");
                }
                stringBuffer2.append("(alarmClass = '" + SlotPath.escape((String)string) + "' and alarmData." + BAlarmClass.ESCALATED + " != null and alarmData." + BAlarmClass.ESCALATED + " = '" + BAlarmClass.LEVEL_3 + "')");
                ++n;
            }
            catch (PermissionException permissionException) {}
            ++n2;
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(" where (");
            stringBuffer.append(stringBuffer2.toString() + ')');
        } else {
            stringBuffer.append(" where alarmClass = 'null'");
        }
        return stringBuffer.toString();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$tridium$alarm$BAlarmConsoleChannel;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$BAlarmConsoleChannel = BConsoleRecipient.class("[Lcom.tridium.alarm.BAlarmConsoleChannel;", false);
        }
        this.channels = new Array(clazz);
    }

    public BConsoleRecipient() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$alarm$BConsoleRecipient;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$BConsoleRecipient = BConsoleRecipient.class("[Lcom.tridium.alarm.BConsoleRecipient;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        logger = Log.getLog((String)"alarm");
        icon = BIcon.make((BIcon)BIcon.std((String)"computer.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    }
}

