/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.utils;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.db.BMbusPointData;
import com.tridium.mbus.enums.BMbusDescription;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.enums.BMbusFunction;
import com.tridium.mbus.enums.BMbusHeaderTypes;
import com.tridium.mbus.enums.BMbusNumberType;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.utils.MbusDataDecoderIEC870;
import com.tridium.mbus.utils.MbusEnhancedVifExtensionConvertor;
import com.tridium.mbus.utils.MbusExtendedIndicatorVifConvertor;
import com.tridium.mbus.utils.MbusExtendedVifConvertor;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusTextUtil;
import com.tridium.mbus.utils.MbusToolkit;
import com.tridium.mbus.utils.MbusVifConvertor;
import java.util.ArrayList;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MbusDecodeVariableFrame {
    String identNumber;
    String secondaryAddress;
    String manufacturer;
    String fabricationNumber;
    int versionNumber;
    BMbusDeviceTypeId deviceTypeId;
    int difeUnit;
    int access;
    String status;
    int storageNumber;
    BMbusFunction function;
    int difeTariff;
    int dataType;
    String description;
    BMbusOrthogonalDescription orthogonalDescription;
    BMbusUnit unitType;
    int exponent;
    double offset;
    boolean vifStringFlag;
    boolean status5;
    boolean status6;
    boolean status7;
    String vifString;
    BStatusValue value;
    int finishedAtIndex;
    int recordNumber;
    int lastRecordNumber;
    BMbusDevice device;
    BAbstractMbusNetwork network;
    int inputSlot;
    long blockSize;
    long blockDate;
    long blockInterval;
    boolean manufacturersData;
    int manufacturersIndex;
    boolean specialFunctionFound;
    private ArrayList activedataInformation;

    public final int decodeFixedDataHeader(int[] nArray) {
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" IN decodeFixedDataHeader ");
        }
        int n = 7;
        int n2 = 0;
        int n3 = 0;
        if (nArray[6] == 122 || nArray[6] == 114) {
            if (nArray[6] == 122) {
                n2 = nArray[7];
                n3 = nArray[8];
                n = 11;
            } else {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" IN 12 Byte Header ");
                }
                this.identNumber = MbusTextUtil.intToHexString((nArray[10] & 0xF0) >> 4, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString(nArray[10] & 0xF, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString((nArray[9] & 0xF0) >> 4, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString(nArray[9] & 0xF, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString((nArray[8] & 0xF0) >> 4, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString(nArray[8] & 0xF, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString((nArray[7] & 0xF0) >> 4, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString(nArray[7] & 0xF, 1);
                this.secondaryAddress = MbusTextUtil.intToHexString((nArray[11] & 0xF0) >> 4, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString(nArray[11] & 0xF, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString((nArray[12] & 0xF0) >> 4, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString(nArray[12] & 0xF, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString((nArray[13] & 0xF0) >> 4, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString(nArray[13] & 0xF, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString((nArray[14] & 0xF0) >> 4, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString(nArray[14] & 0xF, 1);
                this.secondaryAddress = this.identNumber + this.secondaryAddress;
                int n4 = nArray[11] | nArray[12] << 8;
                byte[] byArray = new byte[3];
                byArray[2] = (byte)((n4 & 0x1F) + 64);
                byArray[1] = (byte)((n4 >> 5 & 0x1F) + 64);
                byArray[0] = (byte)((n4 >> 10 & 0x1F) + 64);
                this.manufacturer = new String(byArray);
                this.versionNumber = nArray[13];
                this.deviceTypeId = nArray[14] <= 25 ? BMbusDeviceTypeId.make(nArray[14]) : BMbusDeviceTypeId.reserved;
                n2 = nArray[15];
                n3 = nArray[16];
                n = 19;
            }
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace(" IN Common Header ");
            }
            this.access = n2;
            if ((n3 & 0xF) == 0) {
                this.status = this.status + "No Application Error; ";
            } else if ((n3 & 0xF) == 1) {
                this.status = this.status + "Application Busy; ";
            } else if ((n3 & 0xF) == 2) {
                this.status = this.status + "Application Error; ";
            } else if ((n3 & 0xF) == 3) {
                this.status = this.status + "Application Reserved State; ";
            }
            if ((n3 & 8) != 0) {
                this.status = this.status + "Permanent Error; ";
            }
            if ((n3 & 0x10) != 0) {
                this.status = this.status + "Temporary Error; ";
            }
            this.status5 = (n3 & 0x20) != 0;
            this.status6 = (n3 & 0x40) != 0;
            this.status7 = (n3 & 0x80) != 0;
        }
        return n;
    }

    public final void decodeVariableDataBlocks(int[] nArray, int n, BMbusDevice bMbusDevice, boolean bl, boolean bl2) {
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" IN decodeVariableDataBlocks ");
        }
        int[] nArray2 = nArray;
        int n2 = n;
        boolean bl3 = true;
        this.manufacturersData = false;
        boolean bl4 = false;
        if (bMbusDevice == null) {
            bl4 = true;
        }
        while (bl3) {
            Object object;
            this.finishedAtIndex = this.decodeDataInformationBlock(nArray2, n2, bl4, bl2);
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace(" Returned from decodeDataInformationBlock ");
            }
            if (this.recordNumber > this.lastRecordNumber && bl) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("MBUSDECODEVARIABLEFRAME: recordNumber = " + this.recordNumber + "  and lastRecordNumber= " + this.lastRecordNumber);
                }
                if (this.device != null && this.recordNumber > this.device.getMaxInputsPerCycleCount()) {
                    this.device.setMaxInputsPerCycleCount(this.recordNumber);
                }
                this.lastRecordNumber = this.recordNumber;
                if (this.network != null) {
                    MbusReqUd2Message mbusReqUd2Message = new MbusReqUd2Message(this.device, this.network);
                    if (this.device != null) {
                        mbusReqUd2Message.setMessageBaudRate(this.device.getBaudRate());
                    } else {
                        mbusReqUd2Message.setMessageBaudRate(this.network.getSearchBaudRate());
                    }
                    object = null;
                    object = (MbusResponseMessage)this.network.sendSync(mbusReqUd2Message);
                    if (object != null && object.getSuccessfulResponse()) {
                        if (MbusLogInputOutput.log.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Input(Multiple Records):- " + ((MbusResponseMessage)((Object)object)).toDebugString());
                        }
                        byte[] byArray = ((MbusResponseMessage)((Object)object)).getBytes();
                        int[] nArray3 = new int[byArray.length];
                        if (byArray.length > 8) {
                            int n3 = 0;
                            while (n3 < byArray.length) {
                                nArray3[n3] = byArray[n3] & 0xFF;
                                ++n3;
                            }
                            n2 = this.decodeFixedDataHeader(nArray3);
                            nArray2 = nArray3;
                            continue;
                        }
                        bl3 = false;
                        continue;
                    }
                    bl3 = false;
                    continue;
                }
                bl3 = false;
                continue;
            }
            if (this.manufacturersIndex == -1 && !this.specialFunctionFound) {
                int n4 = 0;
                if (this.alreadyExists(this.description, this.orthogonalDescription, this.unitType, this.recordNumber, this.function, this.exponent)) {
                    n4 = this.inputSlot;
                }
                if (this.storageNumber == 1) {
                    n4 = 0;
                }
                object = new BMbusPointData();
                ((BMbusPointData)((Object)object)).setUnit(this.unitType);
                ((BMbusPointData)((Object)object)).setDescription(this.description);
                ((BMbusPointData)((Object)object)).setExponent(this.exponent);
                ((BMbusPointData)((Object)object)).setValue(this.value);
                ((BMbusPointData)((Object)object)).setStorageNumber(this.storageNumber);
                ((BMbusPointData)((Object)object)).setFunction(this.function);
                ((BMbusPointData)((Object)object)).setOrthogonalDescription(this.orthogonalDescription);
                ((BMbusPointData)((Object)object)).setRecordNumber(this.recordNumber);
                ((BMbusPointData)((Object)object)).setMessageSlotNumber(n4);
                if (this.description.equals(BMbusDescription.sizeOfStorageBlock.toString())) {
                    this.blockSize = (long)((BStatusNumeric)this.value).getValue();
                }
                if (this.description.equals(BMbusDescription.date.toString()) || this.description.equals(BMbusDescription.dateAndTime.toString()) || this.orthogonalDescription.equals((Object)BMbusOrthogonalDescription.startDate)) {
                    ((BMbusPointData)((Object)object)).setNumberType(BMbusNumberType.dateIp);
                } else if (this.value instanceof BStatusNumeric) {
                    ((BMbusPointData)((Object)object)).setNumberType(BMbusNumberType.numericIp);
                } else if (this.value instanceof BStatusBoolean) {
                    ((BMbusPointData)((Object)object)).setNumberType(BMbusNumberType.booleanIp);
                } else if (this.value instanceof BStatusEnum) {
                    ((BMbusPointData)((Object)object)).setNumberType(BMbusNumberType.enumIp);
                } else if (this.value instanceof BStatusString) {
                    ((BMbusPointData)((Object)object)).setNumberType(BMbusNumberType.stringIp);
                } else {
                    ((BMbusPointData)((Object)object)).setNumberType(BMbusNumberType.notKnown);
                }
                if (this.value.getStatus().equals((Object)BStatus.ok)) {
                    this.activedataInformation.add(object);
                    ++this.inputSlot;
                }
            }
            if (this.finishedAtIndex > nArray2.length - 3) {
                bl3 = false;
                continue;
            }
            n2 = this.finishedAtIndex;
        }
    }

    private final int decodeDataInformationBlock(int[] nArray, int n, boolean bl, boolean bl2) {
        String string;
        Object object;
        int n2;
        int n3;
        int n4;
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" IN decodeDataInformationBlock ");
        }
        int n5 = n;
        boolean bl3 = false;
        int n6 = nArray[n5];
        this.orthogonalDescription = BMbusOrthogonalDescription.none;
        this.description = "None";
        this.manufacturersIndex = -1;
        this.difeTariff = 0;
        this.difeUnit = 0;
        int n7 = 0;
        if (n6 == 15) {
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace(" Found Manufactures Data at " + (n + 1));
            }
            this.manufacturersIndex = n + 1;
            return nArray.length;
        }
        if (n6 == 31) {
            this.specialFunctionFound = true;
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace(" Found Special Functions  Data ");
            }
            ++this.recordNumber;
            return nArray.length;
        }
        this.specialFunctionFound = false;
        if ((n6 & 0x80) != 0) {
            bl3 = true;
        }
        this.storageNumber = (n6 & 0x40) != 0 ? 1 : 0;
        this.function = BMbusFunction.make(n6 >> 4 & 3);
        this.dataType = n6 & 0xF;
        int n8 = 0;
        int n9 = n5 + 1;
        int n10 = 0;
        int n11 = 1;
        while (bl3) {
            n10 = nArray[n9];
            if ((n10 & 0x80) == 0) {
                bl3 = false;
            }
            n4 = 0;
            if ((n10 & 0x40) != 0) {
                n4 = 1;
            }
            this.difeUnit |= (n4 <<= n7);
            ++n7;
            n3 = n10 >> 4 & 3;
            this.difeTariff = this.difeTariff << 2 | n3;
            long l = (long)(n10 & 0xF) << n11;
            n11 += 4;
            this.storageNumber = (int)((long)this.storageNumber | l) & Short.MAX_VALUE;
            ++n9;
            if (++n8 <= 9) continue;
            bl3 = false;
        }
        n3 = n4 = n9;
        n8 = 0;
        bl3 = false;
        int n12 = nArray[n4];
        int n13 = 0;
        int n14 = 0;
        if ((n12 & 0x80) != 0) {
            bl3 = true;
        }
        int n15 = n12 & 0x7F;
        if (bl3) {
            if (n12 == 253) {
                ++n14;
                n15 = nArray[++n3] & 0x7F;
                if ((nArray[n3] & 0x80) == 0) {
                    bl3 = false;
                }
                this.description = MbusExtendedVifConvertor.getDescription(n15).toString();
                this.unitType = MbusExtendedVifConvertor.getUnits(n15);
                this.exponent = MbusExtendedVifConvertor.getValueExponent(n15);
                ++n4;
            } else if (n12 == 251) {
                ++n14;
                n15 = nArray[++n3] & 0x7F;
                if ((nArray[n3] & 0x80) == 0) {
                    bl3 = false;
                }
                this.description = MbusExtendedIndicatorVifConvertor.getDescription(n15).toString();
                this.unitType = MbusExtendedIndicatorVifConvertor.getUnits(n15);
                this.exponent = MbusExtendedIndicatorVifConvertor.getValueExponent(n15);
                ++n4;
            } else if (n12 == 252) {
                n2 = nArray[n4 + 1];
                object = new char[n2];
                int n16 = 0;
                while (n16 < n2) {
                    object[n2 - n16 - 1] = (char)nArray[n16 + n4 + 2];
                    ++n16;
                }
                string = new String((char[])object);
                this.value = new BStatusString(string, BStatus.ok);
                n4 += nArray[n4 + 1];
                if ((nArray[n3] & 0x80) != 0) {
                    bl3 = true;
                }
                ++n4;
            } else if (n12 == 255) {
                ++n14;
                n15 = nArray[++n3] & 0x7F;
                if ((nArray[n3] & 0x80) == 0) {
                    bl3 = false;
                }
                this.description = "ManufacturerSpecific";
                this.orthogonalDescription = MbusEnhancedVifExtensionConvertor.getDescription(127, nArray[n3]);
                this.unitType = BMbusUnit.none;
                this.exponent = 0;
                ++n4;
            } else if (n12 < 251) {
                ++n14;
                this.description = MbusVifConvertor.getDescription(n15, false).toString();
                this.unitType = MbusVifConvertor.getUnits(n15, false);
                this.exponent = MbusVifConvertor.getValueExponent(n15);
                ++n4;
            }
            if (bl3) {
                n15 = nArray[++n3];
                if ((nArray[n3] & 0x80) == 0) {
                    bl3 = false;
                }
                if (n15 == 61) {
                    this.unitType = MbusVifConvertor.getUnits(n15, true);
                    this.description = MbusVifConvertor.getDescription(n15, true).toString();
                } else if ((n15 = nArray[n3++] & 0x7F) == 125) {
                    this.exponent += 3;
                } else if (n15 > 111 && n15 < 120) {
                    n2 = n15 & 7;
                    this.exponent = this.exponent + n2 - 6;
                } else if (n15 > 119 && n15 < 124) {
                    this.offset = (double)(n15 & 3) - (double)3;
                } else {
                    this.orthogonalDescription = n15 == 127 ? MbusEnhancedVifExtensionConvertor.getDescription(n15, nArray[n3]) : MbusEnhancedVifExtensionConvertor.getDescription(n15, 0);
                }
            }
        } else if (n15 < 123) {
            this.description = MbusVifConvertor.getDescription(n15, false).toString();
            this.unitType = MbusVifConvertor.getUnits(n15, false);
            this.exponent = MbusVifConvertor.getValueExponent(n15);
            if (n15 == 120) {
                this.fabricationNumber = MbusTextUtil.intToHexString((nArray[n4 + 4] & 0xF0) >> 4, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString(nArray[n4 + 4] & 0xF, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString((nArray[n4 + 3] & 0xF0) >> 4, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString(nArray[n4 + 3] & 0xF, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString((nArray[n4 + 2] & 0xF0) >> 4, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString(nArray[n4 + 2] & 0xF, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString((nArray[n4 + 1] & 0xF0) >> 4, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString(nArray[n4 + 1] & 0xF, 1);
            }
        } else if (n15 == 124) {
            char[] cArray = new char[nArray[n4 + 1]];
            int n17 = cArray.length;
            int n18 = 0;
            while (n18 < n17) {
                cArray[n17 - n18 - 1] = (char)nArray[n18 + n4 + 2];
                ++n18;
            }
            String string2 = new String(cArray) + "  ";
            n4 = n4 + nArray[n4 + 1] + 2;
            char[] cArray2 = new char[nArray[n4]];
            n17 = cArray2.length;
            ++n4;
            if (this.dataType == 13) {
                int n19 = 0;
                while (n19 < n17) {
                    cArray2[n17 - n19 - 1] = (char)nArray[n19 + n4];
                    ++n19;
                }
            } else {
                MbusDataDecoderIEC870.ValueData valueData = MbusDataDecoderIEC870.decode(n4 - 1, nArray, this.dataType, bl, bl2);
                String string3 = new String(valueData.getValue().toString());
                string2 = string2 + string3;
                this.value = new BStatusString(string2, BStatus.ok);
                return valueData.getIndex();
            }
            String string4 = new String(cArray2);
            string2 = string2 + string4;
            this.value = new BStatusString(string2, BStatus.ok);
            return n4 += n17;
        }
        n3 = n4 + 1;
        while (bl3) {
            n13 = nArray[n3];
            if (n13 == 255) {
                this.orthogonalDescription = MbusEnhancedVifExtensionConvertor.getDescription(127, nArray[n3 + 1]);
            }
            if ((n13 & 0x80) == 0) {
                bl3 = false;
            }
            ++n3;
            if (++n8 <= 9) continue;
            bl3 = false;
        }
        n2 = n3;
        if (this.description.equals(BMbusDescription.date.toString()) && this.dataType == 2) {
            this.dataType = 18;
        } else if (this.description.equals(BMbusDescription.dateAndTime.toString())) {
            if (this.dataType == 4) {
                this.dataType = 19;
            } else if (this.dataType == 3) {
                this.dataType = 21;
            } else if (this.dataType == 6) {
                this.dataType = 20;
            }
        }
        if (this.orthogonalDescription.equals((Object)BMbusOrthogonalDescription.startDate)) {
            this.dataType = this.dataType == 2 ? 18 : 19;
        }
        object = MbusDataDecoderIEC870.decode(n2, nArray, this.dataType, bl, bl2);
        this.value = ((MbusDataDecoderIEC870.ValueData)object).getValue();
        if (this.value instanceof BStatusNumeric) {
            string = (BStatusNumeric)this.value;
            this.value = new BStatusNumeric((string.getValue() + this.offset) * Math.pow(10.0, this.exponent), BStatus.ok);
        }
        if (this.difeTariff != 0) {
            this.description = this.description + " Tariff " + this.difeTariff;
        }
        if (this.difeUnit != 0) {
            this.description = this.description + " SubUnit " + this.difeUnit;
        }
        return ((MbusDataDecoderIEC870.ValueData)object).getIndex();
    }

    private final boolean alreadyExists(String string, BMbusOrthogonalDescription bMbusOrthogonalDescription, BMbusUnit bMbusUnit, int n, BMbusFunction bMbusFunction, int n2) {
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.activedataInformation.size()) {
            BMbusPointData bMbusPointData = (BMbusPointData)((Object)this.activedataInformation.get(n3));
            if (bMbusPointData.getUnit().equals((Object)bMbusUnit) && bMbusPointData.getDescription().equals(string) && bMbusPointData.getRecordNumber() == n && bMbusPointData.getFunction() == bMbusFunction && bMbusPointData.getOrthogonalDescription().equals((Object)bMbusOrthogonalDescription)) {
                bl = true;
                break;
            }
            ++n3;
        }
        return bl;
    }

    public final String getIdentNumber() {
        return this.identNumber;
    }

    public final String getSecondaryAddress() {
        return this.secondaryAddress;
    }

    public final String getManufacturer() {
        return this.manufacturer;
    }

    public final int getVersionNumber() {
        return this.versionNumber;
    }

    public final BMbusDeviceTypeId getDeviceTypeId() {
        return this.deviceTypeId;
    }

    public final int getAccess() {
        return this.access;
    }

    public final String getStatus() {
        return this.status;
    }

    public final boolean getStatusBit5() {
        return this.status5;
    }

    public final boolean getStatusBit6() {
        return this.status6;
    }

    public final boolean getStatusBit7() {
        return this.status7;
    }

    public final int getDifeUnit() {
        return this.difeUnit;
    }

    public final int getDifeTariff() {
        return this.difeTariff;
    }

    public final ArrayList getData() {
        return this.activedataInformation;
    }

    public final long getStorageBlockSize() {
        return this.blockSize;
    }

    public final long getStorageBlockDate() {
        return this.blockDate;
    }

    public final long getStorageBlockInterval() {
        return this.blockInterval;
    }

    public final int getManufacturersIndex() {
        return this.manufacturersIndex;
    }

    public final String getFabricationNumber() {
        return this.fabricationNumber;
    }

    private final /* synthetic */ void this() {
        this.identNumber = "";
        this.secondaryAddress = "";
        this.manufacturer = "No Manufacturer";
        this.fabricationNumber = "";
        this.versionNumber = 0;
        this.deviceTypeId = BMbusDeviceTypeId.other;
        this.difeUnit = 0;
        this.access = 0;
        this.status = "";
        this.storageNumber = 0;
        this.function = BMbusFunction.instantaneous;
        this.difeTariff = 0;
        this.dataType = 0;
        this.description = "None";
        this.orthogonalDescription = BMbusOrthogonalDescription.none;
        this.unitType = BMbusUnit.none;
        this.exponent = 0;
        this.offset = 0.0;
        this.vifStringFlag = false;
        this.status5 = false;
        this.status6 = false;
        this.status7 = false;
        this.vifString = "";
        this.value = new BStatusString("No Data", BStatus.ok);
        this.finishedAtIndex = 0;
        this.recordNumber = 1;
        this.lastRecordNumber = 1;
        this.device = null;
        this.network = null;
        this.inputSlot = 1;
        this.blockSize = 0L;
        this.blockDate = 0L;
        this.blockInterval = 0L;
        this.manufacturersData = false;
        this.manufacturersIndex = -1;
        this.specialFunctionFound = false;
        this.activedataInformation = new ArrayList();
    }

    public MbusDecodeVariableFrame(int[] nArray, BAbstractMbusNetwork bAbstractMbusNetwork, BMbusDevice bMbusDevice, boolean bl, boolean bl2) {
        this.this();
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" IN MbusDecodeVariableFrame ");
        }
        int n = 0;
        this.device = bMbusDevice;
        this.network = bAbstractMbusNetwork;
        if (this.device != null) {
            if (this.device.getHeaderType().equals((Object)BMbusHeaderTypes.zeroLength)) {
                nArray[6] = 120;
            } else if (this.device.getHeaderType().equals((Object)BMbusHeaderTypes.byte4)) {
                nArray[6] = 122;
            }
            if (this.device.getHeaderType().equals((Object)BMbusHeaderTypes.byte12)) {
                nArray[6] = 114;
            }
            if (this.device.getHeaderType().equals((Object)BMbusHeaderTypes.byte12Mode2)) {
                nArray[6] = 118;
            }
        }
        n = this.decodeFixedDataHeader(nArray);
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Returned from decodeFixedDataHeader ");
        }
        this.decodeVariableDataBlocks(nArray, n, bMbusDevice, bl, bl2);
    }
}

