/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.types.BMbusPrimaryAddressRange;
import com.tridium.mbus.types.BMbusSecondaryAddressFilters;
import com.tridium.mbus.ui.BDiscoveryModeSelectPane;
import com.tridium.mbus.ui.BMbusPrimaryAddressRangeFE;
import com.tridium.mbus.ui.BMbusSecondaryAddressFE;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.gx.BImage;
import javax.baja.sys.BObject;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class DiscoveryWizardModel
extends WizardModel
implements BDiscoveryModeSelectPane.DiscoveryModeListener {
    private static final BImage bannerImg = BImage.make((String)"module://icons/x32/wizard.png");
    private int step;
    private BWizardHeader banner;
    private BBorderPane bannerBorder;
    private BEdgePane bannerPane;
    private boolean finished;
    private boolean multipleRecords;
    private BMbusPrimaryAddressRange range;
    private BMbusPrimaryAddressRangeFE addressStep;
    private BDiscoveryModeSelectPane modeSelectPane;
    private BMbusSecondaryAddressFilters filters;
    private BMbusSecondaryAddressFE secondaryAddressInfo;

    public String getTitle() {
        return MbusToolkit.getText("DiscoveryWizard.title");
    }

    public void init() {
        this.modeSelectPane = new BDiscoveryModeSelectPane(this);
        this.addressStep.loadValue((BObject)this.range);
        this.secondaryAddressInfo.loadValue((BObject)this.filters);
        this.checkStep();
    }

    public void next() {
        ++this.step;
        this.checkStep();
    }

    public void back() {
        --this.step;
        this.checkStep();
    }

    public boolean finish() {
        boolean bl;
        block18: {
            bl = false;
            if (this.modeSelectPane.isAddressDiscover()) {
                block17: {
                    try {
                        this.addressStep.saveValue((BObject)this.range, null);
                        bl = true;
                    }
                    catch (Exception exception) {
                        try {
                            BDialog.error((BWidget)this.getWizard(), (String)"Error", (Object)exception.getMessage(), (Throwable)exception);
                        }
                        catch (Exception exception2) {
                            if (!MbusToolkit.isTraceOn()) break block17;
                            MbusToolkit.trace("Error attempting to show exception dialog", exception);
                        }
                    }
                }
                if (bl && BDialog.confirm((BWidget)this.getWizard(), (String)MbusToolkit.getText("DiscoveryWizard.DiscoveryWarning"), (Object)MbusToolkit.getText("DiscoveryWizard.TimeLength")) == 8) {
                    bl = false;
                }
            } else {
                if (this.modeSelectPane.isSecondaryDiscover()) {
                    try {
                        this.secondaryAddressInfo.saveValue((BObject)this.filters, null);
                        bl = true;
                    }
                    catch (Exception exception) {
                        try {
                            BDialog.error((BWidget)this.getWizard(), (String)"Error", (Object)exception.getMessage(), (Throwable)exception);
                            break block18;
                        }
                        catch (Exception exception3) {
                            if (MbusToolkit.isTraceOn()) {
                                MbusToolkit.trace("Error attempting to show exception dialog", exception);
                            }
                            break block18;
                        }
                    }
                }
                if (this.modeSelectPane.isSingleDeviceDiscover()) {
                    if (BDialog.open((BWidget)this.getWizard(), (String)MbusToolkit.getText("DiscoveryWizard.discovery"), (Object)MbusToolkit.getText("DiscoveryWizard.singleDisconnection"), (int)12) == 4) {
                        bl = true;
                    }
                } else if (this.modeSelectPane.isScanDeviceDatabaseDiscover() || this.modeSelectPane.isIdDiscover() || this.modeSelectPane.isSecondaryDiscover()) {
                    bl = true;
                }
            }
        }
        this.finished = bl;
        return bl;
    }

    private final void checkStep() {
        if (this.step == 1) {
            int n = this.modeSelectPane.isSingleDeviceDiscover() || this.modeSelectPane.isScanDeviceDatabaseDiscover() || this.modeSelectPane.isIdDiscover() ? 4 : 2;
            this.setBannerWidget((BWidget)this.modeSelectPane, MbusToolkit.getText("DiscoveryWizard.discoveryMode"), MbusToolkit.getText("DiscoveryWizard.discoveryModeSelect"), n);
        } else if (this.step == 2) {
            if (this.modeSelectPane.isSecondaryDiscover()) {
                this.setBannerWidget((BWidget)this.secondaryAddressInfo, MbusToolkit.getText("DiscoveryWizard.addressFiltersTitle"), MbusToolkit.getText("DiscoveryWizard.AddressFilterRequest"), 5);
            } else {
                this.setBannerWidget((BWidget)this.addressStep, MbusToolkit.getText("DiscoveryWizard.addressRange"), MbusToolkit.getText("DiscoveryWizard.deviceAddressRange"), 5);
            }
        }
    }

    private final void setBannerWidget(BWidget bWidget, String string, String string2, int n) {
        this.bannerBorder.setContent(bWidget);
        this.banner.setTitle(string);
        this.banner.setDescription(string2);
        this.update((BWidget)this.bannerPane, n);
    }

    public void modeChanged() {
        this.checkStep();
    }

    boolean isSingleDeviceDiscover() {
        return this.modeSelectPane.isSingleDeviceDiscover();
    }

    boolean isScanDeviceDatabaseDiscover() {
        return this.modeSelectPane.isScanDeviceDatabaseDiscover();
    }

    boolean isAddressDiscover() {
        return this.modeSelectPane.isAddressDiscover();
    }

    boolean isFinished() {
        return this.finished;
    }

    BMbusPrimaryAddressRange getRange() {
        return this.range;
    }

    boolean getMultipleRecords() {
        return this.multipleRecords;
    }

    boolean isIdDiscover() {
        return this.modeSelectPane.isIdDiscover();
    }

    boolean isSecondaryDiscover() {
        return this.modeSelectPane.isSecondaryDiscover();
    }

    BMbusSecondaryAddressFilters getFilters() {
        return this.filters;
    }

    private final /* synthetic */ void this() {
        this.step = 1;
        this.banner = new BWizardHeader(bannerImg, "", "");
        this.bannerBorder = new BBorderPane((BWidget)new BNullWidget(), 10.0, 10.0, 10.0, 10.0);
        this.bannerPane = new BEdgePane((BWidget)this.banner, null, null, null, (BWidget)this.bannerBorder);
        this.finished = false;
        this.multipleRecords = false;
        this.range = new BMbusPrimaryAddressRange();
        this.addressStep = new BMbusPrimaryAddressRangeFE();
        this.modeSelectPane = null;
        this.filters = new BMbusSecondaryAddressFilters();
        this.secondaryAddressInfo = new BMbusSecondaryAddressFE();
    }

    DiscoveryWizardModel() {
        this.this();
    }
}

