/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.types;

import com.tridium.mbus.utils.MbusTextUtil;
import com.tridium.mbus.utils.MbusToolkit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.io.BIEncodable;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BEncodableList
extends BSimple {
    public static final BEncodableList NULL;
    public static final BEncodableList DEFAULT;
    private static final char SEPARATOR = '|';
    public static final Type TYPE;
    private BIEncodable[] ens;
    private int hashCode;
    static /* synthetic */ Class class$com$tridium$mbus$types$BEncodableList;

    public static final BEncodableList make(BIEncodable[] bIEncodableArray) {
        if (bIEncodableArray == null) {
            return NULL;
        }
        return new BEncodableList((BIEncodable[])bIEncodableArray.clone());
    }

    public static final BEncodableList make(int[] nArray) {
        if (nArray == null) {
            return NULL;
        }
        BIEncodable[] bIEncodableArray = new BIEncodable[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            bIEncodableArray[n] = BInteger.make((int)nArray[n]);
            ++n;
        }
        return BEncodableList.make(bIEncodableArray);
    }

    public static final BEncodableList make(long[] lArray) {
        if (lArray == null) {
            return NULL;
        }
        BIEncodable[] bIEncodableArray = new BIEncodable[lArray.length];
        int n = 0;
        while (n < lArray.length) {
            bIEncodableArray[n] = BLong.make((long)lArray[n]);
            ++n;
        }
        return BEncodableList.make(bIEncodableArray);
    }

    public static final BEncodableList make(String[] stringArray) {
        if (stringArray == null) {
            return NULL;
        }
        BIEncodable[] bIEncodableArray = new BIEncodable[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            bIEncodableArray[n] = BString.make((String)stringArray[n]);
            ++n;
        }
        return BEncodableList.make(bIEncodableArray);
    }

    public static final BEncodableList make(double[] dArray) {
        if (dArray == null) {
            return NULL;
        }
        BIEncodable[] bIEncodableArray = new BIEncodable[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            bIEncodableArray[n] = BDouble.make((double)dArray[n]);
            ++n;
        }
        return BEncodableList.make(bIEncodableArray);
    }

    public static final BEncodableList make(float[] fArray) {
        if (fArray == null) {
            return NULL;
        }
        BIEncodable[] bIEncodableArray = new BIEncodable[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            bIEncodableArray[n] = BFloat.make((float)fArray[n]);
            ++n;
        }
        return BEncodableList.make(bIEncodableArray);
    }

    public final BIEncodable get(int n) {
        return this.ens[n];
    }

    public final int size() {
        return this.ens.length;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this.ens.length == 0) {
            bl = true;
        }
        return bl;
    }

    public final BIEncodable[] toArray() {
        return (BIEncodable[])this.ens.clone();
    }

    public final int[] toIntArray() {
        int[] nArray = new int[this.ens.length];
        int n = 0;
        while (n < this.ens.length) {
            nArray[n] = ((BInteger)this.ens[n]).getInt();
            ++n;
        }
        return nArray;
    }

    public final long[] toLongArray() {
        long[] lArray = new long[this.ens.length];
        int n = 0;
        while (n < this.ens.length) {
            lArray[n] = ((BLong)this.ens[n]).getLong();
            ++n;
        }
        return lArray;
    }

    public final String[] toStringArray() {
        String[] stringArray = new String[this.ens.length];
        int n = 0;
        while (n < this.ens.length) {
            stringArray[n] = ((BString)this.ens[n]).getString();
            ++n;
        }
        return stringArray;
    }

    public final double[] toDoubleArray() {
        double[] dArray = new double[this.ens.length];
        int n = 0;
        while (n < this.ens.length) {
            dArray[n] = ((BDouble)this.ens[n]).getDouble();
            ++n;
        }
        return dArray;
    }

    public final float[] toFloatArray() {
        float[] fArray = new float[this.ens.length];
        int n = 0;
        while (n < this.ens.length) {
            fArray[n] = ((BFloat)this.ens[n]).getFloat();
            ++n;
        }
        return fArray;
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            int n = 11;
            int n2 = 0;
            while (n2 < this.ens.length) {
                n ^= this.ens[n2].hashCode();
                ++n2;
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        if (object instanceof BIEncodable) {
            BIEncodable[] bIEncodableArray = this.ens;
            BIEncodable[] bIEncodableArray2 = ((BEncodableList)((Object)object)).ens;
            if (bIEncodableArray.length != bIEncodableArray2.length) {
                return false;
            }
            int n = 0;
            while (n < bIEncodableArray.length) {
                if (!bIEncodableArray[n].equals(bIEncodableArray2[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ens.length > 0) {
            try {
                stringBuffer.append(this.ens[0].getType().toString());
                int n = 0;
                while (n < this.ens.length) {
                    stringBuffer.append('|');
                    stringBuffer.append(this.ens[n].encodeToString());
                    ++n;
                }
            }
            catch (IOException iOException) {
                MbusToolkit.error("Error encoding encodables to string");
            }
        }
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) {
        if (string.length() <= 1) {
            return DEFAULT;
        }
        String[] stringArray = MbusTextUtil.splitAndTrim(string, '|');
        BIEncodable[] bIEncodableArray = new BIEncodable[stringArray.length - 1];
        try {
            BIEncodable bIEncodable = null;
            int n = 0;
            while (n < stringArray.length) {
                if (n == 0) {
                    bIEncodable = (BIEncodable)Sys.getType((String)stringArray[n]).getInstance();
                } else {
                    bIEncodableArray[n - 1] = (BIEncodable)bIEncodable.decodeFromString(stringArray[n]);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            MbusToolkit.error("Error parsing encodables", exception);
        }
        return new BEncodableList(bIEncodableArray);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ens = null;
        this.hashCode = 0;
    }

    private BEncodableList(BIEncodable[] bIEncodableArray) {
        this.this();
        this.ens = bIEncodableArray;
    }

    static {
        DEFAULT = NULL = new BEncodableList(new BIEncodable[0]);
        Class clazz = class$com$tridium$mbus$types$BEncodableList;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$types$BEncodableList = BEncodableList.class("[Lcom.tridium.mbus.types.BEncodableList;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

