/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusCommandCodes;
import com.tridium.mbus.enums.BMbusFunction;
import com.tridium.mbus.enums.BMbusNumberType;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.enums.BMbusVifCodes;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.mspec.BManuSpecDefElement;
import com.tridium.mbus.point.BMbusPointDeviceExt;
import com.tridium.mbus.point.BMbusPollGroup;
import com.tridium.mbus.utils.MbusDataDecoderIEC870;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusProxyExt
extends BBasicProxyExt {
    public static final Property mbusUnit = BMbusProxyExt.newProperty((int)0, (BValue)BMbusUnit.none, null);
    public static final Property description = BMbusProxyExt.newProperty((int)0, (String)"", null);
    public static final Property orthogonalDescription = BMbusProxyExt.newProperty((int)0, (BValue)BMbusOrthogonalDescription.none, null);
    public static final Property numberType = BMbusProxyExt.newProperty((int)0, (BValue)BMbusNumberType.notKnown, null);
    public static final Property messageSlotNumber = BMbusProxyExt.newProperty((int)0, (int)0, null);
    public static final Property recordNumber = BMbusProxyExt.newProperty((int)0, (int)0, null);
    public static final Property function = BMbusProxyExt.newProperty((int)0, (BValue)BMbusFunction.instantaneous, null);
    public static final Property cycleNumber = BMbusProxyExt.newProperty((int)4, (int)0, null);
    public static final Property storageNumber = BMbusProxyExt.newProperty((int)4, (int)0, null);
    public static final Property exponent = BMbusProxyExt.newProperty((int)0, (int)1, null);
    public static final Property manuSpecDefElementOrd = BMbusProxyExt.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"mbus:DualComponentOrdFE"), (String)"parentType", (BIDataValue)BString.make((String)"mbus:ManuSpecDef"), (String)"childType", (BIDataValue)BString.make((String)"mbus:ManuSpecDefElement")));
    public static final Property mbusDifCode = BMbusProxyExt.newProperty((int)4, (BValue)BMbusCommandCodes.none, null);
    public static final Property mbusVifCode = BMbusProxyExt.newProperty((int)4, (BValue)BMbusVifCodes.none, null);
    public static final Property deviceMode = BMbusProxyExt.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)2)));
    public static final Action loadManuSpecData = BMbusProxyExt.newAction((int)0, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$mbus$point$BMbusProxyExt;

    public final BMbusUnit getMbusUnit() {
        return (BMbusUnit)this.get(mbusUnit);
    }

    public final void setMbusUnit(BMbusUnit bMbusUnit) {
        this.set(mbusUnit, (BValue)bMbusUnit, null);
    }

    public final String getDescription() {
        return this.getString(description);
    }

    public final void setDescription(String string) {
        this.setString(description, string, null);
    }

    public final BMbusOrthogonalDescription getOrthogonalDescription() {
        return (BMbusOrthogonalDescription)this.get(orthogonalDescription);
    }

    public final void setOrthogonalDescription(BMbusOrthogonalDescription bMbusOrthogonalDescription) {
        this.set(orthogonalDescription, (BValue)bMbusOrthogonalDescription, null);
    }

    public final BMbusNumberType getNumberType() {
        return (BMbusNumberType)this.get(numberType);
    }

    public final void setNumberType(BMbusNumberType bMbusNumberType) {
        this.set(numberType, (BValue)bMbusNumberType, null);
    }

    public final int getMessageSlotNumber() {
        return this.getInt(messageSlotNumber);
    }

    public final void setMessageSlotNumber(int n) {
        this.setInt(messageSlotNumber, n, null);
    }

    public final int getRecordNumber() {
        return this.getInt(recordNumber);
    }

    public final void setRecordNumber(int n) {
        this.setInt(recordNumber, n, null);
    }

    public final BMbusFunction getFunction() {
        return (BMbusFunction)this.get(function);
    }

    public final void setFunction(BMbusFunction bMbusFunction) {
        this.set(function, (BValue)bMbusFunction, null);
    }

    public final int getCycleNumber() {
        return this.getInt(cycleNumber);
    }

    public final void setCycleNumber(int n) {
        this.setInt(cycleNumber, n, null);
    }

    public final int getStorageNumber() {
        return this.getInt(storageNumber);
    }

    public final void setStorageNumber(int n) {
        this.setInt(storageNumber, n, null);
    }

    public final int getExponent() {
        return this.getInt(exponent);
    }

    public final void setExponent(int n) {
        this.setInt(exponent, n, null);
    }

    public final BOrd getManuSpecDefElementOrd() {
        return (BOrd)this.get(manuSpecDefElementOrd);
    }

    public final void setManuSpecDefElementOrd(BOrd bOrd) {
        this.set(manuSpecDefElementOrd, (BValue)bOrd, null);
    }

    public final BMbusCommandCodes getMbusDifCode() {
        return (BMbusCommandCodes)this.get(mbusDifCode);
    }

    public final void setMbusDifCode(BMbusCommandCodes bMbusCommandCodes) {
        this.set(mbusDifCode, (BValue)bMbusCommandCodes, null);
    }

    public final BMbusVifCodes getMbusVifCode() {
        return (BMbusVifCodes)this.get(mbusVifCode);
    }

    public final void setMbusVifCode(BMbusVifCodes bMbusVifCodes) {
        this.set(mbusVifCode, (BValue)bMbusVifCodes, null);
    }

    public final int getDeviceMode() {
        return this.getInt(deviceMode);
    }

    public final void setDeviceMode(int n) {
        this.setInt(deviceMode, n, null);
    }

    public final void loadManuSpecData() {
        this.invoke(loadManuSpecData, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final BAbstractMbusNetwork getMbusNetwork() {
        return (BAbstractMbusNetwork)this.getNetwork();
    }

    public final BMbusDevice getMbusDevice() {
        return (BMbusDevice)this.getDevice();
    }

    public final BMbusPointDeviceExt getMbusPointDeviceExt() {
        return (BMbusPointDeviceExt)this.getDeviceExt();
    }

    public final void started() throws Exception {
        super.started();
        this.setFlags((Slot)deviceFacets, 4);
        if (this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)conversion, 4);
            this.setFlags((Slot)tuningPolicyName, 4);
            this.setFlags((Slot)mbusUnit, 4);
            this.setFlags((Slot)description, 4);
            this.setFlags((Slot)orthogonalDescription, 4);
            this.setFlags((Slot)numberType, 4);
            this.setFlags((Slot)messageSlotNumber, 4);
            this.setFlags((Slot)recordNumber, 4);
            this.setFlags((Slot)function, 4);
            this.setFlags((Slot)manuSpecDefElementOrd, 4);
            this.setFlags((Slot)mbusDifCode, 0);
            this.setFlags((Slot)mbusVifCode, 0);
            this.setFlags((Slot)writeValue, 0);
            this.setFlags((Slot)readValue, 4);
        } else {
            int n = 0;
            if (this.getExponent() < 0) {
                n = -this.getExponent();
            }
            BUnit bUnit = BMbusUnit.getNiagaraUnits(this.getMbusUnit());
            this.setDeviceFacets(BFacets.makeNumeric((BUnit)bUnit, (int)n));
            this.setFlags((Slot)conversion, 0);
            this.setFlags((Slot)tuningPolicyName, 0);
            this.setFlags((Slot)function, 1);
            this.setFlags((Slot)manuSpecDefElementOrd, 0);
            this.setFlags((Slot)mbusDifCode, 4);
            this.setFlags((Slot)mbusVifCode, 4);
            this.setFlags((Slot)writeValue, 4);
            this.setFlags((Slot)readValue, 0);
            BOrd bOrd = this.getManuSpecDefElementOrd();
            if (bOrd.isNull()) {
                this.setFlags((Slot)mbusUnit, 1);
                this.setFlags((Slot)description, 1);
                this.setFlags((Slot)orthogonalDescription, 1);
                this.setFlags((Slot)numberType, 1);
                this.setFlags((Slot)messageSlotNumber, 1);
                this.setFlags((Slot)recordNumber, 1);
                this.setFlags((Slot)function, 1);
            } else {
                this.setFlags((Slot)mbusUnit, 4);
                this.setFlags((Slot)description, 4);
                this.setFlags((Slot)orthogonalDescription, 4);
                this.setFlags((Slot)numberType, 4);
                this.setFlags((Slot)messageSlotNumber, 4);
                this.setFlags((Slot)recordNumber, 4);
            }
        }
        this.loadManuSpecData();
    }

    public final void changed(Property property, Context context) {
        if (this.isRunning() && property == manuSpecDefElementOrd) {
            this.loadManuSpecData();
        }
        super.changed(property, context);
    }

    public final void doLoadManuSpecData() throws Exception {
        BOrd bOrd = this.getManuSpecDefElementOrd();
        if (bOrd.isNull()) {
            if (this.getParentPoint().isWritablePoint()) {
                this.setFlags((Slot)mbusUnit, 4);
                this.setFlags((Slot)description, 4);
                this.setFlags((Slot)orthogonalDescription, 4);
                this.setFlags((Slot)numberType, 4);
                this.setFlags((Slot)messageSlotNumber, 4);
                this.setFlags((Slot)recordNumber, 4);
                this.setFlags((Slot)function, 4);
            } else {
                this.setFlags((Slot)mbusUnit, 1);
                this.setFlags((Slot)description, 1);
                this.setFlags((Slot)orthogonalDescription, 1);
                this.setFlags((Slot)numberType, 1);
                this.setFlags((Slot)messageSlotNumber, 1);
                this.setFlags((Slot)recordNumber, 1);
                this.setFlags((Slot)function, 1);
            }
            return;
        }
        this.setFlags((Slot)mbusUnit, 4);
        this.setFlags((Slot)description, 4);
        this.setFlags((Slot)orthogonalDescription, 4);
        this.setFlags((Slot)numberType, 4);
        this.setFlags((Slot)messageSlotNumber, 4);
        this.setFlags((Slot)recordNumber, 4);
        try {
            BManuSpecDefElement bManuSpecDefElement = (BManuSpecDefElement)bOrd.get((BObject)this.getMbusNetwork());
            if (bManuSpecDefElement == null) {
                this.readFail("Manufacturer Specific Data Ord not set up");
            }
        }
        catch (Exception exception) {
            this.readFail("Failed to resolve Manufacturer Specific Data");
        }
    }

    public final Type getDeviceExtType() {
        return BMbusPointDeviceExt.TYPE;
    }

    public final BReadWriteMode getMode() {
        return BReadWriteMode.readWrite;
    }

    public final Object getPollGroupCode() {
        BMbusDevice bMbusDevice = (BMbusDevice)this.getDevice();
        String string = new Integer(this.getDeviceMode() * 500).toString();
        if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.primary)) {
            return new Integer(bMbusDevice.getPrimaryAddress()).toString() + string;
        }
        if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.secondary)) {
            return bMbusDevice.getSecondaryAddress() + string;
        }
        return bMbusDevice.getSecondaryAddress() + bMbusDevice.getFabricationNumber() + string;
    }

    public final Type getPollGroupType() {
        return BMbusPollGroup.TYPE;
    }

    public final BPollFrequency getPollFrequency() {
        return this.getMbusDevice().getPollFrequency();
    }

    public final void doWrite(BStatusValue bStatusValue) {
        if (this.getParentPoint().isWritablePoint()) {
            byte[] byArray = MbusDataDecoderIEC870.encode(bStatusValue, this.getMbusDifCode());
            byte[] byArray2 = null;
            if (byArray != null) {
                if (this.getMbusDifCode().getOrdinal() > 14) {
                    byArray2 = byArray;
                } else {
                    byArray2 = new byte[byArray.length + 2];
                    int n = 0;
                    while (n < byArray.length) {
                        byArray2[n + 2] = byArray[n];
                        ++n;
                    }
                    byArray2[0] = (byte)this.getMbusDifCode().getOrdinal();
                    byArray2[1] = (byte)this.getMbusVifCode().getOrdinal();
                }
            }
            if (byArray != null && byArray2 != null) {
                BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusDevice().getMbusNetwork();
                MbusSndUdMessage mbusSndUdMessage = new MbusSndUdMessage(this.getMbusDevice(), bAbstractMbusNetwork, byArray2);
                bAbstractMbusNetwork.sendSync(mbusSndUdMessage);
                this.writeOk(bStatusValue);
            } else {
                this.writeFail("Incorrect MBusDifCode or MBusVifCode Selection");
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BMbusProxyExt() {
        this.setFlags((Slot)deviceFacets, 1);
    }

    static {
        Class clazz = class$com$tridium$mbus$point$BMbusProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$point$BMbusProxyExt = BMbusProxyExt.class("[Lcom.tridium.mbus.point.BMbusProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

