/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.point;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BBasicPollGroup;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusNumberType;
import com.tridium.mbus.enums.BMbusTestControl;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndNkeMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.mspec.BManuSpecDefElement;
import com.tridium.mbus.point.BMbusProxyExt;
import com.tridium.mbus.types.BMbusCommand;
import com.tridium.mbus.utils.MbusDataSort;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusSortedDataInformation;
import com.tridium.mbus.utils.MbusStringConvertor;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMbusPollGroup
extends BBasicPollGroup
implements BIBasicPollable {
    public static final Type TYPE;
    private static Lexicon lex;
    private static int[] manufacturersData;
    static /* synthetic */ Class class$com$tridium$mbus$point$BMbusPollGroup;
    static /* synthetic */ Class class$com$tridium$mbus$point$BMbusProxyExt;
    static /* synthetic */ Class class$com$tridium$mbus$types$BMbusCommand;

    public Type getType() {
        return TYPE;
    }

    public void poll() {
        Class clazz;
        BMbusCommand[] bMbusCommandArray;
        boolean bl = false;
        BBasicProxyExt[] bBasicProxyExtArray = this.getSubscribedProxyExts();
        if (bBasicProxyExtArray.length == 0) {
            return;
        }
        BAbstractMbusNetwork bAbstractMbusNetwork = (BAbstractMbusNetwork)bBasicProxyExtArray[0].getNetwork();
        BMbusDevice bMbusDevice = (BMbusDevice)bBasicProxyExtArray[0].getDevice();
        if (bMbusDevice.getAddressMode() != BMbusAddressing.primary) {
            bMbusCommandArray = new MbusSndUdMessage(bMbusDevice, bAbstractMbusNetwork, null);
            bAbstractMbusNetwork.sendSync((Message)bMbusCommandArray);
        }
        if (bMbusDevice.getResetRequired()) {
            bMbusCommandArray = new MbusSndNkeMessage(bMbusDevice, bAbstractMbusNetwork, 0);
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Poll Reset to Meter:- " + bMbusDevice.getPrimaryAddress() + "Sec Add= " + bMbusDevice.getSecondaryAddress());
            }
            bAbstractMbusNetwork.sendSync((Message)bMbusCommandArray);
            bMbusDevice.setFcBitState(true);
        }
        if ((clazz = class$com$tridium$mbus$types$BMbusCommand) == null) {
            clazz = class$com$tridium$mbus$types$BMbusCommand = BMbusPollGroup.class("[Lcom.tridium.mbus.types.BMbusCommand;", false);
        }
        bMbusCommandArray = (BMbusCommand[])bMbusDevice.getChildren(clazz);
        if (bBasicProxyExtArray.length > 0) {
            BMbusProxyExt bMbusProxyExt = (BMbusProxyExt)bBasicProxyExtArray[0];
            if (bMbusProxyExt.getDeviceMode() != bMbusDevice.getReadoutModeNumber()) {
                if (bMbusCommandArray.length > 0 && bMbusCommandArray[0].changeMode(bMbusProxyExt.getDeviceMode())) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        int n = 0;
        while (n < bMbusDevice.getCycleQuantity()) {
            Object object;
            Object object2;
            MbusReqUd2Message mbusReqUd2Message = new MbusReqUd2Message(bMbusDevice, bAbstractMbusNetwork);
            mbusReqUd2Message.setMessageBaudRate(bMbusDevice.getBaudRate());
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Poll to Meter:- " + bMbusDevice.getPrimaryAddress() + " ,Sec Add= " + bMbusDevice.getSecondaryAddress() + "  Cycle= " + n);
            }
            MbusResponseMessage mbusResponseMessage = null;
            if (bAbstractMbusNetwork.getTestMode() != BMbusTestControl.inactive) {
                mbusResponseMessage = new MbusResponseMessage(MbusStringConvertor.calc(bAbstractMbusNetwork.getTestString()));
                if (bAbstractMbusNetwork.getTestMode() == BMbusTestControl.oneShot) {
                    bAbstractMbusNetwork.setTestMode(BMbusTestControl.inactive);
                }
            } else {
                mbusResponseMessage = (MbusResponseMessage)bAbstractMbusNetwork.sendSync(mbusReqUd2Message);
            }
            if (mbusResponseMessage == null) {
                object2 = lex.getText("BMbusPollGroup.readNull");
                int n2 = 0;
                while (n2 < bBasicProxyExtArray.length) {
                    bBasicProxyExtArray[n2].readFail((String)object2);
                    ++n2;
                }
                bMbusDevice.pingFail("timeout");
                return;
            }
            if (!mbusResponseMessage.getSuccessfulResponse()) {
                int n3 = 0;
                while (n3 < bBasicProxyExtArray.length) {
                    object = lex.getText("BMbusPollGroup.pollError");
                    bBasicProxyExtArray[n3].readFail((String)object);
                    ++n3;
                }
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("POLL_GRP: read fail");
                }
                return;
            }
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("BMBUSPOLLGROUP: We have valid message");
            }
            if (((Object)(object2 = (Object)mbusResponseMessage.getBytes())).length > 8) {
                int n4;
                int n5;
                object = null;
                object = new MbusReceivedLongFrame(mbusResponseMessage, bAbstractMbusNetwork, bMbusDevice, bMbusDevice.getAllowMultipleRecords());
                boolean bl2 = false;
                if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.primary)) {
                    if (bMbusDevice.getPrimaryAddress() != ((MbusReceivedLongFrame)((Object)object)).getPrimaryAddress()) {
                        bl2 = true;
                    }
                } else if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.secondary)) {
                    if (!bMbusDevice.getSecondaryAddress().equals(((MbusReceivedLongFrame)((Object)object)).getSecondaryAddress())) {
                        bl2 = true;
                    }
                } else if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.secondaryExtended) && !bMbusDevice.getSecondaryAddress().equals(((MbusReceivedLongFrame)((Object)object)).getSecondaryAddress())) {
                    bl2 = true;
                }
                bMbusDevice.setMbusMeterStatusDescription(((MbusReceivedLongFrame)((Object)object)).getStatus());
                bMbusDevice.setManufacturerStatusBit5(((MbusReceivedLongFrame)((Object)object)).getStatusBit5());
                bMbusDevice.setManufacturerStatusBit6(((MbusReceivedLongFrame)((Object)object)).getStatusBit6());
                bMbusDevice.setManufacturerStatusBit7(((MbusReceivedLongFrame)((Object)object)).getStatusBit7());
                if (bl2) {
                    n5 = 0;
                    while (n5 < bBasicProxyExtArray.length) {
                        String string = lex.getText("BMbusPollGroup.AddressError");
                        bBasicProxyExtArray[n5].readFail(string);
                        ++n5;
                    }
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace("Response Message: Wrong Meter!");
                    }
                    return;
                }
                bAbstractMbusNetwork.getNetworkDatabase().addDeviceData((MbusReceivedLongFrame)((Object)object), n, bMbusDevice.getBaudRate(), bMbusDevice, bMbusDevice.getAddressMode());
                if (!((MbusReceivedLongFrame)((Object)object)).getFabricationNumber().equals("")) {
                    bMbusDevice.setFabricationNumber(((MbusReceivedLongFrame)((Object)object)).getFabricationNumber());
                }
                if (((MbusReceivedLongFrame)((Object)object)).getManufacturerIndex() != -1) {
                    n5 = ((MbusReceivedLongFrame)((Object)object)).getManufacturerIndex();
                    n4 = ((Object)object2).length - n5 - 2;
                    manufacturersData = new int[n4];
                    int n6 = 0;
                    while (n6 < n4) {
                        BMbusPollGroup.manufacturersData[n6] = (int)object2[n5 + n6];
                        ++n6;
                    }
                }
                n5 = 0;
                while (n5 < bBasicProxyExtArray.length) {
                    BAbsTime bAbsTime;
                    n4 = 0;
                    BMbusProxyExt bMbusProxyExt = (BMbusProxyExt)bBasicProxyExtArray[n5];
                    BStatusValue bStatusValue = bMbusProxyExt.getReadValue();
                    if (bMbusProxyExt.getDeviceMode() != bMbusDevice.getReadoutModeNumber()) {
                        bl = false;
                    }
                    BStatusValue bStatusValue2 = null;
                    if (bMbusProxyExt.getManuSpecDefElementOrd().isNull()) {
                        bAbsTime = MbusDataSort.sort((MbusReceivedLongFrame)((Object)object), bMbusProxyExt.getMbusUnit(), bMbusProxyExt.getDescription(), bMbusProxyExt.getOrthogonalDescription(), bMbusProxyExt.getMessageSlotNumber(), bMbusProxyExt.getRecordNumber(), bMbusProxyExt.getStorageNumber(), bMbusProxyExt.getFunction(), bMbusProxyExt.getExponent(), true);
                        if (bAbsTime != null && ((MbusSortedDataInformation[])bAbsTime).length > 0) {
                            bStatusValue2 = bAbsTime[((MbusSortedDataInformation[])bAbsTime).length - 1].value;
                        }
                    } else {
                        bStatusValue2 = ((BManuSpecDefElement)bMbusProxyExt.getManuSpecDefElementOrd().get((BObject)bAbstractMbusNetwork)).getValue(manufacturersData);
                    }
                    if (bStatusValue2 != null && bl) {
                        BStatusString bStatusString;
                        if (bStatusValue2 instanceof BStatusString) {
                            bMbusProxyExt.readOk(bStatusValue2);
                            n4 = 1;
                        } else if (bStatusValue instanceof BStatusString) {
                            if (bStatusValue2 instanceof BStatusNumeric) {
                                if (bMbusProxyExt.getNumberType().equals((Object)BMbusNumberType.dateIp)) {
                                    bAbsTime = BAbsTime.make((long)((long)((BStatusNumeric)bStatusValue2).getValue()));
                                    bStatusString = new BStatusString(bAbsTime.encodeToString(), BStatus.ok);
                                    bMbusProxyExt.readOk((BStatusValue)bStatusString);
                                    n4 = 1;
                                } else {
                                    bMbusProxyExt.readFail("Input was Numeric and expected a String");
                                    n4 = 1;
                                }
                            } else {
                                bMbusProxyExt.readFail("Input was Numeric and expected a String");
                                n4 = 1;
                            }
                        } else if (bStatusValue instanceof BStatusNumeric && bStatusValue2 instanceof BStatusNumeric || bStatusValue instanceof BStatusEnum && bStatusValue2 instanceof BStatusEnum || bStatusValue instanceof BStatusBoolean && bStatusValue2 instanceof BStatusBoolean) {
                            if (bStatusValue2 instanceof BStatusNumeric) {
                                if (bMbusProxyExt.getNumberType().equals((Object)BMbusNumberType.dateIp)) {
                                    bAbsTime = BAbsTime.make((long)((long)((BStatusNumeric)bStatusValue2).getValue()));
                                    bStatusString = new BStatusString(bAbsTime.encodeToString(), BStatus.ok);
                                    bMbusProxyExt.readOk((BStatusValue)bStatusString);
                                    n4 = 1;
                                } else {
                                    bMbusProxyExt.readOk(bStatusValue2);
                                    n4 = 1;
                                }
                            } else {
                                bMbusProxyExt.readOk(bStatusValue2);
                                n4 = 1;
                            }
                        } else {
                            bMbusProxyExt.readFail("Input was incorrect type");
                        }
                    }
                    bStatusValue.setStatus(16);
                    if (n4 == 0 || !bl) {
                        bMbusProxyExt.readOk(bStatusValue);
                    }
                    ++n5;
                }
            }
            ++n;
        }
    }

    public BPollFrequency getPollFrequency() {
        BBasicProxyExt[] bBasicProxyExtArray = this.getSubscribedProxyExts();
        if (bBasicProxyExtArray.length == 0) {
            return BPollFrequency.normal;
        }
        BMbusDevice bMbusDevice = (BMbusDevice)bBasicProxyExtArray[0].getDevice();
        return bMbusDevice.getPollFrequency();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$mbus$point$BMbusPollGroup;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$point$BMbusPollGroup = BMbusPollGroup.class("[Lcom.tridium.mbus.point.BMbusPollGroup;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$mbus$point$BMbusProxyExt;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$mbus$point$BMbusProxyExt = BMbusPollGroup.class("[Lcom.tridium.mbus.point.BMbusProxyExt;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        manufacturersData = null;
    }
}

