/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.messages;

import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.mbus.messages.MbusReceivedMessage;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MbusResponseMessage
extends ReceivedMessage {
    private byte[] data;

    public byte[] getBytes() {
        return this.data;
    }

    public int getLength() {
        return this.data.length;
    }

    public String toDebugString() {
        return ByteArrayUtil.toHexString((byte[])this.data, (int)0, (int)this.data.length);
    }

    public int getChecksum() {
        return this.data[this.data.length - 2] & 0xFF;
    }

    public int getPrimaryAddress() {
        if (this.data == null) {
            return 0;
        }
        if (this.data.length == 5) {
            return this.data[2] & 0xFF;
        }
        if (this.data.length > 5) {
            return this.data[5] & 0xFF;
        }
        return 0;
    }

    public void setBytes(byte[] byArray) {
        this.data = byArray;
    }

    private final boolean validate() {
        if (this.getSuccessfulResponse()) {
            return true;
        }
        if (MbusToolkit.getLog().isTraceOn()) {
            MbusToolkit.trace("Response Message: read/write fail, null response");
        }
        return false;
    }

    private final /* synthetic */ void this() {
        this.data = null;
    }

    public MbusResponseMessage() {
        this.this();
        this.setSuccessfulResponse(false);
    }

    public MbusResponseMessage(byte[] byArray) {
        this.this();
        this.data = byArray;
        this.setSuccessfulResponse(true);
    }

    public MbusResponseMessage(int[] nArray) {
        this.this();
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        this.data = byArray;
        this.setSuccessfulResponse(true);
    }

    public MbusResponseMessage(MbusReceivedMessage mbusReceivedMessage) {
        this.this();
        this.setBytes(mbusReceivedMessage.getBytes());
        this.setSuccessfulResponse(mbusReceivedMessage.getSuccessfulResponse());
        if (this.data.length > 4) {
            this.setSuccessfulResponse(this.validate());
        }
    }
}

