/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.messages;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.messages.MbusMessage;
import com.tridium.mbus.utils.MbusTextUtil;

public final class MbusReqUd1Message
extends MbusMessage {
    public MbusReqUd1Message(BMbusDevice bMbusDevice, BAbstractMbusNetwork bAbstractMbusNetwork) {
        this.setCFieldNoFcb(74);
        this.setFcBitInUse(false);
        this.setFcBitState(false);
        if (bMbusDevice != null) {
            if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.primary)) {
                if (bMbusDevice.getFcBitInUse()) {
                    this.setFcBitInUse(true);
                    this.setFcBitState(bMbusDevice.getFcBitState());
                    bMbusDevice.setFcBitState(bMbusDevice.getFcBitState() ^ true);
                }
                this.setAField(bMbusDevice.getPrimaryAddress());
            } else {
                this.setStartCode(104);
                this.setFrame(2);
                this.setAField(253);
                this.setCiField(82);
                String string = bMbusDevice.getSecondaryAddress().trim();
                if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.secondaryExtended)) {
                    string = bMbusDevice.getFabricationNumber() + "780C" + string;
                }
                byte[] byArray = new byte[string.length() / 2];
                int n = 0;
                while (n < byArray.length) {
                    byArray[byArray.length - n - 1] = (byte)(MbusTextUtil.hexCharToInt(string.charAt(n * 2)) << 4 | MbusTextUtil.hexCharToInt(string.charAt(n * 2 + 1)));
                    ++n;
                }
                this.setBytes(byArray);
                if (bAbstractMbusNetwork.getSearchFcBitInUse()) {
                    this.setFcBitInUse(true);
                    this.setFcBitState(bAbstractMbusNetwork.getSearchFcBitState());
                    bAbstractMbusNetwork.setSearchFcBitState(bAbstractMbusNetwork.getSearchFcBitState() ^ true);
                }
            }
        } else if (bAbstractMbusNetwork != null) {
            this.setAField(bAbstractMbusNetwork.getPrimarySearchAddress());
            if (bAbstractMbusNetwork.getSearchFcBitInUse()) {
                this.setFcBitInUse(true);
                this.setFcBitState(bAbstractMbusNetwork.getSearchFcBitState());
                bAbstractMbusNetwork.setSearchFcBitState(bAbstractMbusNetwork.getSearchFcBitState() ^ true);
            }
        }
    }

    public MbusReqUd1Message(int n) {
        this.setCFieldNoFcb(74);
        this.setFcBitInUse(true);
        this.setAField(n);
    }

    public MbusReqUd1Message(int n, long l, BAbstractMbusNetwork bAbstractMbusNetwork) {
        this.setCFieldNoFcb(74);
        if (l == 0L) {
            this.setAField(n);
        } else {
            this.setStartCode(104);
            this.setFrame(2);
            this.setAField(253);
            this.setCiField(82);
            byte[] byArray = new byte[8];
            byArray[7] = (byte)(l & 0xFFL);
            byArray[6] = (byte)(l >> 8 & 0xFFL);
            byArray[5] = (byte)(l >> 16 & 0xFFL);
            byArray[4] = (byte)(l >> 24 & 0xFFL);
            byArray[3] = (byte)(l >> 32 & 0xFFL);
            byArray[2] = (byte)(l >> 40 & 0xFFL);
            byArray[1] = (byte)(l >> 48 & 0xFFL);
            byArray[0] = (byte)(l >> 56 & 0xFFL);
            this.setBytes(byArray);
        }
        if (bAbstractMbusNetwork != null && bAbstractMbusNetwork.getSearchFcBitInUse()) {
            this.setFcBitInUse(true);
            this.setFcBitState(bAbstractMbusNetwork.getSearchFcBitState());
            bAbstractMbusNetwork.setSearchFcBitState(bAbstractMbusNetwork.getSearchFcBitState() ^ true);
        }
    }
}

