/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.messages;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.messages.MbusMessage;
import com.tridium.mbus.utils.MbusTextUtil;

public final class MbusReqSkeMessage
extends MbusMessage {
    public MbusReqSkeMessage(BMbusDevice bMbusDevice, BAbstractMbusNetwork bAbstractMbusNetwork) {
        this.setCFieldNoFcb(73);
        this.setFcBitInUse(false);
        this.setFcBitState(false);
        if (bMbusDevice != null) {
            bMbusDevice.setFcBitState(false);
            this.setMessageBaudRate(bMbusDevice.getBaudRate());
            this.setAField(bMbusDevice.getPrimaryAddress());
            if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.primary)) {
                this.setAField(bMbusDevice.getPrimaryAddress());
                bAbstractMbusNetwork.setSearchFcBitState(false);
            } else {
                this.setStartCode(104);
                this.setFrame(2);
                this.setAField(253);
                this.setCiField(82);
                String string = bMbusDevice.getSecondaryAddress().trim();
                if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.secondaryExtended)) {
                    string = bMbusDevice.getFabricationNumber() + "780C" + string;
                }
                byte[] byArray = new byte[string.length() / 2];
                int n = 0;
                while (n < byArray.length) {
                    byArray[byArray.length - n - 1] = (byte)(MbusTextUtil.hexCharToInt(string.charAt(n * 2)) << 4 | MbusTextUtil.hexCharToInt(string.charAt(n * 2 + 1)));
                    ++n;
                }
                this.setBytes(byArray);
            }
        }
    }
}

