/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.messages.MbusReceivedMessage;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.utils.MbusCrcGenerator;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusToolkit;
import java.io.OutputStream;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class MbusMessage
extends Message {
    protected byte[] outputData;
    protected byte[] data;
    int startCode;
    int cField;
    int ciField;
    int aField;
    int chksum;
    int stop;
    boolean fcBitInUse;
    boolean fcBitState;
    int startCodeIndex;
    int cFieldIndex;
    int aFieldIndex;
    int chkSumIndex;
    int stopIndex;
    int ciFieldIndex;
    int lFieldIndex;
    BMbusBaudRate baudRate;
    int frame;
    String secondaryAdd;

    public Message toResponse(ReceivedMessage receivedMessage) {
        MbusResponseMessage mbusResponseMessage = new MbusResponseMessage((MbusReceivedMessage)receivedMessage);
        return mbusResponseMessage;
    }

    public String toDebugString() {
        if (this.data != null) {
            return ByteArrayUtil.toHexString((byte[])this.data, (int)0, (int)this.data.length);
        }
        return "";
    }

    public byte[] getBytes() {
        return this.outputData;
    }

    public void setBytes(byte[] byArray) {
        this.data = byArray;
    }

    public int getLength() {
        return this.data.length;
    }

    public void setAField(int n) {
        this.aField = n;
    }

    public int getAField() {
        return this.aField;
    }

    public void setSecondaryAdd(String string) {
        this.secondaryAdd = string;
    }

    public String getSecondaryAdd() {
        return this.secondaryAdd;
    }

    public void setCFieldNoFcb(int n) {
        this.cField = n;
    }

    public void setCiField(int n) {
        this.ciField = n;
    }

    public int getCField() {
        return this.cField;
    }

    public boolean getFcBitInUse() {
        return this.fcBitInUse;
    }

    public void setFcBitInUse(boolean bl) {
        this.fcBitInUse = bl;
    }

    public boolean getFcBitState() {
        return this.fcBitState;
    }

    public void setFcBitState(boolean bl) {
        this.fcBitState = bl;
    }

    public void setMessageBaudRate(BMbusBaudRate bMbusBaudRate) {
        this.baudRate = bMbusBaudRate;
    }

    public BMbusBaudRate getMessageBaudRate() {
        return this.baudRate;
    }

    public void setFrame(int n) {
        this.frame = n;
    }

    public void setStartCode(int n) {
        this.startCode = n;
    }

    public void write(OutputStream outputStream) {
        try {
            int n = 0;
            int n2 = 0;
            if (this.fcBitInUse) {
                n2 = 16;
                if (this.fcBitState) {
                    n = 32;
                }
            }
            if (this.frame == 0) {
                this.outputData = new byte[5];
                this.outputData[0] = 16;
                this.outputData[1] = (byte)(this.cField | n | n2);
                this.outputData[2] = (byte)this.aField;
            } else if (this.frame == 1) {
                this.outputData = new byte[9];
                this.outputData[0] = 104;
                this.outputData[1] = 3;
                this.outputData[2] = 3;
                this.outputData[3] = 104;
                this.outputData[4] = (byte)(this.cField | n | n2);
                this.outputData[5] = (byte)this.aField;
                this.outputData[6] = (byte)this.ciField;
            } else if (this.frame == 2) {
                int n3 = 9 + this.data.length;
                this.outputData = new byte[n3];
                this.outputData[0] = 104;
                this.outputData[1] = (byte)(this.outputData.length - 6);
                this.outputData[2] = (byte)(this.outputData.length - 6);
                this.outputData[3] = 104;
                this.outputData[4] = (byte)(this.cField | n | n2);
                this.outputData[5] = (byte)this.aField;
                this.outputData[6] = (byte)this.ciField;
                int n4 = 0;
                while (n4 < this.data.length) {
                    this.outputData[n4 + 7] = this.data[n4];
                    ++n4;
                }
            } else {
                return;
            }
            this.outputData[this.outputData.length - 2] = MbusCrcGenerator.mBus(this.outputData);
            this.outputData[this.outputData.length - 1] = 22;
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Output Message = " + ByteArrayUtil.toHexString((byte[])this.outputData, (int)0, (int)this.outputData.length));
            }
            outputStream.write(this.outputData);
        }
        catch (Exception exception) {
            MbusToolkit.error("Error writing bytes to output stream", exception);
        }
    }

    private final /* synthetic */ void this() {
        this.outputData = new byte[5];
        this.data = null;
        this.startCode = 16;
        this.cField = 0;
        this.ciField = 81;
        this.aField = 0;
        this.chksum = 0;
        this.stop = 22;
        this.fcBitInUse = false;
        this.fcBitState = false;
        this.startCodeIndex = 0;
        this.cFieldIndex = 1;
        this.aFieldIndex = 2;
        this.chkSumIndex = 3;
        this.stopIndex = 4;
        this.ciFieldIndex = 0;
        this.lFieldIndex = 0;
        this.baudRate = BMbusBaudRate.baud2400;
        this.frame = 0;
        this.secondaryAdd = "";
    }

    public MbusMessage() {
        this.this();
        this.setResponseExpected(true);
    }
}

