/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.basicdriver.message.Message;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.db.BMbusDeviceData;
import com.tridium.mbus.db.BMbusNetworkDatabase;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.learn.BMbusDeviceEntry;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.types.BMbusSecondaryAddressFilters;
import com.tridium.mbus.utils.MbusToolkit;
import java.util.Date;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusSecondarySearchJob
extends BSimpleJob {
    public static final Property networkOrd = BMbusSecondarySearchJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Type TYPE;
    private BAbstractMbusNetwork network;
    private BMbusNetworkDatabase networkManager;
    private boolean identSearchOnly;
    private BMbusSecondaryAddressFilters filters;
    private boolean cancelInProgress;
    static /* synthetic */ Class class$com$tridium$mbus$jobs$BMbusSecondarySearchJob;

    public final BOrd getNetworkOrd() {
        return (BOrd)this.get(networkOrd);
    }

    public final void setNetworkOrd(BOrd bOrd) {
        this.set(networkOrd, (BValue)bOrd, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void run(Context context) throws Exception {
        if (this.networkManager != null) {
            this.networkManager.clearJustDetected();
            if (this.identSearchOnly) {
                this.doSecondarySearch(null);
            } else {
                this.doSecondarySearch(this.filters);
            }
        }
    }

    private final void doSecondarySearch(BMbusSecondaryAddressFilters bMbusSecondaryAddressFilters) {
        Object object;
        this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.identSearchStarted"));
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        byte[] byArray = new byte[]{-1, -1};
        if (bMbusSecondaryAddressFilters != null) {
            String string = bMbusSecondaryAddressFilters.getManufacturer();
            if (string.length() == 3) {
                n = (string.charAt(0) - 64) * 32 * 32 + (string.charAt(1) - 64) * 32 + (string.charAt(2) - 64);
                byArray[0] = (byte)(n & 0xFF);
                byArray[1] = (byte)(n >> 8 & 0xFF);
            }
            n3 = (byte)bMbusSecondaryAddressFilters.getDeviceTypeId().getOrdinal();
            if (bMbusSecondaryAddressFilters.getVersionNumber() != 0) {
                n2 = (byte)bMbusSecondaryAddressFilters.getVersionNumber();
            }
        }
        int n4 = 0;
        int[] nArray = new int[8];
        boolean bl = true;
        byte[] byArray2 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        byArray2[4] = byArray[0];
        byArray2[5] = byArray[1];
        byArray2[6] = n2;
        byArray2[7] = n3;
        long l = (long)((byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF) & 0xFFFFFFFFL;
        long l2 = 0L;
        long l3 = 0L;
        boolean bl2 = false;
        int n5 = 2;
        while (bl) {
            if (!bl2) {
                int n6 = n4 + 1;
                while (n6 < nArray.length) {
                    nArray[n6] = 15;
                    ++n6;
                }
            }
            this.progress(n5);
            if (++n5 > 99) {
                n5 = 99;
            }
            byArray2[0] = (byte)(nArray[0] << 4 | nArray[1]);
            byArray2[1] = (byte)(nArray[2] << 4 | nArray[3]);
            byArray2[2] = (byte)(nArray[4] << 4 | nArray[5]);
            byArray2[3] = (byte)(nArray[6] << 4 | nArray[7]);
            l2 = (long)(byArray2[0] & 0xFF) << 56 | (long)(byArray2[1] & 0xFF) << 48 | (long)(byArray2[2] & 0xFF) << 40 | (long)(byArray2[3] & 0xFF) << 32 | l;
            object = new MbusSndUdMessage(byArray2);
            MbusResponseMessage mbusResponseMessage = (MbusResponseMessage)this.network.sendSync((Message)object);
            if (l3 == l2) {
                bl = false;
            }
            l3 = l2;
            if (mbusResponseMessage != null && mbusResponseMessage.getSuccessfulResponse()) {
                int n7 = this.getAllTheData();
                if (n7 > 0) {
                    int n8 = n4;
                    nArray[n8] = nArray[n8] + 1;
                    if (nArray[n4] < 10) {
                        bl2 = false;
                        continue;
                    }
                    bl2 = true;
                    if (n4 > 0) {
                        int n9 = --n4;
                        nArray[n9] = nArray[n9] + 1;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (n4 >= nArray.length - 1) continue;
                nArray[++n4] = 0;
                continue;
            }
            int n10 = n4;
            nArray[n10] = nArray[n10] + 1;
            bl2 = false;
            if (nArray[n4] < 10) {
                bl2 = false;
                continue;
            }
            bl2 = true;
            if (n4 > 0) {
                int n11 = --n4;
                nArray[n11] = nArray[n11] + 1;
                continue;
            }
            bl = false;
        }
        this.progress(100);
        object = this.network.getNetworkDatabase().getDynamicDeviceData();
        int n12 = 0;
        while (n12 < ((BMbusDeviceData[])object).length) {
            BMbusDeviceData bMbusDeviceData = object[n12];
            if (bMbusDeviceData.getJustDetected()) {
                BMbusDeviceEntry bMbusDeviceEntry = new BMbusDeviceEntry();
                bMbusDeviceEntry.setPrimaryAddress(bMbusDeviceData.getPrimaryAddress());
                bMbusDeviceEntry.setSecondaryAddress(bMbusDeviceData.getSecondaryAddress());
                bMbusDeviceEntry.setIdentNumber(bMbusDeviceData.getIdentNumber());
                bMbusDeviceEntry.setManufacturer(bMbusDeviceData.getManufacturer());
                bMbusDeviceEntry.setVersionNumber(bMbusDeviceData.getVersionNumber());
                bMbusDeviceEntry.setDeviceTypeId(bMbusDeviceData.getDeviceTypeId());
                bMbusDeviceEntry.setBaudRate(bMbusDeviceData.getBaudRate());
                bMbusDeviceEntry.setFcBitInUse(bMbusDeviceData.getFcBitInUse());
                bMbusDeviceEntry.setFcBitState(bMbusDeviceData.getFcBitState());
                bMbusDeviceEntry.setAddressMode(bMbusDeviceData.getAddressMode());
                this.add(null, (BValue)bMbusDeviceEntry);
            }
            double d = (double)n12 / (double)((BMbusDeviceData[])object).length;
            int n13 = (int)(d * 100.0);
            this.progress(n13);
            ++n12;
        }
        this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.secondarySearchFinished"));
    }

    private final int getAllTheData() {
        MbusReceivedLongFrame mbusReceivedLongFrame = null;
        MbusResponseMessage mbusResponseMessage = null;
        int n = 0;
        boolean bl = true;
        MbusReqUd2Message mbusReqUd2Message = new MbusReqUd2Message(253, this.network);
        mbusReqUd2Message.setFcBitState(bl);
        int n2 = 0;
        if (!this.getCancelInProgress()) {
            if (bl) {
                this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.RecvdDataTypeFCBS"));
            } else {
                this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.RecvdDataTypeNoFCBS"));
            }
            mbusResponseMessage = (MbusResponseMessage)this.network.sendSync(mbusReqUd2Message);
            if (mbusResponseMessage != null && mbusResponseMessage.getSuccessfulResponse() && mbusResponseMessage.getLength() > 10) {
                mbusReceivedLongFrame = new MbusReceivedLongFrame(mbusResponseMessage, this.network, null, true);
                n += this.networkManager.addDeviceData(mbusReceivedLongFrame, 0, this.network.getSearchBaudRate(), null, BMbusAddressing.secondary);
                ++n2;
            }
            bl ^= true;
            this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.searchCompleted"));
        }
        return n2;
    }

    public final void success() {
        if (!this.cancelInProgress) {
            super.success();
        } else {
            this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.searchCanceled"));
        }
    }

    public final void doCancel(Context context) {
        try {
            this.cancelInProgress = true;
            this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.searchCanceling"));
            this.canceled();
            this.complete(BJobState.canceled);
        }
        catch (Exception exception) {
            this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.Error Canceling"));
        }
    }

    public final boolean getCancelInProgress() {
        return this.cancelInProgress;
    }

    public final void initialiseDelay(int n) {
        Date date = new Date();
        long l = date.getTime() / 1000L;
        boolean bl = true;
        while (bl && !this.cancelInProgress) {
            Date date2 = new Date();
            long l2 = date2.getTime() / 1000L;
            if (l2 - l <= (long)n) continue;
            bl = false;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.network = null;
        this.networkManager = null;
        this.identSearchOnly = false;
        this.filters = null;
        this.cancelInProgress = true;
    }

    public BMbusSecondarySearchJob() {
        this.this();
    }

    public BMbusSecondarySearchJob(BAbstractMbusNetwork bAbstractMbusNetwork, BMbusSecondaryAddressFilters bMbusSecondaryAddressFilters) {
        this.this();
        if (bMbusSecondaryAddressFilters == null) {
            this.identSearchOnly = true;
        } else {
            this.filters = bMbusSecondaryAddressFilters;
        }
        this.network = bAbstractMbusNetwork;
        this.networkManager = this.network.getNetworkDatabase();
        this.cancelInProgress = false;
    }

    static {
        Class clazz = class$com$tridium$mbus$jobs$BMbusSecondarySearchJob;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$jobs$BMbusSecondarySearchJob = BMbusSecondarySearchJob.class("[Lcom.tridium.mbus.jobs.BMbusSecondarySearchJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

