/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.db.BMbusNetworkDatabase;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusTestControl;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndNkeMessage;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusStringConvertor;
import com.tridium.mbus.utils.MbusToolkit;
import java.util.Date;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusDeviceSearchJob
extends BSimpleJob {
    public static final Property networkOrd = BMbusDeviceSearchJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Type TYPE;
    BAbstractMbusNetwork network;
    BMbusNetworkDatabase networkManager;
    int[] addrs;
    JobLog log;
    boolean cancelInProgress;
    static /* synthetic */ Class class$com$tridium$mbus$jobs$BMbusDeviceSearchJob;

    public final BOrd getNetworkOrd() {
        return (BOrd)this.get(networkOrd);
    }

    public final void setNetworkOrd(BOrd bOrd) {
        this.set(networkOrd, (BValue)bOrd, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void run(Context context) throws Exception {
        if (this.networkManager != null) {
            this.networkManager.clearJustDetected();
            this.searchForNewDevice();
        }
        this.progress(100);
    }

    public final void searchForNewDevice() {
        if (this.getCancelInProgress()) {
            return;
        }
        int n = 1;
        boolean[] blArray = new boolean[this.addrs.length];
        MbusResponseMessage mbusResponseMessage = null;
        MbusSndNkeMessage mbusSndNkeMessage = null;
        if (this.addrs[0] == 254) {
            this.progress(5);
            mbusSndNkeMessage = new MbusSndNkeMessage(null, this.network, 255);
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Initialisation Request No Response Expected (SndNke)");
            }
            mbusResponseMessage = (MbusResponseMessage)this.network.sendSync(mbusSndNkeMessage);
            this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.DeviceSearch"));
            this.log().add(new JobLogItem(0, MbusToolkit.getText("MbusNetworkDeviceSearchJob.DeviceSearch")));
            MbusReqUd2Message mbusReqUd2Message = new MbusReqUd2Message(this.addrs[0], this.network);
            mbusReqUd2Message.setMessageBaudRate(this.network.getSearchBaudRate());
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("All Reply Request output ");
            }
            if (this.network.getTestMode() != BMbusTestControl.inactive) {
                mbusResponseMessage = new MbusResponseMessage(MbusStringConvertor.calc(this.network.getTestString()));
                if (this.network.getTestMode() == BMbusTestControl.oneShot) {
                    this.network.setTestMode(BMbusTestControl.inactive);
                }
            } else {
                mbusResponseMessage = (MbusResponseMessage)this.network.sendSync(mbusReqUd2Message);
            }
            if (mbusResponseMessage != null && mbusResponseMessage.getSuccessfulResponse() && mbusResponseMessage.getLength() > 10) {
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("All Reply Response Received ");
                }
                MbusReceivedLongFrame mbusReceivedLongFrame = new MbusReceivedLongFrame(mbusResponseMessage, this.network, null, true);
                int n2 = mbusReceivedLongFrame.getPrimaryAddress();
                this.network.setPrimarySearchAddress(n2);
                String string = mbusReceivedLongFrame.getSecondaryAddress();
                BDevice[] bDeviceArray = this.network.getDevices();
                BMbusDevice bMbusDevice = null;
                int n3 = 0;
                while (n3 < bDeviceArray.length) {
                    bMbusDevice = (BMbusDevice)bDeviceArray[n3];
                    if (bMbusDevice.getPrimaryAddress() == n2 && bMbusDevice.getSecondaryAddress().equals(string)) {
                        n = bMbusDevice.getCycleQuantity();
                        break;
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < n) {
                    this.networkManager.addDeviceData(mbusReceivedLongFrame, n3, this.network.getSearchBaudRate(), null, BMbusAddressing.primary);
                    ++n3;
                }
            }
            this.progress(100);
        } else {
            this.progress(5);
            this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.InitNetworkDelay"));
            this.log().add(new JobLogItem(0, MbusToolkit.getText("MbusNetworkDeviceSearchJob.InitNetworkDelay")));
            mbusSndNkeMessage = new MbusSndNkeMessage(null, this.network, 255);
            mbusSndNkeMessage.setMessageBaudRate(this.network.getSearchBaudRate());
            this.network.sendSync(mbusSndNkeMessage);
            double d = 33.0 / (double)(this.addrs.length + 1);
            double d2 = 0.0;
            double d3 = 0.0;
            this.progress((int)d);
            if (this.getCancelInProgress()) {
                return;
            }
            this.initialiseDelay(this.network.getInitialisationDelay().getSeconds());
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.addrs.length) {
                this.network.setPrimarySearchAddress(this.addrs[n5]);
                if (this.getCancelInProgress()) {
                    return;
                }
                this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.DeviceSearch") + ' ' + this.addrs[n5]);
                this.log().add(new JobLogItem(0, MbusToolkit.getText("MbusNetworkDeviceSearchJob.DeviceSearch") + ' ' + this.addrs[n5]));
                mbusSndNkeMessage = new MbusSndNkeMessage(null, this.network, this.addrs[n5]);
                mbusSndNkeMessage.setMessageBaudRate(this.network.getSearchBaudRate());
                mbusResponseMessage = (MbusResponseMessage)this.network.sendSync(mbusSndNkeMessage);
                if (this.getCancelInProgress()) {
                    return;
                }
                if (mbusResponseMessage != null && mbusResponseMessage.getSuccessfulResponse()) {
                    this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.FoundDevice") + ' ' + this.addrs[n5]);
                    this.log().add(new JobLogItem(0, MbusToolkit.getText("MbusNetworkDeviceSearchJob.FoundDevice") + ' ' + this.addrs[n5]));
                    blArray[n5] = true;
                    ++n4;
                } else {
                    blArray[n5] = false;
                    this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.DeviceNotFound") + ' ' + this.addrs[n5]);
                    this.log().add(new JobLogItem(0, MbusToolkit.getText("MbusNetworkDeviceSearchJob.DeviceNotFound") + ' ' + this.addrs[n5]));
                }
                d2 = d;
                d3 = 22.0 / (double)this.addrs.length;
                d = d3 * (double)n5 + d2;
                this.progress((int)d);
                ++n5;
            }
            if (n4 > 0) {
                n5 = 0;
                while (n5 < this.addrs.length) {
                    if (this.getCancelInProgress()) {
                        return;
                    }
                    if (blArray[n5]) {
                        d2 = d;
                        d3 = (100.0 - d2) / (double)(n4 * n);
                        BDevice[] bDeviceArray = this.network.getDevices();
                        BMbusDevice bMbusDevice = null;
                        BMbusDevice bMbusDevice2 = null;
                        int n6 = 0;
                        while (n6 < bDeviceArray.length) {
                            bMbusDevice2 = (BMbusDevice)bDeviceArray[n6];
                            if (bMbusDevice2.getPrimaryAddress() == this.addrs[n5]) {
                                n = bMbusDevice2.getCycleQuantity();
                                bMbusDevice = (BMbusDevice)bDeviceArray[n6];
                                break;
                            }
                            ++n6;
                        }
                        this.getAllTheData(this.addrs[n5], 0L, d2, d3, n, bMbusDevice);
                        d = d2 + d3;
                        this.progress((int)d);
                    }
                    ++n5;
                }
            }
        }
    }

    private final int getAllTheData(int n, long l, double d, double d2, int n2, BMbusDevice bMbusDevice) {
        MbusReceivedLongFrame mbusReceivedLongFrame = null;
        MbusResponseMessage mbusResponseMessage = null;
        int n3 = 0;
        MbusReqUd2Message mbusReqUd2Message = null;
        if (bMbusDevice != null) {
            mbusReqUd2Message = new MbusReqUd2Message(bMbusDevice, this.network);
        } else {
            this.network.setSearchFcBitState(false);
            mbusReqUd2Message = n <= 250 ? new MbusReqUd2Message(n, this.network) : new MbusReqUd2Message(this.network.getPrimarySearchAddress(), this.network);
        }
        int n4 = 0;
        while (n4 < n2) {
            if (this.getCancelInProgress()) {
                return 0;
            }
            this.progress((int)(d + d2 * 0.5));
            if (this.network.getTestMode() != BMbusTestControl.inactive) {
                mbusResponseMessage = new MbusResponseMessage(MbusStringConvertor.calc(this.network.getTestString()));
                if (this.network.getTestMode() == BMbusTestControl.oneShot) {
                    this.network.setTestMode(BMbusTestControl.inactive);
                }
            } else {
                mbusResponseMessage = (MbusResponseMessage)this.network.sendSync(mbusReqUd2Message);
            }
            if (mbusResponseMessage != null && mbusResponseMessage.getSuccessfulResponse() && mbusResponseMessage.getLength() > 10) {
                mbusReceivedLongFrame = new MbusReceivedLongFrame(mbusResponseMessage, this.network, bMbusDevice, true);
                n3 += this.networkManager.addDeviceData(mbusReceivedLongFrame, n4, this.network.getSearchBaudRate(), null, BMbusAddressing.primary);
            }
            ++n4;
        }
        this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.searchCompleted"));
        this.log().add(new JobLogItem(0, MbusToolkit.getText("MbusNetworkDeviceSearchJob.searchCompleted")));
        return n3;
    }

    public final void success() {
        if (!this.cancelInProgress) {
            super.success();
        } else {
            this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.searchCanceled"));
        }
    }

    public final void doCancel(Context context) {
        try {
            this.cancelInProgress = true;
            this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.searchCanceling"));
            this.canceled();
            this.complete(BJobState.canceled);
        }
        catch (Exception exception) {
            this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.Error in Canceling"));
        }
    }

    public final boolean getCancelInProgress() {
        return this.cancelInProgress;
    }

    public final void initialiseDelay(int n) {
        Date date = new Date();
        long l = date.getTime() / 1000L;
        boolean bl = true;
        while (bl && !this.cancelInProgress) {
            Date date2 = new Date();
            long l2 = date2.getTime() / 1000L;
            if (l2 - l <= (long)n) continue;
            bl = false;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.network = null;
        this.networkManager = null;
        this.addrs = null;
        this.log = null;
        this.cancelInProgress = true;
    }

    public BMbusDeviceSearchJob() {
        this.this();
    }

    public BMbusDeviceSearchJob(BAbstractMbusNetwork bAbstractMbusNetwork, int n, int n2) {
        this.this();
        this.network = bAbstractMbusNetwork;
        this.networkManager = bAbstractMbusNetwork.getNetworkDatabase();
        this.cancelInProgress = false;
        this.log = this.log();
        this.addrs = new int[n2 - n + 1];
        int n3 = 0;
        while (n3 < this.addrs.length) {
            this.addrs[n3] = n + n3;
            ++n3;
        }
    }

    public BMbusDeviceSearchJob(BAbstractMbusNetwork bAbstractMbusNetwork, int[] nArray) {
        this.this();
        this.network = bAbstractMbusNetwork;
        this.networkManager = bAbstractMbusNetwork.getNetworkDatabase();
        this.cancelInProgress = false;
        this.addrs = nArray;
        this.log = this.log();
    }

    static {
        Class clazz = class$com$tridium$mbus$jobs$BMbusDeviceSearchJob;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$jobs$BMbusDeviceSearchJob = BMbusDeviceSearchJob.class("[Lcom.tridium.mbus.jobs.BMbusDeviceSearchJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

