/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.enums;

import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.units.UnitException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusUnit
extends BFrozenEnum {
    public static final int WATT_HOURS = 0;
    public static final int MEGA_WATT_HOURS = 1;
    public static final int KILO_JOULES = 2;
    public static final int GIGA_JOULES = 3;
    public static final int WATTS = 4;
    public static final int MEGA_WATTS = 5;
    public static final int KILO_JOULES_PER_HOUR = 6;
    public static final int GIGA_JOULES_PER_HOUR = 7;
    public static final int LITRES = 8;
    public static final int METRES_CUBED = 9;
    public static final int LITRES_PER_HOUR = 10;
    public static final int METRES_CUBED_PER_HOUR = 11;
    public static final int HCA_UNITS = 12;
    public static final int RESERVED = 13;
    public static final int SAME_BUT_HISTORIC = 14;
    public static final int CUBIC_FEET = 15;
    public static final int US_GALLONS = 16;
    public static final int TONNES = 17;
    public static final int US_GALLONS_PER_MINUTE = 18;
    public static final int US_GALLONS_PERHOUR = 19;
    public static final int CELSIUS = 20;
    public static final int FAHRENHEIT = 21;
    public static final int KELVIN = 22;
    public static final int LOCAL_CURRENCY = 23;
    public static final int NONE = 24;
    public static final int BIT_TIMES = 25;
    public static final int SECONDS = 26;
    public static final int MINUTES = 27;
    public static final int HOURS = 28;
    public static final int DAYS = 29;
    public static final int MONTHS = 30;
    public static final int YEARS = 31;
    public static final int DATE_AND_TIME = 32;
    public static final int VOLTS = 33;
    public static final int AMPERES = 34;
    public static final int JOULES = 35;
    public static final int KILOGRAMS = 36;
    public static final int JOULES_PER_HOUR = 37;
    public static final int METRES_CUBED_PER_MINUTE = 38;
    public static final int METRES_CUBED_PER_SECOND = 39;
    public static final int KILOGRAMS_PER_HOUR = 40;
    public static final int BAR = 41;
    public static final int DATE = 42;
    public static final int BOOLEAN_TYPE = 43;
    public static final int DAY_OF_WEEK = 44;
    public static final int K_VARH = 45;
    public static final int M_BTU_PER_SECOND = 46;
    public static final int K_BTU = 47;
    public static final int M_BTU = 48;
    public static final BMbusUnit wattHours = new BMbusUnit(0);
    public static final BMbusUnit megaWattHours = new BMbusUnit(1);
    public static final BMbusUnit kiloJoules = new BMbusUnit(2);
    public static final BMbusUnit gigaJoules = new BMbusUnit(3);
    public static final BMbusUnit watts = new BMbusUnit(4);
    public static final BMbusUnit megaWatts = new BMbusUnit(5);
    public static final BMbusUnit kiloJoulesPerHour = new BMbusUnit(6);
    public static final BMbusUnit gigaJoulesPerHour = new BMbusUnit(7);
    public static final BMbusUnit litres = new BMbusUnit(8);
    public static final BMbusUnit metresCubed = new BMbusUnit(9);
    public static final BMbusUnit litresPerHour = new BMbusUnit(10);
    public static final BMbusUnit metresCubedPerHour = new BMbusUnit(11);
    public static final BMbusUnit hcaUnits = new BMbusUnit(12);
    public static final BMbusUnit reserved = new BMbusUnit(13);
    public static final BMbusUnit sameButHistoric = new BMbusUnit(14);
    public static final BMbusUnit cubicFeet = new BMbusUnit(15);
    public static final BMbusUnit usGallons = new BMbusUnit(16);
    public static final BMbusUnit tonnes = new BMbusUnit(17);
    public static final BMbusUnit usGallonsPerMinute = new BMbusUnit(18);
    public static final BMbusUnit usGallonsPerhour = new BMbusUnit(19);
    public static final BMbusUnit celsius = new BMbusUnit(20);
    public static final BMbusUnit fahrenheit = new BMbusUnit(21);
    public static final BMbusUnit kelvin = new BMbusUnit(22);
    public static final BMbusUnit localCurrency = new BMbusUnit(23);
    public static final BMbusUnit none = new BMbusUnit(24);
    public static final BMbusUnit bitTimes = new BMbusUnit(25);
    public static final BMbusUnit seconds = new BMbusUnit(26);
    public static final BMbusUnit minutes = new BMbusUnit(27);
    public static final BMbusUnit hours = new BMbusUnit(28);
    public static final BMbusUnit days = new BMbusUnit(29);
    public static final BMbusUnit months = new BMbusUnit(30);
    public static final BMbusUnit years = new BMbusUnit(31);
    public static final BMbusUnit dateAndTime = new BMbusUnit(32);
    public static final BMbusUnit volts = new BMbusUnit(33);
    public static final BMbusUnit amperes = new BMbusUnit(34);
    public static final BMbusUnit joules = new BMbusUnit(35);
    public static final BMbusUnit kilograms = new BMbusUnit(36);
    public static final BMbusUnit joulesPerHour = new BMbusUnit(37);
    public static final BMbusUnit metresCubedPerMinute = new BMbusUnit(38);
    public static final BMbusUnit metresCubedPerSecond = new BMbusUnit(39);
    public static final BMbusUnit kilogramsPerHour = new BMbusUnit(40);
    public static final BMbusUnit bar = new BMbusUnit(41);
    public static final BMbusUnit date = new BMbusUnit(42);
    public static final BMbusUnit booleanType = new BMbusUnit(43);
    public static final BMbusUnit dayOfWeek = new BMbusUnit(44);
    public static final BMbusUnit kVARh = new BMbusUnit(45);
    public static final BMbusUnit mBtuPerSecond = new BMbusUnit(46);
    public static final BMbusUnit kBTU = new BMbusUnit(47);
    public static final BMbusUnit mBTU = new BMbusUnit(48);
    public static final Type TYPE;
    public static final BMbusUnit DEFAULT;
    private static final String[] NIAGARA_UNIT_STRINGS;
    private static final String[] SYMBOLS;
    private static final String[] DIMENSIONS;
    private static final double[] SCALES;
    private static final double[] OFFSETS;
    static /* synthetic */ Class class$com$tridium$mbus$enums$BMbusUnit;

    public final Type getType() {
        return TYPE;
    }

    public static final BMbusUnit make(int n) {
        return (BMbusUnit)wattHours.getRange().get(n, false);
    }

    public static final BMbusUnit make(String string) {
        return (BMbusUnit)wattHours.getRange().get(string);
    }

    public static final BUnit getNiagaraUnits(BMbusUnit bMbusUnit) {
        int n = bMbusUnit.getOrdinal();
        if (n < NIAGARA_UNIT_STRINGS.length) {
            if (NIAGARA_UNIT_STRINGS[n].equals("null")) {
                return null;
            }
            try {
                return BUnit.getUnit((String)NIAGARA_UNIT_STRINGS[n]);
            }
            catch (UnitException unitException) {
                try {
                    BDimension bDimension = (BDimension)BDimension.DEFAULT.decodeFromString(DIMENSIONS[n]);
                    BUnit bUnit = BUnit.make((String)NIAGARA_UNIT_STRINGS[n], (String)SYMBOLS[n], (BDimension)bDimension, (double)SCALES[n], (double)OFFSETS[n]);
                    return bUnit;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace("BDimensionException: " + NIAGARA_UNIT_STRINGS[n]);
                        System.out.println(exception);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BMbusUnit(int n) {
        super(n);
    }

    static {
        Class clazz = class$com$tridium$mbus$enums$BMbusUnit;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$enums$BMbusUnit = BMbusUnit.class("[Lcom.tridium.mbus.enums.BMbusUnit;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        DEFAULT = wattHours;
        NIAGARA_UNIT_STRINGS = new String[]{"watt hour", "megawatt hour", "kilojoule", "gigajoule", "watt", "megawatt", "kilojoule hour", "gigajoule hour", "liter", "cubic meter", "liters per hour", "cubic meters per hour", "hca units", "null", "same but historic", "cubic foot", "gallon", "metric ton", "gallons per minute", "gallons per hour", "celsius", "fahrenheit", "kelvin", "local currency", "null", "bit times", "second", "minute", "hour", "day", "julian month", "year", "date and time", "volt", "ampere", "joule", "kilogram", "joule hour", "cubic meters per minute", "cubic meters per second", "kilograms per hour", "bar", "date", "null", "day of week", "kilovolt ampere reactive hour", "millibtu per second", "kilobtu"};
        SYMBOLS = new String[]{"W-hr", "MW-hr", "kJ", "GJ", "W", "MW", "kJ-hr", "GJ-hr", "L", "m&#xb3", "L/hr", "m&#xb3", "hcau", "null", "sbh", "ft&#xb3", "gal", "ton", "gal/min", "gal/hr", "&#xba;C", "&#xba;F", "&#xba;K", "#", "", "b/s", "s", "min", "hr", "day", "mo", "yr", "ms Abs", "V", "A", "J", "kg", "J-hr", "m&#xb3;/min", "m&#xb3;/s", "kg/hr", "bar", "ms Abs", "", "day", "kVAR-hr", "mBTU/s", "kBTU"};
        DIMENSIONS = new String[]{"(m2)(kg)(s-2)", "(m2)(kg)(s-2)", "(m2)(kg)(s-2)", "(m2)(kg)(s-2)", "(m2)(kg)(s-3)", "(m2)(kg)(s-3)", "(m2)(kg)(s-2)", "(m2)(kg)(s-2)", "(m3)", "(m3)", "(m3)(s-1)", "(m3)(s-1)", "", "", "", "(m3)", "(m3)", "(kg)", "(m3)(s-1)", "(m3)(s-1)", "(K)", "(K)", "(K)", "", "", "(s-1)", "(s)", "(s)", "(s)", "(s)", "(s)", "(s)", "(s)", "(m2)(kg)(s-3)(A-1)", "(A)", "(m2)(kg)(s-2)", "(kg)", "(m2)(kg)(s-2)", "(m3)(s-1)", "(m3)(s-1)", "(kg)(s-1)", "(m-1)(kg)(s-2)", "(s)", "", "", "(m2)(kg)(s-2)", "(m2)(kg)(s-2)", "(m2)(kg)(s-2)"};
        SCALES = new double[]{3600.0, 3.6E9, 1000.0, 1.0E9, 1.0, 1000000.0, 3600000.0, 3.6E12, 0.001, 1.0, 2.7777777777777776E-7, 2.777777777777778E-4, 1.0, 1.0, 1.0, 0.028317, 0.003785, 1000.0, 1.0515032733333334E-6, 6.30901964E-5, 1.0, 0.5555555555555556, 1.0, 1.0, 1.0, 1.0, 1.0, 60.0, 3600.0, 86400.0, 2629800.0, 3.1536E7, 1.0, 1.0, 1.0, 1.0, 1.0, 3600.0, 4.719474432E-4, 1.0, 2.777777777777778E-4, 100000.0, 1.0, 1.0, 1.0, 1000.0, 1.054852, 1054852.0};
        double[] dArray = new double[48];
        dArray[20] = 273.15;
        dArray[21] = 255.37222222222223;
        OFFSETS = dArray;
    }
}

