/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.db;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.db.BMbusDeviceData;
import com.tridium.mbus.db.BMbusPointData;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.enums.BMbusFunction;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusSndNkeMessage;
import com.tridium.mbus.utils.MbusToolkit;
import java.util.ArrayList;
import java.util.Date;
import javax.baja.collection.BICollection;
import javax.baja.collection.BIList;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusNetworkDatabase
extends BComponent {
    public static final Property statusMessage = BMbusNetworkDatabase.newProperty((int)1, (String)"", null);
    public static final Property detectedDevices = BMbusNetworkDatabase.newProperty((int)4, (BValue)new BMbusDeviceData(), null);
    public static final Type TYPE;
    private static Lexicon lex;
    private BAbstractMbusNetwork network;
    private BIcon icon;
    static /* synthetic */ Class class$com$tridium$mbus$db$BMbusNetworkDatabase;
    static /* synthetic */ Class class$com$tridium$mbus$db$BMbusDeviceData;

    public final String getStatusMessage() {
        return this.getString(statusMessage);
    }

    public final void setStatusMessage(String string) {
        this.setString(statusMessage, string, null);
    }

    public final BMbusDeviceData getDetectedDevices() {
        return (BMbusDeviceData)this.get(detectedDevices);
    }

    public final void setDetectedDevices(BMbusDeviceData bMbusDeviceData) {
        this.set(detectedDevices, (BValue)bMbusDeviceData, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        this.network = (BAbstractMbusNetwork)this.getParent();
        this.setStatusMessage(lex.getText("MbusNetworkManager.statusAwaitingStart"));
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BAbstractMbusNetwork;
    }

    public final BIcon getIcon() {
        return this.icon;
    }

    public final BMbusDeviceData[] getDynamicDeviceData() {
        Property[] propertyArray = this.getDynamicPropertiesArray();
        Class clazz = class$com$tridium$mbus$db$BMbusDeviceData;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$db$BMbusDeviceData = BMbusNetworkDatabase.class("[Lcom.tridium.mbus.db.BMbusDeviceData;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < propertyArray.length) {
            if (propertyArray[n].getType().equals(BMbusDeviceData.TYPE)) {
                array.add((Object)this.get(propertyArray[n]));
            }
            ++n;
        }
        return (BMbusDeviceData[])array.trim();
    }

    private final String constructDeviceName(int n, String string) {
        String string2 = "";
        string2 = n < 0 || n > 250 ? detectedDevices.getName() + string + "S?" : detectedDevices.getName() + new Integer(n).toString() + "P?";
        return string2;
    }

    public final void removeDevice(int n, String string) {
        String string2 = this.constructDeviceName(n, string);
        string2 = string2.substring(0, string2.length() - 1);
        System.out.println("Name= " + string2);
        this.remove(string2);
    }

    public final void addDevice(BMbusDeviceData bMbusDeviceData) {
        BObject[] bObjectArray;
        String string = this.constructDeviceName(bMbusDeviceData.getPrimaryAddress(), bMbusDeviceData.getSecondaryAddress());
        bMbusDeviceData.setJustDetected(true);
        this.add(string, (BValue)bMbusDeviceData, 1);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.network.getSlotPathOrd().toString());
        stringBuffer.append("|bql:select from mbus:MbusDevice where primaryAddress=");
        stringBuffer.append(String.valueOf(bMbusDeviceData.getPrimaryAddress()));
        stringBuffer.append(" and secondaryAddress='");
        stringBuffer.append(String.valueOf(bMbusDeviceData.getSecondaryAddress()));
        stringBuffer.append("'");
        BICollection bICollection = (BICollection)BOrd.make((String)stringBuffer.toString()).get((BObject)this.network);
        BIList bIList = bICollection.toList();
        if (bIList != null && (bObjectArray = bIList.list()) != null) {
            BMbusDevice bMbusDevice = null;
            int n = 0;
            while (n < bObjectArray.length) {
                bMbusDevice = (BMbusDevice)bObjectArray[n];
                bMbusDevice.setIdentNumber(bMbusDeviceData.getIdentNumber());
                bMbusDevice.setManufacturer(bMbusDeviceData.getManufacturer());
                bMbusDevice.setVersionNumber(bMbusDeviceData.getVersionNumber());
                bMbusDevice.setDeviceTypeId(bMbusDeviceData.getDeviceTypeId());
                ++n;
            }
        }
    }

    public final void clearAllDetectedDevices() {
        this.removeAll();
    }

    public final boolean doesDeviceExistAlready(int n, String string, String string2) {
        BMbusDeviceData[] bMbusDeviceDataArray = this.getDynamicDeviceData();
        if (bMbusDeviceDataArray.length > 0) {
            int n2 = 0;
            while (n2 < bMbusDeviceDataArray.length) {
                if (string2 != null && !string2.equals("") && string2.equals(bMbusDeviceDataArray[n2].getModelName())) {
                    return true;
                }
                int n3 = bMbusDeviceDataArray[n2].getPrimaryAddress();
                if (bMbusDeviceDataArray[n2].getAddressMode() == BMbusAddressing.primary && n >= 0 && n <= 250) {
                    if (n3 == n) {
                        bMbusDeviceDataArray[n2].setJustDetected(true);
                        return true;
                    }
                } else if (bMbusDeviceDataArray[n2].getSecondaryAddress().equals(string)) {
                    bMbusDeviceDataArray[n2].setJustDetected(true);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public final void initialiseDelay(int n) {
        Date date = new Date();
        long l = date.getTime() / 1000L;
        boolean bl = true;
        while (bl) {
            Date date2 = new Date();
            long l2 = date2.getTime() / 1000L;
            if (l2 - l <= (long)n) continue;
            bl = false;
        }
    }

    public final int addDeviceData(MbusReceivedLongFrame mbusReceivedLongFrame, int n, BMbusBaudRate bMbusBaudRate, BMbusDevice bMbusDevice, BMbusAddressing bMbusAddressing) {
        int n2 = 0;
        int n3 = 0;
        if (mbusReceivedLongFrame == null) {
            return 0;
        }
        int n4 = mbusReceivedLongFrame.getPrimaryAddress();
        String string = mbusReceivedLongFrame.getIdentNumber();
        String string2 = mbusReceivedLongFrame.getManufacturer();
        int n5 = mbusReceivedLongFrame.getVersionNumber();
        BMbusDeviceTypeId bMbusDeviceTypeId = mbusReceivedLongFrame.getDeviceTypeId();
        ArrayList arrayList = mbusReceivedLongFrame.getData();
        String string3 = mbusReceivedLongFrame.getSecondaryAddress();
        String string4 = "";
        int n6 = 0;
        if (bMbusDevice != null) {
            string4 = bMbusDevice.getModelName();
            n6 = bMbusDevice.getReadoutModeNumber();
        }
        n2 = arrayList.size();
        BMbusPointData[] bMbusPointDataArray = new BMbusPointData[n2];
        int n7 = 0;
        n7 = 0;
        while (n7 < arrayList.size()) {
            bMbusPointDataArray[n7] = (BMbusPointData)((Object)arrayList.get(n7));
            bMbusPointDataArray[n7].setCycleNumber(n);
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("Units= " + (Object)((Object)bMbusPointDataArray[n7].getUnit()) + "  Description= " + bMbusPointDataArray[n7].getDescription());
                MbusToolkit.trace("Ortho= " + (Object)((Object)bMbusPointDataArray[n7].getOrthogonalDescription()));
                MbusToolkit.trace("Rec= " + bMbusPointDataArray[n7].getRecordNumber());
                MbusToolkit.trace("Cycle= " + bMbusPointDataArray[n7].getCycleNumber());
                MbusToolkit.trace("Exp= " + bMbusPointDataArray[n7].getExponent());
                MbusToolkit.trace("NumberType= " + (Object)((Object)bMbusPointDataArray[n7].getNumberType()));
                MbusToolkit.trace("StNum= " + bMbusPointDataArray[n7].getStorageNumber());
                MbusToolkit.trace("Funct= " + (Object)((Object)bMbusPointDataArray[n7].getFunction()));
                MbusToolkit.trace("Slot= " + bMbusPointDataArray[n7].getMessageSlotNumber());
                MbusToolkit.trace("Mode= " + n6);
                MbusToolkit.trace("Model Name= " + string4);
            }
            ++n7;
        }
        if (this.doesDeviceExistAlready(n4, string3, string4)) {
            BMbusDeviceData bMbusDeviceData = this.getSpecificDeviceInformation(n4, string3, string4);
            if (bMbusDeviceData != null) {
                bMbusDeviceData.setManufacturer(string2);
                bMbusDeviceData.setVersionNumber(n5);
                bMbusDeviceData.setIdentNumber(string);
                bMbusDeviceData.setDeviceTypeId(bMbusDeviceTypeId);
                bMbusDeviceData.setJustDetected(true);
                int n8 = 0;
                while (n8 < bMbusPointDataArray.length) {
                    String string5 = bMbusPointDataArray[n8].getDescription().toString();
                    BMbusOrthogonalDescription bMbusOrthogonalDescription = bMbusPointDataArray[n8].getOrthogonalDescription();
                    BMbusUnit bMbusUnit = bMbusPointDataArray[n8].getUnit();
                    int n9 = bMbusPointDataArray[n8].getMessageSlotNumber();
                    int n10 = bMbusPointDataArray[n8].getRecordNumber();
                    long l = bMbusPointDataArray[n8].getStorageNumber();
                    BMbusFunction bMbusFunction = bMbusPointDataArray[n8].getFunction();
                    int n11 = bMbusPointDataArray[n8].getExponent();
                    if (l >= 0L && l < (long)2) {
                        BMbusPointData[] bMbusPointDataArray2 = new BMbusPointData[]{};
                        if (!bMbusDeviceData.getPointDataInvalid()) {
                            bMbusPointDataArray2 = bMbusDeviceData.getDynamicPointData();
                        }
                        boolean bl = false;
                        int n12 = 0;
                        while (n12 < bMbusPointDataArray2.length) {
                            if (bMbusPointDataArray2[n12].getUnit().equals((Object)bMbusUnit) && bMbusPointDataArray2[n12].getDescription().equals(string5) && bMbusPointDataArray2[n12].getRecordNumber() == n10 && bMbusPointDataArray2[n12].getCycleNumber() == n && bMbusPointDataArray2[n12].getFunction() == bMbusFunction && bMbusPointDataArray2[n12].getMessageSlotNumber() == n9 && (long)bMbusPointDataArray2[n12].getStorageNumber() == l && bMbusPointDataArray2[n12].getDeviceMode() == n6 && bMbusPointDataArray2[n12].getOrthogonalDescription().equals((Object)bMbusOrthogonalDescription)) {
                                if (MbusToolkit.isTraceOn()) {
                                    MbusToolkit.trace("Matching Units= " + (Object)((Object)bMbusUnit) + "  Description= " + string5);
                                    MbusToolkit.trace("Matching Ortho= " + (Object)((Object)bMbusOrthogonalDescription));
                                    MbusToolkit.trace("Matching Rec= " + n10);
                                    MbusToolkit.trace("Matching Cycle= " + n);
                                    MbusToolkit.trace("Matching Exp= " + bMbusPointDataArray2[n12].getExponent());
                                    MbusToolkit.trace("Matching NumberType= " + (Object)((Object)bMbusPointDataArray2[n12].getNumberType()));
                                    MbusToolkit.trace("Matching StNum= " + bMbusPointDataArray2[n12].getStorageNumber());
                                    MbusToolkit.trace("Matching Funct= " + (Object)((Object)bMbusPointDataArray2[n12].getFunction()));
                                    MbusToolkit.trace("Matching Slot= " + n9);
                                    MbusToolkit.trace("Matching Mode= " + bMbusPointDataArray2[n12].getDeviceMode());
                                }
                                bl = true;
                                break;
                            }
                            ++n12;
                        }
                        if (!bl) {
                            if (MbusToolkit.isTraceOn()) {
                                MbusToolkit.trace("BMbusDeviceData: adding in " + string5 + ", units= " + (Object)((Object)bMbusUnit) + ", orth= " + (Object)((Object)bMbusOrthogonalDescription) + ", function= " + (Object)((Object)bMbusFunction) + ", exponent= " + n11 + ", store= " + l + ", rec= " + n10 + ", cycle= " + n + ", slot= " + n9 + ", mode= " + n6);
                            }
                            bMbusPointDataArray[n8].setRecordNumber(n10);
                            ++n3;
                            bMbusPointDataArray[n8].setDeviceMode(n6);
                            bMbusDeviceData.add("pointData?", (BValue)bMbusPointDataArray[n8], 1);
                        }
                    }
                    ++n8;
                }
                this.remove(bMbusDeviceData.getName());
                this.addDevice(bMbusDeviceData);
            }
        } else {
            boolean bl = this.network.getSearchFcBitState();
            boolean bl2 = this.network.getSearchFcBitInUse();
            BMbusDeviceData bMbusDeviceData = new BMbusDeviceData(n4, string3, string, string2, n5, bMbusDeviceTypeId, bMbusBaudRate, bMbusPointDataArray, bl, bl2, bMbusAddressing);
            bMbusDeviceData.setJustDetected(true);
            this.addDevice(bMbusDeviceData);
            n3 = n2;
            this.network.setSearchFcBitState(false);
        }
        return n3;
    }

    public final BMbusDeviceData getSpecificDeviceInformation(BMbusDevice bMbusDevice) {
        return this.getSpecificDeviceInformation(bMbusDevice.getPrimaryAddress(), bMbusDevice.getSecondaryAddress(), bMbusDevice.getModelName());
    }

    public final BMbusDeviceData getSpecificDeviceInformation(int n, String string, String string2) {
        BMbusDeviceData[] bMbusDeviceDataArray = this.getDynamicDeviceData();
        if (bMbusDeviceDataArray.length > 0) {
            int n2 = 0;
            while (n2 < bMbusDeviceDataArray.length) {
                if (!string2.equals("") && bMbusDeviceDataArray[n2].getModelName().equals(string2)) {
                    return bMbusDeviceDataArray[n2];
                }
                if (bMbusDeviceDataArray[n2].getAddressMode() == BMbusAddressing.primary ? bMbusDeviceDataArray[n2].getPrimaryAddress() == n : bMbusDeviceDataArray[n2].getSecondaryAddress().equals(string)) {
                    return bMbusDeviceDataArray[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    public final void removeDevicePointInformation(int n, String string, String string2) {
        BMbusDeviceData[] bMbusDeviceDataArray = this.getDynamicDeviceData();
        if (bMbusDeviceDataArray.length > 0) {
            int n2 = 0;
            while (n2 < bMbusDeviceDataArray.length) {
                if (!string2.equals("") && bMbusDeviceDataArray[n2].getModelName().equals(string2) || bMbusDeviceDataArray[n2].getPrimaryAddress() == n && bMbusDeviceDataArray[n2].getSecondaryAddress().equals(string)) {
                    bMbusDeviceDataArray[n2].setPointDataInvalid(true);
                    bMbusDeviceDataArray[n2].removeAll();
                    break;
                }
                ++n2;
            }
        }
    }

    public final void rationalise(BMbusDevice bMbusDevice) {
        BMbusDeviceData[] bMbusDeviceDataArray = this.getDynamicDeviceData();
        BMbusPointData[] bMbusPointDataArray = null;
        String string = "";
        if (!bMbusDevice.getModelName().equals("") && bMbusDeviceDataArray.length > 1) {
            int n = 0;
            while (n < bMbusDeviceDataArray.length) {
                if (bMbusDeviceDataArray[n].getPrimaryAddress() == bMbusDevice.getPrimaryAddress() && bMbusDeviceDataArray[n].getSecondaryAddress().equals(bMbusDevice.getSecondaryAddress())) {
                    bMbusDeviceDataArray[n].setModelName(bMbusDevice.getModelName());
                    bMbusPointDataArray = bMbusDeviceDataArray[n].getDynamicPointData();
                    string = bMbusDeviceDataArray[n].getName();
                    break;
                }
                ++n;
            }
            n = 0;
            while (n < bMbusDeviceDataArray.length) {
                if (bMbusDeviceDataArray[n].getModelName().equals(bMbusDevice.getModelName()) && (bMbusDeviceDataArray[n].getPrimaryAddress() != bMbusDevice.getPrimaryAddress() || !bMbusDeviceDataArray[n].getSecondaryAddress().equals(bMbusDevice.getSecondaryAddress()))) {
                    BMbusPointData[] bMbusPointDataArray2 = bMbusDeviceDataArray[n].getDynamicPointData();
                    String string2 = bMbusDeviceDataArray[n].getName();
                    int n2 = 0;
                    while (n2 < bMbusPointDataArray.length) {
                        boolean bl = false;
                        int n3 = 0;
                        while (n3 < bMbusPointDataArray2.length) {
                            if (bMbusPointDataArray2[n3].getUnit().equals((Object)bMbusPointDataArray[n2].getUnit()) && bMbusPointDataArray2[n3].getDescription().equals(bMbusPointDataArray[n2].getDescription()) && bMbusPointDataArray2[n3].getRecordNumber() == bMbusPointDataArray[n2].getRecordNumber() && bMbusPointDataArray2[n3].getCycleNumber() == bMbusPointDataArray[n2].getCycleNumber() && bMbusPointDataArray2[n3].getMessageSlotNumber() == bMbusPointDataArray[n2].getMessageSlotNumber() && bMbusPointDataArray2[n3].getStorageNumber() == bMbusPointDataArray[n2].getStorageNumber() && bMbusPointDataArray2[n3].getDeviceMode() == bMbusPointDataArray[n2].getDeviceMode() && bMbusPointDataArray2[n3].getOrthogonalDescription().equals((Object)bMbusPointDataArray[n2].getOrthogonalDescription())) {
                                bl = true;
                                break;
                            }
                            ++n3;
                        }
                        if (!bl) {
                            bMbusDeviceDataArray[n].add("pointData?", (BValue)bMbusPointDataArray[n2], 1);
                        }
                        ++n2;
                    }
                    this.remove(string2);
                    this.addDevice(bMbusDeviceDataArray[n]);
                    this.remove(string);
                    break;
                }
                ++n;
            }
        }
    }

    public final void doResetNetwork() {
        this.setStatusMessage(lex.getText("MbusNetworkManager.NetworkInitStarted"));
        MbusSndNkeMessage mbusSndNkeMessage = new MbusSndNkeMessage(null, this.network, 255);
        mbusSndNkeMessage.setMessageBaudRate(BMbusBaudRate.baud300);
        this.network.sendSync(mbusSndNkeMessage);
        this.initialiseDelay(this.network.getInitialisationDelay().getSeconds());
    }

    public final void clearJustDetected() {
        BMbusDeviceData[] bMbusDeviceDataArray = this.getDynamicDeviceData();
        if (bMbusDeviceDataArray.length > 0) {
            int n = 0;
            while (n < bMbusDeviceDataArray.length) {
                bMbusDeviceDataArray[n].setJustDetected(false);
                ++n;
            }
        }
    }

    public final void setJustDetected() {
        BMbusDeviceData[] bMbusDeviceDataArray = this.getDynamicDeviceData();
        if (bMbusDeviceDataArray.length > 0) {
            int n = 0;
            while (n < bMbusDeviceDataArray.length) {
                bMbusDeviceDataArray[n].setJustDetected(true);
                ++n;
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.network = null;
        this.icon = BIcon.std((String)"database.png");
    }

    public BMbusNetworkDatabase() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$mbus$db$BMbusNetworkDatabase;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$db$BMbusNetworkDatabase = BMbusNetworkDatabase.class("[Lcom.tridium.mbus.db.BMbusNetworkDatabase;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$mbus$db$BMbusNetworkDatabase;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$mbus$db$BMbusNetworkDatabase = BMbusNetworkDatabase.class("[Lcom.tridium.mbus.db.BMbusNetworkDatabase;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

