/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.comm;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.mbus.comm.IMbusComm;
import com.tridium.mbus.comm.MbusCommUtil;
import java.net.Socket;
import javax.baja.net.BInternetAddress;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MbusSocketComm
extends Comm
implements IMbusComm {
    private static final long MIN_SLEEP_TIME = 10L;
    private Object socketRestartLock;
    private Socket socket;
    private Thread rxThread;
    private ISocketAddressHolder socketAddressHolder;
    private long lastRecvMessageTicks;

    protected boolean started() throws Exception {
        try {
            this.reopenSocket();
            this.rxThread = new Thread((Runnable)this.getCommReceiver(), "MbusTcpIpSocketRcv:" + this.getNetwork().getName());
            this.getCommReceiver().setAlive(true);
            this.rxThread.start();
            this.rxThread.setPriority(5);
        }
        catch (Exception exception) {
            String string = "Error opening and configuring the socket";
            this.getNetwork().getLog().error(string, (Throwable)exception);
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception2) {
                    this.getNetwork().getLog().error("Unable to close socket", (Throwable)exception2);
                }
            }
            throw exception;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopped() throws Exception {
        this.getCommReceiver().setAlive(false);
        if (this.getCommReceiver() != null && this.rxThread != null) {
            this.rxThread.interrupt();
        }
        if (this.socket == null) return;
        try {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                this.getNetwork().getLog().error("Unable to close socket", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.socket = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.socket = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reopenSocket() throws BasicException {
        Object object = this.socketRestartLock;
        synchronized (object) {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
                BInternetAddress bInternetAddress = this.socketAddressHolder.getInternetAddress();
                this.socket = new Socket(bInternetAddress.getAddress(), bInternetAddress.getPort());
                this.socket.setKeepAlive(true);
                this.getCommReceiver().setInputStream(this.socket.getInputStream());
                this.getCommTransmitter().setOutputStream(this.socket.getOutputStream());
                this.getNetwork().pingOk();
            }
            catch (Exception exception) {
                this.getNetwork().pingFail("Error reopening/reconfiguring the socket " + exception.getMessage());
                this.getNetwork().getLog().error("Error reopening/reconfiguring the socket", (Throwable)exception);
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (Exception exception2) {
                        this.getNetwork().getLog().error("Unable to close socket after reopen", (Throwable)exception2);
                    }
                }
                this.getNetwork().pingFail("Could not establish TCP/IP communications");
                throw new BasicException(exception.getMessage(), (Throwable)exception);
            }
            return;
        }
    }

    public void onReceiveError(Exception exception) {
        this.reopenSocket();
    }

    public Message transmit(Message message, BRelTime bRelTime, int n) throws BasicException {
        try {
            return MbusCommUtil.transmit(this, message, bRelTime, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof BasicException) {
                throw (BasicException)((Object)exception);
            }
            return null;
        }
    }

    public void receive(ReceivedMessage receivedMessage) {
        this.lastRecvMessageTicks = Clock.ticks();
        super.receive(receivedMessage);
    }

    public void performNetworkInterMessageDelay() {
        long l = ((BSerialNetwork)this.getNetwork()).getInterMessageDelay().getMillis();
        if (l <= 0L) {
            return;
        }
        long l2 = Clock.ticks() - this.lastRecvMessageTicks;
        if (l2 >= l) {
            return;
        }
        long l3 = Math.max(l - l2, 10L);
        try {
            Thread.sleep(l3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Message processNetworkTransmit(Message message, BRelTime bRelTime) throws BasicException {
        return this.processTransmit(message, bRelTime);
    }

    private final /* synthetic */ void this() {
        this.socketRestartLock = new Object();
        this.socket = null;
        this.rxThread = null;
        this.socketAddressHolder = null;
        this.lastRecvMessageTicks = 0L;
    }

    public MbusSocketComm(BBasicNetwork bBasicNetwork, CommReceiver commReceiver, ISocketAddressHolder iSocketAddressHolder) {
        super(bBasicNetwork, commReceiver);
        this.this();
        this.socketAddressHolder = iSocketAddressHolder;
    }

    public static interface ISocketAddressHolder {
        public BInternetAddress getInternetAddress();
    }
}

