/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.comm;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.mbus.comm.IMbusComm;
import com.tridium.mbus.comm.MbusSocketComm;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.messages.MbusMessage;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BRelTime;

public final class MbusCommUtil {
    public static final Message transmit(Comm comm, Message message, BRelTime bRelTime, int n) throws BasicException {
        MbusMessage mbusMessage;
        if (message == null) {
            return null;
        }
        if (message instanceof MbusMessage && !(comm instanceof MbusSocketComm)) {
            mbusMessage = (MbusMessage)message;
            if (comm.isCommStarted()) {
                BSerialHelper bSerialHelper = ((BSerialNetwork)comm.getNetwork()).getSerialPortConfig();
                BMbusBaudRate bMbusBaudRate = (BMbusBaudRate)bSerialHelper.getBaudRate();
                BMbusBaudRate bMbusBaudRate2 = mbusMessage.getMessageBaudRate();
                if (!bMbusBaudRate2.equals((Object)bMbusBaudRate)) {
                    bSerialHelper.setBaudRate((BBaudRate)bMbusBaudRate2);
                }
            }
        }
        mbusMessage = MbusCommUtil.performTransmit(comm, message, bRelTime, n);
        ((IMbusComm)comm).performNetworkInterMessageDelay();
        return mbusMessage;
    }

    private static final Message performTransmit(Comm comm, Message message, BRelTime bRelTime, int n) throws BasicException {
        if (!message.getResponseExpected()) {
            comm.transmitNoResponse(message);
            return null;
        }
        BasicException basicException = null;
        Message message2 = null;
        try {
            int n2 = 0;
            while (n2 < n + 1) {
                message2 = ((IMbusComm)comm).processNetworkTransmit(message, bRelTime);
                if (message2 != null && message2.getSuccessfulResponse()) break;
                ++n2;
            }
            if (message2 != null && !message2.getSuccessfulResponse()) {
                String string = "Unsuccessful response for request message sent.";
                basicException = new BasicException(string);
            }
        }
        catch (BasicException basicException2) {
            basicException = basicException2;
        }
        if (basicException != null) {
            if (basicException instanceof BasicException) {
                if (comm.getNetwork().getLog().isTraceOn()) {
                    comm.getNetwork().getLog().trace("Comm sendRequest exception: ", (Throwable)basicException);
                }
            } else {
                throw basicException;
            }
        }
        return message2;
    }
}

