/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.comm.MbusCommReceiver;
import com.tridium.mbus.comm.MbusSocketComm;
import javax.baja.net.BInternetAddress;
import javax.baja.status.BStatus;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusTcpIpNetwork
extends BAbstractMbusNetwork
implements MbusSocketComm.ISocketAddressHolder {
    public static final Property ipAddress = BMbusTcpIpNetwork.newProperty((int)0, (BValue)new BInternetAddress("192.168.1.10:6021"), null);
    public static final Type TYPE;
    private Object startCommsLock;
    private volatile boolean commsStarted;
    static /* synthetic */ Class class$com$tridium$mbus$BMbusTcpIpNetwork;
    static /* synthetic */ Class class$javax$baja$sys$Type;

    public final BInternetAddress getIpAddress() {
        return (BInternetAddress)this.get(ipAddress);
    }

    public final void setIpAddress(BInternetAddress bInternetAddress) {
        this.set(ipAddress, (BValue)bInternetAddress, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Type[] getServiceTypes() {
        Class clazz = class$javax$baja$sys$Type;
        if (clazz == null) {
            clazz = class$javax$baja$sys$Type = BMbusTcpIpNetwork.class("[Ljavax.baja.sys.Type;", false);
        }
        Array array = new Array(clazz);
        array.add((Object)this.getType());
        array.addAll((Object[])super.getServiceTypes());
        return (Type[])array.trim();
    }

    public final void started() throws Exception {
        this.setFlags((Slot)ping, 8);
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
    }

    public final void atSteadyState() throws Exception {
        if (this.getEnabled()) {
            this.setEnabled(false);
            this.setEnabled(true);
        }
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && ipAddress == property) {
            try {
                this.stopComm();
                if (!this.isFatalFault()) {
                    this.startComm();
                }
            }
            catch (Exception exception) {
                this.getLog().error("Error attempting to change the IP address on this device", (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void startComm() throws Exception {
        Object object = this.startCommsLock;
        synchronized (object) {
            if (this.getComm().isCommStarted()) {
                return;
            }
            if (!this.isDisabled() && !this.isFatalFault() && this.getComm() != null) {
                try {
                    if (this.getLog().isTraceOn()) {
                        this.getLog().trace(this.getName() + " *** Starting Communication Handler ***");
                    }
                    this.getComm().start();
                    if (this.getLog().isTraceOn()) {
                        this.getLog().trace(this.getName() + " *** Started Communication Handler ***");
                    }
                }
                catch (Exception exception) {
                    this.setFaultCause(exception.getMessage());
                    this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)true));
                    throw exception;
                }
            }
            this.commsStarted = true;
            return;
        }
    }

    public final void doPing() {
        MbusSocketComm mbusSocketComm = (MbusSocketComm)this.getComm();
        if (this.isDown()) {
            try {
                mbusSocketComm.reopenSocket();
                this.setFaultCause("");
            }
            catch (BasicException basicException) {
                this.pingFail(basicException.getMessage());
                return;
            }
        }
        this.pingOk();
    }

    protected final String checkSerialConfig() {
        return null;
    }

    protected final String getLicenseConnectTypeName() {
        return "tcpip";
    }

    protected final Comm makeComm() {
        return new MbusSocketComm((BBasicNetwork)this, new MbusCommReceiver(), this);
    }

    public final BInternetAddress getInternetAddress() {
        return this.getIpAddress();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.startCommsLock = new Object();
        this.commsStarted = false;
    }

    public BMbusTcpIpNetwork() {
        this.this();
        this.setFlags((Slot)serialPortConfig, 4);
        this.setFlags((Slot)searchBaudRate, 4);
    }

    static {
        Class clazz = class$com$tridium$mbus$BMbusTcpIpNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$BMbusTcpIpNetwork = BMbusTcpIpNetwork.class("[Lcom.tridium.mbus.BMbusTcpIpNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

