/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.basicdriver.message.Message;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDeviceFolder;
import com.tridium.mbus.BMbusNetwork;
import com.tridium.mbus.BMbusTcpIpNetwork;
import com.tridium.mbus.db.BMbusNetworkDatabase;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusAppReset;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.enums.BMbusHeaderTypes;
import com.tridium.mbus.enums.BMbusTestControl;
import com.tridium.mbus.history.BMbusHistoryDeviceExt;
import com.tridium.mbus.jobs.BMbusAssignAddressJob;
import com.tridium.mbus.messages.MbusLongFrameMessage;
import com.tridium.mbus.messages.MbusMessage;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqSkeMessage;
import com.tridium.mbus.messages.MbusReqUd1Message;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndNkeMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.point.BMbusPointDeviceExt;
import com.tridium.mbus.types.BMbusCommand;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusDevice
extends BBasicDevice {
    public static final Property modelName = BMbusDevice.newProperty((int)0, (String)"", null);
    public static final Property pollFrequency = BMbusDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property baudRate = BMbusDevice.newProperty((int)0, (BValue)BMbusBaudRate.baud300, null);
    public static final Property primaryAddress = BMbusDevice.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)250), (String)"fieldWidth", (BIDataValue)BInteger.make((int)3)));
    public static final Property secondaryAddress = BMbusDevice.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)16)));
    public static final Property addressMode = BMbusDevice.newProperty((int)0, (BValue)BMbusAddressing.primary, null);
    public static final Property cycleQuantity = BMbusDevice.newProperty((int)0, (int)1, null);
    public static final Property resetRequired = BMbusDevice.newProperty((int)0, (boolean)false, null);
    public static final Property resetRequiredForPing = BMbusDevice.newProperty((int)0, (boolean)false, null);
    public static final Property inhibitPing = BMbusDevice.newProperty((int)0, (boolean)false, null);
    public static final Property fcBitState = BMbusDevice.newProperty((int)1, (boolean)false, null);
    public static final Property fcBitInUse = BMbusDevice.newProperty((int)0, (boolean)true, null);
    public static final Property reqSkeCapable = BMbusDevice.newProperty((int)0, (boolean)false, null);
    public static final Property identNumber = BMbusDevice.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)8)));
    public static final Property manufacturer = BMbusDevice.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)3)));
    public static final Property manufString = BMbusDevice.newProperty((int)4, (String)"", null);
    public static final Property versionNumber = BMbusDevice.newProperty((int)4, (int)0, null);
    public static final Property deviceTypeId = BMbusDevice.newProperty((int)0, (BValue)BMbusDeviceTypeId.other, null);
    public static final Property applicationResetType = BMbusDevice.newProperty((int)0, (BValue)BMbusAppReset.all, null);
    public static final Property subTelegramNumber = BMbusDevice.newProperty((int)0, (int)0, null);
    public static final Property history = BMbusDevice.newProperty((int)0, (BValue)new BMbusHistoryDeviceExt(), null);
    public static final Property points = BMbusDevice.newProperty((int)0, (BValue)new BMbusPointDeviceExt(), null);
    public static final Property headerType = BMbusDevice.newProperty((int)0, (BValue)BMbusHeaderTypes.asMessage, null);
    public static final Property maxInputsPerCycleCount = BMbusDevice.newProperty((int)0, (int)0, null);
    public static final Property allowMultipleRecords = BMbusDevice.newProperty((int)0, (boolean)true, null);
    public static final Property commandHidden = BMbusDevice.newProperty((int)4, (BValue)new BMbusCommand(), null);
    public static final Property fabricationNumber = BMbusDevice.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)8)));
    public static final Property readoutModeNumber = BMbusDevice.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)2)));
    public static final Property mbusMeterStatusDescription = BMbusDevice.newProperty((int)1, (String)"No status Input", null);
    public static final Property manufacturerStatusBit5 = BMbusDevice.newProperty((int)1, (boolean)false, null);
    public static final Property manufacturerStatusBit6 = BMbusDevice.newProperty((int)1, (boolean)false, null);
    public static final Property manufacturerStatusBit7 = BMbusDevice.newProperty((int)1, (boolean)false, null);
    public static final Action resetDatalink = BMbusDevice.newAction((int)16, null);
    public static final Action resetApplication = BMbusDevice.newAction((int)16, null);
    public static final Action removeFromDatabase = BMbusDevice.newAction((int)16, null);
    public static final Action alarmProtocol = BMbusDevice.newAction((int)16, null);
    public static final Action assignAddress = BMbusDevice.newAction((int)128, (BValue)BInteger.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)250)));
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$mbus$BMbusDevice;

    public final String getModelName() {
        return this.getString(modelName);
    }

    public final void setModelName(String string) {
        this.setString(modelName, string, null);
    }

    public final BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public final void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public final BMbusBaudRate getBaudRate() {
        return (BMbusBaudRate)this.get(baudRate);
    }

    public final void setBaudRate(BMbusBaudRate bMbusBaudRate) {
        this.set(baudRate, (BValue)bMbusBaudRate, null);
    }

    public final int getPrimaryAddress() {
        return this.getInt(primaryAddress);
    }

    public final void setPrimaryAddress(int n) {
        this.setInt(primaryAddress, n, null);
    }

    public final String getSecondaryAddress() {
        return this.getString(secondaryAddress);
    }

    public final void setSecondaryAddress(String string) {
        this.setString(secondaryAddress, string, null);
    }

    public final BMbusAddressing getAddressMode() {
        return (BMbusAddressing)this.get(addressMode);
    }

    public final void setAddressMode(BMbusAddressing bMbusAddressing) {
        this.set(addressMode, (BValue)bMbusAddressing, null);
    }

    public final int getCycleQuantity() {
        return this.getInt(cycleQuantity);
    }

    public final void setCycleQuantity(int n) {
        this.setInt(cycleQuantity, n, null);
    }

    public final boolean getResetRequired() {
        return this.getBoolean(resetRequired);
    }

    public final void setResetRequired(boolean bl) {
        this.setBoolean(resetRequired, bl, null);
    }

    public final boolean getResetRequiredForPing() {
        return this.getBoolean(resetRequiredForPing);
    }

    public final void setResetRequiredForPing(boolean bl) {
        this.setBoolean(resetRequiredForPing, bl, null);
    }

    public final boolean getInhibitPing() {
        return this.getBoolean(inhibitPing);
    }

    public final void setInhibitPing(boolean bl) {
        this.setBoolean(inhibitPing, bl, null);
    }

    public final boolean getFcBitState() {
        return this.getBoolean(fcBitState);
    }

    public final void setFcBitState(boolean bl) {
        this.setBoolean(fcBitState, bl, null);
    }

    public final boolean getFcBitInUse() {
        return this.getBoolean(fcBitInUse);
    }

    public final void setFcBitInUse(boolean bl) {
        this.setBoolean(fcBitInUse, bl, null);
    }

    public final boolean getReqSkeCapable() {
        return this.getBoolean(reqSkeCapable);
    }

    public final void setReqSkeCapable(boolean bl) {
        this.setBoolean(reqSkeCapable, bl, null);
    }

    public final String getIdentNumber() {
        return this.getString(identNumber);
    }

    public final void setIdentNumber(String string) {
        this.setString(identNumber, string, null);
    }

    public final String getManufacturer() {
        return this.getString(manufacturer);
    }

    public final void setManufacturer(String string) {
        this.setString(manufacturer, string, null);
    }

    public final String getManufString() {
        return this.getString(manufString);
    }

    public final void setManufString(String string) {
        this.setString(manufString, string, null);
    }

    public final int getVersionNumber() {
        return this.getInt(versionNumber);
    }

    public final void setVersionNumber(int n) {
        this.setInt(versionNumber, n, null);
    }

    public final BMbusDeviceTypeId getDeviceTypeId() {
        return (BMbusDeviceTypeId)this.get(deviceTypeId);
    }

    public final void setDeviceTypeId(BMbusDeviceTypeId bMbusDeviceTypeId) {
        this.set(deviceTypeId, (BValue)bMbusDeviceTypeId, null);
    }

    public final BMbusAppReset getApplicationResetType() {
        return (BMbusAppReset)this.get(applicationResetType);
    }

    public final void setApplicationResetType(BMbusAppReset bMbusAppReset) {
        this.set(applicationResetType, (BValue)bMbusAppReset, null);
    }

    public final int getSubTelegramNumber() {
        return this.getInt(subTelegramNumber);
    }

    public final void setSubTelegramNumber(int n) {
        this.setInt(subTelegramNumber, n, null);
    }

    public final BMbusHistoryDeviceExt getHistory() {
        return (BMbusHistoryDeviceExt)this.get(history);
    }

    public final void setHistory(BMbusHistoryDeviceExt bMbusHistoryDeviceExt) {
        this.set(history, (BValue)bMbusHistoryDeviceExt, null);
    }

    public final BMbusPointDeviceExt getPoints() {
        return (BMbusPointDeviceExt)this.get(points);
    }

    public final void setPoints(BMbusPointDeviceExt bMbusPointDeviceExt) {
        this.set(points, (BValue)bMbusPointDeviceExt, null);
    }

    public final BMbusHeaderTypes getHeaderType() {
        return (BMbusHeaderTypes)this.get(headerType);
    }

    public final void setHeaderType(BMbusHeaderTypes bMbusHeaderTypes) {
        this.set(headerType, (BValue)bMbusHeaderTypes, null);
    }

    public final int getMaxInputsPerCycleCount() {
        return this.getInt(maxInputsPerCycleCount);
    }

    public final void setMaxInputsPerCycleCount(int n) {
        this.setInt(maxInputsPerCycleCount, n, null);
    }

    public final boolean getAllowMultipleRecords() {
        return this.getBoolean(allowMultipleRecords);
    }

    public final void setAllowMultipleRecords(boolean bl) {
        this.setBoolean(allowMultipleRecords, bl, null);
    }

    public final BMbusCommand getCommandHidden() {
        return (BMbusCommand)this.get(commandHidden);
    }

    public final void setCommandHidden(BMbusCommand bMbusCommand) {
        this.set(commandHidden, (BValue)bMbusCommand, null);
    }

    public final String getFabricationNumber() {
        return this.getString(fabricationNumber);
    }

    public final void setFabricationNumber(String string) {
        this.setString(fabricationNumber, string, null);
    }

    public final int getReadoutModeNumber() {
        return this.getInt(readoutModeNumber);
    }

    public final void setReadoutModeNumber(int n) {
        this.setInt(readoutModeNumber, n, null);
    }

    public final String getMbusMeterStatusDescription() {
        return this.getString(mbusMeterStatusDescription);
    }

    public final void setMbusMeterStatusDescription(String string) {
        this.setString(mbusMeterStatusDescription, string, null);
    }

    public final boolean getManufacturerStatusBit5() {
        return this.getBoolean(manufacturerStatusBit5);
    }

    public final void setManufacturerStatusBit5(boolean bl) {
        this.setBoolean(manufacturerStatusBit5, bl, null);
    }

    public final boolean getManufacturerStatusBit6() {
        return this.getBoolean(manufacturerStatusBit6);
    }

    public final void setManufacturerStatusBit6(boolean bl) {
        this.setBoolean(manufacturerStatusBit6, bl, null);
    }

    public final boolean getManufacturerStatusBit7() {
        return this.getBoolean(manufacturerStatusBit7);
    }

    public final void setManufacturerStatusBit7(boolean bl) {
        this.setBoolean(manufacturerStatusBit7, bl, null);
    }

    public final void resetDatalink() {
        this.invoke(resetDatalink, null, null);
    }

    public final void resetApplication() {
        this.invoke(resetApplication, null, null);
    }

    public final void removeFromDatabase() {
        this.invoke(removeFromDatabase, null, null);
    }

    public final void alarmProtocol() {
        this.invoke(alarmProtocol, null, null);
    }

    public final void assignAddress(BInteger bInteger) {
        this.invoke(assignAddress, (BValue)bInteger, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final IFuture post(Action action, BValue bValue, Context context) {
        if (action == resetDatalink || action == resetApplication || action == removeFromDatabase || action == alarmProtocol || action == assignAddress) {
            this.getMbusNetwork().getWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
            return null;
        }
        return super.post(action, bValue, context);
    }

    public final boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof BMbusCommand || bComponent instanceof BMbusDeviceFolder || bComponent instanceof BMbusDevice || bComponent instanceof BMbusTcpIpNetwork || bComponent instanceof BMbusNetwork) {
            bl = true;
        }
        return bl;
    }

    public final BAbstractMbusNetwork getMbusNetwork() {
        return (BAbstractMbusNetwork)this.getNetwork();
    }

    public final Type getNetworkType() {
        return BAbstractMbusNetwork.TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        this.getMbusNetwork().getNetworkDatabase().rationalise(this);
    }

    public final void changed(Property property, Context context) {
        Object object;
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusNetwork();
        if (property == headerType) {
            object = bAbstractMbusNetwork.getNetworkDatabase();
            object.removeDevicePointInformation(this.getPrimaryAddress(), this.getSecondaryAddress(), this.getModelName());
            this.setIdentNumber("");
            this.setManufacturer("");
            this.setVersionNumber(0);
            this.setDeviceTypeId(BMbusDeviceTypeId.other);
            if (this.getPrimaryAddress() != 253) {
                this.setSecondaryAddress("");
            }
        }
        if (property == addressMode) {
            object = new MbusSndNkeMessage(this, bAbstractMbusNetwork, this.getPrimaryAddress());
            bAbstractMbusNetwork.sendSync((Message)object);
            MbusSndUdMessage mbusSndUdMessage = new MbusSndUdMessage(this, bAbstractMbusNetwork, null);
            bAbstractMbusNetwork.sendSync(mbusSndUdMessage);
        }
        if (property == modelName) {
            this.getMbusNetwork().getNetworkDatabase().rationalise(this);
        }
    }

    public final IFuture postPing() {
        this.doPing();
        return null;
    }

    public final void doPing() {
        block16: {
            Object object;
            if (!this.isRunning()) {
                return;
            }
            if (this.getMbusNetwork().getTestMode() != BMbusTestControl.inactive) {
                this.pingOk();
                return;
            }
            if (this.getInhibitPing()) {
                this.pingOk();
                return;
            }
            if (this.getResetRequiredForPing()) {
                object = new MbusSndNkeMessage(this, this.getMbusNetwork(), 0);
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("Ping Reset to Meter:- " + this.getPrimaryAddress() + "Sec Add= " + this.getSecondaryAddress());
                }
                this.getMbusNetwork().sendSync((Message)object);
                this.setFcBitState(true);
            }
            object = null;
            try {
                Object object2;
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("Ping to Meter:- " + this.getPrimaryAddress() + "Sec Add= " + this.getSecondaryAddress());
                }
                if (this.getReqSkeCapable()) {
                    object2 = new MbusReqSkeMessage(this, this.getMbusNetwork());
                    ((MbusMessage)((Object)object2)).setMessageBaudRate(this.getBaudRate());
                    object = (MbusResponseMessage)this.getMbusNetwork().sendSync((Message)object2);
                } else if (this.getAddressMode() == BMbusAddressing.primary) {
                    object2 = new MbusReqUd2Message(this, this.getMbusNetwork());
                    ((MbusMessage)((Object)object2)).setMessageBaudRate(this.getBaudRate());
                    object = (MbusResponseMessage)this.getMbusNetwork().sendSync((Message)object2);
                } else {
                    object2 = new MbusSndUdMessage(this, this.getMbusNetwork(), null);
                    ((MbusMessage)((Object)object2)).setMessageBaudRate(this.getBaudRate());
                    object = (MbusResponseMessage)this.getMbusNetwork().sendSync((Message)object2);
                }
                if (object != null) {
                    if (MbusLogInputOutput.log.isTraceOn()) {
                        MbusLogInputOutput.log.trace("Input(Ping):- " + ((MbusResponseMessage)((Object)object)).toDebugString());
                    }
                    if (((MbusResponseMessage)((Object)object)).getBytes().length > 8) {
                        object2 = null;
                        object2 = new MbusReceivedLongFrame((MbusResponseMessage)((Object)object), this.getMbusNetwork(), this, false);
                        this.setMbusMeterStatusDescription(((MbusReceivedLongFrame)((Object)object2)).getStatus());
                        this.setManufacturerStatusBit5(((MbusReceivedLongFrame)((Object)object2)).getStatusBit5());
                        this.setManufacturerStatusBit6(((MbusReceivedLongFrame)((Object)object2)).getStatusBit6());
                        this.setManufacturerStatusBit7(((MbusReceivedLongFrame)((Object)object2)).getStatusBit7());
                    }
                    this.pingOk();
                } else {
                    this.pingFail("timeout");
                }
            }
            catch (Exception exception) {
                this.pingFail("caught exception");
                if (!MbusToolkit.isTraceOn()) break block16;
                MbusToolkit.trace("Error pinging device", exception);
            }
        }
    }

    public final void doResetDatalink() {
        block2: {
            try {
                BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusNetwork();
                MbusSndNkeMessage mbusSndNkeMessage = new MbusSndNkeMessage(this, bAbstractMbusNetwork, 0);
                mbusSndNkeMessage.setMessageBaudRate(this.getBaudRate());
                bAbstractMbusNetwork.sendSync(mbusSndNkeMessage);
                bAbstractMbusNetwork.getNetworkDatabase().initialiseDelay(bAbstractMbusNetwork.getInitialisationDelay().getSeconds());
            }
            catch (Exception exception) {
                if (!MbusToolkit.isTraceOn()) break block2;
                MbusToolkit.trace("Error resetting data link", exception);
            }
        }
    }

    public final void doAlarmProtocol() {
        block2: {
            try {
                BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusNetwork();
                MbusReqUd1Message mbusReqUd1Message = new MbusReqUd1Message(this, bAbstractMbusNetwork);
                mbusReqUd1Message.setMessageBaudRate(this.getBaudRate());
                bAbstractMbusNetwork.sendSync(mbusReqUd1Message);
            }
            catch (Exception exception) {
                if (!MbusToolkit.isTraceOn()) break block2;
                MbusToolkit.trace("Error resetting data link", exception);
            }
        }
    }

    public final void doResetApplication() {
        block2: {
            try {
                MbusLongFrameMessage mbusLongFrameMessage = new MbusLongFrameMessage();
                mbusLongFrameMessage.setAField(this.getPrimaryAddress());
                mbusLongFrameMessage.setCFieldNoFcb(67);
                mbusLongFrameMessage.setCiField(80);
                byte[] byArray = new byte[]{(byte)(this.getApplicationResetType().getOrdinal() | this.getSubTelegramNumber() & 0xF)};
                mbusLongFrameMessage.setBytes(byArray);
                this.getMbusNetwork().sendSync(mbusLongFrameMessage);
            }
            catch (Exception exception) {
                if (!MbusToolkit.isTraceOn()) break block2;
                MbusToolkit.trace("Error resetting appliance", exception);
            }
        }
    }

    public final void doRemoveFromDatabase() {
        BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusNetwork();
        BMbusNetworkDatabase bMbusNetworkDatabase = bAbstractMbusNetwork.getNetworkDatabase();
        bMbusNetworkDatabase.removeDevice(this.getPrimaryAddress(), this.getSecondaryAddress());
    }

    public final void doAssignAddress(BInteger bInteger) {
        BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusNetwork();
        new BMbusAssignAddressJob(bAbstractMbusNetwork, bInteger.getInt(), this).submit(null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$mbus$BMbusDevice;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$BMbusDevice = BMbusDevice.class("[Lcom.tridium.mbus.BMbusDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

