/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.BMbusDeviceFolder;
import com.tridium.mbus.comm.MbusCommReceiver;
import com.tridium.mbus.comm.MbusSerialComm;
import com.tridium.mbus.db.BMbusNetworkDatabase;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.enums.BMbusTestControl;
import com.tridium.mbus.jobs.BMbusAssignAddressJob;
import com.tridium.mbus.jobs.BMbusAssignBaudRateData;
import com.tridium.mbus.jobs.BMbusAssignBaudRateJob;
import com.tridium.mbus.jobs.BMbusDeviceSearchJob;
import com.tridium.mbus.jobs.BMbusSecondarySearchJob;
import com.tridium.mbus.learn.BMbusDeviceDiscoveryJob;
import com.tridium.mbus.learn.BMbusHistoryImportDiscoveryJob;
import com.tridium.mbus.learn.BMbusPointDiscoveryJob;
import com.tridium.mbus.types.BEncodableList;
import com.tridium.mbus.types.BMbusPrimaryAddressRange;
import com.tridium.mbus.types.BMbusSecondaryAddressFilters;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialHelper;
import javax.baja.serial.BSerialParity;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BAbstractMbusNetwork
extends BSerialNetwork {
    public static final Property initialisationDelay = BAbstractMbusNetwork.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)12), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.make((long)100000L)));
    public static final Property networkDatabase = BAbstractMbusNetwork.newProperty((int)0, (BValue)new BMbusNetworkDatabase(), null);
    public static final Property searchBaudRate = BAbstractMbusNetwork.newProperty((int)0, (BValue)BMbusBaudRate.baud300, null);
    public static final Property searchFcBitState = BAbstractMbusNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property searchFcBitInUse = BAbstractMbusNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property primarySearchAddress = BAbstractMbusNetwork.newProperty((int)4, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)250)));
    public static final Property testMode = BAbstractMbusNetwork.newProperty((int)4, (BValue)BMbusTestControl.inactive, null);
    public static final Property testString = BAbstractMbusNetwork.newProperty((int)4, (String)"", null);
    public static final Action submitDeviceDiscoveryJob = BAbstractMbusNetwork.newAction((int)4, null);
    public static final Action submitHistoryImportDiscoveryJob = BAbstractMbusNetwork.newAction((int)4, (BValue)BOrd.NULL, null);
    public static final Action submitPointDiscoveryJob = BAbstractMbusNetwork.newAction((int)4, (BValue)BOrd.NULL, null);
    public static final Action submitSingleDeviceDiscoveryJob = BAbstractMbusNetwork.newAction((int)4, null);
    public static final Action submitPrimaryDiscoverJob = BAbstractMbusNetwork.newAction((int)4, (BValue)BEncodableList.DEFAULT, null);
    public static final Action submitPrimaryDiscoverRangeJob = BAbstractMbusNetwork.newAction((int)4, (BValue)new BMbusPrimaryAddressRange(), null);
    public static final Action submitAssignBaudRateJob = BAbstractMbusNetwork.newAction((int)4, (BValue)new BMbusAssignBaudRateData(), null);
    public static final Action submitIdentDiscoverJob = BAbstractMbusNetwork.newAction((int)4, null);
    public static final Action submitFullSecondaryDiscoverJob = BAbstractMbusNetwork.newAction((int)4, (BValue)new BMbusSecondaryAddressFilters(), null);
    public static final Action assignAddress = BAbstractMbusNetwork.newAction((int)128, (BValue)BInteger.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)250)));
    public static final Action clearNetworkDatabase = BAbstractMbusNetwork.newAction((int)0, null);
    public static final Type TYPE;
    static int currentTestMeterNumber;
    static /* synthetic */ Class class$com$tridium$mbus$BAbstractMbusNetwork;

    public BRelTime getInitialisationDelay() {
        return (BRelTime)this.get(initialisationDelay);
    }

    public void setInitialisationDelay(BRelTime bRelTime) {
        this.set(initialisationDelay, (BValue)bRelTime, null);
    }

    public BMbusNetworkDatabase getNetworkDatabase() {
        return (BMbusNetworkDatabase)this.get(networkDatabase);
    }

    public void setNetworkDatabase(BMbusNetworkDatabase bMbusNetworkDatabase) {
        this.set(networkDatabase, (BValue)bMbusNetworkDatabase, null);
    }

    public BMbusBaudRate getSearchBaudRate() {
        return (BMbusBaudRate)this.get(searchBaudRate);
    }

    public void setSearchBaudRate(BMbusBaudRate bMbusBaudRate) {
        this.set(searchBaudRate, (BValue)bMbusBaudRate, null);
    }

    public boolean getSearchFcBitState() {
        return this.getBoolean(searchFcBitState);
    }

    public void setSearchFcBitState(boolean bl) {
        this.setBoolean(searchFcBitState, bl, null);
    }

    public boolean getSearchFcBitInUse() {
        return this.getBoolean(searchFcBitInUse);
    }

    public void setSearchFcBitInUse(boolean bl) {
        this.setBoolean(searchFcBitInUse, bl, null);
    }

    public int getPrimarySearchAddress() {
        return this.getInt(primarySearchAddress);
    }

    public void setPrimarySearchAddress(int n) {
        this.setInt(primarySearchAddress, n, null);
    }

    public BMbusTestControl getTestMode() {
        return (BMbusTestControl)this.get(testMode);
    }

    public void setTestMode(BMbusTestControl bMbusTestControl) {
        this.set(testMode, (BValue)bMbusTestControl, null);
    }

    public String getTestString() {
        return this.getString(testString);
    }

    public void setTestString(String string) {
        this.setString(testString, string, null);
    }

    public BOrd submitDeviceDiscoveryJob() {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, null, null);
    }

    public BOrd submitHistoryImportDiscoveryJob(BOrd bOrd) {
        return (BOrd)this.invoke(submitHistoryImportDiscoveryJob, (BValue)bOrd, null);
    }

    public BOrd submitPointDiscoveryJob(BOrd bOrd) {
        return (BOrd)this.invoke(submitPointDiscoveryJob, (BValue)bOrd, null);
    }

    public BOrd submitSingleDeviceDiscoveryJob() {
        return (BOrd)this.invoke(submitSingleDeviceDiscoveryJob, null, null);
    }

    public BOrd submitPrimaryDiscoverJob(BEncodableList bEncodableList) {
        return (BOrd)this.invoke(submitPrimaryDiscoverJob, (BValue)bEncodableList, null);
    }

    public BOrd submitPrimaryDiscoverRangeJob(BMbusPrimaryAddressRange bMbusPrimaryAddressRange) {
        return (BOrd)this.invoke(submitPrimaryDiscoverRangeJob, (BValue)bMbusPrimaryAddressRange, null);
    }

    public BOrd submitAssignBaudRateJob(BMbusAssignBaudRateData bMbusAssignBaudRateData) {
        return (BOrd)this.invoke(submitAssignBaudRateJob, (BValue)bMbusAssignBaudRateData, null);
    }

    public BOrd submitIdentDiscoverJob() {
        return (BOrd)this.invoke(submitIdentDiscoverJob, null, null);
    }

    public BOrd submitFullSecondaryDiscoverJob(BMbusSecondaryAddressFilters bMbusSecondaryAddressFilters) {
        return (BOrd)this.invoke(submitFullSecondaryDiscoverJob, (BValue)bMbusSecondaryAddressFilters, null);
    }

    public void assignAddress(BInteger bInteger) {
        this.invoke(assignAddress, (BValue)bInteger, null);
    }

    public void clearNetworkDatabase() {
        this.invoke(clearNetworkDatabase, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == interMessageDelay) {
            String[] stringArray = new String[]{"showSeconds", "showMilliseconds", "min", "max"};
            BIDataValue[] bIDataValueArray = new BIDataValue[]{BBoolean.TRUE, BBoolean.TRUE, BRelTime.make((long)0L), BRelTime.MINUTE};
            return BFacets.make((String[])stringArray, (BIDataValue[])bIDataValueArray);
        }
        return super.getSlotFacets(slot);
    }

    public Type getDeviceType() {
        return BMbusDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BMbusDeviceFolder.TYPE;
    }

    public void started() throws Exception {
        super.started();
        MbusToolkit.setLog(this.getLog());
        this.setFlags((Slot)ping, 4);
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        this.setSearchFcBitInUse(true);
        this.setSearchFcBitState(false);
        this.setTestMode(BMbusTestControl.inactive);
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("*** Mbus Driver Started ***");
        }
    }

    protected Comm makeComm() {
        return new MbusSerialComm(this, new MbusCommReceiver());
    }

    public BOrd doSubmitDeviceDiscoveryJob() {
        return new BMbusDeviceDiscoveryJob(this).submit(null);
    }

    public BOrd doSubmitHistoryImportDiscoveryJob(BOrd bOrd) {
        return new BMbusHistoryImportDiscoveryJob(this.getSlotPathOrd(), bOrd).submit(null);
    }

    public BOrd doSubmitPointDiscoveryJob(BOrd bOrd) {
        return new BMbusPointDiscoveryJob(this.getSlotPathOrd(), bOrd).submit(null);
    }

    public final Feature getLicenseFeature() {
        Feature feature = Sys.getLicenseManager().checkFeature("tridium", "mbus");
        String[] stringArray = feature.list();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(this.getLicenseConnectTypeName()) && !feature.getb(stringArray[n], true)) {
                throw new FeatureNotLicensedException("Not licensed for " + this.getLicenseConnectTypeName());
            }
            ++n;
        }
        return feature;
    }

    protected abstract String getLicenseConnectTypeName();

    public BOrd doSubmitSingleDeviceDiscoveryJob() {
        return new BMbusDeviceSearchJob(this, 254, 254).submit(null);
    }

    public BOrd doSubmitPrimaryDiscoverRangeJob(BMbusPrimaryAddressRange bMbusPrimaryAddressRange) {
        return new BMbusDeviceSearchJob(this, bMbusPrimaryAddressRange.getStart(), bMbusPrimaryAddressRange.getEnd()).submit(null);
    }

    public BOrd doSubmitIdentDiscoverJob() {
        return new BMbusSecondarySearchJob(this, null).submit(null);
    }

    public BOrd doSubmitFullSecondaryDiscoverJob(BMbusSecondaryAddressFilters bMbusSecondaryAddressFilters) {
        return new BMbusSecondarySearchJob(this, bMbusSecondaryAddressFilters).submit(null);
    }

    public BOrd doSubmitPrimaryDiscoverJob(BEncodableList bEncodableList) {
        BOrd bOrd = BOrd.NULL;
        try {
            int[] nArray = bEncodableList.toIntArray();
            bOrd = new BMbusDeviceSearchJob(this, nArray).submit(null);
        }
        catch (Exception exception) {
            MbusToolkit.error("Error in Device discovery Job, String part ", exception);
        }
        return bOrd;
    }

    public BOrd doSubmitAssignBaudRateJob(BMbusAssignBaudRateData bMbusAssignBaudRateData) {
        return new BMbusAssignBaudRateJob(this, bMbusAssignBaudRateData).submit(null);
    }

    public void doAssignAddress(BInteger bInteger) {
        new BMbusAssignAddressJob(this, bInteger.getInt(), null).submit(null);
    }

    public void doClearNetworkDatabase() {
        this.getNetworkDatabase().clearAllDetectedDevices();
    }

    public static int getCurrentTestMeterNumber() {
        return currentTestMeterNumber;
    }

    public static void setCurrentTestMeterNumber(int n) {
        currentTestMeterNumber = n;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAbstractMbusNetwork() {
        BSerialHelper bSerialHelper = this.getSerialPortConfig();
        bSerialHelper.setParity(BSerialParity.even);
        bSerialHelper.setBaudRate((BBaudRate)BMbusBaudRate.baud300);
        this.setResponseTimeout(BRelTime.make((long)(BRelTime.SECOND.getMillis() * 12L)));
        this.setInterMessageDelay(BRelTime.make((long)(BRelTime.SECOND.getMillis() * 12L)));
        this.setSearchFcBitState(false);
        this.getPollScheduler().setFastRate(BRelTime.make((long)30000L));
        this.getPollScheduler().setNormalRate(BRelTime.make((long)45000L));
        this.getPollScheduler().setSlowRate(BRelTime.make((long)90000L));
    }

    static {
        Class clazz = class$com$tridium$mbus$BAbstractMbusNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$BAbstractMbusNetwork = BAbstractMbusNetwork.class("[Lcom.tridium.mbus.BAbstractMbusNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        currentTestMeterNumber = 0;
    }
}

