/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetws.job;

import com.tridium.bacnet.asn.NAlarmSummary;
import com.tridium.bacnet.asn.NEventSummary;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnetws.BBacnetWsNetwork;
import com.tridium.bacnetws.datatypes.BGetEventInfoConfig;
import java.text.MessageFormat;
import java.util.ListIterator;
import java.util.Vector;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BGetEventInformationJob
extends BDeviceManagerJob {
    public static final Property serviceChoice = BGetEventInformationJob.newProperty((int)0, (int)-1, null);
    public static final Type TYPE;
    static Lexicon lex;
    private BBacnetWsNetwork bacnetws;
    private BGetEventInfoConfig params;
    static /* synthetic */ Class class$com$tridium$bacnetws$job$BGetEventInformationJob;

    public int getServiceChoice() {
        return this.getInt(serviceChoice);
    }

    public void setServiceChoice(int n) {
        this.setInt(serviceChoice, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        try {
            BBacnetDevice bBacnetDevice = this.bacnetws.lookupDeviceById(this.params.getObjectId());
            if (bBacnetDevice == null) {
                throw new IllegalArgumentException("No BacnetDevice found for objectId " + this.params.getObjectId());
            }
            if (log.isTraceOn()) {
                log.trace("Getting event information from " + bBacnetDevice.getObjectId() + " at " + bBacnetDevice.getAddress() + "...");
            }
            if (bBacnetDevice.isServiceSupported(BacnetBitStringUtil.getBitIndex((String)"BacnetServicesSupported", (String)"getEventInformation"))) {
                Vector vector = this.client().getEventInformation(bBacnetDevice.getAddress(), null);
                this.setServiceChoice(29);
                ListIterator listIterator = vector.listIterator();
                while (listIterator.hasNext()) {
                    NEventSummary nEventSummary = (NEventSummary)listIterator.next();
                    this.add(null, (BValue)nEventSummary.toJob());
                    this.server().getEventHandler().processEventSummary(nEventSummary, bBacnetDevice.getObjectId());
                }
            } else if (bBacnetDevice.isServiceSupported(BacnetBitStringUtil.getBitIndex((String)"BacnetServicesSupported", (String)"getAlarmSummary"))) {
                String string = lex.getText("getEventInfo.unsupported");
                this.log().message(string);
                String string2 = lex.getText("getASumm.warning");
                if (log.isTraceOn()) {
                    log.trace(string + "\n  Trying GetAlarmSummary - " + string2);
                }
                Vector vector = this.client().getAlarmSummary(bBacnetDevice.getAddress());
                this.setServiceChoice(3);
                ListIterator listIterator = vector.listIterator();
                while (listIterator.hasNext()) {
                    NAlarmSummary nAlarmSummary = (NAlarmSummary)listIterator.next();
                    this.add(null, (BValue)nAlarmSummary.toJob());
                }
            } else {
                String string = lex.getText("getASumm.unsupported");
                this.log().message(string);
                log.message(string);
                this.add("failureCause", (BValue)BString.make((String)string));
            }
        }
        catch (Exception exception) {
            log.message("Exception sending GetEventInformation: " + exception, (Throwable)exception);
            String string = MessageFormat.format(lex.getText("getEventInfo.fail"), exception);
            this.add("failureCause", (BValue)BString.make((String)exception.toString()));
            this.log().failed(string);
            throw exception;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BGetEventInformationJob() {
    }

    public BGetEventInformationJob(BBacnetWsNetwork bBacnetWsNetwork, BGetEventInfoConfig bGetEventInfoConfig) {
        super((BBacnetNetwork)bBacnetWsNetwork);
        this.bacnetws = bBacnetWsNetwork;
        this.params = bGetEventInfoConfig;
    }

    static {
        Class clazz = class$com$tridium$bacnetws$job$BGetEventInformationJob;
        if (clazz == null) {
            clazz = class$com$tridium$bacnetws$job$BGetEventInformationJob = BGetEventInformationJob.class("[Lcom.tridium.bacnetws.job.BGetEventInformationJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"bacnetws");
    }
}

