/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetws;

import com.tridium.bacnet.asn.NAlarmSummary;
import com.tridium.bacnet.asn.NEventSummary;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnetws.BBacnetWsNetwork;
import com.tridium.bacnetws.datatypes.BCommControlConfig;
import com.tridium.bacnetws.datatypes.BGetESummConfig;
import com.tridium.bacnetws.datatypes.BReinitializeDeviceConfig;
import com.tridium.bacnetws.job.BDeviceCommControlJob;
import com.tridium.bacnetws.job.BReinitializeDeviceJob;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetWsDevice
extends BBacnetDevice {
    public static final Action commControl = BBacnetWsDevice.newAction((int)132, (BValue)new BCommControlConfig(), null);
    public static final Action reinitializeDevice = BBacnetWsDevice.newAction((int)132, (BValue)new BReinitializeDeviceConfig(), null);
    public static final Action getEnrollmentSummary = BBacnetWsDevice.newAction((int)20, (BValue)new BGetESummConfig(), null);
    public static final Action getEventInformation = BBacnetWsDevice.newAction((int)20, null);
    public static final Type TYPE;
    public static final Log wslog;
    static /* synthetic */ Class class$com$tridium$bacnetws$BBacnetWsDevice;

    public void commControl(BStruct bStruct) {
        this.invoke(commControl, (BValue)bStruct, null);
    }

    public void reinitializeDevice(BStruct bStruct) {
        this.invoke(reinitializeDevice, (BValue)bStruct, null);
    }

    public BString getEnrollmentSummary(BStruct bStruct) {
        return (BString)this.invoke(getEnrollmentSummary, (BValue)bStruct, null);
    }

    public BString getEventInformation() {
        return (BString)this.invoke(getEventInformation, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BacnetWsDevice {").append(this.getName()).append("}");
        return stringBuffer.toString();
    }

    private final BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    private final BBacnetServerLayer server() {
        return ((BBacnetStack)this.network().getBacnetComm()).getServer();
    }

    public Type getNetworkType() {
        return BBacnetWsNetwork.TYPE;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)commControl)) {
            return this.postAction(commControl, bValue);
        }
        if (action.equals((Object)reinitializeDevice)) {
            return this.postAction(reinitializeDevice, bValue);
        }
        if (action.equals((Object)getEnrollmentSummary)) {
            return this.postAction(getEnrollmentSummary, bValue);
        }
        if (action.equals((Object)getEventInformation)) {
            return this.postAction(getEventInformation, bValue);
        }
        return super.post(action, bValue, context);
    }

    private final IFuture postAction(Action action, BValue bValue) {
        return this.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, null));
    }

    public void doCommControl(BStruct bStruct) throws BacnetException {
        BCommControlConfig bCommControlConfig = (BCommControlConfig)bStruct;
        if (wslog.isTraceOn()) {
            wslog.trace("Sending Device Communication Control request to device " + (Object)((Object)this) + "\n  Comm Control: " + bCommControlConfig.getEnableDisable() + " for " + bCommControlConfig.getDuration() + " minutes.");
        }
        try {
            BDeviceCommControlJob.dcc(this.client(), bCommControlConfig, this.getAddress(), this.getCharacterSet());
        }
        catch (BacnetException bacnetException) {
            wslog.message("BacnetException sending Device Communication Control to " + (Object)((Object)this) + ": " + (Object)((Object)bacnetException), (Throwable)bacnetException);
            throw new LocalizableRuntimeException("bacnetws", "devCommCtrl.fail", new Object[]{bacnetException.toString()}, (Throwable)bacnetException);
        }
    }

    public void doReinitializeDevice(BStruct bStruct) throws BacnetException {
        BReinitializeDeviceConfig bReinitializeDeviceConfig = (BReinitializeDeviceConfig)bStruct;
        if (wslog.isTraceOn()) {
            wslog.trace("Sending Reinitialize Device request (" + (Object)((Object)bReinitializeDeviceConfig.getReinitializeCommand()) + ") to device " + (Object)((Object)this));
        }
        try {
            BReinitializeDeviceJob.reinit(this.client(), bReinitializeDeviceConfig, this.getAddress(), this.getCharacterSet());
        }
        catch (BacnetException bacnetException) {
            wslog.message("BacnetException sending Reinitialize Device to " + (Object)((Object)this) + ": " + (Object)((Object)bacnetException), (Throwable)bacnetException);
            throw new LocalizableRuntimeException("bacnetws", "reinitDevice.fail", new Object[]{bacnetException.toString()}, (Throwable)bacnetException);
        }
    }

    public BString doGetEnrollmentSummary(BStruct bStruct) {
        BGetESummConfig bGetESummConfig = (BGetESummConfig)bStruct;
        if (wslog.isTraceOn()) {
            wslog.trace("Getting enrollment information for " + (Object)((Object)this) + "\n  Criteria:" + bStruct);
        }
        try {
            Vector vector = this.client().getEnrollmentSummary(this.getAddress(), bGetESummConfig.getAcknowledgmentFilter().getOrdinal(), bGetESummConfig.getEnrollmentFilter(), bGetESummConfig.getEventStateFilter().getOrdinal(), bGetESummConfig.getEventTypeFilter(), new int[]{bGetESummConfig.getPriorityFilter().getMinPriority(), bGetESummConfig.getPriorityFilter().getMaxPriority()}, bGetESummConfig.getNotificationClassFilter());
            System.out.println("Enrollment Summary response:");
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                System.out.println("\n" + iterator.next());
            }
            System.out.println("\n");
        }
        catch (BacnetException bacnetException) {
            wslog.message("BacnetException sending GetEnrollmentSummary to " + (Object)((Object)this) + ": " + (Object)((Object)bacnetException), (Throwable)bacnetException);
        }
        return BString.DEFAULT;
    }

    public BString doGetEventInformation() {
        if (this.isServiceSupported(BacnetBitStringUtil.getBitIndex((String)"BacnetServicesSupported", (String)"getEventInformation"))) {
            if (wslog.isTraceOn()) {
                wslog.trace("Getting event information for " + (Object)((Object)this));
            }
            try {
                Vector vector = this.client().getEventInformation(this.getAddress(), null);
                ListIterator listIterator = vector.listIterator();
                while (listIterator.hasNext()) {
                    NEventSummary nEventSummary = (NEventSummary)listIterator.next();
                    this.server().getEventHandler().processEventSummary(nEventSummary, this.getObjectId());
                }
            }
            catch (BacnetException bacnetException) {
                wslog.message("BacnetException sending GetEventInformation: " + (Object)((Object)bacnetException), (Throwable)bacnetException);
            }
        } else if (this.isServiceSupported(BacnetBitStringUtil.getBitIndex((String)"BacnetServicesSupported", (String)"getAlarmSummary"))) {
            if (wslog.isTraceOn()) {
                wslog.trace("GetEventInformation not supported; trying GetAlarmSummary (events will not be routed to Alarm Service)");
            }
            try {
                Vector vector = this.client().getAlarmSummary(this.getAddress());
                ListIterator listIterator = vector.listIterator();
                int n = 0;
                while (listIterator.hasNext()) {
                    NAlarmSummary nAlarmSummary = (NAlarmSummary)listIterator.next();
                    System.out.println("Alarm #" + ++n + ':' + nAlarmSummary);
                }
                System.out.println("AlarmSummary Information for " + (Object)((Object)this));
            }
            catch (BacnetException bacnetException) {
                wslog.message("BacnetException sending GetAlarmSummary: " + (Object)((Object)bacnetException), (Throwable)bacnetException);
            }
        } else {
            wslog.message("Unable to get Event Information or Alarm Summary - These services are not supported by the device!");
        }
        return BString.DEFAULT;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$bacnetws$BBacnetWsDevice;
        if (clazz == null) {
            clazz = class$com$tridium$bacnetws$BBacnetWsDevice = BBacnetWsDevice.class("[Lcom.tridium.bacnetws.BBacnetWsDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        wslog = Log.getLog((String)"bacnetws");
    }
}

